/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionToolbox;
import org.apache.druid.indexing.common.actions.TaskLocks;
import org.apache.druid.indexing.common.task.IndexTaskUtils;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.CriticalAction;
import org.apache.druid.indexing.overlord.SegmentPublishResult;
import org.apache.druid.indexing.overlord.supervisor.SupervisorManager;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.ReplaceTaskLock;
import org.apache.druid.segment.SegmentUtils;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.timeline.DataSegment;

public class SegmentTransactionalReplaceAction
implements TaskAction<SegmentPublishResult> {
    private static final Logger log = new Logger(SegmentTransactionalReplaceAction.class);
    private final Set<DataSegment> segments;

    public static SegmentTransactionalReplaceAction create(Set<DataSegment> segmentsToPublish) {
        return new SegmentTransactionalReplaceAction(segmentsToPublish);
    }

    @JsonCreator
    private SegmentTransactionalReplaceAction(@JsonProperty(value="segments") Set<DataSegment> segments) {
        this.segments = ImmutableSet.copyOf(segments);
    }

    @JsonProperty
    public Set<DataSegment> getSegments() {
        return this.segments;
    }

    @Override
    public TypeReference<SegmentPublishResult> getReturnTypeReference() {
        return new TypeReference<SegmentPublishResult>(){};
    }

    @Override
    public SegmentPublishResult perform(Task task, TaskActionToolbox toolbox) {
        SegmentPublishResult publishResult;
        TaskLocks.checkLockCoversSegments(task, toolbox.getTaskLockbox(), this.segments);
        Set<ReplaceTaskLock> replaceLocksForTask = toolbox.getTaskLockbox().findReplaceLocksForTask(task);
        try {
            publishResult = toolbox.getTaskLockbox().doInCriticalSection(task, this.segments.stream().map(DataSegment::getInterval).collect(Collectors.toSet()), CriticalAction.builder().onValidLocks(() -> toolbox.getIndexerMetadataStorageCoordinator().commitReplaceSegments(this.segments, replaceLocksForTask)).onInvalidLocks(() -> SegmentPublishResult.fail((String)"Invalid task locks. Maybe they are revoked by a higher priority task. Please check the overlord log for details.")).build());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        IndexTaskUtils.emitSegmentPublishMetrics(publishResult, task, toolbox);
        if (publishResult.isSuccess() && toolbox.getSupervisorManager() != null) {
            try {
                this.tryUpgradeOverlappingPendingSegments(task, toolbox);
            }
            catch (Exception e) {
                log.error((Throwable)e, "Error while upgrading pending segments for task[%s]", new Object[]{task.getId()});
            }
        }
        return publishResult;
    }

    private void tryUpgradeOverlappingPendingSegments(Task task, TaskActionToolbox toolbox) {
        SupervisorManager supervisorManager = toolbox.getSupervisorManager();
        Optional<String> activeSupervisorIdWithAppendLock = supervisorManager.getActiveSupervisorIdForDatasourceWithAppendLock(task.getDataSource());
        if (!activeSupervisorIdWithAppendLock.isPresent()) {
            return;
        }
        Set<String> activeRealtimeSequencePrefixes = supervisorManager.getActiveRealtimeSequencePrefixes((String)activeSupervisorIdWithAppendLock.get());
        Map upgradedPendingSegments = toolbox.getIndexerMetadataStorageCoordinator().upgradePendingSegmentsOverlappingWith(this.segments, activeRealtimeSequencePrefixes);
        log.info("Upgraded [%d] pending segments for REPLACE task[%s]: [%s]", new Object[]{upgradedPendingSegments.size(), task.getId(), upgradedPendingSegments});
        upgradedPendingSegments.forEach((oldId, newId) -> toolbox.getSupervisorManager().registerNewVersionOfPendingSegmentOnSupervisor((String)activeSupervisorIdWithAppendLock.get(), (SegmentIdWithShardSpec)oldId, (SegmentIdWithShardSpec)newId));
    }

    @Override
    public boolean isAudited() {
        return true;
    }

    @Override
    public String toString() {
        return "SegmentTransactionalReplaceAction{segments=" + SegmentUtils.commaSeparatedIdentifiers(this.segments) + '}';
    }
}

