/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.index;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import java.io.File;
import javax.annotation.Nullable;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.incremental.AppendableIndexSpec;
import org.apache.druid.segment.realtime.appenderator.AppenderatorConfig;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.Period;

@JsonTypeName(value="realtime_appenderator")
public class RealtimeAppenderatorTuningConfig
implements AppenderatorConfig {
    private static final Period DEFAULT_INTERMEDIATE_PERSIST_PERIOD = new Period((Object)"PT10M");
    private static final int DEFAULT_MAX_PENDING_PERSISTS = 0;
    private static final ShardSpec DEFAULT_SHARD_SPEC = new NumberedShardSpec(0, 1);
    private static final IndexSpec DEFAULT_INDEX_SPEC = IndexSpec.DEFAULT;
    private static final Boolean DEFAULT_REPORT_PARSE_EXCEPTIONS = Boolean.FALSE;
    private static final long DEFAULT_HANDOFF_CONDITION_TIMEOUT = 0L;
    private static final long DEFAULT_ALERT_TIMEOUT = 0L;
    private final AppendableIndexSpec appendableIndexSpec;
    private final int maxRowsInMemory;
    private final long maxBytesInMemory;
    private final boolean skipBytesInMemoryOverheadCheck;
    private final DynamicPartitionsSpec partitionsSpec;
    private final Period intermediatePersistPeriod;
    private final File basePersistDirectory;
    private final int maxPendingPersists;
    private final ShardSpec shardSpec;
    private final IndexSpec indexSpec;
    private final IndexSpec indexSpecForIntermediatePersists;
    private final boolean reportParseExceptions;
    private final long publishAndHandoffTimeout;
    private final long alertTimeout;
    @Nullable
    private final SegmentWriteOutMediumFactory segmentWriteOutMediumFactory;
    private final boolean logParseExceptions;
    private final int maxParseExceptions;
    private final int maxSavedParseExceptions;

    public RealtimeAppenderatorTuningConfig(@Nullable AppendableIndexSpec appendableIndexSpec, Integer maxRowsInMemory, @Nullable Long maxBytesInMemory, @Nullable Boolean skipBytesInMemoryOverheadCheck, @Nullable Integer maxRowsPerSegment, @Nullable Long maxTotalRows, Period intermediatePersistPeriod, File basePersistDirectory, Integer maxPendingPersists, ShardSpec shardSpec, IndexSpec indexSpec, @Nullable IndexSpec indexSpecForIntermediatePersists, Boolean reportParseExceptions, Long publishAndHandoffTimeout, Long alertTimeout, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory, @Nullable Boolean logParseExceptions, @Nullable Integer maxParseExceptions, @Nullable Integer maxSavedParseExceptions) {
        this.appendableIndexSpec = appendableIndexSpec == null ? DEFAULT_APPENDABLE_INDEX : appendableIndexSpec;
        this.maxRowsInMemory = maxRowsInMemory == null ? 150000 : maxRowsInMemory;
        this.maxBytesInMemory = maxBytesInMemory == null ? 0L : maxBytesInMemory;
        this.skipBytesInMemoryOverheadCheck = skipBytesInMemoryOverheadCheck == null ? false : skipBytesInMemoryOverheadCheck;
        this.partitionsSpec = new DynamicPartitionsSpec(maxRowsPerSegment, maxTotalRows);
        this.intermediatePersistPeriod = intermediatePersistPeriod == null ? DEFAULT_INTERMEDIATE_PERSIST_PERIOD : intermediatePersistPeriod;
        this.basePersistDirectory = basePersistDirectory;
        this.maxPendingPersists = maxPendingPersists == null ? 0 : maxPendingPersists;
        this.shardSpec = shardSpec == null ? DEFAULT_SHARD_SPEC : shardSpec;
        this.indexSpec = indexSpec == null ? DEFAULT_INDEX_SPEC : indexSpec;
        this.indexSpecForIntermediatePersists = indexSpecForIntermediatePersists == null ? this.indexSpec : indexSpecForIntermediatePersists;
        this.reportParseExceptions = reportParseExceptions == null ? DEFAULT_REPORT_PARSE_EXCEPTIONS : reportParseExceptions;
        this.publishAndHandoffTimeout = publishAndHandoffTimeout == null ? 0L : publishAndHandoffTimeout;
        Preconditions.checkArgument((this.publishAndHandoffTimeout >= 0L ? 1 : 0) != 0, (Object)"publishAndHandoffTimeout must be >= 0");
        this.alertTimeout = alertTimeout == null ? 0L : alertTimeout;
        Preconditions.checkArgument((this.alertTimeout >= 0L ? 1 : 0) != 0, (Object)"alertTimeout must be >= 0");
        this.segmentWriteOutMediumFactory = segmentWriteOutMediumFactory;
        if (this.reportParseExceptions) {
            this.maxParseExceptions = 0;
            this.maxSavedParseExceptions = maxSavedParseExceptions == null ? 0 : Math.min(1, maxSavedParseExceptions);
        } else {
            this.maxParseExceptions = maxParseExceptions == null ? Integer.MAX_VALUE : maxParseExceptions;
            this.maxSavedParseExceptions = maxSavedParseExceptions == null ? 0 : maxSavedParseExceptions;
        }
        this.logParseExceptions = logParseExceptions == null ? false : logParseExceptions;
    }

    @JsonCreator
    private RealtimeAppenderatorTuningConfig(@JsonProperty(value="appendableIndexSpec") @Nullable AppendableIndexSpec appendableIndexSpec, @JsonProperty(value="maxRowsInMemory") Integer maxRowsInMemory, @JsonProperty(value="maxBytesInMemory") @Nullable Long maxBytesInMemory, @JsonProperty(value="skipBytesInMemoryOverheadCheck") @Nullable Boolean skipBytesInMemoryOverheadCheck, @JsonProperty(value="maxRowsPerSegment") @Nullable Integer maxRowsPerSegment, @JsonProperty(value="maxTotalRows") @Nullable Long maxTotalRows, @JsonProperty(value="intermediatePersistPeriod") Period intermediatePersistPeriod, @JsonProperty(value="maxPendingPersists") Integer maxPendingPersists, @JsonProperty(value="shardSpec") ShardSpec shardSpec, @JsonProperty(value="indexSpec") IndexSpec indexSpec, @JsonProperty(value="indexSpecForIntermediatePersists") @Nullable IndexSpec indexSpecForIntermediatePersists, @JsonProperty(value="reportParseExceptions") Boolean reportParseExceptions, @JsonProperty(value="publishAndHandoffTimeout") Long publishAndHandoffTimeout, @JsonProperty(value="alertTimeout") Long alertTimeout, @JsonProperty(value="segmentWriteOutMediumFactory") @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory, @JsonProperty(value="logParseExceptions") @Nullable Boolean logParseExceptions, @JsonProperty(value="maxParseExceptions") @Nullable Integer maxParseExceptions, @JsonProperty(value="maxSavedParseExceptions") @Nullable Integer maxSavedParseExceptions) {
        this(appendableIndexSpec, maxRowsInMemory, maxBytesInMemory, skipBytesInMemoryOverheadCheck, maxRowsPerSegment, maxTotalRows, intermediatePersistPeriod, null, maxPendingPersists, shardSpec, indexSpec, indexSpecForIntermediatePersists, reportParseExceptions, publishAndHandoffTimeout, alertTimeout, segmentWriteOutMediumFactory, logParseExceptions, maxParseExceptions, maxSavedParseExceptions);
    }

    @JsonProperty
    public AppendableIndexSpec getAppendableIndexSpec() {
        return this.appendableIndexSpec;
    }

    @JsonProperty
    public int getMaxRowsInMemory() {
        return this.maxRowsInMemory;
    }

    @JsonProperty
    public long getMaxBytesInMemory() {
        return this.maxBytesInMemory;
    }

    @JsonProperty
    public boolean isSkipBytesInMemoryOverheadCheck() {
        return this.skipBytesInMemoryOverheadCheck;
    }

    @JsonProperty
    public Integer getMaxRowsPerSegment() {
        return this.partitionsSpec.getMaxRowsPerSegment();
    }

    @JsonProperty
    @Nullable
    public Long getMaxTotalRows() {
        return this.partitionsSpec.getMaxTotalRows();
    }

    public DynamicPartitionsSpec getPartitionsSpec() {
        return this.partitionsSpec;
    }

    @JsonProperty
    public Period getIntermediatePersistPeriod() {
        return this.intermediatePersistPeriod;
    }

    public File getBasePersistDirectory() {
        return (File)Preconditions.checkNotNull((Object)this.basePersistDirectory, (Object)"basePersistDirectory not set");
    }

    @JsonProperty
    public int getMaxPendingPersists() {
        return this.maxPendingPersists;
    }

    @JsonProperty
    public ShardSpec getShardSpec() {
        return this.shardSpec;
    }

    @JsonProperty
    public IndexSpec getIndexSpec() {
        return this.indexSpec;
    }

    @JsonProperty
    public IndexSpec getIndexSpecForIntermediatePersists() {
        return this.indexSpecForIntermediatePersists;
    }

    @JsonProperty
    public boolean isReportParseExceptions() {
        return this.reportParseExceptions;
    }

    @JsonProperty
    public long getPublishAndHandoffTimeout() {
        return this.publishAndHandoffTimeout;
    }

    @JsonProperty
    public long getAlertTimeout() {
        return this.alertTimeout;
    }

    @JsonProperty
    @Nullable
    public SegmentWriteOutMediumFactory getSegmentWriteOutMediumFactory() {
        return this.segmentWriteOutMediumFactory;
    }

    @JsonProperty
    public boolean isLogParseExceptions() {
        return this.logParseExceptions;
    }

    @JsonProperty
    public int getMaxParseExceptions() {
        return this.maxParseExceptions;
    }

    @JsonProperty
    public int getMaxSavedParseExceptions() {
        return this.maxSavedParseExceptions;
    }

    public RealtimeAppenderatorTuningConfig withBasePersistDirectory(File dir) {
        return new RealtimeAppenderatorTuningConfig(this.appendableIndexSpec, this.maxRowsInMemory, this.maxBytesInMemory, this.skipBytesInMemoryOverheadCheck, this.partitionsSpec.getMaxRowsPerSegment(), this.partitionsSpec.getMaxTotalRows(), this.intermediatePersistPeriod, dir, this.maxPendingPersists, this.shardSpec, this.indexSpec, this.indexSpecForIntermediatePersists, this.reportParseExceptions, this.publishAndHandoffTimeout, this.alertTimeout, this.segmentWriteOutMediumFactory, this.logParseExceptions, this.maxParseExceptions, this.maxSavedParseExceptions);
    }
}

