/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.RetrieveUnusedSegmentsAction;
import org.apache.druid.indexing.common.actions.SegmentMetadataUpdateAction;
import org.apache.druid.indexing.common.task.AbstractFixedIntervalTask;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;

public class ArchiveTask
extends AbstractFixedIntervalTask {
    private static final Logger log = new Logger(ArchiveTask.class);

    public ArchiveTask(@JsonProperty(value="id") String id, @JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="interval") Interval interval, @JsonProperty(value="context") Map<String, Object> context) {
        super(ArchiveTask.getOrMakeId(id, "archive", dataSource, interval), dataSource, interval, context);
    }

    @Override
    public String getType() {
        return "archive";
    }

    @Override
    @Nonnull
    @JsonIgnore
    public Set<ResourceAction> getInputSourceResources() {
        return ImmutableSet.of();
    }

    @Override
    public TaskStatus runTask(TaskToolbox toolbox) throws Exception {
        TaskLock myLock = this.getAndCheckLock(toolbox);
        List<DataSegment> unusedSegments = toolbox.getTaskActionClient().submit(new RetrieveUnusedSegmentsAction(myLock.getDataSource(), myLock.getInterval(), null, null));
        for (DataSegment unusedSegment : unusedSegments) {
            if (unusedSegment.getVersion().compareTo(myLock.getVersion()) > 0) {
                throw new ISE("Unused segment[%s] has version[%s] > task version[%s]", new Object[]{unusedSegment.getId(), unusedSegment.getVersion(), myLock.getVersion()});
            }
            log.info("OK to archive segment: %s", new Object[]{unusedSegment.getId()});
        }
        for (DataSegment segment : unusedSegments) {
            DataSegment archivedSegment = toolbox.getDataSegmentArchiver().archive(segment);
            if (archivedSegment != null) {
                toolbox.getTaskActionClient().submit(new SegmentMetadataUpdateAction((Set<DataSegment>)ImmutableSet.of((Object)archivedSegment)));
                continue;
            }
            log.info("No action was taken for [%s]", new Object[]{segment.getId()});
        }
        return TaskStatus.success((String)this.getId());
    }
}

