/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.LockListAction;
import org.apache.druid.indexing.common.actions.SurrogateAction;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.task.NonLinearlyPartitionedSequenceNameFunction;
import org.apache.druid.indexing.common.task.SegmentAllocatorForBatch;
import org.apache.druid.indexing.common.task.SequenceNameFunction;
import org.apache.druid.indexing.common.task.ShardSpecs;
import org.apache.druid.indexing.common.task.batch.parallel.SupervisorTaskAccess;
import org.apache.druid.indexing.common.task.batch.partition.CompletePartitionAnalysis;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.timeline.partition.BucketNumberedShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;

public class CachingLocalSegmentAllocator
implements SegmentAllocatorForBatch {
    private final String dataSource;
    private final Map<String, Pair<Interval, BucketNumberedShardSpec>> sequenceNameToBucket;
    private final Function<Interval, String> versionFinder;
    private final NonLinearlyPartitionedSequenceNameFunction sequenceNameFunction;
    private final boolean isParallel;
    private final Map<String, SegmentIdWithShardSpec> sequenceNameToSegmentId = new HashMap<String, SegmentIdWithShardSpec>();
    private final Object2IntMap<Interval> intervalToNextPartitionId = new Object2IntOpenHashMap();

    CachingLocalSegmentAllocator(TaskToolbox toolbox, String dataSource, String baseSequenceName, GranularitySpec granularitySpec, @Nullable SupervisorTaskAccess supervisorTaskAccess, CompletePartitionAnalysis<?, ?> partitionAnalysis) throws IOException {
        TaskAction<List<TaskLock>> action;
        this.dataSource = dataSource;
        this.sequenceNameToBucket = new HashMap<String, Pair<Interval, BucketNumberedShardSpec>>();
        if (supervisorTaskAccess == null) {
            action = new LockListAction();
            this.isParallel = false;
        } else {
            action = new SurrogateAction(supervisorTaskAccess.getSupervisorTaskId(), new LockListAction());
            this.isParallel = true;
        }
        this.versionFinder = CachingLocalSegmentAllocator.createVersionFinder(toolbox, action);
        Map<Interval, List<BucketNumberedShardSpec<?>>> intervalToShardSpecs = partitionAnalysis.createBuckets(toolbox);
        this.sequenceNameFunction = new NonLinearlyPartitionedSequenceNameFunction(baseSequenceName, new ShardSpecs(intervalToShardSpecs, granularitySpec.getQueryGranularity()));
        for (Map.Entry<Interval, List<BucketNumberedShardSpec<?>>> entry : intervalToShardSpecs.entrySet()) {
            Interval interval = entry.getKey();
            List<BucketNumberedShardSpec<?>> buckets = entry.getValue();
            buckets.forEach(bucket -> this.sequenceNameToBucket.put(this.sequenceNameFunction.getSequenceName(interval, (BucketNumberedShardSpec<?>)bucket), (Pair<Interval, BucketNumberedShardSpec>)Pair.of((Object)interval, (Object)bucket)));
        }
    }

    static Function<Interval, String> createVersionFinder(TaskToolbox toolbox, TaskAction<List<TaskLock>> lockListAction) throws IOException {
        Map<Interval, String> intervalToVersion = toolbox.getTaskActionClient().submit(lockListAction).stream().collect(Collectors.toMap(TaskLock::getInterval, TaskLock::getVersion));
        return interval -> CachingLocalSegmentAllocator.findVersion(intervalToVersion, interval);
    }

    private static String findVersion(Map<Interval, String> intervalToVersion, Interval interval) {
        return intervalToVersion.entrySet().stream().filter(entry -> ((Interval)entry.getKey()).contains((ReadableInterval)interval)).map(Map.Entry::getValue).findFirst().orElseThrow(() -> new ISE("Cannot find a version for interval[%s]", new Object[]{interval}));
    }

    public SegmentIdWithShardSpec allocate(InputRow row, String sequenceName, String previousSegmentId, boolean skipSegmentLineageCheck) {
        return this.sequenceNameToSegmentId.computeIfAbsent(sequenceName, k -> {
            Pair pair = (Pair)Preconditions.checkNotNull(this.sequenceNameToBucket.get(sequenceName), (String)"Missing bucket for sequence[%s]", (Object)sequenceName);
            Interval interval = (Interval)pair.lhs;
            ShardSpec shardSpec = this.isParallel ? (ShardSpec)pair.rhs : ((BucketNumberedShardSpec)pair.rhs).convert(this.intervalToNextPartitionId.computeInt((Object)interval, (i, nextPartitionId) -> nextPartitionId == null ? 0 : nextPartitionId + 1));
            String version = this.versionFinder.apply(interval);
            return new SegmentIdWithShardSpec(this.dataSource, interval, version, shardSpec);
        });
    }

    @Override
    public SequenceNameFunction getSequenceNameFunction() {
        return this.sequenceNameFunction;
    }
}

