/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.curator.shaded.com.google.common.base.Verify;
import org.apache.druid.client.coordinator.CoordinatorClient;
import org.apache.druid.client.indexing.ClientCompactionTaskGranularitySpec;
import org.apache.druid.client.indexing.ClientCompactionTaskTransformSpec;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.data.input.SplitHintSpec;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.indexer.Checks;
import org.apache.druid.indexer.Property;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexing.common.LockGranularity;
import org.apache.druid.indexing.common.RetryPolicyFactory;
import org.apache.druid.indexing.common.SegmentCacheManagerFactory;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.RetrieveUsedSegmentsAction;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.task.AbstractBatchIndexTask;
import org.apache.druid.indexing.common.task.CompactionIOConfig;
import org.apache.druid.indexing.common.task.CompactionInputSpec;
import org.apache.druid.indexing.common.task.CompactionIntervalSpec;
import org.apache.druid.indexing.common.task.CurrentSubTaskHolder;
import org.apache.druid.indexing.common.task.IndexTask;
import org.apache.druid.indexing.common.task.SpecificSegmentsSpec;
import org.apache.druid.indexing.common.task.TaskResource;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexIOConfig;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexIngestionSpec;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSupervisorTask;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTuningConfig;
import org.apache.druid.indexing.input.DruidInputSource;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.java.util.common.NonnullPair;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.GranularityType;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.DimensionHandler;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.incremental.AppendableIndexSpec;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.TuningConfig;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.druid.segment.indexing.granularity.UniformGranularitySpec;
import org.apache.druid.segment.loading.SegmentCacheManager;
import org.apache.druid.segment.transform.TransformSpec;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentTimeline;
import org.apache.druid.timeline.TimelineObjectHolder;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInterval;

public class CompactionTask
extends AbstractBatchIndexTask {
    private static final Logger log = new Logger(CompactionTask.class);
    private static final Clock UTC_CLOCK = Clock.systemUTC();
    public static final String CTX_KEY_APPENDERATOR_TRACKING_TASK_ID = "appenderatorTrackingTaskId";
    private static final String TYPE = "compact";
    private static final boolean STORE_COMPACTION_STATE = true;
    private final CompactionIOConfig ioConfig;
    @Nullable
    private final DimensionsSpec dimensionsSpec;
    @Nullable
    private final ClientCompactionTaskTransformSpec transformSpec;
    @Nullable
    private final AggregatorFactory[] metricsSpec;
    @Nullable
    private final ClientCompactionTaskGranularitySpec granularitySpec;
    @Nullable
    private final CompactionTuningConfig tuningConfig;
    @JsonIgnore
    private final SegmentProvider segmentProvider;
    @JsonIgnore
    private final PartitionConfigurationManager partitionConfigurationManager;
    @JsonIgnore
    private final SegmentCacheManagerFactory segmentCacheManagerFactory;
    @JsonIgnore
    private final CurrentSubTaskHolder currentSubTaskHolder = new CurrentSubTaskHolder((taskObject, config) -> {
        ParallelIndexSupervisorTask indexTask = (ParallelIndexSupervisorTask)taskObject;
        indexTask.stopGracefully((TaskConfig)config);
    });

    @JsonCreator
    public CompactionTask(@JsonProperty(value="id") @Nullable String id, @JsonProperty(value="resource") @Nullable TaskResource taskResource, @JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="interval") @Deprecated @Nullable Interval interval, @JsonProperty(value="segments") @Deprecated @Nullable List<DataSegment> segments, @JsonProperty(value="ioConfig") @Nullable CompactionIOConfig ioConfig, @JsonProperty(value="dimensions") @Nullable DimensionsSpec dimensions, @JsonProperty(value="dimensionsSpec") @Nullable DimensionsSpec dimensionsSpec, @JsonProperty(value="transformSpec") @Nullable ClientCompactionTaskTransformSpec transformSpec, @JsonProperty(value="metricsSpec") @Nullable AggregatorFactory[] metricsSpec, @JsonProperty(value="segmentGranularity") @Deprecated @Nullable Granularity segmentGranularity, @JsonProperty(value="granularitySpec") @Nullable ClientCompactionTaskGranularitySpec granularitySpec, @JsonProperty(value="tuningConfig") @Nullable TuningConfig tuningConfig, @JsonProperty(value="context") @Nullable Map<String, Object> context, @JacksonInject SegmentCacheManagerFactory segmentCacheManagerFactory) {
        super(CompactionTask.getOrMakeId(id, TYPE, dataSource), null, taskResource, dataSource, context, -1, CompactionTask.computeCompactionIngestionMode(ioConfig));
        Checks.checkOneNotNullOrEmpty((List)ImmutableList.of((Object)new Property("ioConfig", (Object)ioConfig), (Object)new Property("interval", (Object)interval), (Object)new Property("segments", segments)));
        this.ioConfig = ioConfig != null ? ioConfig : (interval != null ? new CompactionIOConfig(new CompactionIntervalSpec(interval, null), false, null) : new CompactionIOConfig(SpecificSegmentsSpec.fromSegments(segments), false, null));
        this.dimensionsSpec = dimensionsSpec == null ? dimensions : dimensionsSpec;
        this.transformSpec = transformSpec;
        this.metricsSpec = metricsSpec;
        if (granularitySpec != null && segmentGranularity != null && !segmentGranularity.equals(granularitySpec.getSegmentGranularity())) {
            throw new IAE(StringUtils.format((String)"Conflicting segment granularities found %s(segmentGranularity) and %s(granularitySpec.segmentGranularity).\nRemove `segmentGranularity` and set the `granularitySpec.segmentGranularity` to the expected granularity", (Object[])new Object[]{segmentGranularity, granularitySpec.getSegmentGranularity()}), new Object[0]);
        }
        this.granularitySpec = granularitySpec == null && segmentGranularity != null ? new ClientCompactionTaskGranularitySpec(segmentGranularity, null, null) : granularitySpec;
        this.tuningConfig = tuningConfig != null ? CompactionTask.getTuningConfig(tuningConfig) : null;
        this.segmentProvider = new SegmentProvider(dataSource, this.ioConfig.getInputSpec());
        this.partitionConfigurationManager = new PartitionConfigurationManager(this.tuningConfig);
        this.segmentCacheManagerFactory = segmentCacheManagerFactory;
    }

    @VisibleForTesting
    static CompactionTuningConfig getTuningConfig(TuningConfig tuningConfig) {
        if (tuningConfig instanceof CompactionTuningConfig) {
            return (CompactionTuningConfig)tuningConfig;
        }
        if (tuningConfig instanceof ParallelIndexTuningConfig) {
            ParallelIndexTuningConfig parallelIndexTuningConfig = (ParallelIndexTuningConfig)tuningConfig;
            return new CompactionTuningConfig(null, parallelIndexTuningConfig.getMaxRowsPerSegment(), parallelIndexTuningConfig.getAppendableIndexSpec(), parallelIndexTuningConfig.getMaxRowsInMemory(), parallelIndexTuningConfig.getMaxBytesInMemory(), parallelIndexTuningConfig.isSkipBytesInMemoryOverheadCheck(), parallelIndexTuningConfig.getMaxTotalRows(), parallelIndexTuningConfig.getNumShards(), parallelIndexTuningConfig.getSplitHintSpec(), parallelIndexTuningConfig.getPartitionsSpec(), parallelIndexTuningConfig.getIndexSpec(), parallelIndexTuningConfig.getIndexSpecForIntermediatePersists(), parallelIndexTuningConfig.getMaxPendingPersists(), parallelIndexTuningConfig.isForceGuaranteedRollup(), parallelIndexTuningConfig.isReportParseExceptions(), parallelIndexTuningConfig.getPushTimeout(), parallelIndexTuningConfig.getSegmentWriteOutMediumFactory(), null, parallelIndexTuningConfig.getMaxNumConcurrentSubTasks(), parallelIndexTuningConfig.getMaxRetry(), parallelIndexTuningConfig.getTaskStatusCheckPeriodMs(), parallelIndexTuningConfig.getChatHandlerTimeout(), parallelIndexTuningConfig.getChatHandlerNumRetries(), parallelIndexTuningConfig.getMaxNumSegmentsToMerge(), parallelIndexTuningConfig.getTotalNumMergeTasks(), parallelIndexTuningConfig.isLogParseExceptions(), parallelIndexTuningConfig.getMaxParseExceptions(), parallelIndexTuningConfig.getMaxSavedParseExceptions(), parallelIndexTuningConfig.getMaxColumnsToMerge(), parallelIndexTuningConfig.getAwaitSegmentAvailabilityTimeoutMillis());
        }
        if (tuningConfig instanceof IndexTask.IndexTuningConfig) {
            IndexTask.IndexTuningConfig indexTuningConfig = (IndexTask.IndexTuningConfig)tuningConfig;
            return new CompactionTuningConfig(null, indexTuningConfig.getMaxRowsPerSegment(), indexTuningConfig.getAppendableIndexSpec(), indexTuningConfig.getMaxRowsInMemory(), indexTuningConfig.getMaxBytesInMemory(), indexTuningConfig.isSkipBytesInMemoryOverheadCheck(), indexTuningConfig.getMaxTotalRows(), indexTuningConfig.getNumShards(), null, indexTuningConfig.getPartitionsSpec(), indexTuningConfig.getIndexSpec(), indexTuningConfig.getIndexSpecForIntermediatePersists(), indexTuningConfig.getMaxPendingPersists(), indexTuningConfig.isForceGuaranteedRollup(), indexTuningConfig.isReportParseExceptions(), indexTuningConfig.getPushTimeout(), indexTuningConfig.getSegmentWriteOutMediumFactory(), null, null, null, null, null, null, null, null, indexTuningConfig.isLogParseExceptions(), indexTuningConfig.getMaxParseExceptions(), indexTuningConfig.getMaxSavedParseExceptions(), indexTuningConfig.getMaxColumnsToMerge(), indexTuningConfig.getAwaitSegmentAvailabilityTimeoutMillis());
        }
        throw new ISE("Unknown tuningConfig type: [%s], Must be in [%s, %s, %s]", new Object[]{tuningConfig.getClass().getName(), CompactionTuningConfig.class.getName(), ParallelIndexTuningConfig.class.getName(), IndexTask.IndexTuningConfig.class.getName()});
    }

    @VisibleForTesting
    public CurrentSubTaskHolder getCurrentSubTaskHolder() {
        return this.currentSubTaskHolder;
    }

    @JsonProperty
    public CompactionIOConfig getIoConfig() {
        return this.ioConfig;
    }

    @JsonProperty
    @Nullable
    public DimensionsSpec getDimensionsSpec() {
        return this.dimensionsSpec;
    }

    @JsonProperty
    @Nullable
    public ClientCompactionTaskTransformSpec getTransformSpec() {
        return this.transformSpec;
    }

    @JsonProperty
    @Nullable
    public AggregatorFactory[] getMetricsSpec() {
        return this.metricsSpec;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty
    @Nullable
    public Granularity getSegmentGranularity() {
        return this.granularitySpec == null ? null : this.granularitySpec.getSegmentGranularity();
    }

    @JsonProperty
    @Nullable
    public ClientCompactionTaskGranularitySpec getGranularitySpec() {
        return this.granularitySpec;
    }

    @Nullable
    @JsonProperty
    public ParallelIndexTuningConfig getTuningConfig() {
        return this.tuningConfig;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    @Nonnull
    @JsonIgnore
    public Set<ResourceAction> getInputSourceResources() {
        return ImmutableSet.of();
    }

    @Override
    public int getPriority() {
        return this.getContextValue("priority", 25);
    }

    @Override
    public boolean isReady(TaskActionClient taskActionClient) throws Exception {
        List<DataSegment> segments = this.segmentProvider.findSegments(taskActionClient);
        return this.determineLockGranularityAndTryLockWithSegments(taskActionClient, segments, this.segmentProvider::checkSegments);
    }

    @Override
    public boolean requireLockExistingSegments() {
        return true;
    }

    @Override
    public List<DataSegment> findSegmentsToLock(TaskActionClient taskActionClient, List<Interval> intervals) throws IOException {
        return ImmutableList.copyOf(taskActionClient.submit(new RetrieveUsedSegmentsAction(this.getDataSource(), intervals)));
    }

    @Override
    public boolean isPerfectRollup() {
        return this.tuningConfig != null && this.tuningConfig.isForceGuaranteedRollup();
    }

    @VisibleForTesting
    void emitCompactIngestionModeMetrics(ServiceEmitter emitter, boolean isDropExisting) {
        if (emitter == null) {
            return;
        }
        this.emitMetric(emitter, "ingest/count", 1);
    }

    @Override
    public TaskStatus runTask(TaskToolbox toolbox) throws Exception {
        this.emitCompactIngestionModeMetrics(toolbox.getEmitter(), this.ioConfig.isDropExisting());
        List<ParallelIndexIngestionSpec> ingestionSpecs = CompactionTask.createIngestionSchema(UTC_CLOCK, toolbox, this.getTaskLockHelper().getLockGranularityToUse(), this.ioConfig, this.segmentProvider, this.partitionConfigurationManager, this.dimensionsSpec, this.transformSpec, this.metricsSpec, this.granularitySpec, toolbox.getCoordinatorClient(), this.segmentCacheManagerFactory, this.getMetricBuilder());
        List indexTaskSpecs = IntStream.range(0, ingestionSpecs.size()).mapToObj(i -> {
            ParallelIndexIngestionSpec ingestionSpec = (ParallelIndexIngestionSpec)((Object)((Object)ingestionSpecs.get(i)));
            String baseSequenceName = this.createIndexTaskSpecId(i);
            return this.newTask(baseSequenceName, ingestionSpec);
        }).collect(Collectors.toList());
        if (indexTaskSpecs.isEmpty()) {
            String msg = StringUtils.format((String)"Can't find segments from inputSpec[%s], nothing to do.", (Object[])new Object[]{this.ioConfig.getInputSpec()});
            log.warn(msg, new Object[0]);
            return TaskStatus.failure((String)this.getId(), (String)msg);
        }
        this.registerResourceCloserOnAbnormalExit(this.currentSubTaskHolder);
        int totalNumSpecs = indexTaskSpecs.size();
        log.info("Generated [%d] compaction task specs", new Object[]{totalNumSpecs});
        int failCnt = 0;
        for (ParallelIndexSupervisorTask eachSpec : indexTaskSpecs) {
            String json = toolbox.getJsonMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)eachSpec);
            if (!this.currentSubTaskHolder.setTask(eachSpec)) {
                String errMsg = "Task was asked to stop. Finish as failed.";
                log.info(errMsg, new Object[0]);
                return TaskStatus.failure((String)this.getId(), (String)errMsg);
            }
            try {
                if (eachSpec.isReady(toolbox.getTaskActionClient())) {
                    log.info("Running indexSpec: " + json, new Object[0]);
                    TaskStatus eachResult = eachSpec.run(toolbox);
                    if (eachResult.isSuccess()) continue;
                    ++failCnt;
                    log.warn("Failed to run indexSpec: [%s].\nTrying the next indexSpec.", new Object[]{json});
                    continue;
                }
                ++failCnt;
                log.warn("indexSpec is not ready: [%s].\nTrying the next indexSpec.", new Object[]{json});
            }
            catch (Exception e) {
                ++failCnt;
                log.warn((Throwable)e, "Failed to run indexSpec: [%s].\nTrying the next indexSpec.", new Object[]{json});
            }
        }
        String msg = StringUtils.format((String)"Ran [%d] specs, [%d] succeeded, [%d] failed", (Object[])new Object[]{totalNumSpecs, totalNumSpecs - failCnt, failCnt});
        log.info(msg, new Object[0]);
        return failCnt == 0 ? TaskStatus.success((String)this.getId()) : TaskStatus.failure((String)this.getId(), (String)msg);
    }

    @VisibleForTesting
    ParallelIndexSupervisorTask newTask(String baseSequenceName, ParallelIndexIngestionSpec ingestionSpec) {
        return new ParallelIndexSupervisorTask(this.getId(), this.getGroupId(), this.getTaskResource(), ingestionSpec, baseSequenceName, this.createContextForSubtask());
    }

    @VisibleForTesting
    Map<String, Object> createContextForSubtask() {
        HashMap<String, Object> newContext = new HashMap<String, Object>(this.getContext());
        newContext.put(CTX_KEY_APPENDERATOR_TRACKING_TASK_ID, this.getId());
        newContext.putIfAbsent("storeCompactionState", true);
        newContext.put("priority", this.getPriority());
        return newContext;
    }

    private String createIndexTaskSpecId(int i) {
        return StringUtils.format((String)"%s_%d", (Object[])new Object[]{this.getId(), i});
    }

    @VisibleForTesting
    static List<ParallelIndexIngestionSpec> createIngestionSchema(Clock clock, TaskToolbox toolbox, LockGranularity lockGranularityInUse, CompactionIOConfig ioConfig, SegmentProvider segmentProvider, PartitionConfigurationManager partitionConfigurationManager, @Nullable DimensionsSpec dimensionsSpec, @Nullable ClientCompactionTaskTransformSpec transformSpec, @Nullable AggregatorFactory[] metricsSpec, @Nullable ClientCompactionTaskGranularitySpec granularitySpec, CoordinatorClient coordinatorClient, SegmentCacheManagerFactory segmentCacheManagerFactory, ServiceMetricEvent.Builder metricBuilder) throws IOException {
        List<TimelineObjectHolder<String, DataSegment>> timelineSegments = CompactionTask.retrieveRelevantTimelineHolders(toolbox, segmentProvider, lockGranularityInUse);
        if (timelineSegments.size() == 0) {
            return Collections.emptyList();
        }
        CompactionTuningConfig compactionTuningConfig = partitionConfigurationManager.computeTuningConfig();
        if (granularitySpec == null || granularitySpec.getSegmentGranularity() == null) {
            ArrayList<ParallelIndexIngestionSpec> specs = new ArrayList<ParallelIndexIngestionSpec>();
            TreeMap<Interval, List> intervalToSegments = new TreeMap<Interval, List>(Comparators.intervalsByStartThenEnd());
            for (DataSegment dataSegment : VersionedIntervalTimeline.getAllObjects(timelineSegments)) {
                intervalToSegments.computeIfAbsent(dataSegment.getInterval(), k -> new ArrayList()).add(dataSegment);
            }
            ArrayList<NonnullPair> intervalToSegmentsUnified = new ArrayList<NonnullPair>();
            Interval union = null;
            ArrayList segments = new ArrayList();
            for (Map.Entry entry : intervalToSegments.entrySet()) {
                Interval cur = (Interval)entry.getKey();
                if (union == null) {
                    union = cur;
                    segments.addAll((Collection)entry.getValue());
                    continue;
                }
                if (union.overlaps((ReadableInterval)cur)) {
                    union = Intervals.utc((long)union.getStartMillis(), (long)Math.max(union.getEndMillis(), cur.getEndMillis()));
                    segments.addAll((Collection)entry.getValue());
                    continue;
                }
                intervalToSegmentsUnified.add(new NonnullPair((Object)union, segments));
                union = cur;
                segments = new ArrayList((Collection)entry.getValue());
            }
            intervalToSegmentsUnified.add(new NonnullPair(union, segments));
            for (NonnullPair nonnullPair : intervalToSegmentsUnified) {
                Interval interval = (Interval)nonnullPair.lhs;
                List segmentsToCompact = (List)nonnullPair.rhs;
                Granularity segmentGranularityToUse = GranularityType.fromPeriod((Period)interval.toPeriod()).getDefaultGranularity();
                DataSchema dataSchema = CompactionTask.createDataSchema(clock, toolbox.getEmitter(), metricBuilder, segmentProvider.dataSource, interval, CompactionTask.lazyFetchSegments(segmentsToCompact, toolbox.getSegmentCacheManager(), toolbox.getIndexIO()), dimensionsSpec, transformSpec, metricsSpec, granularitySpec == null ? new ClientCompactionTaskGranularitySpec(segmentGranularityToUse, null, null) : granularitySpec.withSegmentGranularity(segmentGranularityToUse));
                specs.add(new ParallelIndexIngestionSpec(dataSchema, CompactionTask.createIoConfig(toolbox, dataSchema, interval, coordinatorClient, segmentCacheManagerFactory, ioConfig), compactionTuningConfig));
            }
            return specs;
        }
        DataSchema dataSchema = CompactionTask.createDataSchema(clock, toolbox.getEmitter(), metricBuilder, segmentProvider.dataSource, JodaUtils.umbrellaInterval((Iterable)Iterables.transform((Iterable)VersionedIntervalTimeline.getAllObjects(timelineSegments), DataSegment::getInterval)), CompactionTask.lazyFetchSegments(VersionedIntervalTimeline.getAllObjects(timelineSegments), toolbox.getSegmentCacheManager(), toolbox.getIndexIO()), dimensionsSpec, transformSpec, metricsSpec, granularitySpec);
        return Collections.singletonList(new ParallelIndexIngestionSpec(dataSchema, CompactionTask.createIoConfig(toolbox, dataSchema, segmentProvider.interval, coordinatorClient, segmentCacheManagerFactory, ioConfig), compactionTuningConfig));
    }

    private static ParallelIndexIOConfig createIoConfig(TaskToolbox toolbox, DataSchema dataSchema, Interval interval, CoordinatorClient coordinatorClient, SegmentCacheManagerFactory segmentCacheManagerFactory, CompactionIOConfig compactionIOConfig) {
        Granularity segmentGranularity;
        Interval widenedInterval;
        if (!compactionIOConfig.isAllowNonAlignedInterval() && !interval.equals((Object)(widenedInterval = Intervals.utc((long)(segmentGranularity = dataSchema.getGranularitySpec().getSegmentGranularity()).bucketStart(interval.getStart()).getMillis(), (long)segmentGranularity.bucketEnd(interval.getEnd().minus(1L)).getMillis())))) {
            throw new IAE("Interval[%s] to compact is not aligned with segmentGranularity[%s]", new Object[]{interval, segmentGranularity});
        }
        return new ParallelIndexIOConfig(null, new DruidInputSource(dataSchema.getDataSource(), interval, null, null, null, null, toolbox.getIndexIO(), coordinatorClient, segmentCacheManagerFactory, toolbox.getConfig()).withTaskToolbox(toolbox), null, false, compactionIOConfig.isDropExisting());
    }

    private static List<TimelineObjectHolder<String, DataSegment>> retrieveRelevantTimelineHolders(TaskToolbox toolbox, SegmentProvider segmentProvider, LockGranularity lockGranularityInUse) throws IOException {
        List<DataSegment> usedSegments = segmentProvider.findSegments(toolbox.getTaskActionClient());
        segmentProvider.checkSegments(lockGranularityInUse, usedSegments);
        List timelineSegments = SegmentTimeline.forSegments(usedSegments).lookup(segmentProvider.interval);
        return timelineSegments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DataSchema createDataSchema(Clock clock, ServiceEmitter emitter, ServiceMetricEvent.Builder metricBuilder, String dataSource, Interval totalInterval, Iterable<Pair<DataSegment, Supplier<ResourceHolder<QueryableIndex>>>> segments, @Nullable DimensionsSpec dimensionsSpec, @Nullable ClientCompactionTaskTransformSpec transformSpec, @Nullable AggregatorFactory[] metricsSpec, @Nonnull ClientCompactionTaskGranularitySpec granularitySpec) {
        Granularity queryGranularityToUse;
        ExistingSegmentAnalyzer existingSegmentAnalyzer = new ExistingSegmentAnalyzer(segments, granularitySpec.isRollup() == null, granularitySpec.getQueryGranularity() == null, dimensionsSpec == null, metricsSpec == null);
        long start = clock.millis();
        try {
            existingSegmentAnalyzer.fetchAndProcessIfNeeded();
        }
        finally {
            if (emitter != null) {
                emitter.emit((ServiceEventBuilder)metricBuilder.setMetric("compact/segmentAnalyzer/fetchAndProcessMillis", (Number)(clock.millis() - start)));
            }
        }
        if (granularitySpec.getQueryGranularity() == null) {
            queryGranularityToUse = existingSegmentAnalyzer.getQueryGranularity();
            log.info("Generate compaction task spec with segments original query granularity [%s]", new Object[]{queryGranularityToUse});
        } else {
            queryGranularityToUse = granularitySpec.getQueryGranularity();
            log.info("Generate compaction task spec with new query granularity overrided from input [%s]", new Object[]{queryGranularityToUse});
        }
        UniformGranularitySpec uniformGranularitySpec = new UniformGranularitySpec((Granularity)Preconditions.checkNotNull((Object)granularitySpec.getSegmentGranularity()), queryGranularityToUse, granularitySpec.isRollup() == null ? existingSegmentAnalyzer.getRollup() : granularitySpec.isRollup(), Collections.singletonList(totalInterval));
        DimensionsSpec finalDimensionsSpec = dimensionsSpec == null ? existingSegmentAnalyzer.getDimensionsSpec() : dimensionsSpec;
        AggregatorFactory[] finalMetricsSpec = metricsSpec == null ? existingSegmentAnalyzer.getMetricsSpec() : metricsSpec;
        return new DataSchema(dataSource, new TimestampSpec("__time", "millis", null), finalDimensionsSpec, finalMetricsSpec, (GranularitySpec)uniformGranularitySpec, transformSpec == null ? null : new TransformSpec(transformSpec.getFilter(), null));
    }

    private static Iterable<Pair<DataSegment, Supplier<ResourceHolder<QueryableIndex>>>> lazyFetchSegments(Iterable<DataSegment> dataSegments, SegmentCacheManager segmentCacheManager, IndexIO indexIO) {
        return Iterables.transform((Iterable)Iterables.filter(dataSegments, dataSegment -> !dataSegment.isTombstone()), dataSegment -> CompactionTask.fetchSegment(dataSegment, segmentCacheManager, indexIO));
    }

    private static Pair<DataSegment, Supplier<ResourceHolder<QueryableIndex>>> fetchSegment(DataSegment dataSegment, SegmentCacheManager segmentCacheManager, IndexIO indexIO) {
        return Pair.of((Object)dataSegment, () -> {
            try {
                final Closer closer = Closer.create();
                File file = segmentCacheManager.getSegmentFiles(dataSegment);
                closer.register(() -> segmentCacheManager.cleanup(dataSegment));
                final QueryableIndex queryableIndex = (QueryableIndex)closer.register((Closeable)indexIO.loadIndex(file));
                return new ResourceHolder<QueryableIndex>(){

                    public QueryableIndex get() {
                        return queryableIndex;
                    }

                    public void close() {
                        try {
                            closer.close();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    static {
        Verify.verify((boolean)TYPE.equals(TYPE));
    }

    public static class CompactionTuningConfig
    extends ParallelIndexTuningConfig {
        public static final String TYPE = "compaction";

        public static CompactionTuningConfig defaultConfig() {
            return new CompactionTuningConfig(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0L);
        }

        @JsonCreator
        public CompactionTuningConfig(@JsonProperty(value="targetPartitionSize") @Deprecated @Nullable Integer targetPartitionSize, @JsonProperty(value="maxRowsPerSegment") @Deprecated @Nullable Integer maxRowsPerSegment, @JsonProperty(value="appendableIndexSpec") @Nullable AppendableIndexSpec appendableIndexSpec, @JsonProperty(value="maxRowsInMemory") @Nullable Integer maxRowsInMemory, @JsonProperty(value="maxBytesInMemory") @Nullable Long maxBytesInMemory, @JsonProperty(value="skipBytesInMemoryOverheadCheck") @Nullable Boolean skipBytesInMemoryOverheadCheck, @JsonProperty(value="maxTotalRows") @Deprecated @Nullable Long maxTotalRows, @JsonProperty(value="numShards") @Deprecated @Nullable Integer numShards, @JsonProperty(value="splitHintSpec") @Nullable SplitHintSpec splitHintSpec, @JsonProperty(value="partitionsSpec") @Nullable PartitionsSpec partitionsSpec, @JsonProperty(value="indexSpec") @Nullable IndexSpec indexSpec, @JsonProperty(value="indexSpecForIntermediatePersists") @Nullable IndexSpec indexSpecForIntermediatePersists, @JsonProperty(value="maxPendingPersists") @Nullable Integer maxPendingPersists, @JsonProperty(value="forceGuaranteedRollup") @Nullable Boolean forceGuaranteedRollup, @JsonProperty(value="reportParseExceptions") @Nullable Boolean reportParseExceptions, @JsonProperty(value="pushTimeout") @Nullable Long pushTimeout, @JsonProperty(value="segmentWriteOutMediumFactory") @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory, @JsonProperty(value="maxNumSubTasks") @Deprecated @Nullable Integer maxNumSubTasks, @JsonProperty(value="maxNumConcurrentSubTasks") @Nullable Integer maxNumConcurrentSubTasks, @JsonProperty(value="maxRetry") @Nullable Integer maxRetry, @JsonProperty(value="taskStatusCheckPeriodMs") @Nullable Long taskStatusCheckPeriodMs, @JsonProperty(value="chatHandlerTimeout") @Nullable Duration chatHandlerTimeout, @JsonProperty(value="chatHandlerNumRetries") @Nullable Integer chatHandlerNumRetries, @JsonProperty(value="maxNumSegmentsToMerge") @Nullable Integer maxNumSegmentsToMerge, @JsonProperty(value="totalNumMergeTasks") @Nullable Integer totalNumMergeTasks, @JsonProperty(value="logParseExceptions") @Nullable Boolean logParseExceptions, @JsonProperty(value="maxParseExceptions") @Nullable Integer maxParseExceptions, @JsonProperty(value="maxSavedParseExceptions") @Nullable Integer maxSavedParseExceptions, @JsonProperty(value="maxColumnsToMerge") @Nullable Integer maxColumnsToMerge, @JsonProperty(value="awaitSegmentAvailabilityTimeoutMillis") @Nullable Long awaitSegmentAvailabilityTimeoutMillis) {
            super(targetPartitionSize, maxRowsPerSegment, appendableIndexSpec, maxRowsInMemory, maxBytesInMemory, skipBytesInMemoryOverheadCheck, maxTotalRows, numShards, splitHintSpec, partitionsSpec, indexSpec, indexSpecForIntermediatePersists, maxPendingPersists, forceGuaranteedRollup, reportParseExceptions, pushTimeout, segmentWriteOutMediumFactory, maxNumSubTasks, maxNumConcurrentSubTasks, maxRetry, taskStatusCheckPeriodMs, chatHandlerTimeout, chatHandlerNumRetries, maxNumSegmentsToMerge, totalNumMergeTasks, logParseExceptions, maxParseExceptions, maxSavedParseExceptions, maxColumnsToMerge, awaitSegmentAvailabilityTimeoutMillis, null);
            Preconditions.checkArgument((awaitSegmentAvailabilityTimeoutMillis == null || awaitSegmentAvailabilityTimeoutMillis == 0L ? 1 : 0) != 0, (Object)"awaitSegmentAvailabilityTimeoutMillis is not supported for Compcation Task");
        }

        @Override
        public CompactionTuningConfig withPartitionsSpec(PartitionsSpec partitionsSpec) {
            return new CompactionTuningConfig(null, null, this.getAppendableIndexSpec(), this.getMaxRowsInMemory(), this.getMaxBytesInMemory(), this.isSkipBytesInMemoryOverheadCheck(), null, null, this.getSplitHintSpec(), partitionsSpec, this.getIndexSpec(), this.getIndexSpecForIntermediatePersists(), this.getMaxPendingPersists(), this.isForceGuaranteedRollup(), this.isReportParseExceptions(), this.getPushTimeout(), this.getSegmentWriteOutMediumFactory(), null, this.getMaxNumConcurrentSubTasks(), this.getMaxRetry(), this.getTaskStatusCheckPeriodMs(), this.getChatHandlerTimeout(), this.getChatHandlerNumRetries(), this.getMaxNumSegmentsToMerge(), this.getTotalNumMergeTasks(), this.isLogParseExceptions(), this.getMaxParseExceptions(), this.getMaxSavedParseExceptions(), this.getMaxColumnsToMerge(), this.getAwaitSegmentAvailabilityTimeoutMillis());
        }
    }

    public static class Builder {
        private final String dataSource;
        private final SegmentCacheManagerFactory segmentCacheManagerFactory;
        private final RetryPolicyFactory retryPolicyFactory;
        private CompactionIOConfig ioConfig;
        @Nullable
        private DimensionsSpec dimensionsSpec;
        @Nullable
        private ClientCompactionTaskTransformSpec transformSpec;
        @Nullable
        private AggregatorFactory[] metricsSpec;
        @Nullable
        private Granularity segmentGranularity;
        @Nullable
        private ClientCompactionTaskGranularitySpec granularitySpec;
        @Nullable
        private TuningConfig tuningConfig;
        @Nullable
        private Map<String, Object> context;

        public Builder(String dataSource, SegmentCacheManagerFactory segmentCacheManagerFactory, RetryPolicyFactory retryPolicyFactory) {
            this.dataSource = dataSource;
            this.segmentCacheManagerFactory = segmentCacheManagerFactory;
            this.retryPolicyFactory = retryPolicyFactory;
        }

        public Builder interval(Interval interval) {
            return this.inputSpec(new CompactionIntervalSpec(interval, null));
        }

        public Builder segments(List<DataSegment> segments) {
            return this.inputSpec(SpecificSegmentsSpec.fromSegments(segments));
        }

        public Builder ioConfig(CompactionIOConfig ioConfig) {
            this.ioConfig = ioConfig;
            return this;
        }

        public Builder inputSpec(CompactionInputSpec inputSpec) {
            this.ioConfig = new CompactionIOConfig(inputSpec, false, null);
            return this;
        }

        public Builder inputSpec(CompactionInputSpec inputSpec, Boolean dropExisting) {
            this.ioConfig = new CompactionIOConfig(inputSpec, false, dropExisting);
            return this;
        }

        public Builder dimensionsSpec(DimensionsSpec dimensionsSpec) {
            this.dimensionsSpec = dimensionsSpec;
            return this;
        }

        public Builder transformSpec(ClientCompactionTaskTransformSpec transformSpec) {
            this.transformSpec = transformSpec;
            return this;
        }

        public Builder metricsSpec(AggregatorFactory[] metricsSpec) {
            this.metricsSpec = metricsSpec;
            return this;
        }

        public Builder segmentGranularity(Granularity segmentGranularity) {
            this.segmentGranularity = segmentGranularity;
            return this;
        }

        public Builder granularitySpec(ClientCompactionTaskGranularitySpec granularitySpec) {
            this.granularitySpec = granularitySpec;
            return this;
        }

        public Builder tuningConfig(TuningConfig tuningConfig) {
            this.tuningConfig = tuningConfig;
            return this;
        }

        public Builder context(Map<String, Object> context) {
            this.context = context;
            return this;
        }

        public CompactionTask build() {
            return new CompactionTask(null, null, this.dataSource, null, null, this.ioConfig, null, this.dimensionsSpec, this.transformSpec, this.metricsSpec, this.segmentGranularity, this.granularitySpec, this.tuningConfig, this.context, this.segmentCacheManagerFactory);
        }
    }

    @VisibleForTesting
    static class PartitionConfigurationManager {
        @Nullable
        private final CompactionTuningConfig tuningConfig;

        PartitionConfigurationManager(@Nullable CompactionTuningConfig tuningConfig) {
            this.tuningConfig = tuningConfig;
        }

        @Nullable
        CompactionTuningConfig computeTuningConfig() {
            CompactionTuningConfig newTuningConfig = this.tuningConfig == null ? CompactionTuningConfig.defaultConfig() : this.tuningConfig;
            PartitionsSpec partitionsSpec = newTuningConfig.getGivenOrDefaultPartitionsSpec();
            if (partitionsSpec instanceof DynamicPartitionsSpec) {
                DynamicPartitionsSpec dynamicPartitionsSpec = (DynamicPartitionsSpec)partitionsSpec;
                partitionsSpec = new DynamicPartitionsSpec(dynamicPartitionsSpec.getMaxRowsPerSegment(), Long.valueOf(dynamicPartitionsSpec.getMaxTotalRowsOr(Long.MAX_VALUE)));
            }
            return newTuningConfig.withPartitionsSpec(partitionsSpec);
        }
    }

    @VisibleForTesting
    static class SegmentProvider {
        private final String dataSource;
        private final CompactionInputSpec inputSpec;
        private final Interval interval;

        SegmentProvider(String dataSource, CompactionInputSpec inputSpec) {
            this.dataSource = (String)Preconditions.checkNotNull((Object)dataSource);
            this.inputSpec = inputSpec;
            this.interval = inputSpec.findInterval(dataSource);
        }

        List<DataSegment> findSegments(TaskActionClient actionClient) throws IOException {
            return new ArrayList<DataSegment>(actionClient.submit(new RetrieveUsedSegmentsAction(this.dataSource, (Collection<Interval>)ImmutableList.of((Object)this.interval))));
        }

        void checkSegments(LockGranularity lockGranularityInUse, List<DataSegment> latestSegments) {
            if (latestSegments.isEmpty()) {
                throw new ISE("No segments found for compaction. Please check that datasource name and interval are correct.", new Object[0]);
            }
            if (!this.inputSpec.validateSegments(lockGranularityInUse, latestSegments)) {
                throw new ISE("Specified segments in the spec are different from the current used segments. Possibly new segments would have been added or some segments have been unpublished.", new Object[0]);
            }
        }
    }

    static class ExistingSegmentAnalyzer {
        private final Iterable<Pair<DataSegment, Supplier<ResourceHolder<QueryableIndex>>>> segmentsIterable;
        private final boolean needRollup;
        private final boolean needQueryGranularity;
        private final boolean needDimensionsSpec;
        private final boolean needMetricsSpec;
        private boolean rollup = true;
        private Granularity queryGranularity;
        private final BiMap<String, Integer> uniqueDims = HashBiMap.create();
        private final Map<String, DimensionSchema> dimensionSchemaMap = new HashMap<String, DimensionSchema>();
        private final Set<List<AggregatorFactory>> aggregatorFactoryLists = new HashSet<List<AggregatorFactory>>();

        ExistingSegmentAnalyzer(Iterable<Pair<DataSegment, Supplier<ResourceHolder<QueryableIndex>>>> segmentsIterable, boolean needRollup, boolean needQueryGranularity, boolean needDimensionsSpec, boolean needMetricsSpec) {
            this.segmentsIterable = segmentsIterable;
            this.needRollup = needRollup;
            this.needQueryGranularity = needQueryGranularity;
            this.needDimensionsSpec = needDimensionsSpec;
            this.needMetricsSpec = needMetricsSpec;
        }

        public void fetchAndProcessIfNeeded() {
            if (!(this.needRollup || this.needQueryGranularity || this.needDimensionsSpec || this.needMetricsSpec)) {
                return;
            }
            List<Pair<DataSegment, Supplier<ResourceHolder<QueryableIndex>>>> segments = this.sortSegmentsListNewestFirst();
            for (Pair<DataSegment, Supplier<ResourceHolder<QueryableIndex>>> segmentPair : segments) {
                DataSegment dataSegment = (DataSegment)segmentPair.lhs;
                ResourceHolder queryableIndexHolder = (ResourceHolder)((Supplier)segmentPair.rhs).get();
                try {
                    QueryableIndex index = (QueryableIndex)queryableIndexHolder.get();
                    if (index == null) continue;
                    if (index.getMetadata() == null) {
                        throw new RE("Index metadata doesn't exist for segment [%s]. Try providing explicit rollup, queryGranularity, dimensionsSpec, and metricsSpec.", new Object[]{dataSegment.getId()});
                    }
                    this.processRollup(index);
                    this.processQueryGranularity(index);
                    this.processDimensionsSpec(index);
                    this.processMetricsSpec(index);
                }
                finally {
                    if (queryableIndexHolder == null) continue;
                    queryableIndexHolder.close();
                }
            }
        }

        public Boolean getRollup() {
            if (!this.needRollup) {
                throw new ISE("Not computing rollup", new Object[0]);
            }
            return this.rollup;
        }

        public Granularity getQueryGranularity() {
            if (!this.needQueryGranularity) {
                throw new ISE("Not computing queryGranularity", new Object[0]);
            }
            return this.queryGranularity;
        }

        public DimensionsSpec getDimensionsSpec() {
            if (!this.needDimensionsSpec) {
                throw new ISE("Not computing dimensionsSpec", new Object[0]);
            }
            BiMap orderedDims = this.uniqueDims.inverse();
            List dimensionSchemas = IntStream.range(0, orderedDims.size()).mapToObj(i -> {
                String dimName = (String)orderedDims.get((Object)i);
                return (DimensionSchema)Preconditions.checkNotNull((Object)this.dimensionSchemaMap.get(dimName), (String)"Cannot find dimension[%s] from dimensionSchemaMap", (Object)dimName);
            }).collect(Collectors.toList());
            return new DimensionsSpec(dimensionSchemas);
        }

        public AggregatorFactory[] getMetricsSpec() {
            if (!this.needMetricsSpec) {
                throw new ISE("Not computing metricsSpec", new Object[0]);
            }
            if (this.aggregatorFactoryLists.isEmpty()) {
                return new AggregatorFactory[0];
            }
            AggregatorFactory[] mergedAggregators = AggregatorFactory.mergeAggregators(this.aggregatorFactoryLists.stream().map(xs -> xs.toArray(new AggregatorFactory[0])).collect(Collectors.toList()));
            if (mergedAggregators == null) {
                throw new ISE("Failed to merge existing aggregators when generating metricsSpec; try providing explicit metricsSpec", new Object[0]);
            }
            return mergedAggregators;
        }

        private List<Pair<DataSegment, Supplier<ResourceHolder<QueryableIndex>>>> sortSegmentsListNewestFirst() {
            ArrayList segments = Lists.newArrayList(this.segmentsIterable);
            segments.sort(Comparator.comparing(o -> ((DataSegment)o.lhs).getInterval(), Comparators.intervalsByStartThenEnd().reversed()));
            return segments;
        }

        private void processRollup(QueryableIndex index) {
            if (!this.needRollup) {
                return;
            }
            Boolean isIndexRollup = index.getMetadata().isRollup();
            this.rollup = this.rollup && Boolean.valueOf(true).equals(isIndexRollup);
        }

        private void processQueryGranularity(QueryableIndex index) {
            if (!this.needQueryGranularity) {
                return;
            }
            Granularity current = index.getMetadata().getQueryGranularity();
            this.queryGranularity = ExistingSegmentAnalyzer.compareWithCurrent(this.queryGranularity, current);
        }

        private void processDimensionsSpec(QueryableIndex index) {
            if (!this.needDimensionsSpec) {
                return;
            }
            Map dimensionHandlerMap = index.getDimensionHandlers();
            for (String dimension : index.getAvailableDimensions()) {
                ColumnHolder columnHolder = (ColumnHolder)Preconditions.checkNotNull((Object)index.getColumnHolder(dimension), (String)"Cannot find column for dimension[%s]", (Object)dimension);
                if (this.uniqueDims.containsKey((Object)dimension)) continue;
                Preconditions.checkNotNull((Object)((DimensionHandler)dimensionHandlerMap.get(dimension)), (String)"Cannot find dimensionHandler for dimension[%s]", (Object)dimension);
                this.uniqueDims.put((Object)dimension, (Object)this.uniqueDims.size());
                this.dimensionSchemaMap.put(dimension, columnHolder.getColumnFormat().getColumnSchema(dimension));
            }
        }

        private void processMetricsSpec(QueryableIndex index) {
            if (!this.needMetricsSpec) {
                return;
            }
            AggregatorFactory[] aggregators = index.getMetadata().getAggregators();
            if (aggregators != null) {
                this.aggregatorFactoryLists.add(Arrays.asList(aggregators));
            }
        }

        static Granularity compareWithCurrent(Granularity queryGranularity, Granularity current) {
            if (queryGranularity == null && current != null) {
                queryGranularity = current;
            } else if (queryGranularity != null && current != null && Granularity.IS_FINER_THAN.compare(current, queryGranularity) < 0) {
                queryGranularity = current;
            }
            return queryGranularity;
        }
    }
}

