/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.google.common.base.Optional;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.apache.druid.data.input.HandlingInputRowIterator;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexing.common.task.AbstractBatchIndexTask;
import org.apache.druid.indexing.common.task.FilteringCloseableInputRowIterator;
import org.apache.druid.indexing.common.task.SequenceNameFunction;
import org.apache.druid.indexing.common.task.batch.parallel.iterator.IndexTaskInputRowIteratorBuilder;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.incremental.ParseExceptionHandler;
import org.apache.druid.segment.incremental.RowIngestionMeters;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.druid.segment.realtime.appenderator.AppenderatorDriverAddResult;
import org.apache.druid.segment.realtime.appenderator.BatchAppenderatorDriver;
import org.apache.druid.segment.realtime.appenderator.SegmentsAndCommitMetadata;
import org.joda.time.Chronology;
import org.joda.time.Interval;
import org.joda.time.chrono.ISOChronology;

public class InputSourceProcessor {
    private static final Logger LOG = new Logger(InputSourceProcessor.class);

    public static SegmentsAndCommitMetadata process(DataSchema dataSchema, BatchAppenderatorDriver driver, PartitionsSpec partitionsSpec, InputSource inputSource, @Nullable InputFormat inputFormat, File tmpDir, SequenceNameFunction sequenceNameFunction, IndexTaskInputRowIteratorBuilder inputRowIteratorBuilder, RowIngestionMeters buildSegmentsMeters, ParseExceptionHandler parseExceptionHandler, long pushTimeout) throws IOException, InterruptedException, ExecutionException, TimeoutException {
        DynamicPartitionsSpec dynamicPartitionsSpec = partitionsSpec instanceof DynamicPartitionsSpec ? (DynamicPartitionsSpec)partitionsSpec : null;
        GranularitySpec granularitySpec = dataSchema.getGranularitySpec();
        try (FilteringCloseableInputRowIterator inputRowIterator = AbstractBatchIndexTask.inputSourceReader(tmpDir, dataSchema, inputSource, inputFormat, AbstractBatchIndexTask.defaultRowFilter(granularitySpec), buildSegmentsMeters, parseExceptionHandler);){
            SegmentsAndCommitMetadata segmentsAndCommitMetadata;
            block14: {
                HandlingInputRowIterator iterator = inputRowIteratorBuilder.delegate(inputRowIterator).granularitySpec(granularitySpec).build();
                try {
                    while (iterator.hasNext()) {
                        InputRow inputRow = iterator.next();
                        if (inputRow == null) continue;
                        Optional optInterval = granularitySpec.bucketInterval(inputRow.getTimestamp());
                        Interval interval = ((Interval)optInterval.get()).withChronology((Chronology)ISOChronology.getInstanceUTC());
                        String sequenceName = sequenceNameFunction.getSequenceName(interval, inputRow);
                        AppenderatorDriverAddResult addResult = driver.add(inputRow, sequenceName);
                        if (addResult.isOk()) {
                            boolean isPushRequired;
                            if (dynamicPartitionsSpec == null || !(isPushRequired = addResult.isPushRequired(dynamicPartitionsSpec.getMaxRowsPerSegment(), Long.valueOf(dynamicPartitionsSpec.getMaxTotalRowsOr(20000000L))))) continue;
                            SegmentsAndCommitMetadata pushed = driver.pushAllAndClear(pushTimeout);
                            LOG.debugSegments((Collection)pushed.getSegments(), "Pushed segments");
                            continue;
                        }
                        throw new ISE("Failed to add a row with timestamp[%s]", new Object[]{inputRow.getTimestamp()});
                    }
                    SegmentsAndCommitMetadata pushed = driver.pushAllAndClear(pushTimeout);
                    LOG.debugSegments((Collection)pushed.getSegments(), "Pushed segments");
                    segmentsAndCommitMetadata = pushed;
                    if (iterator == null) break block14;
                }
                catch (Throwable throwable) {
                    if (iterator != null) {
                        try {
                            iterator.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                iterator.close();
            }
            return segmentsAndCommitMetadata;
        }
    }
}

