/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.task.AbstractTask;
import org.apache.druid.indexing.common.task.CachingLocalSegmentAllocator;
import org.apache.druid.indexing.common.task.LocalSegmentAllocator;
import org.apache.druid.indexing.common.task.OverlordCoordinatingSegmentAllocator;
import org.apache.druid.indexing.common.task.SegmentAllocatorForBatch;
import org.apache.druid.indexing.common.task.SupervisorTaskCoordinatingSegmentAllocator;
import org.apache.druid.indexing.common.task.TaskLockHelper;
import org.apache.druid.indexing.common.task.batch.parallel.SupervisorTaskAccess;
import org.apache.druid.indexing.common.task.batch.partition.CompletePartitionAnalysis;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;

public final class SegmentAllocators {
    public static SegmentAllocatorForBatch forLinearPartitioning(TaskToolbox toolbox, String sequenceName, @Nullable SupervisorTaskAccess supervisorTaskAccess, DataSchema dataSchema, TaskLockHelper taskLockHelper, AbstractTask.IngestionMode ingestionMode, PartitionsSpec partitionsSpec, @Nullable Boolean useLineageBasedSegmentAllocation) throws IOException {
        if (ingestionMode == AbstractTask.IngestionMode.APPEND || taskLockHelper.isUseSegmentLock()) {
            return new OverlordCoordinatingSegmentAllocator(toolbox, sequenceName, supervisorTaskAccess, dataSchema, taskLockHelper, ingestionMode, partitionsSpec);
        }
        if (supervisorTaskAccess == null) {
            return new LocalSegmentAllocator(toolbox, sequenceName, dataSchema.getDataSource(), dataSchema.getGranularitySpec());
        }
        return new SupervisorTaskCoordinatingSegmentAllocator(sequenceName, supervisorTaskAccess, (Boolean)Preconditions.checkNotNull((Object)useLineageBasedSegmentAllocation, (Object)"useLineageBasedSegmentAllocation"));
    }

    public static SegmentAllocatorForBatch forNonLinearPartitioning(TaskToolbox toolbox, String dataSource, String baseSequenceName, GranularitySpec granularitySpec, @Nullable SupervisorTaskAccess supervisorTaskAccess, CompletePartitionAnalysis partitionAnalysis) throws IOException {
        return new CachingLocalSegmentAllocator(toolbox, dataSource, baseSequenceName, granularitySpec, supervisorTaskAccess, partitionAnalysis);
    }

    private SegmentAllocators() {
    }
}

