/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.actions.LockListAction;
import org.apache.druid.indexing.common.actions.RetrieveUsedSegmentsAction;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.task.batch.TooManyBucketsException;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.IntervalsByGranularity;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.TombstoneShardSpec;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;

public class TombstoneHelper {
    private final TaskActionClient taskActionClient;

    public TombstoneHelper(TaskActionClient taskActionClient) {
        this.taskActionClient = (TaskActionClient)Preconditions.checkNotNull((Object)taskActionClient, (Object)"taskActionClient");
    }

    private List<Interval> getCondensedPushedSegmentsIntervals(Collection<DataSegment> pushedSegments) {
        ArrayList<Interval> pushedSegmentsIntervals = new ArrayList<Interval>();
        for (DataSegment pushedSegment : pushedSegments) {
            pushedSegmentsIntervals.add(pushedSegment.getInterval());
        }
        return JodaUtils.condenseIntervals(pushedSegmentsIntervals);
    }

    public Set<DataSegment> computeTombstones(DataSchema dataSchema, Map<Interval, SegmentIdWithShardSpec> tombstoneIntervalsAndVersions) {
        HashSet<DataSegment> retVal = new HashSet<DataSegment>();
        String dataSource = dataSchema.getDataSource();
        for (Map.Entry<Interval, SegmentIdWithShardSpec> tombstoneIntervalAndVersion : tombstoneIntervalsAndVersions.entrySet()) {
            DataSegment tombstone = this.createTombstoneForTimeChunkInterval(dataSource, tombstoneIntervalAndVersion.getValue().getVersion(), tombstoneIntervalAndVersion.getValue().getShardSpec(), tombstoneIntervalAndVersion.getKey());
            retVal.add(tombstone);
        }
        return retVal;
    }

    public List<Interval> computeTombstoneIntervals(Collection<DataSegment> pushedSegments, DataSchema dataSchema) throws IOException {
        ArrayList<Interval> retVal = new ArrayList<Interval>();
        GranularitySpec granularitySpec = dataSchema.getGranularitySpec();
        List<Interval> pushedSegmentsIntervals = this.getCondensedPushedSegmentsIntervals(pushedSegments);
        List<Interval> intervalsForUsedSegments = this.getExistingNonEmptyIntervalsOfDatasource(dataSchema.getGranularitySpec().inputIntervals(), dataSchema.getDataSource());
        block0: for (Interval timeChunkInterval : granularitySpec.sortedBucketIntervals()) {
            boolean isEmpty = true;
            for (Interval pushedSegmentCondensedInterval : pushedSegmentsIntervals) {
                if (!timeChunkInterval.overlaps((ReadableInterval)pushedSegmentCondensedInterval)) continue;
                isEmpty = false;
                break;
            }
            if (!isEmpty) continue;
            for (Interval usedSegmentInterval : intervalsForUsedSegments) {
                if (!timeChunkInterval.overlaps((ReadableInterval)usedSegmentInterval)) continue;
                retVal.add(timeChunkInterval);
                continue block0;
            }
        }
        return retVal;
    }

    public Set<DataSegment> computeTombstoneSegmentsForReplace(List<Interval> intervalsToDrop, List<Interval> intervalsToReplace, String dataSource, Granularity replaceGranularity, int maxBuckets) throws IOException {
        Set<Interval> tombstoneIntervals = this.computeTombstoneIntervalsForReplace(intervalsToDrop, intervalsToReplace, dataSource, replaceGranularity, maxBuckets);
        List<TaskLock> locks = this.taskActionClient.submit(new LockListAction());
        HashSet<DataSegment> tombstones = new HashSet<DataSegment>();
        for (Interval tombstoneInterval : tombstoneIntervals) {
            String version = null;
            for (TaskLock lock : locks) {
                if (!lock.getInterval().contains((ReadableInterval)tombstoneInterval)) continue;
                version = lock.getVersion();
            }
            if (version == null) {
                throw new ISE("Unable to fetch the version of the segments in use. The lock for the task might have been revoked", new Object[0]);
            }
            DataSegment tombstone = this.createTombstoneForTimeChunkInterval(dataSource, version, (ShardSpec)new TombstoneShardSpec(), tombstoneInterval);
            tombstones.add(tombstone);
        }
        return tombstones;
    }

    public Set<Interval> computeTombstoneIntervalsForReplace(List<Interval> intervalsToDrop, List<Interval> intervalsToReplace, String dataSource, Granularity replaceGranularity, int maxBuckets) throws IOException {
        HashSet<Interval> retVal = new HashSet<Interval>();
        List<Interval> usedIntervals = this.getExistingNonEmptyIntervalsOfDatasource(intervalsToReplace, dataSource);
        int buckets = 0;
        for (Interval intervalToDrop : intervalsToDrop) {
            for (Interval usedInterval : usedIntervals) {
                Interval overlap = intervalToDrop.overlap((ReadableInterval)usedInterval);
                if (overlap == null) continue;
                if (Intervals.isEternity((Interval)overlap)) {
                    buckets = this.validateAndIncrementBuckets(buckets, maxBuckets);
                    retVal.add(overlap);
                    continue;
                }
                if (Intervals.ETERNITY.getStart().equals((Object)overlap.getStart())) {
                    buckets = this.validateAndIncrementBuckets(buckets, maxBuckets);
                    retVal.add(new Interval((ReadableInstant)overlap.getStart(), (ReadableInstant)replaceGranularity.bucketStart(overlap.getEnd())));
                    continue;
                }
                if (Intervals.ETERNITY.getEnd().equals((Object)overlap.getEnd())) {
                    buckets = this.validateAndIncrementBuckets(buckets, maxBuckets);
                    retVal.add(new Interval((ReadableInstant)replaceGranularity.bucketStart(overlap.getStart()), (ReadableInstant)overlap.getEnd()));
                    continue;
                }
                IntervalsByGranularity intervalsToDropByGranularity = new IntervalsByGranularity((Collection)ImmutableList.of((Object)overlap), replaceGranularity);
                Iterator intervalIterator = intervalsToDropByGranularity.granularityIntervalsIterator();
                while (intervalIterator.hasNext()) {
                    buckets = this.validateAndIncrementBuckets(buckets, maxBuckets);
                    retVal.add((Interval)intervalIterator.next());
                }
            }
        }
        return retVal;
    }

    public DataSegment createTombstoneForTimeChunkInterval(String dataSource, String version, ShardSpec shardSpec, Interval timeChunkInterval) {
        HashMap<String, String> tombstoneLoadSpec = new HashMap<String, String>();
        tombstoneLoadSpec.put("type", "tombstone");
        tombstoneLoadSpec.put("path", null);
        DataSegment.Builder dataSegmentBuilder = DataSegment.builder().dataSource(dataSource).interval(timeChunkInterval).version(version).shardSpec(shardSpec).loadSpec(tombstoneLoadSpec).size(1L);
        return dataSegmentBuilder.build();
    }

    private List<Interval> getExistingNonEmptyIntervalsOfDatasource(List<Interval> inputIntervals, String dataSource) throws IOException {
        ArrayList<Interval> retVal = new ArrayList<Interval>();
        List condensedInputIntervals = JodaUtils.condenseIntervals(inputIntervals);
        if (!condensedInputIntervals.isEmpty()) {
            Collection<DataSegment> usedSegmentsInInputInterval = this.taskActionClient.submit(new RetrieveUsedSegmentsAction(dataSource, condensedInputIntervals));
            block0: for (DataSegment usedSegment : usedSegmentsInInputInterval) {
                for (Interval condensedInputInterval : condensedInputIntervals) {
                    if (!condensedInputInterval.overlaps((ReadableInterval)usedSegment.getInterval())) continue;
                    retVal.add(usedSegment.getInterval());
                    continue block0;
                }
            }
        }
        return JodaUtils.condenseIntervals(retVal);
    }

    private int validateAndIncrementBuckets(int buckets, int maxBuckets) {
        if (buckets >= maxBuckets) {
            throw new TooManyBucketsException(maxBuckets);
        }
        return buckets + 1;
    }
}

