/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.google.inject.Inject;
import java.util.Comparator;
import java.util.Optional;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.indexer.TaskInfo;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.indexing.overlord.TaskStorageQueryAdapter;
import org.apache.druid.java.util.common.DateTimes;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;

public class IndexerMetadataStorageAdapter {
    private final TaskStorageQueryAdapter taskStorageQueryAdapter;
    private final IndexerMetadataStorageCoordinator indexerMetadataStorageCoordinator;

    @Inject
    public IndexerMetadataStorageAdapter(TaskStorageQueryAdapter taskStorageQueryAdapter, IndexerMetadataStorageCoordinator indexerMetadataStorageCoordinator) {
        this.taskStorageQueryAdapter = taskStorageQueryAdapter;
        this.indexerMetadataStorageCoordinator = indexerMetadataStorageCoordinator;
    }

    public int deletePendingSegments(String dataSource, Interval deleteInterval) {
        TaskInfo earliestActiveTask;
        Interval activeTaskInterval;
        Optional<TaskInfo> earliestActiveTaskOptional = this.taskStorageQueryAdapter.getActiveTaskInfo(dataSource).stream().min(Comparator.comparing(TaskInfo::getCreatedTime));
        if (earliestActiveTaskOptional.isPresent() && deleteInterval.overlaps((ReadableInterval)(activeTaskInterval = new Interval((ReadableInstant)(earliestActiveTask = earliestActiveTaskOptional.get()).getCreatedTime(), (ReadableInstant)DateTimes.MAX)))) {
            throw InvalidInput.exception((String)"Cannot delete pendingSegments for datasource[%s] as there is at least one active task[%s] created at[%s] that overlaps with the delete interval[%s]. Please retry when there are no active tasks.", (Object[])new Object[]{dataSource, earliestActiveTask.getId(), activeTaskInterval.getStart(), deleteInterval});
        }
        return this.indexerMetadataStorageCoordinator.deletePendingSegmentsCreatedInInterval(dataSource, deleteInterval);
    }
}

