/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.druid.annotations.SuppressFBWarnings;
import org.apache.druid.common.utils.IdUtils;
import org.apache.druid.error.DruidException;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.Counters;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.actions.TaskActionClientFactory;
import org.apache.druid.indexing.common.task.IndexTaskUtils;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.common.task.batch.MaxAllowedLocksExceededException;
import org.apache.druid.indexing.overlord.Stats;
import org.apache.druid.indexing.overlord.TaskLockbox;
import org.apache.druid.indexing.overlord.TaskRunner;
import org.apache.druid.indexing.overlord.TaskRunnerWorkItem;
import org.apache.druid.indexing.overlord.TaskStorage;
import org.apache.druid.indexing.overlord.config.DefaultTaskConfig;
import org.apache.druid.indexing.overlord.config.TaskLockConfig;
import org.apache.druid.indexing.overlord.config.TaskQueueConfig;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.concurrent.ScheduledExecutors;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.metadata.EntryExistsException;
import org.apache.druid.server.coordinator.stats.CoordinatorRunStats;
import org.apache.druid.utils.CollectionUtils;
import org.joda.time.Duration;

public class TaskQueue {
    private static final long MANAGEMENT_WAIT_TIMEOUT_NANOS = TimeUnit.SECONDS.toNanos(60L);
    private static final long MIN_WAIT_TIME_MS = 100L;
    @GuardedBy(value="giant")
    private final LinkedHashMap<String, Task> tasks = new LinkedHashMap();
    @GuardedBy(value="giant")
    private final Map<String, ListenableFuture<TaskStatus>> taskFutures = new HashMap<String, ListenableFuture<TaskStatus>>();
    @GuardedBy(value="giant")
    private final Set<String> recentlyCompletedTasks = new HashSet<String>();
    private final TaskLockConfig lockConfig;
    private final TaskQueueConfig config;
    private final DefaultTaskConfig defaultTaskConfig;
    private final TaskStorage taskStorage;
    private final TaskRunner taskRunner;
    private final TaskActionClientFactory taskActionClientFactory;
    private final TaskLockbox taskLockbox;
    private final ServiceEmitter emitter;
    private final ReentrantLock giant = new ReentrantLock(true);
    private final BlockingQueue<Object> managementMayBeNecessary = new ArrayBlockingQueue<Object>(8);
    private final ExecutorService managerExec = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(false).setNameFormat("TaskQueue-Manager").build());
    private final ScheduledExecutorService storageSyncExec = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(false).setNameFormat("TaskQueue-StorageSync").build());
    private final ExecutorService taskCompleteCallbackExecutor;
    private volatile boolean active = false;
    private static final EmittingLogger log = new EmittingLogger(TaskQueue.class);
    private final ConcurrentHashMap<String, AtomicLong> totalSuccessfulTaskCount = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, AtomicLong> totalFailedTaskCount = new ConcurrentHashMap();
    @GuardedBy(value="totalSuccessfulTaskCount")
    private Map<String, Long> prevTotalSuccessfulTaskCount = new HashMap<String, Long>();
    @GuardedBy(value="totalFailedTaskCount")
    private Map<String, Long> prevTotalFailedTaskCount = new HashMap<String, Long>();
    private final AtomicInteger statusUpdatesInQueue = new AtomicInteger();
    private final AtomicInteger handledStatusUpdates = new AtomicInteger();

    public TaskQueue(TaskLockConfig lockConfig, TaskQueueConfig config, DefaultTaskConfig defaultTaskConfig, TaskStorage taskStorage, TaskRunner taskRunner, TaskActionClientFactory taskActionClientFactory, TaskLockbox taskLockbox, ServiceEmitter emitter) {
        this.lockConfig = (TaskLockConfig)Preconditions.checkNotNull((Object)lockConfig, (Object)"lockConfig");
        this.config = (TaskQueueConfig)Preconditions.checkNotNull((Object)config, (Object)"config");
        this.defaultTaskConfig = (DefaultTaskConfig)Preconditions.checkNotNull((Object)defaultTaskConfig, (Object)"defaultTaskContextConfig");
        this.taskStorage = (TaskStorage)Preconditions.checkNotNull((Object)taskStorage, (Object)"taskStorage");
        this.taskRunner = (TaskRunner)Preconditions.checkNotNull((Object)taskRunner, (Object)"taskRunner");
        this.taskActionClientFactory = (TaskActionClientFactory)Preconditions.checkNotNull((Object)taskActionClientFactory, (Object)"taskActionClientFactory");
        this.taskLockbox = (TaskLockbox)Preconditions.checkNotNull((Object)taskLockbox, (Object)"taskLockbox");
        this.emitter = (ServiceEmitter)Preconditions.checkNotNull((Object)emitter, (Object)"emitter");
        this.taskCompleteCallbackExecutor = Execs.multiThreaded((int)config.getTaskCompleteHandlerNumThreads(), (String)"TaskQueue-OnComplete-%d");
    }

    @VisibleForTesting
    void setActive(boolean active) {
        this.active = active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() {
        this.giant.lock();
        try {
            Preconditions.checkState((!this.active ? 1 : 0) != 0, (Object)"queue must be stopped");
            this.active = true;
            this.syncFromStorage();
            Set<Task> tasksToFail = this.taskLockbox.syncFromStorage().getTasksToFail();
            for (Task task : tasksToFail) {
                this.shutdown(task.getId(), "Shutting down forcefully as task failed to reacquire lock while becoming leader", new Object[0]);
            }
            this.managerExec.submit(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            TaskQueue.this.manage();
                        }
                        catch (InterruptedException e) {
                            log.info("Interrupted, exiting!", new Object[0]);
                        }
                        catch (Exception e) {
                            long restartDelay = TaskQueue.this.config.getRestartDelay().getMillis();
                            log.makeAlert((Throwable)e, "Failed to manage", new Object[0]).addData("restartDelay", (Object)restartDelay).emit();
                            try {
                                Thread.sleep(restartDelay);
                            }
                            catch (InterruptedException e2) {
                                log.info("Interrupted, exiting!", new Object[0]);
                                break;
                            }
                        }
                    }
                }
            });
            ScheduledExecutors.scheduleAtFixedRate((ScheduledExecutorService)this.storageSyncExec, (Duration)this.config.getStorageSyncRate(), (Callable)new Callable<ScheduledExecutors.Signal>(){

                @Override
                public ScheduledExecutors.Signal call() {
                    block3: {
                        try {
                            TaskQueue.this.syncFromStorage();
                        }
                        catch (Exception e) {
                            if (!TaskQueue.this.active) break block3;
                            log.makeAlert((Throwable)e, "Failed to sync with storage", new Object[0]).emit();
                        }
                    }
                    if (TaskQueue.this.active) {
                        return ScheduledExecutors.Signal.REPEAT;
                    }
                    return ScheduledExecutors.Signal.STOP;
                }
            });
            this.requestManagement();
            for (Task task : tasksToFail) {
                for (TaskLock lock : this.taskStorage.getLocks(task.getId())) {
                    this.taskStorage.removeLock(task.getId(), lock);
                }
            }
        }
        finally {
            this.giant.unlock();
        }
    }

    @LifecycleStop
    public void stop() {
        this.giant.lock();
        try {
            this.tasks.clear();
            this.taskFutures.clear();
            this.active = false;
            this.managerExec.shutdownNow();
            this.storageSyncExec.shutdownNow();
            this.requestManagement();
        }
        finally {
            this.giant.unlock();
        }
    }

    public boolean isActive() {
        return this.active;
    }

    void requestManagement() {
        this.managementMayBeNecessary.offer(this);
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"}, justification="using queue as notification mechanism, result has no value")
    void awaitManagementNanos(long nanos) throws InterruptedException {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.managementMayBeNecessary.poll(nanos - TimeUnit.MILLISECONDS.toNanos(100L), TimeUnit.NANOSECONDS);
        this.managementMayBeNecessary.clear();
    }

    private void manage() throws InterruptedException {
        log.info("Beginning management in %s.", new Object[]{this.config.getStartDelay()});
        Thread.sleep(this.config.getStartDelay().getMillis());
        this.taskRunner.restore();
        while (this.active) {
            this.manageInternal();
            this.awaitManagementNanos(MANAGEMENT_WAIT_TIMEOUT_NANOS);
        }
    }

    @VisibleForTesting
    void manageInternal() {
        HashSet<String> knownTaskIds = new HashSet<String>();
        HashMap<String, ListenableFuture<TaskStatus>> runnerTaskFutures = new HashMap<String, ListenableFuture<TaskStatus>>();
        this.giant.lock();
        try {
            this.manageInternalCritical(knownTaskIds, runnerTaskFutures);
        }
        finally {
            this.giant.unlock();
        }
        this.manageInternalPostCritical(knownTaskIds, runnerTaskFutures);
    }

    @GuardedBy(value="giant")
    private void manageInternalCritical(Set<String> knownTaskIds, Map<String, ListenableFuture<TaskStatus>> runnerTaskFutures) {
        for (TaskRunnerWorkItem taskRunnerWorkItem : this.taskRunner.getKnownTasks()) {
            if (this.recentlyCompletedTasks.contains(taskRunnerWorkItem.getTaskId())) continue;
            runnerTaskFutures.put(taskRunnerWorkItem.getTaskId(), taskRunnerWorkItem.getResult());
        }
        for (Task task : ImmutableList.copyOf(this.tasks.values())) {
            if (this.recentlyCompletedTasks.contains(task.getId())) continue;
            knownTaskIds.add(task.getId());
            if (!this.taskFutures.containsKey(task.getId())) {
                ListenableFuture<TaskStatus> runnerTaskFuture;
                if (runnerTaskFutures.containsKey(task.getId())) {
                    runnerTaskFuture = runnerTaskFutures.get(task.getId());
                } else {
                    boolean taskIsReady;
                    try {
                        taskIsReady = task.isReady(this.taskActionClientFactory.create(task));
                    }
                    catch (Exception e) {
                        log.warn((Throwable)e, "Exception thrown during isReady for task: %s", new Object[]{task.getId()});
                        String errorMessage = e instanceof MaxAllowedLocksExceededException ? e.getMessage() : "Failed while waiting for the task to be ready to run. See overlord logs for more details.";
                        this.notifyStatus(task, TaskStatus.failure((String)task.getId(), (String)errorMessage), errorMessage, new Object[0]);
                        continue;
                    }
                    if (taskIsReady) {
                        log.info("Asking taskRunner to run: %s", new Object[]{task.getId()});
                        runnerTaskFuture = this.taskRunner.run(task);
                    } else {
                        this.taskLockbox.unlockAll(task);
                        continue;
                    }
                }
                this.attachCallbacks(task, runnerTaskFuture);
                this.taskFutures.put(task.getId(), runnerTaskFuture);
                continue;
            }
            if (!this.isTaskPending(task)) continue;
            this.taskRunner.run(task);
        }
    }

    @VisibleForTesting
    private void manageInternalPostCritical(Set<String> knownTaskIds, Map<String, ListenableFuture<TaskStatus>> runnerTaskFutures) {
        Sets.SetView tasksToKill = Sets.difference(runnerTaskFutures.keySet(), knownTaskIds);
        if (!tasksToKill.isEmpty()) {
            log.info("Asking taskRunner to clean up %,d tasks.", new Object[]{tasksToKill.size()});
            boolean logKnownTaskIds = log.isDebugEnabled();
            String reason = logKnownTaskIds ? StringUtils.format((String)"Task is not in knownTaskIds[%s]", (Object[])new Object[]{knownTaskIds}) : "Task is not in knownTaskIds";
            for (String taskId : tasksToKill) {
                try {
                    this.taskRunner.shutdown(taskId, reason);
                }
                catch (Exception e) {
                    log.warn((Throwable)e, "TaskRunner failed to clean up task: %s", new Object[]{taskId});
                }
            }
        }
    }

    private boolean isTaskPending(Task task) {
        return this.taskRunner.getPendingTasks().stream().anyMatch(workItem -> workItem.getTaskId().equals(task.getId()));
    }

    public boolean add(Task task) throws EntryExistsException {
        IdUtils.validateId((String)"Task ID", (String)task.getId());
        if (this.taskStorage.getTask(task.getId()).isPresent()) {
            throw new EntryExistsException("Task", task.getId());
        }
        task.addToContextIfAbsent("forceTimeChunkLock", this.lockConfig.isForceTimeChunkLock());
        this.defaultTaskConfig.getContext().forEach(task::addToContextIfAbsent);
        task.addToContextIfAbsent("useLineageBasedSegmentAllocation", true);
        this.giant.lock();
        try {
            Preconditions.checkState((boolean)this.active, (Object)"Queue is not active!");
            Preconditions.checkNotNull((Object)task, (Object)"task");
            if (this.tasks.size() >= this.config.getMaxSize()) {
                throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.ADMIN).ofCategory(DruidException.Category.CAPACITY_EXCEEDED).build(StringUtils.format((String)"Too many tasks are in the queue (Limit = %d), (Current active tasks = %d). Retry later or increase the druid.indexer.queue.maxSize", (Object[])new Object[]{this.config.getMaxSize(), this.tasks.size()}), new Object[0]);
            }
            this.taskStorage.insert(task, TaskStatus.running((String)task.getId()));
            this.addTaskInternal(task);
            this.requestManagement();
            boolean bl = true;
            return bl;
        }
        finally {
            this.giant.unlock();
        }
    }

    @GuardedBy(value="giant")
    private void addTaskInternal(Task task) {
        Task existingTask = this.tasks.putIfAbsent(task.getId(), task);
        if (existingTask == null) {
            this.taskLockbox.add(task);
        } else if (!existingTask.equals(task)) {
            throw new ISE("Cannot add task ID [%s] with same ID as task that has already been added", new Object[]{task.getId()});
        }
    }

    @GuardedBy(value="giant")
    private boolean removeTaskInternal(String taskId) {
        Task task = (Task)this.tasks.remove(taskId);
        if (task != null) {
            this.taskLockbox.remove(task);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(String taskId, String reasonFormat, Object ... args) {
        this.giant.lock();
        try {
            Task task = this.tasks.get(Preconditions.checkNotNull((Object)taskId, (Object)"taskId"));
            if (task != null) {
                this.notifyStatus(task, TaskStatus.failure((String)taskId, (String)StringUtils.format((String)reasonFormat, (Object[])args)), reasonFormat, args);
            }
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownWithSuccess(String taskId, String reasonFormat, Object ... args) {
        this.giant.lock();
        try {
            Task task = this.tasks.get(Preconditions.checkNotNull((Object)taskId, (Object)"taskId"));
            if (task != null) {
                this.notifyStatus(task, TaskStatus.success((String)taskId), reasonFormat, args);
            }
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyStatus(Task task, TaskStatus taskStatus, String reasonFormat, Object ... args) {
        Preconditions.checkNotNull((Object)task, (Object)"task");
        Preconditions.checkNotNull((Object)taskStatus, (Object)"status");
        Preconditions.checkState((boolean)this.active, (Object)"Queue is not active!");
        Preconditions.checkArgument((boolean)task.getId().equals(taskStatus.getId()), (String)"Mismatching task ids[%s/%s]", (Object)task.getId(), (Object)taskStatus.getId());
        if (!taskStatus.isComplete()) {
            return;
        }
        this.giant.lock();
        try {
            this.recentlyCompletedTasks.add(task.getId());
        }
        finally {
            this.giant.unlock();
        }
        TaskLocation taskLocation = this.taskRunner.getTaskLocation(task.getId());
        try {
            Optional<TaskStatus> previousStatus = this.taskStorage.getStatus(task.getId());
            if (!previousStatus.isPresent() || !((TaskStatus)previousStatus.get()).isRunnable()) {
                log.makeAlert("Ignoring notification for already-complete task", new Object[0]).addData("task", (Object)task.getId()).emit();
            } else {
                this.taskStorage.setStatus(taskStatus.withLocation(taskLocation));
            }
        }
        catch (Throwable e) {
            log.makeAlert(e, "Failed to persist status for task", new Object[0]).addData("task", (Object)task.getId()).addData("statusCode", (Object)taskStatus.getStatusCode()).emit();
        }
        try {
            this.taskRunner.shutdown(task.getId(), reasonFormat, args);
        }
        catch (Throwable e) {
            log.warn(e, "TaskRunner failed to cleanup task after completion: %s", new Object[]{task.getId()});
        }
        this.giant.lock();
        try {
            if (this.removeTaskInternal(task.getId())) {
                this.taskFutures.remove(task.getId());
            } else {
                log.warn("Unknown task[%s] completed", new Object[]{task.getId()});
            }
            this.recentlyCompletedTasks.remove(task.getId());
            this.requestManagement();
        }
        finally {
            this.giant.unlock();
        }
    }

    private void attachCallbacks(final Task task, ListenableFuture<TaskStatus> statusFuture) {
        final ServiceMetricEvent.Builder metricBuilder = new ServiceMetricEvent.Builder();
        IndexTaskUtils.setTaskDimensions(metricBuilder, task);
        Futures.addCallback(statusFuture, (FutureCallback)new FutureCallback<TaskStatus>(){

            public void onSuccess(TaskStatus status) {
                log.info("Received status[%s] for task[%s].", new Object[]{status.getStatusCode(), status.getId()});
                TaskQueue.this.statusUpdatesInQueue.incrementAndGet();
                TaskQueue.this.taskCompleteCallbackExecutor.execute(() -> this.handleStatus(status));
            }

            public void onFailure(Throwable t) {
                log.makeAlert(t, "Failed to run task", new Object[0]).addData("task", (Object)task.getId()).addData("type", (Object)task.getType()).addData("dataSource", (Object)task.getDataSource()).emit();
                TaskQueue.this.statusUpdatesInQueue.incrementAndGet();
                TaskStatus status = TaskStatus.failure((String)task.getId(), (String)"Failed to run task. See overlord logs for more details.");
                TaskQueue.this.taskCompleteCallbackExecutor.execute(() -> this.handleStatus(status));
            }

            private void handleStatus(TaskStatus status) {
                try {
                    if (!TaskQueue.this.active) {
                        log.info("Abandoning task [%s] due to shutdown.", new Object[]{task.getId()});
                        return;
                    }
                    TaskQueue.this.notifyStatus(task, status, "notified status change from task", new Object[0]);
                    if (status.isComplete()) {
                        IndexTaskUtils.setTaskStatusDimensions(metricBuilder, status);
                        TaskQueue.this.emitter.emit((ServiceEventBuilder)metricBuilder.setMetric("task/run/time", (Number)status.getDuration()));
                        log.info("Completed task[%s] with status[%s] in [%d]ms.", new Object[]{task.getId(), status.getStatusCode(), status.getDuration()});
                        if (status.isSuccess()) {
                            Counters.incrementAndGetLong(TaskQueue.this.totalSuccessfulTaskCount, task.getDataSource());
                        } else {
                            Counters.incrementAndGetLong(TaskQueue.this.totalFailedTaskCount, task.getDataSource());
                        }
                    }
                }
                catch (Exception e) {
                    log.makeAlert((Throwable)e, "Failed to handle task status", new Object[0]).addData("task", (Object)task.getId()).addData("statusCode", (Object)status.getStatusCode()).emit();
                }
                finally {
                    TaskQueue.this.statusUpdatesInQueue.decrementAndGet();
                    TaskQueue.this.handledStatusUpdates.incrementAndGet();
                }
            }
        }, (Executor)Execs.directExecutor());
    }

    private void syncFromStorage() {
        this.giant.lock();
        try {
            if (this.active) {
                Map<String, Task> newTasks = TaskQueue.toTaskIDMap(this.taskStorage.getActiveTasks());
                int tasksSynced = newTasks.size();
                HashMap<String, Task> oldTasks = new HashMap<String, Task>(this.tasks);
                HashSet commonIds = Sets.newHashSet((Iterable)Sets.intersection(newTasks.keySet(), oldTasks.keySet()));
                for (String taskID : commonIds) {
                    newTasks.remove(taskID);
                    oldTasks.remove(taskID);
                }
                Collection<Task> addedTasks = newTasks.values();
                Collection removedTasks = oldTasks.values();
                for (Task task : removedTasks) {
                    this.removeTaskInternal(task.getId());
                }
                for (Task task : addedTasks) {
                    this.addTaskInternal(task);
                }
                log.info("Synced %d tasks from storage (%d tasks added, %d tasks removed).", new Object[]{tasksSynced, addedTasks.size(), removedTasks.size()});
                this.requestManagement();
            } else {
                log.info("Not active. Skipping storage sync.", new Object[0]);
            }
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Failed to sync tasks from storage!", new Object[0]);
            throw new RuntimeException(e);
        }
        finally {
            this.giant.unlock();
        }
    }

    private static Map<String, Task> toTaskIDMap(List<Task> taskList) {
        HashMap<String, Task> rv = new HashMap<String, Task>();
        for (Task task : taskList) {
            rv.put(task.getId(), task);
        }
        return rv;
    }

    private Map<String, Long> getDeltaValues(Map<String, Long> total, Map<String, Long> prev) {
        return total.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (Long)e.getValue() - prev.getOrDefault(e.getKey(), 0L)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Long> getSuccessfulTaskCount() {
        Map total = CollectionUtils.mapValues(this.totalSuccessfulTaskCount, AtomicLong::get);
        ConcurrentHashMap<String, AtomicLong> concurrentHashMap = this.totalSuccessfulTaskCount;
        synchronized (concurrentHashMap) {
            Map<String, Long> delta = this.getDeltaValues(total, this.prevTotalSuccessfulTaskCount);
            this.prevTotalSuccessfulTaskCount = total;
            return delta;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Long> getFailedTaskCount() {
        Map total = CollectionUtils.mapValues(this.totalFailedTaskCount, AtomicLong::get);
        ConcurrentHashMap<String, AtomicLong> concurrentHashMap = this.totalFailedTaskCount;
        synchronized (concurrentHashMap) {
            Map<String, Long> delta = this.getDeltaValues(total, this.prevTotalFailedTaskCount);
            this.prevTotalFailedTaskCount = total;
            return delta;
        }
    }

    Map<String, String> getCurrentTaskDatasources() {
        this.giant.lock();
        try {
            Map<String, String> map = this.tasks.values().stream().collect(Collectors.toMap(Task::getId, Task::getDataSource));
            return map;
        }
        finally {
            this.giant.unlock();
        }
    }

    public Map<String, Long> getRunningTaskCount() {
        Map<String, String> taskDatasources = this.getCurrentTaskDatasources();
        return this.taskRunner.getRunningTasks().stream().collect(Collectors.toMap(e -> taskDatasources.getOrDefault(e.getTaskId(), ""), e -> 1L, Long::sum));
    }

    public Map<String, Long> getPendingTaskCount() {
        Map<String, String> taskDatasources = this.getCurrentTaskDatasources();
        return this.taskRunner.getPendingTasks().stream().collect(Collectors.toMap(e -> taskDatasources.getOrDefault(e.getTaskId(), ""), e -> 1L, Long::sum));
    }

    public Map<String, Long> getWaitingTaskCount() {
        Set runnerKnownTaskIds = this.taskRunner.getKnownTasks().stream().map(TaskRunnerWorkItem::getTaskId).collect(Collectors.toSet());
        this.giant.lock();
        try {
            Map<String, Long> map = this.tasks.values().stream().filter(task -> !runnerKnownTaskIds.contains(task.getId())).collect(Collectors.toMap(Task::getDataSource, task -> 1L, Long::sum));
            return map;
        }
        finally {
            this.giant.unlock();
        }
    }

    public CoordinatorRunStats getQueueStats() {
        int queuedUpdates = this.statusUpdatesInQueue.get();
        int handledUpdates = this.handledStatusUpdates.getAndSet(0);
        if (queuedUpdates > 0) {
            log.info("There are [%d] task status updates in queue, handled [%d]", new Object[]{queuedUpdates, handledUpdates});
        }
        CoordinatorRunStats stats = new CoordinatorRunStats();
        stats.add(Stats.TaskQueue.STATUS_UPDATES_IN_QUEUE, (long)queuedUpdates);
        stats.add(Stats.TaskQueue.HANDLED_STATUS_UPDATES, (long)handledUpdates);
        return stats;
    }

    public Optional<Task> getActiveTask(String id) {
        this.giant.lock();
        try {
            Optional optional = Optional.fromNullable((Object)this.tasks.get(id));
            return optional;
        }
        finally {
            this.giant.unlock();
        }
    }

    @VisibleForTesting
    List<Task> getTasks() {
        this.giant.lock();
        try {
            ArrayList<Task> arrayList = new ArrayList<Task>(this.tasks.values());
            return arrayList;
        }
        finally {
            this.giant.unlock();
        }
    }
}

