/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.druid.indexer.TaskIdentifier;
import org.apache.druid.indexer.TaskInfo;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.task.ArchiveTask;
import org.apache.druid.indexing.common.task.CompactionTask;
import org.apache.druid.indexing.common.task.HadoopIndexTask;
import org.apache.druid.indexing.common.task.IndexTask;
import org.apache.druid.indexing.common.task.KillUnusedSegmentsTask;
import org.apache.druid.indexing.common.task.MoveTask;
import org.apache.druid.indexing.common.task.NoopTask;
import org.apache.druid.indexing.common.task.RestoreTask;
import org.apache.druid.indexing.common.task.TaskResource;
import org.apache.druid.indexing.common.task.batch.parallel.LegacySinglePhaseSubTask;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSupervisorTask;
import org.apache.druid.indexing.common.task.batch.parallel.PartialDimensionCardinalityTask;
import org.apache.druid.indexing.common.task.batch.parallel.PartialDimensionDistributionTask;
import org.apache.druid.indexing.common.task.batch.parallel.PartialGenericSegmentMergeTask;
import org.apache.druid.indexing.common.task.batch.parallel.PartialHashSegmentGenerateTask;
import org.apache.druid.indexing.common.task.batch.parallel.PartialRangeSegmentGenerateTask;
import org.apache.druid.indexing.common.task.batch.parallel.SinglePhaseSubTask;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.server.coordination.BroadcastDatasourceLoadingSpec;
import org.apache.druid.server.lookup.cache.LookupLoadingSpec;
import org.apache.druid.server.security.Resource;
import org.apache.druid.server.security.ResourceAction;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(name="kill", value=KillUnusedSegmentsTask.class), @JsonSubTypes.Type(name="move", value=MoveTask.class), @JsonSubTypes.Type(name="archive", value=ArchiveTask.class), @JsonSubTypes.Type(name="restore", value=RestoreTask.class), @JsonSubTypes.Type(name="index", value=IndexTask.class), @JsonSubTypes.Type(name="index_parallel", value=ParallelIndexSupervisorTask.class), @JsonSubTypes.Type(name="single_phase_sub_task", value=SinglePhaseSubTask.class), @JsonSubTypes.Type(name="index_sub", value=LegacySinglePhaseSubTask.class), @JsonSubTypes.Type(name="partial_index_generate", value=PartialHashSegmentGenerateTask.class), @JsonSubTypes.Type(name="partial_dimension_cardinality", value=PartialDimensionCardinalityTask.class), @JsonSubTypes.Type(name="partial_range_index_generate", value=PartialRangeSegmentGenerateTask.class), @JsonSubTypes.Type(name="partial_dimension_distribution", value=PartialDimensionDistributionTask.class), @JsonSubTypes.Type(name="partial_index_generic_merge", value=PartialGenericSegmentMergeTask.class), @JsonSubTypes.Type(name="index_hadoop", value=HadoopIndexTask.class), @JsonSubTypes.Type(name="noop", value=NoopTask.class), @JsonSubTypes.Type(name="compact", value=CompactionTask.class)})
public interface Task {
    public String getId();

    public String getGroupId();

    default public int getPriority() {
        return this.getContextValue("priority", 0);
    }

    public TaskResource getTaskResource();

    public String getType();

    public String getNodeType();

    public String getDataSource();

    @JsonIgnore
    @Nonnull
    default public Set<ResourceAction> getInputSourceResources() throws UOE {
        throw new UOE(StringUtils.format((String)"Task type [%s], does not support input source based security", (Object[])new Object[]{this.getType()}), new Object[0]);
    }

    public <T> QueryRunner<T> getQueryRunner(Query<T> var1);

    public boolean supportsQueries();

    public String getClasspathPrefix();

    public boolean isReady(TaskActionClient var1) throws Exception;

    public boolean canRestore();

    public void stopGracefully(TaskConfig var1);

    public TaskStatus run(TaskToolbox var1) throws Exception;

    default public void cleanUp(TaskToolbox toolbox, TaskStatus taskStatus) throws Exception {
    }

    default public boolean waitForCleanupToFinish() {
        return true;
    }

    default public Map<String, Object> addToContext(String key, Object val) {
        this.getContext().put(key, val);
        return this.getContext();
    }

    default public Map<String, Object> addToContextIfAbsent(String key, Object val) {
        this.getContext().putIfAbsent(key, val);
        return this.getContext();
    }

    public Map<String, Object> getContext();

    default public Optional<Resource> getDestinationResource() {
        return Optional.of(new Resource(this.getDataSource(), "DATASOURCE"));
    }

    default public <ContextValueType> ContextValueType getContextValue(String key) {
        return (ContextValueType)this.getContext().get(key);
    }

    default public <ContextValueType> ContextValueType getContextValue(String key, ContextValueType defaultValue) {
        ContextValueType value = this.getContextValue(key);
        return value == null ? defaultValue : value;
    }

    default public TaskIdentifier getMetadata() {
        return new TaskIdentifier(this.getId(), this.getGroupId(), this.getType());
    }

    public static TaskInfo<TaskIdentifier, TaskStatus> toTaskIdentifierInfo(TaskInfo<Task, TaskStatus> taskInfo) {
        return new TaskInfo(taskInfo.getId(), taskInfo.getCreatedTime(), taskInfo.getStatus(), taskInfo.getDataSource(), (Object)((Task)taskInfo.getTask()).getMetadata());
    }

    default public LookupLoadingSpec getLookupLoadingSpec() {
        return LookupLoadingSpec.createFromContext(this.getContext(), (LookupLoadingSpec)LookupLoadingSpec.ALL);
    }

    default public BroadcastDatasourceLoadingSpec getBroadcastDatasourceLoadingSpec() {
        return BroadcastDatasourceLoadingSpec.createFromContext(this.getContext(), (BroadcastDatasourceLoadingSpec)BroadcastDatasourceLoadingSpec.ALL);
    }
}

