/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Table;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.task.TaskResource;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTuningConfig;
import org.apache.druid.indexing.common.task.batch.parallel.PartialSegmentMergeIOConfig;
import org.apache.druid.indexing.common.task.batch.parallel.PartialSegmentMergeIngestionSpec;
import org.apache.druid.indexing.common.task.batch.parallel.PartialSegmentMergeTask;
import org.apache.druid.indexing.common.task.batch.parallel.PartitionLocation;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.timeline.partition.BuildingShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.Interval;

public class PartialGenericSegmentMergeTask
extends PartialSegmentMergeTask<BuildingShardSpec> {
    public static final String TYPE = "partial_index_generic_merge";
    private final PartialSegmentMergeIngestionSpec ingestionSchema;
    private final Table<Interval, Integer, BuildingShardSpec<?>> intervalAndIntegerToShardSpec;

    @JsonCreator
    public PartialGenericSegmentMergeTask(@JsonProperty(value="id") @Nullable String id, @JsonProperty(value="groupId") String groupId, @JsonProperty(value="resource") TaskResource taskResource, @JsonProperty(value="supervisorTaskId") String supervisorTaskId, @JsonProperty(value="subtaskSpecId") @Nullable String subtaskSpecId, @JsonProperty(value="numAttempts") int numAttempts, @JsonProperty(value="spec") PartialSegmentMergeIngestionSpec ingestionSchema, @JsonProperty(value="context") Map<String, Object> context) {
        super(PartialGenericSegmentMergeTask.getOrMakeId(id, TYPE, ingestionSchema.getDataSchema().getDataSource()), groupId, taskResource, supervisorTaskId, subtaskSpecId, ingestionSchema.getDataSchema(), (PartialSegmentMergeIOConfig)ingestionSchema.getIOConfig(), (ParallelIndexTuningConfig)ingestionSchema.getTuningConfig(), numAttempts, context);
        this.ingestionSchema = ingestionSchema;
        this.intervalAndIntegerToShardSpec = PartialGenericSegmentMergeTask.createIntervalAndIntegerToShardSpec(((PartialSegmentMergeIOConfig)ingestionSchema.getIOConfig()).getPartitionLocations());
    }

    private static Table<Interval, Integer, BuildingShardSpec<?>> createIntervalAndIntegerToShardSpec(List<PartitionLocation> partitionLocations) {
        HashBasedTable intervalAndIntegerToShardSpec = HashBasedTable.create();
        partitionLocations.forEach(arg_0 -> PartialGenericSegmentMergeTask.lambda$createIntervalAndIntegerToShardSpec$0((Table)intervalAndIntegerToShardSpec, arg_0));
        return intervalAndIntegerToShardSpec;
    }

    @JsonProperty(value="spec")
    private PartialSegmentMergeIngestionSpec getIngestionSchema() {
        return this.ingestionSchema;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    @Nonnull
    @JsonIgnore
    public Set<ResourceAction> getInputSourceResources() {
        return ImmutableSet.of();
    }

    @Override
    BuildingShardSpec<?> createShardSpec(TaskToolbox toolbox, Interval interval, int partitionId) {
        return (BuildingShardSpec)Preconditions.checkNotNull((Object)this.intervalAndIntegerToShardSpec.get((Object)interval, (Object)partitionId), (String)"no shard spec exists for interval %s, partitionId %s: %s", (Object)interval, (Object)partitionId, (Object)this.intervalAndIntegerToShardSpec.rowMap());
    }

    private static /* synthetic */ void lambda$createIntervalAndIntegerToShardSpec$0(Table intervalAndIntegerToShardSpec, PartitionLocation p) {
        ShardSpec currShardSpec = (ShardSpec)intervalAndIntegerToShardSpec.get((Object)p.getInterval(), (Object)p.getBucketId());
        if (currShardSpec == null) {
            intervalAndIntegerToShardSpec.put((Object)p.getInterval(), (Object)p.getBucketId(), (Object)p.getShardSpec());
        } else if (!p.getShardSpec().equals(currShardSpec)) {
            throw new ISE("interval %s, bucketId %s mismatched shard specs: %s and %s", new Object[]{p.getInterval(), p.getBucketId(), currShardSpec, p.getShardSpec()});
        }
    }
}

