/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.indexer.IngestionState;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexer.report.TaskReport;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.SurrogateTaskActionClient;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.task.AbstractTask;
import org.apache.druid.indexing.common.task.IndexTaskUtils;
import org.apache.druid.indexing.common.task.TaskResource;
import org.apache.druid.indexing.common.task.batch.parallel.AbstractBatchSubtask;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexIngestionSpec;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSupervisorTaskClient;
import org.apache.druid.indexing.common.task.batch.parallel.PushedSegmentsReport;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.DataSegmentsWithSchemas;
import org.apache.druid.segment.incremental.ParseExceptionHandler;
import org.apache.druid.segment.incremental.ParseExceptionReport;
import org.apache.druid.segment.incremental.RowIngestionMeters;
import org.apache.druid.segment.incremental.RowIngestionMetersTotals;
import org.apache.druid.segment.indexing.granularity.ArbitraryGranularitySpec;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.druid.segment.realtime.ChatHandler;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.Resource;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentTimeline;
import org.apache.druid.timeline.TimelineObjectHolder;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.druid.utils.CircularBuffer;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.joda.time.Interval;

public class SinglePhaseSubTask
extends AbstractBatchSubtask
implements ChatHandler {
    public static final String TYPE = "single_phase_sub_task";
    public static final String OLD_TYPE_NAME = "index_sub";
    private static final Logger LOG = new Logger(SinglePhaseSubTask.class);
    private final int numAttempts;
    private final ParallelIndexIngestionSpec ingestionSchema;
    private final String subtaskSpecId;
    private final boolean missingIntervalsInOverwriteMode;
    private @MonotonicNonNull AuthorizerMapper authorizerMapper;
    private @MonotonicNonNull RowIngestionMeters rowIngestionMeters;
    private @MonotonicNonNull ParseExceptionHandler parseExceptionHandler;
    @Nullable
    private String errorMsg;
    private IngestionState ingestionState;

    @JsonCreator
    public SinglePhaseSubTask(@JsonProperty(value="id") @Nullable String id, @JsonProperty(value="groupId") String groupId, @JsonProperty(value="resource") TaskResource taskResource, @JsonProperty(value="supervisorTaskId") String supervisorTaskId, @JsonProperty(value="subtaskSpecId") @Nullable String subtaskSpecId, @JsonProperty(value="numAttempts") int numAttempts, @JsonProperty(value="spec") ParallelIndexIngestionSpec ingestionSchema, @JsonProperty(value="context") Map<String, Object> context) {
        super(SinglePhaseSubTask.getOrMakeId(id, TYPE, ingestionSchema.getDataSchema().getDataSource()), groupId, taskResource, ingestionSchema.getDataSchema().getDataSource(), context, AbstractTask.computeBatchIngestionMode(ingestionSchema.getIOConfig()), supervisorTaskId);
        if (ingestionSchema.getTuningConfig().isForceGuaranteedRollup()) {
            throw new UnsupportedOperationException("Guaranteed rollup is not supported");
        }
        this.subtaskSpecId = subtaskSpecId;
        this.numAttempts = numAttempts;
        this.ingestionSchema = ingestionSchema;
        boolean bl = this.missingIntervalsInOverwriteMode = !ingestionSchema.getIOConfig().isAppendToExisting() && ingestionSchema.getDataSchema().getGranularitySpec().inputIntervals().isEmpty();
        if (this.missingIntervalsInOverwriteMode) {
            this.addToContext("forceTimeChunkLock", true);
        }
        this.ingestionState = IngestionState.NOT_STARTED;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    @Nonnull
    @JsonIgnore
    public Set<ResourceAction> getInputSourceResources() {
        return this.getIngestionSchema().getIOConfig().getInputSource() != null ? this.getIngestionSchema().getIOConfig().getInputSource().getTypes().stream().map(i -> new ResourceAction(new Resource(i, "EXTERNAL"), Action.READ)).collect(Collectors.toSet()) : ImmutableSet.of();
    }

    @Override
    public boolean isReady(TaskActionClient taskActionClient) throws IOException {
        return this.determineLockGranularityAndTryLock(new SurrogateTaskActionClient(this.getSupervisorTaskId(), taskActionClient), this.ingestionSchema.getDataSchema().getGranularitySpec().inputIntervals());
    }

    @JsonProperty
    public int getNumAttempts() {
        return this.numAttempts;
    }

    @JsonProperty(value="spec")
    public ParallelIndexIngestionSpec getIngestionSchema() {
        return this.ingestionSchema;
    }

    @Override
    @JsonProperty
    public String getSubtaskSpecId() {
        return this.subtaskSpecId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskStatus runTask(TaskToolbox toolbox) throws Exception {
        try {
            if (this.missingIntervalsInOverwriteMode) {
                LOG.warn("Intervals are missing in granularitySpec while this task is potentially overwriting existing segments. Forced to use timeChunk lock.", new Object[0]);
            }
            this.authorizerMapper = toolbox.getAuthorizerMapper();
            toolbox.getChatHandlerProvider().register(this.getId(), (ChatHandler)this, false);
            this.rowIngestionMeters = toolbox.getRowIngestionMetersFactory().createRowIngestionMeters();
            this.parseExceptionHandler = new ParseExceptionHandler(this.rowIngestionMeters, this.ingestionSchema.getTuningConfig().isLogParseExceptions(), this.ingestionSchema.getTuningConfig().getMaxParseExceptions(), this.ingestionSchema.getTuningConfig().getMaxSavedParseExceptions());
            InputSource inputSource = this.ingestionSchema.getIOConfig().getNonNullInputSource(toolbox);
            ParallelIndexSupervisorTaskClient taskClient = toolbox.getSupervisorTaskClientProvider().build(this.getSupervisorTaskId(), this.ingestionSchema.getTuningConfig().getChatHandlerTimeout(), this.ingestionSchema.getTuningConfig().getChatHandlerNumRetries());
            this.ingestionState = IngestionState.BUILD_SEGMENTS;
            DataSegmentsWithSchemas dataSegmentsWithSchemas = this.generateAndPushSegments(toolbox, taskClient, inputSource, toolbox.getIndexingTmpDir());
            HashSet<DataSegment> allSegments = new HashSet<DataSegment>(this.getTaskLockHelper().getLockedExistingSegments());
            allSegments.addAll(dataSegmentsWithSchemas.getSegments());
            SegmentTimeline timeline = SegmentTimeline.forSegments(allSegments);
            ImmutableSet oldSegments = FluentIterable.from((Iterable)timeline.findFullyOvershadowed()).transformAndConcat(TimelineObjectHolder::getObject).transform(PartitionChunk::getObject).toSet();
            TaskReport.ReportMap taskReport = this.getTaskCompletionReports();
            taskClient.report(new PushedSegmentsReport(this.getId(), (Set<DataSegment>)oldSegments, dataSegmentsWithSchemas.getSegments(), taskReport, dataSegmentsWithSchemas.getSegmentSchemaMapping()));
            toolbox.getTaskReportFileWriter().write(this.getId(), taskReport);
            TaskStatus taskStatus = TaskStatus.success((String)this.getId());
            return taskStatus;
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "Encountered exception in parallel sub task.", new Object[0]);
            this.errorMsg = Throwables.getStackTraceAsString((Throwable)e);
            toolbox.getTaskReportFileWriter().write(this.getId(), this.getTaskCompletionReports());
            TaskStatus taskStatus = TaskStatus.failure((String)this.getId(), (String)this.errorMsg);
            return taskStatus;
        }
        finally {
            toolbox.getChatHandlerProvider().unregister(this.getId());
        }
    }

    @Override
    public boolean requireLockExistingSegments() {
        return this.getIngestionMode() != AbstractTask.IngestionMode.APPEND;
    }

    @Override
    public List<DataSegment> findSegmentsToLock(TaskActionClient taskActionClient, List<Interval> intervals) throws IOException {
        return SinglePhaseSubTask.findInputSegments(this.getDataSource(), taskActionClient, intervals);
    }

    @Override
    public boolean isPerfectRollup() {
        return false;
    }

    @Override
    @Nullable
    public Granularity getSegmentGranularity() {
        GranularitySpec granularitySpec = this.ingestionSchema.getDataSchema().getGranularitySpec();
        if (granularitySpec instanceof ArbitraryGranularitySpec) {
            return null;
        }
        return granularitySpec.getSegmentGranularity();
    }

    /*
     * Exception decompiling
     */
    private DataSegmentsWithSchemas generateAndPushSegments(TaskToolbox toolbox, ParallelIndexSupervisorTaskClient taskClient, InputSource inputSource, File tmpDir) throws IOException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @GET
    @Path(value="/unparseableEvents")
    @Produces(value={"application/json"})
    public Response getUnparseableEvents(@Context HttpServletRequest req, @QueryParam(value="full") String full) {
        IndexTaskUtils.datasourceAuthorizationCheck(req, Action.READ, this.getDataSource(), this.authorizerMapper);
        HashMap<String, List<ParseExceptionReport>> events = new HashMap<String, List<ParseExceptionReport>>();
        if (SinglePhaseSubTask.addBuildSegmentStatsToReport(full != null, this.ingestionState)) {
            events.put("buildSegments", IndexTaskUtils.getReportListFromSavedParseExceptions((CircularBuffer<ParseExceptionReport>)this.parseExceptionHandler.getSavedParseExceptionReports()));
        }
        return Response.ok(events).build();
    }

    private Map<String, Object> doGetRowStats(boolean isFullReport) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        HashMap<String, RowIngestionMetersTotals> totalsMap = new HashMap<String, RowIngestionMetersTotals>();
        HashMap<String, Map> averagesMap = new HashMap<String, Map>();
        if (SinglePhaseSubTask.addBuildSegmentStatsToReport(isFullReport, this.ingestionState)) {
            totalsMap.put("buildSegments", this.rowIngestionMeters.getTotals());
            averagesMap.put("buildSegments", this.rowIngestionMeters.getMovingAverages());
        }
        returnMap.put("totals", totalsMap);
        returnMap.put("movingAverages", averagesMap);
        return returnMap;
    }

    @GET
    @Path(value="/rowStats")
    @Produces(value={"application/json"})
    public Response getRowStats(@Context HttpServletRequest req, @QueryParam(value="full") String full) {
        IndexTaskUtils.datasourceAuthorizationCheck(req, Action.READ, this.getDataSource(), this.authorizerMapper);
        return Response.ok(this.doGetRowStats(full != null)).build();
    }

    TaskReport.ReportMap doGetLiveReports(boolean isFullReport) {
        return this.buildLiveIngestionStatsReport(this.ingestionState, this.getTaskCompletionUnparseableEvents(), this.doGetRowStats(isFullReport));
    }

    @GET
    @Path(value="/liveReports")
    @Produces(value={"application/json"})
    public Response getLiveReports(@Context HttpServletRequest req, @QueryParam(value="full") String full) {
        IndexTaskUtils.datasourceAuthorizationCheck(req, Action.READ, this.getDataSource(), this.authorizerMapper);
        return Response.ok((Object)this.doGetLiveReports(full != null)).build();
    }

    @Override
    protected Map<String, Object> getTaskCompletionRowStats() {
        return Collections.singletonMap("buildSegments", this.rowIngestionMeters.getTotals());
    }

    private TaskReport.ReportMap getTaskCompletionReports() {
        return this.buildIngestionStatsReport(IngestionState.COMPLETED, this.errorMsg, null, null);
    }

    @Override
    protected Map<String, Object> getTaskCompletionUnparseableEvents() {
        HashMap<String, Object> unparseableEventsMap = new HashMap<String, Object>();
        List<ParseExceptionReport> parseExceptionMessages = IndexTaskUtils.getReportListFromSavedParseExceptions((CircularBuffer<ParseExceptionReport>)this.parseExceptionHandler.getSavedParseExceptionReports());
        if (parseExceptionMessages != null) {
            unparseableEventsMap.put("buildSegments", parseExceptionMessages);
        } else {
            unparseableEventsMap.put("buildSegments", ImmutableList.of());
        }
        return unparseableEventsMap;
    }
}

