/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.input;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.client.coordinator.CoordinatorClient;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.data.input.AbstractInputSource;
import org.apache.druid.data.input.ColumnsFilter;
import org.apache.druid.data.input.InputFileAttribute;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.InputSourceReader;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.data.input.MaxSizeSplitHintSpec;
import org.apache.druid.data.input.SegmentsSplitHintSpec;
import org.apache.druid.data.input.SplitHintSpec;
import org.apache.druid.data.input.impl.InputEntityIteratingReader;
import org.apache.druid.data.input.impl.SplittableInputSource;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.data.input.impl.systemfield.SystemFieldDecoratorFactory;
import org.apache.druid.indexing.common.SegmentCacheManagerFactory;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.RetrieveUsedSegmentsAction;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.input.DruidSegmentInputEntity;
import org.apache.druid.indexing.input.DruidSegmentInputFormat;
import org.apache.druid.indexing.input.TaskInputSource;
import org.apache.druid.indexing.input.WindowedSegmentId;
import org.apache.druid.java.util.common.CloseableIterators;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.loading.SegmentCacheManager;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.SegmentTimeline;
import org.apache.druid.timeline.TimelineObjectHolder;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.druid.timeline.partition.PartitionHolder;
import org.apache.druid.utils.Streams;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DruidInputSource
extends AbstractInputSource
implements SplittableInputSource<List<WindowedSegmentId>>,
TaskInputSource {
    public static final String TYPE_KEY = "druid";
    private static final Logger LOG = new Logger(DruidInputSource.class);
    private static final List<String> STANDARD_TIME_COLUMN_FORMATS = ImmutableList.of((Object)"millis", (Object)"auto");
    private static final Comparator<WindowedSegmentId> WINDOWED_SEGMENT_ID_COMPARATOR = Comparator.comparing(WindowedSegmentId::getSegmentId).thenComparing(windowedSegmentId -> windowedSegmentId.getIntervals().size()).thenComparing((a, b) -> {
        int cmp = 0;
        for (int i = 0; i < a.getIntervals().size(); ++i) {
            cmp = Comparators.intervalsByStartThenEnd().compare(a.getIntervals().get(i), b.getIntervals().get(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return cmp;
    });
    private final String dataSource;
    @Nullable
    private final Interval interval;
    @Nullable
    private final List<WindowedSegmentId> segmentIds;
    private final DimFilter dimFilter;
    private final IndexIO indexIO;
    private final CoordinatorClient coordinatorClient;
    private final SegmentCacheManagerFactory segmentCacheManagerFactory;
    private final TaskConfig taskConfig;
    private final List<String> dimensions;
    private final List<String> metrics;
    @Nullable
    private final TaskToolbox toolbox;
    @Nullable
    private Integer numSegmentsInTimeline;

    @JsonCreator
    public DruidInputSource(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="interval") @Nullable Interval interval, @JsonProperty(value="segments") @Nullable List<WindowedSegmentId> segmentIds, @JsonProperty(value="filter") DimFilter dimFilter, @Nullable @JsonProperty(value="dimensions") List<String> dimensions, @Nullable @JsonProperty(value="metrics") List<String> metrics, @JacksonInject IndexIO indexIO, @JacksonInject CoordinatorClient coordinatorClient, @JacksonInject SegmentCacheManagerFactory segmentCacheManagerFactory, @JacksonInject TaskConfig taskConfig) {
        this(dataSource, interval, segmentIds, dimFilter, dimensions, metrics, indexIO, coordinatorClient, segmentCacheManagerFactory, taskConfig, null);
    }

    private DruidInputSource(String dataSource, @Nullable Interval interval, @Nullable List<WindowedSegmentId> segmentIds, DimFilter dimFilter, List<String> dimensions, List<String> metrics, IndexIO indexIO, CoordinatorClient coordinatorClient, SegmentCacheManagerFactory segmentCacheManagerFactory, TaskConfig taskConfig, @Nullable TaskToolbox toolbox) {
        Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource");
        if (interval == null && segmentIds == null || interval != null && segmentIds != null) {
            throw new IAE("Specify exactly one of 'interval' and 'segments'", new Object[0]);
        }
        this.dataSource = dataSource;
        this.interval = interval;
        this.segmentIds = segmentIds;
        this.dimFilter = dimFilter;
        this.dimensions = dimensions;
        this.metrics = metrics;
        this.indexIO = (IndexIO)Preconditions.checkNotNull((Object)indexIO, (Object)"null IndexIO");
        this.coordinatorClient = (CoordinatorClient)Preconditions.checkNotNull((Object)coordinatorClient, (Object)"null CoordinatorClient");
        this.segmentCacheManagerFactory = (SegmentCacheManagerFactory)Preconditions.checkNotNull((Object)segmentCacheManagerFactory, (Object)"null segmentCacheManagerFactory");
        this.taskConfig = (TaskConfig)Preconditions.checkNotNull((Object)taskConfig, (Object)"null taskConfig");
        this.toolbox = toolbox;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getTypes() {
        return ImmutableSet.of((Object)TYPE_KEY);
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @Nullable
    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    @Nullable
    @JsonProperty(value="segments")
    public List<WindowedSegmentId> getSegmentIds() {
        return this.segmentIds;
    }

    @JsonProperty(value="filter")
    public DimFilter getDimFilter() {
        return this.dimFilter;
    }

    @JsonProperty
    public List<String> getDimensions() {
        return this.dimensions;
    }

    @JsonProperty
    public List<String> getMetrics() {
        return this.metrics;
    }

    @Override
    public InputSource withTaskToolbox(TaskToolbox toolbox) {
        return new DruidInputSource(this.dataSource, this.interval, this.segmentIds, this.dimFilter, this.dimensions, this.metrics, this.indexIO, this.coordinatorClient, this.segmentCacheManagerFactory, this.taskConfig, toolbox);
    }

    protected InputSourceReader fixedFormatReader(InputRowSchema inputRowSchema, @Nullable File temporaryDirectory) {
        SegmentCacheManager segmentCacheManager = this.segmentCacheManagerFactory.manufacturate(temporaryDirectory);
        List<TimelineObjectHolder<String, DataSegment>> timeline = this.createTimeline();
        Iterator entityIterator = FluentIterable.from(timeline).transformAndConcat(holder -> {
            PartitionHolder partitionHolder = holder.getObject();
            return FluentIterable.from((Iterable)partitionHolder).transform(chunk -> new DruidSegmentInputEntity(segmentCacheManager, (DataSegment)chunk.getObject(), holder.getInterval()));
        }).iterator();
        DruidSegmentInputFormat inputFormat = new DruidSegmentInputFormat(this.indexIO, this.dimFilter);
        return new InputEntityIteratingReader(this.getInputRowSchemaToUse(inputRowSchema), (InputFormat)inputFormat, CloseableIterators.withEmptyBaggage((Iterator)entityIterator), SystemFieldDecoratorFactory.NONE, temporaryDirectory);
    }

    @VisibleForTesting
    InputRowSchema getInputRowSchemaToUse(InputRowSchema inputRowSchema) {
        InputRowSchema inputRowSchemaToUse;
        ColumnsFilter columnsFilterToUse = inputRowSchema.getColumnsFilter();
        if (inputRowSchema.getMetricNames() != null) {
            for (String metricName : inputRowSchema.getMetricNames()) {
                columnsFilterToUse = columnsFilterToUse.plus(metricName);
            }
        }
        if (this.taskConfig.isIgnoreTimestampSpecForDruidInputSource()) {
            LOG.warn("Ignoring the provided timestampSpec and reading the __time column instead. To use timestampSpecs with the 'druid' input source, set druid.indexer.task.ignoreTimestampSpecForDruidInputSource to false.", new Object[0]);
            inputRowSchemaToUse = new InputRowSchema(new TimestampSpec("__time", STANDARD_TIME_COLUMN_FORMATS.iterator().next(), null), inputRowSchema.getDimensionsSpec(), columnsFilterToUse.plus("__time"));
        } else {
            inputRowSchemaToUse = new InputRowSchema(inputRowSchema.getTimestampSpec(), inputRowSchema.getDimensionsSpec(), columnsFilterToUse);
        }
        if ("__time".equals(inputRowSchemaToUse.getTimestampSpec().getTimestampColumn()) && !STANDARD_TIME_COLUMN_FORMATS.contains(inputRowSchemaToUse.getTimestampSpec().getTimestampFormat())) {
            LOG.warn("The provided timestampSpec refers to the %s column without using format %s. If you wanted to read the column as-is, switch formats.", new Object[]{inputRowSchemaToUse.getTimestampSpec().getTimestampColumn(), STANDARD_TIME_COLUMN_FORMATS});
        }
        return inputRowSchemaToUse;
    }

    private List<TimelineObjectHolder<String, DataSegment>> createTimeline() {
        List<TimelineObjectHolder<String, DataSegment>> timeline = this.interval == null ? DruidInputSource.getTimelineForSegmentIds(this.coordinatorClient, this.dataSource, this.segmentIds) : DruidInputSource.getTimelineForInterval(this.toolbox, this.coordinatorClient, this.dataSource, this.interval);
        HashSet<SegmentId> ids = new HashSet<SegmentId>();
        for (TimelineObjectHolder<String, DataSegment> holder : timeline) {
            for (PartitionChunk chunk : holder.getObject()) {
                ids.add(((DataSegment)chunk.getObject()).getId());
            }
        }
        this.numSegmentsInTimeline = ids.size();
        return timeline;
    }

    public Stream<InputSplit<List<WindowedSegmentId>>> createSplits(InputFormat inputFormat, @Nullable SplitHintSpec splitHintSpec) {
        if (this.segmentIds == null) {
            return Streams.sequentialStreamFrom(DruidInputSource.createSplits(this.toolbox, this.coordinatorClient, this.dataSource, this.interval, splitHintSpec == null ? SplittableInputSource.DEFAULT_SPLIT_HINT_SPEC : splitHintSpec));
        }
        return Stream.of(new InputSplit(this.segmentIds));
    }

    public int estimateNumSplits(InputFormat inputFormat, @Nullable SplitHintSpec splitHintSpec) {
        if (this.segmentIds == null) {
            return Iterators.size(DruidInputSource.createSplits(this.toolbox, this.coordinatorClient, this.dataSource, this.interval, splitHintSpec == null ? SplittableInputSource.DEFAULT_SPLIT_HINT_SPEC : splitHintSpec));
        }
        return 1;
    }

    public SplittableInputSource<List<WindowedSegmentId>> withSplit(InputSplit<List<WindowedSegmentId>> split) {
        return new DruidInputSource(this.dataSource, null, (List)split.get(), this.dimFilter, this.dimensions, this.metrics, this.indexIO, this.coordinatorClient, this.segmentCacheManagerFactory, this.taskConfig, this.toolbox);
    }

    public boolean needsFormat() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DruidInputSource that = (DruidInputSource)o;
        return Objects.equals(this.dataSource, that.dataSource) && Objects.equals(this.interval, that.interval) && Objects.equals(this.segmentIds, that.segmentIds) && Objects.equals(this.dimFilter, that.dimFilter) && Objects.equals(this.dimensions, that.dimensions) && Objects.equals(this.metrics, that.metrics);
    }

    public int hashCode() {
        return Objects.hash(this.dataSource, this.interval, this.segmentIds, this.dimFilter, this.dimensions, this.metrics);
    }

    public String toString() {
        return "DruidInputSource{dataSource='" + this.dataSource + '\'' + ", interval=" + this.interval + ", segmentIds=" + this.segmentIds + ", dimFilter=" + this.dimFilter + (this.dimensions != null ? ", dimensions=" + this.dimensions : "") + (this.metrics != null ? ", metrics=" + this.metrics : "") + '}';
    }

    public static Iterator<InputSplit<List<WindowedSegmentId>>> createSplits(TaskToolbox toolbox, CoordinatorClient coordinatorClient, String dataSource, Interval interval, SplitHintSpec splitHintSpec) {
        SplitHintSpec convertedSplitHintSpec;
        if (splitHintSpec instanceof SegmentsSplitHintSpec) {
            SegmentsSplitHintSpec segmentsSplitHintSpec = (SegmentsSplitHintSpec)splitHintSpec;
            convertedSplitHintSpec = new MaxSizeSplitHintSpec(segmentsSplitHintSpec.getMaxInputSegmentBytesPerTask(), Integer.valueOf(segmentsSplitHintSpec.getMaxNumSegments()));
        } else {
            convertedSplitHintSpec = splitHintSpec;
        }
        List<TimelineObjectHolder<String, DataSegment>> timelineSegments = DruidInputSource.getTimelineForInterval(toolbox, coordinatorClient, dataSource, interval);
        SortedMap<WindowedSegmentId, Long> segmentIdToSize = DruidInputSource.createWindowedSegmentIdFromTimeline(timelineSegments);
        return Iterators.transform((Iterator)convertedSplitHintSpec.split(segmentIdToSize.keySet().iterator(), segmentId -> new InputFileAttribute(((Long)Preconditions.checkNotNull(segmentIdToSize.get(segmentId), (String)"segment size for [%s]", (Object)segmentId)).longValue())), InputSplit::new);
    }

    private static SortedMap<WindowedSegmentId, Long> createWindowedSegmentIdFromTimeline(List<TimelineObjectHolder<String, DataSegment>> timelineHolders) {
        HashMap<DataSegment, WindowedSegmentId> windowedSegmentIds = new HashMap<DataSegment, WindowedSegmentId>();
        for (TimelineObjectHolder<String, DataSegment> holder : timelineHolders) {
            for (PartitionChunk chunk : holder.getObject()) {
                windowedSegmentIds.computeIfAbsent((DataSegment)chunk.getObject(), segment -> new WindowedSegmentId(segment.getId().toString(), new ArrayList<Interval>())).addInterval(holder.getInterval());
            }
        }
        TreeMap<WindowedSegmentId, Long> segmentSizeMap = new TreeMap<WindowedSegmentId, Long>(WINDOWED_SEGMENT_ID_COMPARATOR);
        windowedSegmentIds.forEach((segment, segmentId) -> segmentSizeMap.put((WindowedSegmentId)segmentId, segment.getSize()));
        return segmentSizeMap;
    }

    public static List<TimelineObjectHolder<String, DataSegment>> getTimelineForInterval(TaskToolbox toolbox, CoordinatorClient coordinatorClient, String dataSource, Interval interval) {
        Collection<DataSegment> usedSegments;
        Preconditions.checkNotNull((Object)interval);
        if (toolbox == null) {
            usedSegments = (Collection<DataSegment>)FutureUtils.getUnchecked((ListenableFuture)coordinatorClient.fetchUsedSegments(dataSource, Collections.singletonList(interval)), (boolean)true);
        } else {
            try {
                usedSegments = toolbox.getTaskActionClient().submit(new RetrieveUsedSegmentsAction(dataSource, Collections.singletonList(interval)));
            }
            catch (IOException e) {
                LOG.error((Throwable)e, "Error retrieving the used segments for interval[%s].", new Object[]{interval});
                throw new RuntimeException(e);
            }
        }
        return SegmentTimeline.forSegments((Iterable)usedSegments).lookup(interval);
    }

    public static List<TimelineObjectHolder<String, DataSegment>> getTimelineForSegmentIds(CoordinatorClient coordinatorClient, String dataSource, List<WindowedSegmentId> segmentIds) {
        TreeMap<Interval, TimelineObjectHolder> timeline = new TreeMap<Interval, TimelineObjectHolder>(Comparators.intervalsByStartThenEnd());
        for (WindowedSegmentId windowedSegmentId : (List)Preconditions.checkNotNull(segmentIds, (Object)"segmentIds")) {
            DataSegment segment = (DataSegment)FutureUtils.getUnchecked((ListenableFuture)coordinatorClient.fetchSegment(dataSource, windowedSegmentId.getSegmentId(), false), (boolean)true);
            for (Interval interval : windowedSegmentId.getIntervals()) {
                TimelineObjectHolder existingHolder = (TimelineObjectHolder)timeline.get(interval);
                if (existingHolder != null) {
                    if (!((String)existingHolder.getVersion()).equals(segment.getVersion())) {
                        throw new ISE("Timeline segments with the same interval should have the same version: existing version[%s] vs new segment[%s]", new Object[]{existingHolder.getVersion(), segment});
                    }
                    existingHolder.getObject().add(segment.getShardSpec().createChunk((Object)segment));
                    continue;
                }
                timeline.put(interval, new TimelineObjectHolder(interval, segment.getInterval(), (Object)segment.getVersion(), new PartitionHolder(segment.getShardSpec().createChunk((Object)segment))));
            }
        }
        Interval lastInterval = null;
        for (Interval interval : timeline.keySet()) {
            if (lastInterval != null && interval.overlaps((ReadableInterval)lastInterval)) {
                throw new IAE("Distinct intervals in input segments may not overlap: [%s] vs [%s]", new Object[]{lastInterval, interval});
            }
            lastInterval = interval;
        }
        return new ArrayList<TimelineObjectHolder<String, DataSegment>>(timeline.values());
    }

    public int getNumberOfSegmentsRead() {
        return this.numSegmentsInTimeline;
    }
}

