/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.seekablestream;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.druid.indexing.common.TaskInfoProvider;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTaskClient;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTaskClientAsyncImpl;
import org.apache.druid.indexing.seekablestream.supervisor.SeekableStreamSupervisorTuningConfig;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.rpc.ServiceClientFactory;

public abstract class SeekableStreamIndexTaskClientFactory<PartitionIdType, SequenceOffsetType> {
    private static final Logger log = new Logger(SeekableStreamIndexTaskClientFactory.class);
    private final ServiceClientFactory serviceClientFactory;
    private final ObjectMapper jsonMapper;

    protected SeekableStreamIndexTaskClientFactory(ServiceClientFactory serviceClientFactory, ObjectMapper jsonMapper) {
        this.serviceClientFactory = serviceClientFactory;
        this.jsonMapper = jsonMapper;
    }

    public SeekableStreamIndexTaskClient<PartitionIdType, SequenceOffsetType> build(String dataSource, TaskInfoProvider taskInfoProvider, int maxNumTasks, SeekableStreamSupervisorTuningConfig tuningConfig) {
        log.info("Created async task client for dataSource[%s] httpTimeout[%s] chatRetries[%d]", new Object[]{dataSource, tuningConfig.getHttpTimeout(), tuningConfig.getChatRetries()});
        return new SeekableStreamIndexTaskClientAsyncImpl<PartitionIdType, SequenceOffsetType>(dataSource, this.serviceClientFactory, taskInfoProvider, this.jsonMapper, tuningConfig.getHttpTimeout(), tuningConfig.getChatRetries()){

            @Override
            public Class<PartitionIdType> getPartitionType() {
                return SeekableStreamIndexTaskClientFactory.this.getPartitionType();
            }

            @Override
            public Class<SequenceOffsetType> getSequenceType() {
                return SeekableStreamIndexTaskClientFactory.this.getSequenceType();
            }
        };
    }

    protected abstract Class<PartitionIdType> getPartitionType();

    protected abstract Class<SequenceOffsetType> getSequenceType();
}

