/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.indexing.common.LockGranularity;
import org.apache.druid.indexing.common.SegmentLock;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.common.TimeChunkLock;
import org.apache.druid.indexing.common.actions.SegmentAllocateAction;
import org.apache.druid.indexing.common.actions.SegmentAllocateRequest;
import org.apache.druid.indexing.common.actions.SegmentAllocateResult;
import org.apache.druid.indexing.common.task.PendingSegmentAllocatingTask;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.common.task.Tasks;
import org.apache.druid.indexing.overlord.CriticalAction;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.indexing.overlord.LockRequest;
import org.apache.druid.indexing.overlord.LockRequestForNewSegment;
import org.apache.druid.indexing.overlord.LockResult;
import org.apache.druid.indexing.overlord.SegmentCreateRequest;
import org.apache.druid.indexing.overlord.SpecificSegmentLockRequest;
import org.apache.druid.indexing.overlord.TaskLockboxSyncResult;
import org.apache.druid.indexing.overlord.TaskStorage;
import org.apache.druid.indexing.overlord.TimeChunkLockRequest;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.metadata.LockFilterPolicy;
import org.apache.druid.metadata.ReplaceTaskLock;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;

public class TaskLockbox {
    private final Map<String, NavigableMap<DateTime, SortedMap<Interval, List<TaskLockPosse>>>> running = new HashMap<String, NavigableMap<DateTime, SortedMap<Interval, List<TaskLockPosse>>>>();
    private final TaskStorage taskStorage;
    private final IndexerMetadataStorageCoordinator metadataStorageCoordinator;
    private final ReentrantLock giant = new ReentrantLock(true);
    private final Condition lockReleaseCondition = this.giant.newCondition();
    private static final EmittingLogger log = new EmittingLogger(TaskLockbox.class);
    private final Set<String> activeTasks = new HashSet<String>();
    @GuardedBy(value="giant")
    private final Map<String, Set<String>> activeAllocatorIdToTaskIds = new HashMap<String, Set<String>>();

    @Inject
    public TaskLockbox(TaskStorage taskStorage, IndexerMetadataStorageCoordinator metadataStorageCoordinator) {
        this.taskStorage = taskStorage;
        this.metadataStorageCoordinator = metadataStorageCoordinator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskLockboxSyncResult syncFromStorage() {
        this.giant.lock();
        try {
            HashSet<Task> storedActiveTasks = new HashSet<Task>();
            ArrayList<Pair> storedLocks = new ArrayList<Pair>();
            for (Task task : this.taskStorage.getActiveTasks()) {
                storedActiveTasks.add(task);
                for (TaskLock taskLock : this.taskStorage.getLocks(task.getId())) {
                    storedLocks.add(Pair.of((Object)task, (Object)taskLock));
                }
            }
            Ordering<Pair<Task, TaskLock>> byVersionOrdering = new Ordering<Pair<Task, TaskLock>>(){

                public int compare(Pair<Task, TaskLock> left, Pair<Task, TaskLock> right) {
                    return ComparisonChain.start().compare((Comparable)((Object)((TaskLock)left.rhs).getVersion()), (Comparable)((Object)((TaskLock)right.rhs).getVersion())).compare((Comparable)((Object)((Task)left.lhs).getId()), (Comparable)((Object)((Task)right.lhs).getId())).result();
                }
            };
            this.running.clear();
            this.activeTasks.clear();
            this.activeTasks.addAll(storedActiveTasks.stream().map(Task::getId).collect(Collectors.toSet()));
            HashSet<String> failedToReacquireLockTaskGroups = new HashSet<String>();
            int taskLockCount = 0;
            for (Pair taskAndLock : byVersionOrdering.sortedCopy(storedLocks)) {
                Task task = (Task)Preconditions.checkNotNull((Object)((Task)taskAndLock.lhs), (Object)"task");
                TaskLock savedTaskLock = (TaskLock)Preconditions.checkNotNull((Object)((TaskLock)taskAndLock.rhs), (Object)"savedTaskLock");
                if (savedTaskLock.getInterval().toDurationMillis() <= 0L) {
                    log.warn("Ignoring lock[%s] with empty interval for task: %s", new Object[]{savedTaskLock, task.getId()});
                    continue;
                }
                TaskLock savedTaskLockWithPriority = savedTaskLock.getPriority() == null ? savedTaskLock.withPriority(task.getPriority()) : savedTaskLock;
                TaskLockPosse taskLockPosse = this.reacquireLockOnStartup(task, savedTaskLockWithPriority);
                if (taskLockPosse != null) {
                    TaskLock taskLock = taskLockPosse.getTaskLock();
                    if (savedTaskLockWithPriority.getVersion().equals(taskLock.getVersion())) {
                        ++taskLockCount;
                        log.info("Reacquired lock[%s] for task[%s].", new Object[]{taskLock, task.getId()});
                        continue;
                    }
                    ++taskLockCount;
                    log.info("Could not reacquire lock on interval[%s] version[%s] (got version[%s] instead) for task[%s].", new Object[]{savedTaskLockWithPriority.getInterval(), savedTaskLockWithPriority.getVersion(), taskLock.getVersion(), task.getId()});
                    continue;
                }
                failedToReacquireLockTaskGroups.add(task.getGroupId());
                log.error("Could not reacquire lock on interval[%s] version[%s] for task[%s], groupId[%s].", new Object[]{savedTaskLockWithPriority.getInterval(), savedTaskLockWithPriority.getVersion(), task.getId(), task.getGroupId()});
            }
            HashSet<Task> hashSet = new HashSet<Task>();
            for (Task task : storedActiveTasks) {
                if (!failedToReacquireLockTaskGroups.contains(task.getGroupId())) continue;
                hashSet.add(task);
                this.activeTasks.remove(task.getId());
            }
            this.activeAllocatorIdToTaskIds.clear();
            for (Task task : storedActiveTasks) {
                if (!this.activeTasks.contains(task.getId())) continue;
                this.trackAppendingTask(task);
            }
            log.info("Synced %,d locks for %,d activeTasks from storage (%,d locks ignored).", new Object[]{taskLockCount, this.activeTasks.size(), storedLocks.size() - taskLockCount});
            if (!failedToReacquireLockTaskGroups.isEmpty()) {
                log.warn("Marking all tasks from task groups[%s] to be failed as they failed to reacquire at least one lock.", new Object[]{failedToReacquireLockTaskGroups});
            }
            TaskLockboxSyncResult taskLockboxSyncResult = new TaskLockboxSyncResult(hashSet);
            return taskLockboxSyncResult;
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @VisibleForTesting
    protected TaskLockPosse reacquireLockOnStartup(Task task, TaskLock taskLock) {
        if (!this.taskMatchesLock(task, taskLock)) {
            log.warn("Task[datasource: %s, groupId: %s, priority: %s] does not match TaskLock[datasource: %s, groupId: %s, priority: %s].", new Object[]{task.getDataSource(), task.getGroupId(), task.getPriority(), taskLock.getDataSource(), taskLock.getGroupId(), taskLock.getNonNullPriority()});
            return null;
        }
        this.giant.lock();
        try {
            LockRequest request;
            int taskPriority = task.getPriority();
            switch (taskLock.getGranularity()) {
                case SEGMENT: {
                    SegmentLock segmentLock = (SegmentLock)taskLock;
                    request = new SpecificSegmentLockRequest(segmentLock.getType(), segmentLock.getGroupId(), segmentLock.getDataSource(), segmentLock.getInterval(), segmentLock.getVersion(), segmentLock.getPartitionId(), taskPriority, segmentLock.isRevoked());
                    break;
                }
                case TIME_CHUNK: {
                    TimeChunkLock timeChunkLock = (TimeChunkLock)taskLock;
                    request = new TimeChunkLockRequest(timeChunkLock.getType(), timeChunkLock.getGroupId(), timeChunkLock.getDataSource(), timeChunkLock.getInterval(), timeChunkLock.getVersion(), taskPriority, timeChunkLock.isRevoked());
                    break;
                }
                default: {
                    throw DruidException.defensive((String)"Unknown lockGranularity[%s]", (Object[])new Object[]{taskLock.getGranularity()});
                }
            }
            TaskLockPosse taskLockPosse = this.createOrFindLockPosse(request, task, false);
            return taskLockPosse;
        }
        catch (Exception e) {
            log.error((Throwable)e, "Could not reacquire lock for task[%s] from metadata store", new Object[]{task.getId()});
            TaskLockPosse taskLockPosse = null;
            return taskLockPosse;
        }
        finally {
            this.giant.unlock();
        }
    }

    private boolean taskMatchesLock(Task task, TaskLock taskLock) {
        return task.getGroupId().equals(taskLock.getGroupId()) && task.getDataSource().equals(taskLock.getDataSource()) && task.getPriority() == taskLock.getNonNullPriority();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockResult lock(Task task, LockRequest request) throws InterruptedException {
        this.giant.lockInterruptibly();
        try {
            LockResult lockResult;
            while (!(lockResult = this.tryLock(task, request)).isOk()) {
                if (lockResult.isRevoked()) {
                    LockResult lockResult2 = lockResult;
                    return lockResult2;
                }
                this.lockReleaseCondition.await();
            }
            LockResult lockResult3 = lockResult;
            return lockResult3;
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockResult lock(Task task, LockRequest request, long timeoutMs) throws InterruptedException {
        long nanos = TimeUnit.MILLISECONDS.toNanos(timeoutMs);
        this.giant.lockInterruptibly();
        try {
            LockResult lockResult;
            while (!(lockResult = this.tryLock(task, request)).isOk()) {
                if (nanos <= 0L || lockResult.isRevoked()) {
                    LockResult lockResult2 = lockResult;
                    return lockResult2;
                }
                nanos = this.lockReleaseCondition.awaitNanos(nanos);
            }
            LockResult lockResult3 = lockResult;
            return lockResult3;
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockResult tryLock(Task task, LockRequest request) {
        this.giant.lock();
        try {
            boolean lockRevoked;
            LockRequest convertedRequest;
            if (!this.activeTasks.contains(task.getId())) {
                throw new ISE("Unable to grant lock to inactive Task [%s]", new Object[]{task.getId()});
            }
            Preconditions.checkArgument((request.getInterval().toDurationMillis() > 0L ? 1 : 0) != 0, (Object)"interval empty");
            SegmentIdWithShardSpec newSegmentId = null;
            if (request instanceof LockRequestForNewSegment) {
                LockRequestForNewSegment lockRequestForNewSegment = (LockRequestForNewSegment)request;
                if (lockRequestForNewSegment.getGranularity() == LockGranularity.SEGMENT) {
                    newSegmentId = this.allocateSegmentId(lockRequestForNewSegment, request.getVersion(), null);
                    if (newSegmentId == null) {
                        LockResult lockResult = LockResult.fail();
                        return lockResult;
                    }
                    convertedRequest = new SpecificSegmentLockRequest(lockRequestForNewSegment, newSegmentId);
                } else {
                    convertedRequest = new TimeChunkLockRequest(lockRequestForNewSegment);
                }
            } else {
                convertedRequest = request;
            }
            TaskLockPosse posseToUse = this.createOrFindLockPosse(convertedRequest, task, true);
            if (posseToUse != null && !posseToUse.getTaskLock().isRevoked()) {
                Object lockRequestForNewSegment;
                if (request instanceof LockRequestForNewSegment && ((LockRequestForNewSegment)(lockRequestForNewSegment = (LockRequestForNewSegment)request)).getGranularity() == LockGranularity.TIME_CHUNK) {
                    if (newSegmentId != null) {
                        throw new ISE("SegmentId must be allocated after getting a timeChunk lock, but we already have [%s] before getting the lock?", new Object[]{newSegmentId});
                    }
                    String taskAllocatorId = ((PendingSegmentAllocatingTask)((Object)task)).getTaskAllocatorId();
                    newSegmentId = this.allocateSegmentId((LockRequestForNewSegment)lockRequestForNewSegment, posseToUse.getTaskLock().getVersion(), taskAllocatorId);
                }
                lockRequestForNewSegment = LockResult.ok(posseToUse.getTaskLock(), newSegmentId);
                return lockRequestForNewSegment;
            }
            boolean bl = lockRevoked = posseToUse != null && posseToUse.getTaskLock().isRevoked();
            if (lockRevoked) {
                LockResult lockResult = LockResult.revoked(posseToUse.getTaskLock());
                return lockResult;
            }
            LockResult lockResult = LockResult.fail();
            return lockResult;
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SegmentAllocateResult> allocateSegments(List<SegmentAllocateRequest> requests, String dataSource, Interval interval, boolean skipSegmentLineageCheck, LockGranularity lockGranularity, boolean reduceMetadataIO) {
        log.info("Allocating [%d] segments for datasource [%s], interval [%s]", new Object[]{requests.size(), dataSource, interval});
        boolean isTimeChunkLock = lockGranularity == LockGranularity.TIME_CHUNK;
        AllocationHolderList holderList = new AllocationHolderList(requests, interval);
        holderList.getPending().forEach(this::verifyTaskIsActive);
        this.giant.lock();
        try {
            if (isTimeChunkLock) {
                holderList.getPending().forEach(holder -> this.acquireTaskLock((SegmentAllocationHolder)holder, true));
                this.allocateSegmentIds(dataSource, interval, skipSegmentLineageCheck, holderList.getPending(), reduceMetadataIO);
            } else {
                this.allocateSegmentIds(dataSource, interval, skipSegmentLineageCheck, holderList.getPending(), false);
                holderList.getPending().forEach(holder -> this.acquireTaskLock((SegmentAllocationHolder)holder, false));
            }
            holderList.getPending().forEach(SegmentAllocationHolder::markSucceeded);
        }
        finally {
            this.giant.unlock();
        }
        return holderList.getResults();
    }

    private void verifyTaskIsActive(SegmentAllocationHolder holder) {
        String taskId = holder.task.getId();
        if (!this.activeTasks.contains(taskId)) {
            holder.markFailed("Unable to grant lock to inactive Task [%s]", taskId);
        }
    }

    private void acquireTaskLock(SegmentAllocationHolder holder, boolean isTimeChunkLock) {
        TaskLock acquiredLock;
        LockRequest lockRequest = isTimeChunkLock ? new TimeChunkLockRequest(holder.lockRequest) : new SpecificSegmentLockRequest(holder.lockRequest, holder.allocatedSegment);
        TaskLockPosse posseToUse = this.createOrFindLockPosse(lockRequest, holder.task, true);
        TaskLock taskLock = acquiredLock = posseToUse == null ? null : posseToUse.getTaskLock();
        if (posseToUse == null) {
            holder.markFailed("Could not find or create lock posse.", new Object[0]);
        } else if (acquiredLock.isRevoked()) {
            holder.markFailed("Lock was revoked.", new Object[0]);
        } else {
            holder.setAcquiredLock(posseToUse, lockRequest.getInterval());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private TaskLockPosse createOrFindLockPosse(LockRequest request, Task task, boolean persist) {
        Preconditions.checkState((!(request instanceof LockRequestForNewSegment) ? 1 : 0) != 0, (Object)"Can't handle LockRequestForNewSegment");
        this.giant.lock();
        try {
            TaskLockPosse posseToUse;
            List reusablePosses;
            List<TaskLockPosse> foundPosses = this.findLockPossesOverlapsInterval(request.getDataSource(), request.getInterval());
            List<TaskLockPosse> conflictPosses = foundPosses.stream().filter(taskLockPosse -> taskLockPosse.getTaskLock().conflict(request)).collect(Collectors.toList());
            if (!conflictPosses.isEmpty()) {
                reusablePosses = foundPosses.stream().filter(posse -> posse.reusableFor(request)).collect(Collectors.toList());
                if (reusablePosses.isEmpty()) {
                    if ((request.getType().equals((Object)TaskLockType.APPEND) || request.getType().equals((Object)TaskLockType.REPLACE)) && !request.getGranularity().equals((Object)LockGranularity.TIME_CHUNK)) {
                        TaskLockPosse taskLockPosse2 = null;
                        return taskLockPosse2;
                    }
                    if (this.canLockCoexist(conflictPosses, request) || this.revokeAllIncompatibleActiveLocksIfPossible(conflictPosses, request)) {
                        posseToUse = this.createNewTaskLockPosse(request);
                    } else {
                        boolean allLocksHaveSameTaskGroupAndInterval = conflictPosses.stream().allMatch(conflictPosse -> conflictPosse.getTaskLock().getGroupId().equals(request.getGroupId()) && conflictPosse.getTaskLock().getInterval().equals((Object)request.getInterval()));
                        if (!allLocksHaveSameTaskGroupAndInterval) {
                            log.info("Cannot create a new taskLockPosse for request[%s] because existing locks[%s] have same or higher priorities", new Object[]{request, conflictPosses});
                            TaskLockPosse taskLockPosse3 = null;
                            return taskLockPosse3;
                        }
                        posseToUse = this.createNewTaskLockPosse(request);
                    }
                } else {
                    if (reusablePosses.size() != 1) throw new ISE("Task group[%s] has multiple locks for the same interval[%s]?", new Object[]{request.getGroupId(), request.getInterval()});
                    posseToUse = (TaskLockPosse)reusablePosses.get(0);
                }
            } else {
                posseToUse = this.createNewTaskLockPosse(request);
            }
            if (posseToUse == null || posseToUse.getTaskLock() == null) {
                reusablePosses = null;
                return reusablePosses;
            }
            if (posseToUse.addTask(task)) {
                log.info("Added task[%s] to TaskLock[%s]", new Object[]{task.getId(), posseToUse.getTaskLock()});
                for (TaskLockPosse conflictPosse2 : conflictPosses) {
                    if (!conflictPosse2.containsTask(task) || !posseToUse.supersedes(conflictPosse2)) continue;
                    this.unlock(task, conflictPosse2.getTaskLock().getInterval());
                }
                if (persist) {
                    try {
                        this.taskStorage.addLock(task.getId(), posseToUse.getTaskLock());
                    }
                    catch (Exception e) {
                        log.makeAlert("Failed to persist lock in storage", new Object[0]).addData("task", (Object)task.getId()).addData("dataSource", (Object)posseToUse.getTaskLock().getDataSource()).addData("interval", (Object)posseToUse.getTaskLock().getInterval()).addData("version", (Object)posseToUse.getTaskLock().getVersion()).emit();
                        this.unlock(task, posseToUse.getTaskLock().getInterval(), posseToUse.getTaskLock().getGranularity() == LockGranularity.SEGMENT ? Integer.valueOf(((SegmentLock)posseToUse.taskLock).getPartitionId()) : null);
                        TaskLockPosse taskLockPosse4 = null;
                        this.giant.unlock();
                        return taskLockPosse4;
                    }
                }
            } else {
                log.debug("Task[%s] already present in TaskLock[%s].", new Object[]{task.getId(), posseToUse.getTaskLock().getGroupId()});
            }
            TaskLockPosse taskLockPosse5 = posseToUse;
            return taskLockPosse5;
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskLockPosse createNewTaskLockPosse(LockRequest request) {
        this.giant.lock();
        try {
            TaskLockPosse posseToUse = new TaskLockPosse(request.toLock());
            this.running.computeIfAbsent(request.getDataSource(), k -> new TreeMap()).computeIfAbsent(request.getInterval().getStart(), k -> new TreeMap(Comparators.intervalsByStartThenEnd())).computeIfAbsent(request.getInterval(), k -> new ArrayList()).add(posseToUse);
            TaskLockPosse taskLockPosse = posseToUse;
            return taskLockPosse;
        }
        finally {
            this.giant.unlock();
        }
    }

    private void allocateSegmentIds(String dataSource, Interval interval, boolean skipSegmentLineageCheck, Collection<SegmentAllocationHolder> holders, boolean reduceMetadataIO) {
        if (holders.isEmpty()) {
            return;
        }
        List createRequests = holders.stream().map(SegmentAllocationHolder::getSegmentRequest).collect(Collectors.toList());
        Map allocatedSegments = this.metadataStorageCoordinator.allocatePendingSegments(dataSource, interval, skipSegmentLineageCheck, createRequests, reduceMetadataIO);
        for (SegmentAllocationHolder holder : holders) {
            SegmentIdWithShardSpec segmentId = (SegmentIdWithShardSpec)allocatedSegments.get(holder.getSegmentRequest());
            if (segmentId == null) {
                holder.markFailed("Storage coordinator could not allocate segment.", new Object[0]);
                continue;
            }
            holder.setAllocatedSegment(segmentId);
        }
    }

    private SegmentIdWithShardSpec allocateSegmentId(LockRequestForNewSegment request, String version, String allocatorId) {
        return this.metadataStorageCoordinator.allocatePendingSegment(request.getDataSource(), request.getInterval(), request.isSkipSegmentLineageCheck(), new SegmentCreateRequest(request.getSequenceName(), request.getPreviousSegmentId(), version, request.getPartialShardSpec(), allocatorId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T doInCriticalSection(Task task, Set<Interval> intervals, CriticalAction<T> action) throws Exception {
        this.giant.lock();
        try {
            boolean areTaskLocksValid = intervals.stream().noneMatch(interval -> {
                Optional<TaskLockPosse> lockPosse = this.getOnlyTaskLockPosseContainingInterval(task, (Interval)interval);
                return lockPosse.isPresent() && lockPosse.get().getTaskLock().isRevoked();
            });
            T t = action.perform(areTaskLocksValid);
            return t;
        }
        finally {
            this.giant.unlock();
        }
    }

    private void revokeLock(TaskLockPosse lockPosse) {
        this.giant.lock();
        try {
            lockPosse.taskIds.forEach(taskId -> this.revokeLock((String)taskId, lockPosse.getTaskLock()));
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void revokeLock(String taskId, TaskLock lock) {
        this.giant.lock();
        try {
            if (!this.activeTasks.contains(taskId)) {
                throw new ISE("Cannot revoke lock for inactive task[%s]", new Object[]{taskId});
            }
            Task task = (Task)this.taskStorage.getTask(taskId).orNull();
            if (task == null) {
                throw new ISE("Cannot revoke lock for unknown task[%s]", new Object[]{taskId});
            }
            log.info("Revoking task lock[%s] for task[%s]", new Object[]{lock, taskId});
            if (lock.isRevoked()) {
                log.warn("TaskLock[%s] is already revoked", new Object[]{lock});
            } else {
                TaskLock revokedLock = lock.revokedCopy();
                this.taskStorage.replaceLock(taskId, lock, revokedLock);
                List possesHolder = (List)((SortedMap)this.running.get(task.getDataSource()).get(lock.getInterval().getStart())).get(lock.getInterval());
                TaskLockPosse foundPosse = possesHolder.stream().filter(posse -> posse.getTaskLock().equals(lock)).findFirst().orElseThrow(() -> new ISE("Failed to find lock posse for lock[%s]", new Object[]{lock}));
                possesHolder.remove(foundPosse);
                possesHolder.add(foundPosse.withTaskLock(revokedLock));
                log.info("Revoked taskLock[%s]", new Object[]{lock});
            }
        }
        finally {
            this.giant.unlock();
        }
    }

    public List<TaskLock> findLocksForTask(Task task) {
        this.giant.lock();
        try {
            List list = Lists.transform(this.findLockPossesForTask(task), TaskLockPosse::getTaskLock);
            return list;
        }
        finally {
            this.giant.unlock();
        }
    }

    public Set<ReplaceTaskLock> findReplaceLocksForTask(Task task) {
        this.giant.lock();
        try {
            Set<ReplaceTaskLock> set = this.getNonRevokedReplaceLocks(this.findLockPossesForTask(task), task.getDataSource());
            return set;
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ReplaceTaskLock> getAllReplaceLocksForDatasource(String datasource) {
        this.giant.lock();
        try {
            NavigableMap<DateTime, SortedMap<Interval, List<TaskLockPosse>>> activeLocks = this.running.get(datasource);
            if (activeLocks == null) {
                ImmutableSet immutableSet = ImmutableSet.of();
                return immutableSet;
            }
            List<TaskLockPosse> lockPosses = activeLocks.values().stream().flatMap(map -> map.values().stream()).flatMap(Collection::stream).collect(Collectors.toList());
            Set<ReplaceTaskLock> set = this.getNonRevokedReplaceLocks(lockPosses, datasource);
            return set;
        }
        finally {
            this.giant.unlock();
        }
    }

    private Set<ReplaceTaskLock> getNonRevokedReplaceLocks(List<TaskLockPosse> posses, String datasource) {
        HashSet<ReplaceTaskLock> replaceLocks = new HashSet<ReplaceTaskLock>();
        for (TaskLockPosse posse : posses) {
            TaskLock lock = posse.getTaskLock();
            if (lock.isRevoked() || !TaskLockType.REPLACE.equals((Object)posse.getTaskLock().getType())) continue;
            if (posse.taskIds.size() > 1) {
                throw DruidException.defensive((String)"Replace lock[%s] for datasource[%s] is held by multiple tasks[%s]", (Object[])new Object[]{lock, datasource, posse.taskIds});
            }
            String supervisorTaskId = posse.taskIds.iterator().next();
            replaceLocks.add(new ReplaceTaskLock(supervisorTaskId, lock.getInterval(), lock.getVersion()));
        }
        return replaceLocks;
    }

    public Map<String, List<Interval>> getLockedIntervals(List<LockFilterPolicy> lockFilterPolicies) {
        HashMap datasourceToIntervals = new HashMap();
        this.giant.lock();
        try {
            lockFilterPolicies.forEach(lockFilter -> {
                String datasource = lockFilter.getDatasource();
                if (!this.running.containsKey(datasource)) {
                    return;
                }
                int priority = lockFilter.getPriority();
                boolean isReplaceLock = TaskLockType.REPLACE.name().equals((Object)lockFilter.getContext().getOrDefault("taskLockType", Tasks.DEFAULT_TASK_LOCK_TYPE));
                boolean isUsingConcurrentLocks = Boolean.TRUE.equals(lockFilter.getContext().getOrDefault("useConcurrentLocks", false));
                boolean ignoreAppendLocks = isUsingConcurrentLocks || isReplaceLock;
                this.running.get(datasource).forEach((startTime, startTimeLocks) -> startTimeLocks.forEach((interval, taskLockPosses) -> taskLockPosses.forEach(taskLockPosse -> {
                    if (!(taskLockPosse.getTaskLock().isRevoked() || ignoreAppendLocks && TaskLockType.APPEND.equals((Object)taskLockPosse.getTaskLock().getType()) || taskLockPosse.getTaskLock().getPriority() == null || taskLockPosse.getTaskLock().getPriority() < priority)) {
                        datasourceToIntervals.computeIfAbsent(datasource, k -> new HashSet()).add(interval);
                    }
                })));
            });
        }
        finally {
            this.giant.unlock();
        }
        return datasourceToIntervals.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new ArrayList((Collection)entry.getValue())));
    }

    public Map<String, List<TaskLock>> getActiveLocks(List<LockFilterPolicy> lockFilterPolicies) {
        HashMap<String, List<TaskLock>> datasourceToLocks = new HashMap<String, List<TaskLock>>();
        this.giant.lock();
        try {
            lockFilterPolicies.forEach(lockFilter -> {
                TaskLockType taskLockType;
                String datasource = lockFilter.getDatasource();
                if (!this.running.containsKey(datasource)) {
                    return;
                }
                int priority = lockFilter.getPriority();
                List<Interval> intervals = lockFilter.getIntervals() != null ? lockFilter.getIntervals() : Collections.singletonList(Intervals.ETERNITY);
                Map context = lockFilter.getContext();
                Boolean useConcurrentLocks = QueryContexts.getAsBoolean((String)"useConcurrentLocks", context.get("useConcurrentLocks"));
                boolean ignoreAppendLocks = useConcurrentLocks == null ? ((taskLockType = (TaskLockType)QueryContexts.getAsEnum((String)"taskLockType", context.get("taskLockType"), TaskLockType.class)) == null ? false : taskLockType == TaskLockType.APPEND) : useConcurrentLocks;
                this.running.get(datasource).forEach((startTime, startTimeLocks) -> startTimeLocks.forEach((interval, taskLockPosses) -> taskLockPosses.forEach(taskLockPosse -> {
                    if (!(taskLockPosse.getTaskLock().isRevoked() || taskLockPosse.getTaskLock().getPriority() == null || taskLockPosse.getTaskLock().getPriority() < priority || ignoreAppendLocks && taskLockPosse.getTaskLock().getType() == TaskLockType.APPEND)) {
                        for (Interval filterInterval : intervals) {
                            if (!interval.overlaps((ReadableInterval)filterInterval)) continue;
                            datasourceToLocks.computeIfAbsent(datasource, ds -> new ArrayList()).add(taskLockPosse.getTaskLock());
                            break;
                        }
                    }
                })));
            });
        }
        finally {
            this.giant.unlock();
        }
        return datasourceToLocks;
    }

    public void unlock(Task task, Interval interval) {
        this.unlock(task, interval, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlock(Task task, Interval interval, @Nullable Integer partitionId) {
        this.giant.lock();
        try {
            String dataSource = task.getDataSource();
            NavigableMap<DateTime, SortedMap<Interval, List<TaskLockPosse>>> locksForDatasource = this.running.get(task.getDataSource());
            if (locksForDatasource == null || locksForDatasource.isEmpty()) {
                return;
            }
            SortedMap intervalToPosses = (SortedMap)locksForDatasource.get(interval.getStart());
            if (intervalToPosses == null || intervalToPosses.isEmpty()) {
                return;
            }
            List possesHolder = (List)intervalToPosses.get(interval);
            if (possesHolder == null || possesHolder.isEmpty()) {
                return;
            }
            List posses = possesHolder.stream().filter(posse -> posse.containsTask(task)).collect(Collectors.toList());
            for (TaskLockPosse taskLockPosse : posses) {
                TaskLock taskLock = taskLockPosse.getTaskLock();
                boolean match = partitionId == null && taskLock.getGranularity() == LockGranularity.TIME_CHUNK || partitionId != null && taskLock.getGranularity() == LockGranularity.SEGMENT && ((SegmentLock)taskLock).getPartitionId() == partitionId.intValue();
                if (!match) continue;
                log.info("Removing task[%s] from TaskLock[%s]", new Object[]{task.getId(), taskLock});
                boolean removed = taskLockPosse.removeTask(task);
                if (taskLockPosse.isTasksEmpty()) {
                    log.info("TaskLock[%s] is now empty.", new Object[]{taskLock});
                    possesHolder.remove(taskLockPosse);
                }
                if (possesHolder.isEmpty()) {
                    intervalToPosses.remove(interval);
                }
                if (intervalToPosses.isEmpty()) {
                    locksForDatasource.remove(interval.getStart());
                }
                if (this.running.get(dataSource).isEmpty()) {
                    this.running.remove(dataSource);
                }
                this.lockReleaseCondition.signalAll();
                try {
                    this.taskStorage.removeLock(task.getId(), taskLock);
                }
                catch (Exception e) {
                    log.makeAlert((Throwable)e, "Failed to clean up lock from storage", new Object[0]).addData("task", (Object)task.getId()).addData("dataSource", (Object)taskLock.getDataSource()).addData("interval", (Object)taskLock.getInterval()).addData("version", (Object)taskLock.getVersion()).emit();
                }
                if (removed) continue;
                log.makeAlert("Lock release without acquire", new Object[0]).addData("task", (Object)task.getId()).addData("interval", (Object)interval).emit();
            }
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockAll(Task task) {
        this.giant.lock();
        try {
            for (TaskLockPosse taskLockPosse : this.findLockPossesForTask(task)) {
                this.unlock(task, taskLockPosse.getTaskLock().getInterval(), taskLockPosse.getTaskLock().getGranularity() == LockGranularity.SEGMENT ? Integer.valueOf(((SegmentLock)taskLockPosse.taskLock).getPartitionId()) : null);
            }
        }
        finally {
            this.giant.unlock();
        }
    }

    public void add(Task task) {
        this.giant.lock();
        try {
            log.info("Adding task[%s] to activeTasks", new Object[]{task.getId()});
            this.activeTasks.add(task.getId());
            this.trackAppendingTask(task);
        }
        finally {
            this.giant.unlock();
        }
    }

    @GuardedBy(value="giant")
    private void trackAppendingTask(Task task) {
        String taskAllocatorId;
        if (task instanceof PendingSegmentAllocatingTask && (taskAllocatorId = ((PendingSegmentAllocatingTask)((Object)task)).getTaskAllocatorId()) != null) {
            this.activeAllocatorIdToTaskIds.computeIfAbsent(taskAllocatorId, s -> new HashSet()).add(task.getId());
        }
    }

    public void remove(Task task) {
        this.giant.lock();
        try {
            try {
                log.info("Removing task[%s] from activeTasks", new Object[]{task.getId()});
                this.cleanupUpgradeAndPendingSegments(task);
                this.unlockAll(task);
            }
            finally {
                this.activeTasks.remove(task.getId());
            }
        }
        finally {
            this.giant.unlock();
        }
    }

    @GuardedBy(value="giant")
    private void cleanupUpgradeAndPendingSegments(Task task) {
        try {
            String taskAllocatorId;
            if (this.findLocksForTask(task).stream().anyMatch(lock -> lock.getType() == TaskLockType.REPLACE)) {
                int upgradeSegmentsDeleted = this.metadataStorageCoordinator.deleteUpgradeSegmentsForTask(task.getId());
                log.info("Deleted [%d] entries from upgradeSegments table for task[%s] with REPLACE locks.", new Object[]{upgradeSegmentsDeleted, task.getId()});
            }
            if (task instanceof PendingSegmentAllocatingTask && this.activeAllocatorIdToTaskIds.containsKey(taskAllocatorId = ((PendingSegmentAllocatingTask)((Object)task)).getTaskAllocatorId())) {
                Set<String> taskIdsForSameAllocator = this.activeAllocatorIdToTaskIds.get(taskAllocatorId);
                taskIdsForSameAllocator.remove(task.getId());
                if (taskIdsForSameAllocator.isEmpty()) {
                    int pendingSegmentsDeleted = this.metadataStorageCoordinator.deletePendingSegmentsForTaskAllocatorId(task.getDataSource(), taskAllocatorId);
                    log.info("Deleted [%d] entries from pendingSegments table for taskAllocatorId[%s].", new Object[]{pendingSegmentsDeleted, taskAllocatorId});
                }
                this.activeAllocatorIdToTaskIds.remove(taskAllocatorId);
            }
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Failure cleaning up upgradeSegments or pendingSegments tables.", new Object[0]);
        }
    }

    @GuardedBy(value="giant")
    private List<TaskLockPosse> findLockPossesForTask(Task task) {
        NavigableMap<DateTime, SortedMap<Interval, List<TaskLockPosse>>> locksForDatasource = this.running.get(task.getDataSource());
        if (locksForDatasource == null) {
            return Collections.emptyList();
        }
        return locksForDatasource.values().stream().flatMap(map -> map.values().stream()).flatMap(Collection::stream).filter(taskLockPosse -> taskLockPosse.containsTask(task)).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TaskLockPosse> findLockPossesContainingInterval(String dataSource, Interval interval) {
        this.giant.lock();
        try {
            List<TaskLockPosse> intervalOverlapsPosses = this.findLockPossesOverlapsInterval(dataSource, interval);
            List<TaskLockPosse> list = intervalOverlapsPosses.stream().filter(taskLockPosse -> taskLockPosse.taskLock.getInterval().contains((ReadableInterval)interval)).collect(Collectors.toList());
            return list;
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TaskLockPosse> findLockPossesOverlapsInterval(String dataSource, Interval interval) {
        this.giant.lock();
        try {
            NavigableMap<DateTime, SortedMap<Interval, List<TaskLockPosse>>> dsRunning = this.running.get(dataSource);
            if (dsRunning == null) {
                List<TaskLockPosse> list = Collections.emptyList();
                return list;
            }
            List<TaskLockPosse> list = dsRunning.navigableKeySet().stream().filter(Objects::nonNull).map(dsRunning::get).filter(Objects::nonNull).flatMap(sortedMap -> sortedMap.entrySet().stream()).filter(entry -> ((Interval)entry.getKey()).overlaps((ReadableInterval)interval)).flatMap(entry -> ((List)entry.getValue()).stream()).collect(Collectors.toList());
            return list;
        }
        finally {
            this.giant.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    Optional<TaskLockPosse> getOnlyTaskLockPosseContainingInterval(Task task, Interval interval) {
        this.giant.lock();
        try {
            List filteredPosses = this.findLockPossesContainingInterval(task.getDataSource(), interval).stream().filter(lockPosse -> lockPosse.containsTask(task)).collect(Collectors.toList());
            if (filteredPosses.isEmpty()) {
                throw new ISE("Cannot find any lock for task[%s] and interval[%s]", new Object[]{task.getId(), interval});
            }
            if (filteredPosses.size() == 1) {
                Optional<TaskLockPosse> optional = Optional.of((TaskLockPosse)filteredPosses.get(0));
                return optional;
            }
            if (filteredPosses.stream().anyMatch(posse -> posse.taskLock.getGranularity() == LockGranularity.TIME_CHUNK)) {
                throw new ISE("There are multiple timechunk lockPosses for task[%s] and interval[%s]", new Object[]{task.getId(), interval});
            }
            Optional<TaskLockPosse> optional = Optional.empty();
            return optional;
        }
        finally {
            this.giant.unlock();
        }
    }

    @VisibleForTesting
    Set<String> getActiveTasks() {
        return this.activeTasks;
    }

    @VisibleForTesting
    Map<String, NavigableMap<DateTime, SortedMap<Interval, List<TaskLockPosse>>>> getAllLocks() {
        return this.running;
    }

    private boolean canLockCoexist(List<TaskLockPosse> conflictPosses, LockRequest request) {
        switch (request.getType()) {
            case APPEND: {
                return this.canAppendLockCoexist(conflictPosses, request);
            }
            case REPLACE: {
                return this.canReplaceLockCoexist(conflictPosses, request);
            }
            case SHARED: {
                return this.canSharedLockCoexist(conflictPosses);
            }
            case EXCLUSIVE: {
                return this.canExclusiveLockCoexist(conflictPosses);
            }
        }
        throw new UOE("Unsupported lock type: " + request.getType(), new Object[0]);
    }

    private boolean canAppendLockCoexist(List<TaskLockPosse> conflictPosses, LockRequest appendRequest) {
        TaskLock replaceLock = null;
        for (TaskLockPosse posse : conflictPosses) {
            if (posse.getTaskLock().isRevoked()) continue;
            if (posse.getTaskLock().getType().equals((Object)TaskLockType.EXCLUSIVE) || posse.getTaskLock().getType().equals((Object)TaskLockType.SHARED)) {
                return false;
            }
            if (!posse.getTaskLock().getType().equals((Object)TaskLockType.REPLACE)) continue;
            if (replaceLock != null) {
                return false;
            }
            replaceLock = posse.getTaskLock();
            if (replaceLock.getInterval().contains((ReadableInterval)appendRequest.getInterval())) continue;
            return false;
        }
        return true;
    }

    private boolean canReplaceLockCoexist(List<TaskLockPosse> conflictPosses, LockRequest replaceLock) {
        for (TaskLockPosse posse : conflictPosses) {
            if (posse.getTaskLock().isRevoked()) continue;
            if (posse.getTaskLock().getType().equals((Object)TaskLockType.EXCLUSIVE) || posse.getTaskLock().getType().equals((Object)TaskLockType.SHARED) || posse.getTaskLock().getType().equals((Object)TaskLockType.REPLACE)) {
                return false;
            }
            if (!posse.getTaskLock().getType().equals((Object)TaskLockType.APPEND) || replaceLock.getInterval().contains((ReadableInterval)posse.getTaskLock().getInterval())) continue;
            return false;
        }
        return true;
    }

    private boolean canSharedLockCoexist(List<TaskLockPosse> conflictPosses) {
        for (TaskLockPosse posse : conflictPosses) {
            if (posse.getTaskLock().isRevoked() || !posse.getTaskLock().getType().equals((Object)TaskLockType.EXCLUSIVE) && !posse.getTaskLock().getType().equals((Object)TaskLockType.APPEND) && !posse.getTaskLock().getType().equals((Object)TaskLockType.REPLACE)) continue;
            return false;
        }
        return true;
    }

    private boolean canExclusiveLockCoexist(List<TaskLockPosse> conflictPosses) {
        for (TaskLockPosse posse : conflictPosses) {
            if (posse.getTaskLock().isRevoked()) continue;
            return false;
        }
        return true;
    }

    private boolean revokeAllIncompatibleActiveLocksIfPossible(List<TaskLockPosse> conflictPosses, LockRequest request) {
        int priority = request.getPriority();
        TaskLockType type = request.getType();
        ArrayList<TaskLockPosse> possesToRevoke = new ArrayList<TaskLockPosse>();
        block6: for (TaskLockPosse posse : conflictPosses) {
            if (posse.getTaskLock().isRevoked()) continue;
            switch (type) {
                case EXCLUSIVE: {
                    if (posse.getTaskLock().getNonNullPriority() >= priority) {
                        return false;
                    }
                    possesToRevoke.add(posse);
                    continue block6;
                }
                case SHARED: {
                    if (posse.getTaskLock().getType().equals((Object)TaskLockType.SHARED)) continue block6;
                    if (posse.getTaskLock().getNonNullPriority() >= priority) {
                        return false;
                    }
                    possesToRevoke.add(posse);
                    continue block6;
                }
                case REPLACE: {
                    if (posse.getTaskLock().getType().equals((Object)TaskLockType.APPEND) && request.getInterval().contains((ReadableInterval)posse.getTaskLock().getInterval())) continue block6;
                    if (posse.getTaskLock().getNonNullPriority() >= priority) {
                        return false;
                    }
                    possesToRevoke.add(posse);
                    continue block6;
                }
                case APPEND: {
                    if (posse.getTaskLock().getType().equals((Object)TaskLockType.APPEND) || posse.getTaskLock().getType().equals((Object)TaskLockType.REPLACE) && posse.getTaskLock().getInterval().contains((ReadableInterval)request.getInterval())) continue block6;
                    if (posse.getTaskLock().getNonNullPriority() >= priority) {
                        return false;
                    }
                    possesToRevoke.add(posse);
                    continue block6;
                }
            }
            throw new UOE("Unsupported lock type: " + type, new Object[0]);
        }
        for (TaskLockPosse revokablePosse : possesToRevoke) {
            this.revokeLock(revokablePosse);
        }
        return true;
    }

    private static class SegmentAllocationHolder {
        final AllocationHolderList list;
        final Task task;
        final Interval allocateInterval;
        final SegmentAllocateAction action;
        final LockRequestForNewSegment lockRequest;
        SegmentCreateRequest segmentRequest;
        TaskLock acquiredLock;
        TaskLockPosse taskLockPosse;
        Interval lockRequestInterval;
        SegmentIdWithShardSpec allocatedSegment;
        SegmentAllocateResult result;

        SegmentAllocationHolder(SegmentAllocateRequest request, Interval allocateInterval, AllocationHolderList list) {
            this.list = list;
            this.allocateInterval = allocateInterval;
            this.task = request.getTask();
            this.action = request.getAction();
            this.lockRequest = new LockRequestForNewSegment(this.action.getLockGranularity(), this.action.getTaskLockType(), this.task.getGroupId(), this.action.getDataSource(), allocateInterval, this.action.getPartialShardSpec(), this.task.getPriority(), this.action.getSequenceName(), this.action.getPreviousSegmentId(), this.action.isSkipSegmentLineageCheck());
        }

        SegmentCreateRequest getSegmentRequest() {
            if (this.segmentRequest == null) {
                this.segmentRequest = new SegmentCreateRequest(this.action.getSequenceName(), this.action.getPreviousSegmentId(), this.acquiredLock == null ? this.lockRequest.getVersion() : this.acquiredLock.getVersion(), this.action.getPartialShardSpec(), ((PendingSegmentAllocatingTask)((Object)this.task)).getTaskAllocatorId());
            }
            return this.segmentRequest;
        }

        void markFailed(String msgFormat, Object ... args) {
            this.list.markCompleted(this);
            this.result = new SegmentAllocateResult(null, StringUtils.format((String)msgFormat, (Object[])args));
        }

        void markSucceeded() {
            this.list.markCompleted(this);
            this.result = new SegmentAllocateResult(this.allocatedSegment, null);
        }

        void setAllocatedSegment(SegmentIdWithShardSpec segmentId) {
            this.allocatedSegment = segmentId;
        }

        void setAcquiredLock(TaskLockPosse lockPosse, Interval lockRequestInterval) {
            this.taskLockPosse = lockPosse;
            this.acquiredLock = lockPosse == null ? null : lockPosse.getTaskLock();
            this.lockRequestInterval = lockRequestInterval;
        }
    }

    private static class AllocationHolderList {
        final List<SegmentAllocationHolder> all = new ArrayList<SegmentAllocationHolder>();
        final Set<SegmentAllocationHolder> pending = new HashSet<SegmentAllocationHolder>();
        final Set<SegmentAllocationHolder> recentlyCompleted = new HashSet<SegmentAllocationHolder>();

        AllocationHolderList(List<SegmentAllocateRequest> requests, Interval interval) {
            for (SegmentAllocateRequest request : requests) {
                SegmentAllocationHolder holder = new SegmentAllocationHolder(request, interval, this);
                this.all.add(holder);
                this.pending.add(holder);
            }
        }

        void markCompleted(SegmentAllocationHolder holder) {
            this.recentlyCompleted.add(holder);
        }

        Set<SegmentAllocationHolder> getPending() {
            this.pending.removeAll(this.recentlyCompleted);
            this.recentlyCompleted.clear();
            return this.pending;
        }

        List<SegmentAllocateResult> getResults() {
            return this.all.stream().map(holder -> holder.result).collect(Collectors.toList());
        }
    }

    static class TaskLockPosse {
        private final TaskLock taskLock;
        private final Set<String> taskIds;

        TaskLockPosse(TaskLock taskLock) {
            this.taskLock = taskLock;
            this.taskIds = new HashSet<String>();
        }

        private TaskLockPosse(TaskLock taskLock, Set<String> taskIds) {
            this.taskLock = taskLock;
            this.taskIds = new HashSet<String>(taskIds);
        }

        TaskLockPosse withTaskLock(TaskLock taskLock) {
            return new TaskLockPosse(taskLock, this.taskIds);
        }

        TaskLock getTaskLock() {
            return this.taskLock;
        }

        boolean addTask(Task task) {
            if (this.taskLock.getType() == TaskLockType.EXCLUSIVE) {
                Preconditions.checkArgument((boolean)this.taskLock.getGroupId().equals(task.getGroupId()), (String)"groupId[%s] of task[%s] is different from the existing lockPosse's groupId[%s]", (Object)task.getGroupId(), (Object)task.getId(), (Object)this.taskLock.getGroupId());
            }
            Preconditions.checkArgument((this.taskLock.getNonNullPriority() == task.getPriority() ? 1 : 0) != 0, (String)"priority[%s] of task[%s] is different from the existing lockPosse's priority[%s]", (Object)task.getPriority(), (Object)task.getId(), (Object)this.taskLock.getNonNullPriority());
            return this.taskIds.add(task.getId());
        }

        boolean containsTask(Task task) {
            Preconditions.checkNotNull((Object)task, (Object)"task");
            return this.taskIds.contains(task.getId());
        }

        boolean removeTask(Task task) {
            Preconditions.checkNotNull((Object)task, (Object)"task");
            return this.taskIds.remove(task.getId());
        }

        boolean isTasksEmpty() {
            return this.taskIds.isEmpty();
        }

        boolean supersedes(TaskLockPosse other) {
            TaskLock otherLock = other.taskLock;
            return !this.taskLock.isRevoked() && this.taskLock.getGranularity() == LockGranularity.TIME_CHUNK && this.taskLock.getGranularity() == otherLock.getGranularity() && this.taskLock.getType() == TaskLockType.APPEND && this.taskLock.getType() == otherLock.getType() && this.taskLock.getVersion().compareTo(otherLock.getVersion()) >= 0 && !this.taskLock.getInterval().equals((Object)otherLock.getInterval()) && this.taskLock.getInterval().contains((ReadableInterval)otherLock.getInterval()) && this.taskLock.getGroupId().equals(otherLock.getGroupId());
        }

        boolean reusableFor(LockRequest request) {
            if (this.taskLock.getType() == request.getType() && this.taskLock.getGranularity() == request.getGranularity()) {
                switch (this.taskLock.getType()) {
                    case APPEND: 
                    case REPLACE: 
                    case SHARED: {
                        if (request instanceof TimeChunkLockRequest) {
                            return this.taskLock.getInterval().contains((ReadableInterval)request.getInterval()) && this.taskLock.getGroupId().equals(request.getGroupId());
                        }
                        return false;
                    }
                    case EXCLUSIVE: {
                        if (request instanceof TimeChunkLockRequest) {
                            return this.taskLock.getInterval().contains((ReadableInterval)request.getInterval()) && this.taskLock.getGroupId().equals(request.getGroupId());
                        }
                        if (request instanceof SpecificSegmentLockRequest) {
                            SegmentLock segmentLock = (SegmentLock)this.taskLock;
                            SpecificSegmentLockRequest specificSegmentLockRequest = (SpecificSegmentLockRequest)request;
                            return segmentLock.getInterval().contains((ReadableInterval)specificSegmentLockRequest.getInterval()) && segmentLock.getGroupId().equals(specificSegmentLockRequest.getGroupId()) && specificSegmentLockRequest.getPartitionId() == segmentLock.getPartitionId();
                        }
                        throw new ISE("Unknown request type[%s]", new Object[]{request});
                    }
                }
                throw new ISE("Unknown lock type[%s]", new Object[]{this.taskLock.getType()});
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !this.getClass().equals(o.getClass())) {
                return false;
            }
            TaskLockPosse that = (TaskLockPosse)o;
            return Objects.equals(this.taskLock, that.taskLock) && Objects.equals(this.taskIds, that.taskIds);
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.taskLock, this.taskIds});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("taskLock", (Object)this.taskLock).add("taskIds", this.taskIds).toString();
        }
    }
}

