/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.clients;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.java.util.http.client.response.StatusResponseHandler;
import org.apache.druid.java.util.http.client.response.StatusResponseHolder;
import org.apache.druid.testing.IntegrationTestingConfig;
import org.apache.druid.testing.guice.TestClient;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public class ClientInfoResourceTestClient {
    private final ObjectMapper jsonMapper;
    private final HttpClient httpClient;
    private final String brokerUrl;
    private final StatusResponseHandler responseHandler;

    @Inject
    ClientInfoResourceTestClient(ObjectMapper jsonMapper, @TestClient HttpClient httpClient, IntegrationTestingConfig config) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.brokerUrl = config.getBrokerUrl();
        this.responseHandler = new StatusResponseHandler(StandardCharsets.UTF_8);
    }

    private String getBrokerURL() {
        return StringUtils.format((String)"%s/druid/v2/datasources", (Object[])new Object[]{this.brokerUrl});
    }

    public List<String> getDimensions(String dataSource, String interval) {
        try {
            StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.GET, new URL(StringUtils.format((String)"%s/%s/dimensions?interval=%s", (Object[])new Object[]{this.getBrokerURL(), dataSource, interval}))), (HttpResponseHandler)this.responseHandler).get();
            if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
                throw new ISE("Error while querying[%s] status[%s] content[%s]", new Object[]{this.getBrokerURL(), response.getStatus(), response.getContent()});
            }
            return (List)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<List<String>>(){});
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

