/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.clients;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.java.util.http.client.response.StatusResponseHandler;
import org.apache.druid.java.util.http.client.response.StatusResponseHolder;
import org.apache.druid.testing.IntegrationTestingConfig;
import org.apache.druid.testing.guice.TestClient;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.joda.time.Interval;

public class CoordinatorResourceTestClient {
    private final ObjectMapper jsonMapper;
    private final HttpClient httpClient;
    private final String coordinator;
    private final StatusResponseHandler responseHandler;

    @Inject
    CoordinatorResourceTestClient(ObjectMapper jsonMapper, @TestClient HttpClient httpClient, IntegrationTestingConfig config) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.coordinator = config.getCoordinatorUrl();
        this.responseHandler = new StatusResponseHandler(StandardCharsets.UTF_8);
    }

    private String getCoordinatorURL() {
        return StringUtils.format((String)"%s/druid/coordinator/v1/", (Object[])new Object[]{this.coordinator});
    }

    private String getMetadataSegmentsURL(String dataSource) {
        return StringUtils.format((String)"%smetadata/datasources/%s/segments", (Object[])new Object[]{this.getCoordinatorURL(), dataSource});
    }

    private String getIntervalsURL(String dataSource) {
        return StringUtils.format((String)"%sdatasources/%s/intervals", (Object[])new Object[]{this.getCoordinatorURL(), dataSource});
    }

    private String getLoadStatusURL() {
        return StringUtils.format((String)"%s%s", (Object[])new Object[]{this.getCoordinatorURL(), "loadstatus"});
    }

    public List<String> getMetadataSegments(String dataSource) {
        ArrayList segments = null;
        try {
            StatusResponseHolder response = this.makeRequest(HttpMethod.GET, this.getMetadataSegmentsURL(dataSource));
            segments = (ArrayList)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<ArrayList<String>>(){});
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        return segments;
    }

    public List<String> getSegmentIntervals(String dataSource) {
        ArrayList segments = null;
        try {
            StatusResponseHolder response = this.makeRequest(HttpMethod.GET, this.getIntervalsURL(dataSource));
            segments = (ArrayList)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<ArrayList<String>>(){});
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        return segments;
    }

    private Map<String, Integer> getLoadStatus() {
        Map status = null;
        try {
            StatusResponseHolder response = this.makeRequest(HttpMethod.GET, this.getLoadStatusURL());
            status = (Map)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<Map<String, Integer>>(){});
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        return status;
    }

    public boolean areSegmentsLoaded(String dataSource) {
        Map<String, Integer> status = this.getLoadStatus();
        return status.containsKey(dataSource) && (double)status.get(dataSource).intValue() == 100.0;
    }

    public void unloadSegmentsForDataSource(String dataSource) {
        try {
            this.makeRequest(HttpMethod.DELETE, StringUtils.format((String)"%sdatasources/%s", (Object[])new Object[]{this.getCoordinatorURL(), dataSource}));
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void deleteSegmentsDataSource(String dataSource, Interval interval) {
        try {
            this.makeRequest(HttpMethod.DELETE, StringUtils.format((String)"%sdatasources/%s/intervals/%s", (Object[])new Object[]{this.getCoordinatorURL(), dataSource, interval.toString().replace("/", "_")}));
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public HttpResponseStatus getProxiedOverlordScalingResponseStatus() {
        try {
            StatusResponseHolder response = this.makeRequest(HttpMethod.GET, StringUtils.format((String)"%s/druid/indexer/v1/scaling", (Object[])new Object[]{this.coordinator}));
            return response.getStatus();
        }
        catch (Exception e) {
            throw new RE((Throwable)e, "Unable to get scaling status from [%s]", new Object[]{this.coordinator});
        }
    }

    private StatusResponseHolder makeRequest(HttpMethod method, String url) {
        try {
            StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(method, new URL(url)), (HttpResponseHandler)this.responseHandler).get();
            if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
                throw new ISE("Error while making request to url[%s] status[%s] content[%s]", new Object[]{url, response.getStatus(), response.getContent()});
            }
            return response;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

