/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.clients;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.java.util.http.client.response.StatusResponseHandler;
import org.apache.druid.java.util.http.client.response.StatusResponseHolder;
import org.apache.druid.query.Query;
import org.apache.druid.testing.IntegrationTestingConfig;
import org.apache.druid.testing.guice.TestClient;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public class QueryResourceTestClient {
    private final ObjectMapper jsonMapper;
    private final HttpClient httpClient;
    private final String routerUrl;
    private final StatusResponseHandler responseHandler;

    @Inject
    QueryResourceTestClient(ObjectMapper jsonMapper, @TestClient HttpClient httpClient, IntegrationTestingConfig config) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.routerUrl = config.getRouterUrl();
        this.responseHandler = new StatusResponseHandler(StandardCharsets.UTF_8);
    }

    private String getBrokerURL() {
        return StringUtils.format((String)"%s/druid/v2/", (Object[])new Object[]{this.routerUrl});
    }

    public List<Map<String, Object>> query(String url, Query query) {
        try {
            StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.POST, new URL(url)).setContent("application/json", this.jsonMapper.writeValueAsBytes((Object)query)), (HttpResponseHandler)this.responseHandler).get();
            if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
                throw new ISE("Error while querying[%s] status[%s] content[%s]", new Object[]{this.getBrokerURL(), response.getStatus(), response.getContent()});
            }
            return (List)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

