/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.testing.IntegrationTestingConfig;
import org.apache.druid.testing.clients.QueryResourceTestClient;
import org.apache.druid.testing.utils.QueryResultVerifier;
import org.apache.druid.testing.utils.QueryWithResults;

public class TestQueryHelper {
    public static Logger LOG = new Logger(TestQueryHelper.class);
    private final QueryResourceTestClient queryClient;
    private final ObjectMapper jsonMapper;
    private final String broker;
    private final String brokerTLS;
    private final String router;
    private final String routerTLS;

    @Inject
    TestQueryHelper(ObjectMapper jsonMapper, QueryResourceTestClient queryClient, IntegrationTestingConfig config) {
        this.jsonMapper = jsonMapper;
        this.queryClient = queryClient;
        this.broker = config.getBrokerUrl();
        this.brokerTLS = config.getBrokerTLSUrl();
        this.router = config.getRouterUrl();
        this.routerTLS = config.getRouterTLSUrl();
    }

    public void testQueriesFromFile(String filePath, int timesToRun) throws Exception {
        this.testQueriesFromFile(this.getQueryURL(this.broker), filePath, timesToRun);
        this.testQueriesFromFile(this.getQueryURL(this.brokerTLS), filePath, timesToRun);
        this.testQueriesFromFile(this.getQueryURL(this.router), filePath, timesToRun);
        this.testQueriesFromFile(this.getQueryURL(this.routerTLS), filePath, timesToRun);
    }

    public void testQueriesFromFile(String url, String filePath, int timesToRun) throws Exception {
        LOG.info("Starting query tests for [%s]", new Object[]{filePath});
        List queries = (List)this.jsonMapper.readValue(TestQueryHelper.class.getResourceAsStream(filePath), (TypeReference)new TypeReference<List<QueryWithResults>>(){});
        this.testQueries(url, queries, timesToRun);
    }

    public void testQueriesFromString(String str, int timesToRun) throws Exception {
        this.testQueriesFromString(this.getQueryURL(this.broker), str, timesToRun);
        this.testQueriesFromString(this.getQueryURL(this.brokerTLS), str, timesToRun);
        this.testQueriesFromString(this.getQueryURL(this.router), str, timesToRun);
        this.testQueriesFromString(this.getQueryURL(this.routerTLS), str, timesToRun);
    }

    public void testQueriesFromString(String url, String str, int timesToRun) throws Exception {
        LOG.info("Starting query tests using\n%s", new Object[]{str});
        List queries = (List)this.jsonMapper.readValue(str, (TypeReference)new TypeReference<List<QueryWithResults>>(){});
        this.testQueries(url, queries, timesToRun);
    }

    private void testQueries(String url, List<QueryWithResults> queries, int timesToRun) throws Exception {
        LOG.info("Running queries, url [%s]", new Object[]{url});
        for (int i = 0; i < timesToRun; ++i) {
            LOG.info("Starting Iteration %d", new Object[]{i});
            boolean failed = false;
            for (QueryWithResults queryWithResult : queries) {
                LOG.info("Running Query %s", new Object[]{queryWithResult.getQuery().getType()});
                List<Map<String, Object>> result = this.queryClient.query(url, queryWithResult.getQuery());
                if (!QueryResultVerifier.compareResults(result, queryWithResult.getExpectedResults())) {
                    LOG.error("Failed while executing query %s \n expectedResults: %s \n actualResults : %s", new Object[]{queryWithResult.getQuery(), this.jsonMapper.writeValueAsString(queryWithResult.getExpectedResults()), this.jsonMapper.writeValueAsString(result)});
                    failed = true;
                    continue;
                }
                LOG.info("Results Verified for Query %s", new Object[]{queryWithResult.getQuery().getType()});
            }
            if (!failed) continue;
            throw new ISE("one or more queries failed", new Object[0]);
        }
    }

    private String getQueryURL(String schemeAndHost) {
        return StringUtils.format((String)"%s/druid/v2?pretty", (Object[])new Object[]{schemeAndHost});
    }

    public int countRows(String dataSource, String interval) {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource(dataSource).aggregators((List)ImmutableList.of((Object)new LongSumAggregatorFactory("rows", "count"))).granularity(Granularities.ALL).intervals(interval).build();
        List<Map<String, Object>> results = this.queryClient.query(this.getQueryURL(this.broker), (Query)query);
        if (results.isEmpty()) {
            return 0;
        }
        Map map = (Map)results.get(0).get("result");
        return (Integer)map.get("rows");
    }
}

