/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.testing.IntegrationTestingConfig;
import org.apache.druid.testing.clients.QueryResourceTestClient;
import org.apache.druid.testing.utils.AbstractTestQueryHelper;
import org.apache.druid.testing.utils.QueryWithResults;

public class TestQueryHelper
extends AbstractTestQueryHelper<QueryWithResults> {
    @Inject
    TestQueryHelper(ObjectMapper jsonMapper, QueryResourceTestClient queryClient, IntegrationTestingConfig config) {
        super(jsonMapper, queryClient, config);
    }

    @Override
    public void testQueriesFromFile(String filePath, int timesToRun) throws Exception {
        this.testQueriesFromFile(this.getQueryURL(this.broker), filePath, timesToRun);
        this.testQueriesFromFile(this.getQueryURL(this.brokerTLS), filePath, timesToRun);
        this.testQueriesFromFile(this.getQueryURL(this.router), filePath, timesToRun);
        this.testQueriesFromFile(this.getQueryURL(this.routerTLS), filePath, timesToRun);
    }

    public void testQueriesFromString(String str, int timesToRun) throws Exception {
        this.testQueriesFromString(this.getQueryURL(this.broker), str, timesToRun);
        this.testQueriesFromString(this.getQueryURL(this.brokerTLS), str, timesToRun);
        this.testQueriesFromString(this.getQueryURL(this.router), str, timesToRun);
        this.testQueriesFromString(this.getQueryURL(this.routerTLS), str, timesToRun);
    }

    @Override
    protected String getQueryURL(String schemeAndHost) {
        return StringUtils.format((String)"%s/druid/v2?pretty", (Object[])new Object[]{schemeAndHost});
    }
}

