/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.guice;

import com.google.common.collect.ImmutableList;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Collections;
import java.util.List;
import org.apache.druid.guice.GuiceInjectors;
import org.apache.druid.guice.IndexingServiceFirehoseModule;
import org.apache.druid.initialization.Initialization;
import org.apache.druid.testing.guice.DruidTestModule;
import org.testng.IModuleFactory;
import org.testng.ITestContext;

public class DruidTestModuleFactory
implements IModuleFactory {
    private static final Module module = new DruidTestModule();
    private static final Injector injector = Initialization.makeInjectorWithModules((Injector)GuiceInjectors.makeStartupInjector(), DruidTestModuleFactory.getModules());

    public static Injector getInjector() {
        return injector;
    }

    private static List<? extends Module> getModules() {
        return ImmutableList.of((Object)new DruidTestModule(), (Object)new IndexingServiceFirehoseModule());
    }

    public Module createModule(ITestContext context, Class<?> testClass) {
        context.addGuiceModule(DruidTestModule.class, module);
        context.addInjector(Collections.singletonList(module), injector);
        return module;
    }
}

