/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.utils;

import java.util.concurrent.Callable;
import org.apache.druid.client.selector.Server;
import org.apache.druid.curator.discovery.ServerDiscoverySelector;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.testing.utils.RetryUtil;

public class ServerDiscoveryUtil {
    private static final Logger LOG = new Logger(ServerDiscoveryUtil.class);

    public static boolean isInstanceReady(ServerDiscoverySelector serviceProvider) {
        try {
            Server instance = serviceProvider.pick();
            if (instance == null) {
                LOG.warn("Unable to find a host", new Object[0]);
                return false;
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "Caught exception waiting for host", new Object[0]);
            return false;
        }
        return true;
    }

    public static void waitUntilInstanceReady(final ServerDiscoverySelector serviceProvider, String instanceType) {
        RetryUtil.retryUntilTrue(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return ServerDiscoveryUtil.isInstanceReady(serviceProvider);
            }
        }, StringUtils.format((String)"Instance %s to get ready", (Object[])new Object[]{instanceType}));
    }
}

