/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.druid.testing.IntegrationTestingConfig;
import org.apache.druid.testing.IntegrationTestingConfigProvider;

public class DockerConfigProvider
implements IntegrationTestingConfigProvider {
    @JsonProperty
    @NotNull
    private String dockerIp;
    @JsonProperty
    @NotNull
    private String hadoopDir;
    @JsonProperty
    private String extraDatasourceNameSuffix = "";

    public IntegrationTestingConfig get() {
        return new IntegrationTestingConfig(){

            @Override
            public String getCoordinatorUrl() {
                return "http://" + DockerConfigProvider.this.dockerIp + ":8081";
            }

            @Override
            public String getCoordinatorTLSUrl() {
                return "https://" + DockerConfigProvider.this.dockerIp + ":8281";
            }

            @Override
            public String getIndexerUrl() {
                return "http://" + DockerConfigProvider.this.dockerIp + ":8090";
            }

            @Override
            public String getIndexerTLSUrl() {
                return "https://" + DockerConfigProvider.this.dockerIp + ":8290";
            }

            @Override
            public String getRouterUrl() {
                return "http://" + DockerConfigProvider.this.dockerIp + ":8888";
            }

            @Override
            public String getRouterTLSUrl() {
                return "https://" + DockerConfigProvider.this.dockerIp + ":9088";
            }

            @Override
            public String getPermissiveRouterUrl() {
                return "http://" + DockerConfigProvider.this.dockerIp + ":8889";
            }

            @Override
            public String getPermissiveRouterTLSUrl() {
                return "https://" + DockerConfigProvider.this.dockerIp + ":9089";
            }

            @Override
            public String getNoClientAuthRouterUrl() {
                return "http://" + DockerConfigProvider.this.dockerIp + ":8890";
            }

            @Override
            public String getNoClientAuthRouterTLSUrl() {
                return "https://" + DockerConfigProvider.this.dockerIp + ":9090";
            }

            @Override
            public String getCustomCertCheckRouterUrl() {
                return "http://" + DockerConfigProvider.this.dockerIp + ":8891";
            }

            @Override
            public String getCustomCertCheckRouterTLSUrl() {
                return "https://" + DockerConfigProvider.this.dockerIp + ":9091";
            }

            @Override
            public String getBrokerUrl() {
                return "http://" + DockerConfigProvider.this.dockerIp + ":8082";
            }

            @Override
            public String getBrokerTLSUrl() {
                return "https://" + DockerConfigProvider.this.dockerIp + ":8282";
            }

            @Override
            public String getHistoricalUrl() {
                return "http://" + DockerConfigProvider.this.dockerIp + ":8083";
            }

            @Override
            public String getHistoricalTLSUrl() {
                return "https://" + DockerConfigProvider.this.dockerIp + ":8283";
            }

            @Override
            public String getMiddleManagerHost() {
                return DockerConfigProvider.this.dockerIp;
            }

            @Override
            public String getZookeeperHosts() {
                return DockerConfigProvider.this.dockerIp + ":2181";
            }

            @Override
            public String getZookeeperInternalHosts() {
                return "druid-zookeeper-kafka:2181";
            }

            @Override
            public String getKafkaHost() {
                return DockerConfigProvider.this.dockerIp + ":9093";
            }

            @Override
            public String getKafkaInternalHost() {
                return "druid-zookeeper-kafka:9092";
            }

            @Override
            public String getProperty(String prop) {
                if ("hadoopTestDir".equals(prop)) {
                    return DockerConfigProvider.this.hadoopDir;
                }
                throw new UnsupportedOperationException("DockerConfigProvider does not support property " + prop);
            }

            @Override
            public String getUsername() {
                return null;
            }

            @Override
            public String getPassword() {
                return null;
            }

            @Override
            public Map<String, String> getProperties() {
                return new HashMap<String, String>();
            }

            @Override
            public boolean manageKafkaTopic() {
                return true;
            }

            @Override
            public String getExtraDatasourceNameSuffix() {
                return DockerConfigProvider.this.extraDatasourceNameSuffix;
            }
        };
    }
}

