/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.Druids;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.testing.IntegrationTestingConfig;
import org.apache.druid.testing.clients.AbstractQueryResourceTestClient;
import org.apache.druid.testing.utils.AbstractQueryWithResults;
import org.apache.druid.testing.utils.QueryResultVerifier;
import org.apache.druid.testing.utils.TestQueryHelper;

public abstract class AbstractTestQueryHelper<QueryResultType extends AbstractQueryWithResults> {
    public static final Logger LOG = new Logger(TestQueryHelper.class);
    private final AbstractQueryResourceTestClient queryClient;
    private final ObjectMapper jsonMapper;
    protected final String broker;
    protected final String brokerTLS;
    protected final String router;
    protected final String routerTLS;

    @Inject
    AbstractTestQueryHelper(ObjectMapper jsonMapper, AbstractQueryResourceTestClient queryClient, IntegrationTestingConfig config) {
        this.jsonMapper = jsonMapper;
        this.queryClient = queryClient;
        this.broker = config.getBrokerUrl();
        this.brokerTLS = config.getBrokerTLSUrl();
        this.router = config.getRouterUrl();
        this.routerTLS = config.getRouterTLSUrl();
    }

    public abstract void testQueriesFromFile(String var1, int var2) throws Exception;

    public abstract String getQueryURL(String var1);

    public void testQueriesFromFile(String url, String filePath, int timesToRun) throws Exception {
        LOG.info("Starting query tests for [%s]", new Object[]{filePath});
        List queries = (List)this.jsonMapper.readValue(TestQueryHelper.class.getResourceAsStream(filePath), new TypeReference<List<QueryResultType>>(){});
        this.testQueries(url, queries, timesToRun);
    }

    public void testQueriesFromString(String url, String str, int timesToRun) throws Exception {
        LOG.info("Starting query tests using\n%s", new Object[]{str});
        List queries = (List)this.jsonMapper.readValue(str, new TypeReference<List<QueryResultType>>(){});
        this.testQueries(url, queries, timesToRun);
    }

    private void testQueries(String url, List<QueryResultType> queries, int timesToRun) throws Exception {
        LOG.info("Running queries, url [%s]", new Object[]{url});
        for (int i = 0; i < timesToRun; ++i) {
            LOG.info("Starting Iteration %d", new Object[]{i});
            boolean failed = false;
            for (AbstractQueryWithResults queryWithResult : queries) {
                LOG.info("Running Query %s", new Object[]{queryWithResult.getQuery()});
                List<Map<String, Object>> result = this.queryClient.query(url, queryWithResult.getQuery());
                if (!QueryResultVerifier.compareResults(result, queryWithResult.getExpectedResults())) {
                    LOG.error("Failed while executing query %s \n expectedResults: %s \n actualResults : %s", new Object[]{queryWithResult.getQuery(), this.jsonMapper.writeValueAsString(queryWithResult.getExpectedResults()), this.jsonMapper.writeValueAsString(result)});
                    failed = true;
                    continue;
                }
                LOG.info("Results Verified for Query %s", new Object[]{queryWithResult.getQuery()});
            }
            if (!failed) continue;
            throw new ISE("one or more queries failed", new Object[0]);
        }
    }

    public int countRows(String dataSource, String interval) {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource(dataSource).aggregators((List)ImmutableList.of((Object)new LongSumAggregatorFactory("rows", "count"))).granularity(Granularities.ALL).intervals(interval).build();
        List<Map<String, Object>> results = this.queryClient.query(this.getQueryURL(this.broker), query);
        if (results.isEmpty()) {
            return 0;
        }
        Map map = (Map)results.get(0).get("result");
        return (Integer)map.get("rows");
    }
}

