/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import com.google.inject.Injector;
import com.google.inject.Key;
import java.net.URL;
import java.util.List;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.java.util.http.client.response.StatusResponseHandler;
import org.apache.druid.java.util.http.client.response.StatusResponseHolder;
import org.apache.druid.testing.IntegrationTestingConfig;
import org.apache.druid.testing.guice.DruidTestModuleFactory;
import org.apache.druid.testing.guice.TestClient;
import org.apache.druid.testing.utils.ITRetryUtil;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.testng.IInvokedMethodListener;
import org.testng.ISuite;
import org.testng.ITestRunnerFactory;
import org.testng.TestNG;
import org.testng.TestRunner;
import org.testng.internal.IConfiguration;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.xml.XmlTest;

public class DruidTestRunnerFactory
implements ITestRunnerFactory {
    private static final Logger LOG = new Logger(DruidTestRunnerFactory.class);

    public TestRunner newTestRunner(ISuite suite, XmlTest test, List<IInvokedMethodListener> listeners) {
        IConfiguration configuration = TestNG.getDefault().getConfiguration();
        String outputDirectory = suite.getOutputDirectory();
        IAnnotationFinder annotationFinder = configuration.getAnnotationFinder();
        Boolean skipFailedInvocationCounts = suite.getXmlSuite().skipFailedInvocationCounts();
        return new DruidTestRunner(configuration, suite, test, outputDirectory, annotationFinder, skipFailedInvocationCounts, listeners);
    }

    private static class DruidTestRunner
    extends TestRunner {
        protected DruidTestRunner(IConfiguration configuration, ISuite suite, XmlTest test, String outputDirectory, IAnnotationFinder finder, boolean skipFailedInvocationCounts, List<IInvokedMethodListener> invokedMethodListeners) {
            super(configuration, suite, test, outputDirectory, finder, skipFailedInvocationCounts, invokedMethodListeners);
        }

        public void run() {
            Injector injector = DruidTestModuleFactory.getInjector();
            IntegrationTestingConfig config = (IntegrationTestingConfig)injector.getInstance(IntegrationTestingConfig.class);
            HttpClient client = (HttpClient)injector.getInstance(Key.get(HttpClient.class, TestClient.class));
            this.waitUntilInstanceReady(client, config.getCoordinatorUrl());
            this.waitUntilInstanceReady(client, config.getIndexerUrl());
            this.waitUntilInstanceReady(client, config.getBrokerUrl());
            String routerHost = config.getRouterUrl();
            if (null != routerHost) {
                this.waitUntilInstanceReady(client, config.getRouterUrl());
            }
            Lifecycle lifecycle = (Lifecycle)injector.getInstance(Lifecycle.class);
            try {
                lifecycle.start();
                this.runTests();
            }
            catch (Exception e) {
                LOG.error((Throwable)e, "", new Object[0]);
                throw new RuntimeException(e);
            }
            finally {
                lifecycle.stop();
            }
        }

        private void runTests() {
            super.run();
        }

        public void waitUntilInstanceReady(HttpClient client, String host) {
            ITRetryUtil.retryUntilTrue(() -> {
                try {
                    StatusResponseHolder response = (StatusResponseHolder)client.go(new Request(HttpMethod.GET, new URL(StringUtils.format((String)"%s/status/health", (Object[])new Object[]{host}))), (HttpResponseHandler)StatusResponseHandler.getInstance()).get();
                    LOG.info("%s %s", new Object[]{response.getStatus(), response.getContent()});
                    return response.getStatus().equals((Object)HttpResponseStatus.OK);
                }
                catch (Throwable e) {
                    LOG.error(e, "", new Object[0]);
                    return false;
                }
            }, "Waiting for instance to be ready: [" + host + "]");
        }
    }
}

