/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.testing.IntegrationTestingConfig;
import org.apache.druid.testing.IntegrationTestingConfigProvider;

public class ConfigFileConfigProvider
implements IntegrationTestingConfigProvider {
    private static final Logger LOG = new Logger(ConfigFileConfigProvider.class);
    private String routerUrl;
    private String brokerUrl;
    private String historicalUrl;
    private String coordinatorUrl;
    private String indexerUrl;
    private String permissiveRouterUrl;
    private String noClientAuthRouterUrl;
    private String customCertCheckRouterUrl;
    private String routerTLSUrl;
    private String brokerTLSUrl;
    private String historicalTLSUrl;
    private String coordinatorTLSUrl;
    private String indexerTLSUrl;
    private String permissiveRouterTLSUrl;
    private String noClientAuthRouterTLSUrl;
    private String customCertCheckRouterTLSUrl;
    private String middleManagerHost;
    private String zookeeperHosts;
    private String kafkaHost;
    private Map<String, String> props = null;
    private String username;
    private String password;
    private String cloudBucket;
    private String cloudPath;
    private String streamEndpoint;

    @JsonCreator
    ConfigFileConfigProvider(@JsonProperty(value="configFile") String configFile) {
        this.loadProperties(configFile);
    }

    private void loadProperties(String configFile) {
        String indexerHost;
        String coordinatorHost;
        String historicalHost;
        String brokerHost;
        String customCertCheckRouterHost;
        String noClientAuthRouterHost;
        String permissiveRouterHost;
        String routerHost;
        ObjectMapper jsonMapper = new ObjectMapper();
        try {
            this.props = (Map)jsonMapper.readValue(new File(configFile), JacksonUtils.TYPE_REFERENCE_MAP_STRING_STRING);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.routerUrl = this.props.get("router_url");
        if (this.routerUrl == null && null != (routerHost = this.props.get("router_host"))) {
            this.routerUrl = StringUtils.format((String)"http://%s:%s", (Object[])new Object[]{routerHost, this.props.get("router_port")});
        }
        this.routerTLSUrl = this.props.get("router_tls_url");
        if (this.routerTLSUrl == null && null != (routerHost = this.props.get("router_host"))) {
            this.routerTLSUrl = StringUtils.format((String)"https://%s:%s", (Object[])new Object[]{routerHost, this.props.get("router_tls_port")});
        }
        this.permissiveRouterUrl = this.props.get("router_permissive_url");
        if (this.permissiveRouterUrl == null && null != (permissiveRouterHost = this.props.get("router_permissive_host"))) {
            this.permissiveRouterUrl = StringUtils.format((String)"http://%s:%s", (Object[])new Object[]{permissiveRouterHost, this.props.get("router_permissive_port")});
        }
        this.permissiveRouterTLSUrl = this.props.get("router_permissive_tls_url");
        if (this.permissiveRouterTLSUrl == null && null != (permissiveRouterHost = this.props.get("router_permissive_host"))) {
            this.permissiveRouterTLSUrl = StringUtils.format((String)"https://%s:%s", (Object[])new Object[]{permissiveRouterHost, this.props.get("router_permissive_tls_port")});
        }
        this.noClientAuthRouterUrl = this.props.get("router_no_client_auth_url");
        if (this.noClientAuthRouterUrl == null && null != (noClientAuthRouterHost = this.props.get("router_no_client_auth_host"))) {
            this.noClientAuthRouterUrl = StringUtils.format((String)"http://%s:%s", (Object[])new Object[]{noClientAuthRouterHost, this.props.get("router_no_client_auth_port")});
        }
        this.noClientAuthRouterTLSUrl = this.props.get("router_no_client_auth_tls_url");
        if (this.noClientAuthRouterTLSUrl == null && null != (noClientAuthRouterHost = this.props.get("router_no_client_auth_host"))) {
            this.noClientAuthRouterTLSUrl = StringUtils.format((String)"https://%s:%s", (Object[])new Object[]{noClientAuthRouterHost, this.props.get("router_no_client_auth_tls_port")});
        }
        this.customCertCheckRouterUrl = this.props.get("router_no_client_auth_url");
        if (this.customCertCheckRouterUrl == null && null != (customCertCheckRouterHost = this.props.get("router_no_client_auth_host"))) {
            this.customCertCheckRouterUrl = StringUtils.format((String)"http://%s:%s", (Object[])new Object[]{customCertCheckRouterHost, this.props.get("router_no_client_auth_port")});
        }
        this.customCertCheckRouterTLSUrl = this.props.get("router_no_client_auth_tls_url");
        if (this.customCertCheckRouterTLSUrl == null && null != (customCertCheckRouterHost = this.props.get("router_no_client_auth_host"))) {
            this.customCertCheckRouterTLSUrl = StringUtils.format((String)"https://%s:%s", (Object[])new Object[]{customCertCheckRouterHost, this.props.get("router_no_client_auth_tls_port")});
        }
        this.brokerUrl = this.props.get("broker_url");
        if (this.brokerUrl == null) {
            this.brokerUrl = StringUtils.format((String)"http://%s:%s", (Object[])new Object[]{this.props.get("broker_host"), this.props.get("broker_port")});
        }
        this.brokerTLSUrl = this.props.get("broker_tls_url");
        if (this.brokerTLSUrl == null && null != (brokerHost = this.props.get("broker_host"))) {
            this.brokerTLSUrl = StringUtils.format((String)"https://%s:%s", (Object[])new Object[]{brokerHost, this.props.get("broker_tls_port")});
        }
        this.historicalUrl = this.props.get("historical_url");
        if (this.historicalUrl == null) {
            this.historicalUrl = StringUtils.format((String)"http://%s:%s", (Object[])new Object[]{this.props.get("historical_host"), this.props.get("historical_port")});
        }
        this.historicalTLSUrl = this.props.get("historical_tls_url");
        if (this.historicalTLSUrl == null && null != (historicalHost = this.props.get("historical_host"))) {
            this.historicalTLSUrl = StringUtils.format((String)"https://%s:%s", (Object[])new Object[]{historicalHost, this.props.get("historical_tls_port")});
        }
        this.coordinatorUrl = this.props.get("coordinator_url");
        if (this.coordinatorUrl == null) {
            this.coordinatorUrl = StringUtils.format((String)"http://%s:%s", (Object[])new Object[]{this.props.get("coordinator_host"), this.props.get("coordinator_port")});
        }
        this.coordinatorTLSUrl = this.props.get("coordinator_tls_url");
        if (this.coordinatorTLSUrl == null && null != (coordinatorHost = this.props.get("coordinator_host"))) {
            this.coordinatorTLSUrl = StringUtils.format((String)"https://%s:%s", (Object[])new Object[]{coordinatorHost, this.props.get("coordinator_tls_port")});
        }
        this.indexerUrl = this.props.get("indexer_url");
        if (this.indexerUrl == null) {
            this.indexerUrl = StringUtils.format((String)"http://%s:%s", (Object[])new Object[]{this.props.get("indexer_host"), this.props.get("indexer_port")});
        }
        this.indexerTLSUrl = this.props.get("indexer_tls_url");
        if (this.indexerTLSUrl == null && null != (indexerHost = this.props.get("indexer_host"))) {
            this.indexerTLSUrl = StringUtils.format((String)"https://%s:%s", (Object[])new Object[]{indexerHost, this.props.get("indexer_tls_port")});
        }
        this.middleManagerHost = this.props.get("middlemanager_host");
        this.zookeeperHosts = this.props.get("zookeeper_hosts");
        this.kafkaHost = this.props.get("kafka_host") + ":" + this.props.get("kafka_port");
        this.username = this.props.get("username");
        this.password = this.props.get("password");
        this.cloudBucket = this.props.get("cloud_bucket");
        this.cloudPath = this.props.get("cloud_path");
        this.streamEndpoint = this.props.get("stream_endpoint");
        LOG.info("router: [%s], [%s]", new Object[]{this.routerUrl, this.routerTLSUrl});
        LOG.info("broker: [%s], [%s]", new Object[]{this.brokerUrl, this.brokerTLSUrl});
        LOG.info("historical: [%s], [%s]", new Object[]{this.historicalUrl, this.historicalTLSUrl});
        LOG.info("coordinator: [%s], [%s]", new Object[]{this.coordinatorUrl, this.coordinatorTLSUrl});
        LOG.info("overlord: [%s], [%s]", new Object[]{this.indexerUrl, this.indexerTLSUrl});
        LOG.info("middle manager: [%s]", new Object[]{this.middleManagerHost});
        LOG.info("zookeepers: [%s]", new Object[]{this.zookeeperHosts});
        LOG.info("kafka: [%s]", new Object[]{this.kafkaHost});
        LOG.info("Username: [%s]", new Object[]{this.username});
    }

    public IntegrationTestingConfig get() {
        return new IntegrationTestingConfig(){

            @Override
            public String getCoordinatorUrl() {
                return ConfigFileConfigProvider.this.coordinatorUrl;
            }

            @Override
            public String getCoordinatorTLSUrl() {
                return ConfigFileConfigProvider.this.coordinatorTLSUrl;
            }

            @Override
            public String getIndexerUrl() {
                return ConfigFileConfigProvider.this.indexerUrl;
            }

            @Override
            public String getIndexerTLSUrl() {
                return ConfigFileConfigProvider.this.indexerTLSUrl;
            }

            @Override
            public String getRouterUrl() {
                return ConfigFileConfigProvider.this.routerUrl;
            }

            @Override
            public String getRouterTLSUrl() {
                return ConfigFileConfigProvider.this.routerTLSUrl;
            }

            @Override
            public String getPermissiveRouterUrl() {
                return ConfigFileConfigProvider.this.permissiveRouterUrl;
            }

            @Override
            public String getPermissiveRouterTLSUrl() {
                return ConfigFileConfigProvider.this.permissiveRouterTLSUrl;
            }

            @Override
            public String getNoClientAuthRouterUrl() {
                return ConfigFileConfigProvider.this.noClientAuthRouterUrl;
            }

            @Override
            public String getNoClientAuthRouterTLSUrl() {
                return ConfigFileConfigProvider.this.noClientAuthRouterTLSUrl;
            }

            @Override
            public String getCustomCertCheckRouterUrl() {
                return ConfigFileConfigProvider.this.customCertCheckRouterUrl;
            }

            @Override
            public String getCustomCertCheckRouterTLSUrl() {
                return ConfigFileConfigProvider.this.customCertCheckRouterTLSUrl;
            }

            @Override
            public String getBrokerUrl() {
                return ConfigFileConfigProvider.this.brokerUrl;
            }

            @Override
            public String getBrokerTLSUrl() {
                return ConfigFileConfigProvider.this.brokerTLSUrl;
            }

            @Override
            public String getHistoricalUrl() {
                return ConfigFileConfigProvider.this.historicalUrl;
            }

            @Override
            public String getHistoricalTLSUrl() {
                return ConfigFileConfigProvider.this.historicalTLSUrl;
            }

            @Override
            public String getMiddleManagerHost() {
                return ConfigFileConfigProvider.this.middleManagerHost;
            }

            @Override
            public String getZookeeperHosts() {
                return ConfigFileConfigProvider.this.zookeeperHosts;
            }

            @Override
            public String getKafkaHost() {
                return ConfigFileConfigProvider.this.kafkaHost;
            }

            @Override
            public String getProperty(String keyword) {
                return (String)ConfigFileConfigProvider.this.props.get(keyword);
            }

            @Override
            public String getUsername() {
                return ConfigFileConfigProvider.this.username;
            }

            @Override
            public String getPassword() {
                return ConfigFileConfigProvider.this.password;
            }

            @Override
            public String getCloudBucket() {
                return ConfigFileConfigProvider.this.cloudBucket;
            }

            @Override
            public String getCloudPath() {
                return ConfigFileConfigProvider.this.cloudPath;
            }

            @Override
            public String getStreamEndpoint() {
                return ConfigFileConfigProvider.this.streamEndpoint;
            }

            @Override
            public Map<String, String> getProperties() {
                return ConfigFileConfigProvider.this.props;
            }

            @Override
            public boolean manageKafkaTopic() {
                return Boolean.valueOf(ConfigFileConfigProvider.this.props.getOrDefault("manageKafkaTopic", "true"));
            }

            @Override
            public String getExtraDatasourceNameSuffix() {
                return "";
            }
        };
    }
}

