/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.utils;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.DockerCmdExecFactory;
import com.github.dockerjava.core.DockerClientBuilder;
import com.github.dockerjava.netty.NettyDockerCmdExecFactory;
import com.google.inject.Inject;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.java.util.http.client.response.StatusResponseHandler;
import org.apache.druid.java.util.http.client.response.StatusResponseHolder;
import org.apache.druid.testing.IntegrationTestingConfig;
import org.apache.druid.testing.guice.TestClient;
import org.apache.druid.testing.utils.ITRetryUtil;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public class DruidClusterAdminClient {
    private static final Logger LOG = new Logger(DruidClusterAdminClient.class);
    private static final String COORDINATOR_DOCKER_CONTAINER_NAME = "/druid-coordinator";
    private static final String HISTORICAL_DOCKER_CONTAINER_NAME = "/druid-historical";
    private static final String INDEXER_DOCKER_CONTAINER_NAME = "/druid-overlord";
    private static final String BROKERR_DOCKER_CONTAINER_NAME = "/druid-broker";
    private static final String ROUTER_DOCKER_CONTAINER_NAME = "/druid-router";
    private static final String MIDDLEMANAGER_DOCKER_CONTAINER_NAME = "/druid-middlemanager";
    private final HttpClient httpClient;
    private IntegrationTestingConfig config;

    @Inject
    DruidClusterAdminClient(@TestClient HttpClient httpClient, IntegrationTestingConfig config) {
        this.httpClient = httpClient;
        this.config = config;
    }

    public void restartCoordinatorContainer() {
        this.restartDockerContainer(COORDINATOR_DOCKER_CONTAINER_NAME);
    }

    public void restartHistoricalContainer() {
        this.restartDockerContainer(HISTORICAL_DOCKER_CONTAINER_NAME);
    }

    public void restartIndexerContainer() {
        this.restartDockerContainer(INDEXER_DOCKER_CONTAINER_NAME);
    }

    public void restartBrokerContainer() {
        this.restartDockerContainer(BROKERR_DOCKER_CONTAINER_NAME);
    }

    public void restartRouterContainer() {
        this.restartDockerContainer(ROUTER_DOCKER_CONTAINER_NAME);
    }

    public void restartMiddleManagerContainer() {
        this.restartDockerContainer(MIDDLEMANAGER_DOCKER_CONTAINER_NAME);
    }

    public void waitUntilCoordinatorReady() {
        this.waitUntilInstanceReady(this.config.getCoordinatorUrl());
    }

    public void waitUntilHistoricalReady() {
        this.waitUntilInstanceReady(this.config.getHistoricalUrl());
    }

    public void waitUntilIndexerReady() {
        this.waitUntilInstanceReady(this.config.getIndexerUrl());
    }

    public void waitUntilBrokerReady() {
        this.waitUntilInstanceReady(this.config.getBrokerUrl());
    }

    public void waitUntilRouterReady() {
        this.waitUntilInstanceReady(this.config.getRouterUrl());
    }

    private void restartDockerContainer(String serviceName) {
        DockerClient dockerClient = DockerClientBuilder.getInstance().withDockerCmdExecFactory((DockerCmdExecFactory)new NettyDockerCmdExecFactory().withConnectTimeout(Integer.valueOf(10000))).build();
        List containers = (List)dockerClient.listContainersCmd().exec();
        Optional<String> containerName = containers.stream().filter(container -> Arrays.asList(container.getNames()).contains(serviceName)).findFirst().map(container -> container.getId());
        if (!containerName.isPresent()) {
            LOG.error("Cannot find docker container for " + serviceName, new Object[0]);
            throw new ISE("Cannot find docker container for " + serviceName, new Object[0]);
        }
        dockerClient.restartContainerCmd(containerName.get()).exec();
    }

    private void waitUntilInstanceReady(String host) {
        ITRetryUtil.retryUntilTrue(() -> {
            try {
                StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.GET, new URL(StringUtils.format((String)"%s/status/health", (Object[])new Object[]{host}))), (HttpResponseHandler)StatusResponseHandler.getInstance()).get();
                LOG.info("%s %s", new Object[]{response.getStatus(), response.getContent()});
                return response.getStatus().equals((Object)HttpResponseStatus.OK);
            }
            catch (Throwable e) {
                LOG.error(e, "", new Object[0]);
                return false;
            }
        }, "Waiting for instance to be ready: [" + host + "]");
    }
}

