/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.utils;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.logger.Logger;

public class ITRetryUtil {
    private static final Logger LOG = new Logger(ITRetryUtil.class);
    public static final int DEFAULT_RETRY_COUNT = 30;
    public static final long DEFAULT_RETRY_SLEEP = TimeUnit.SECONDS.toMillis(10L);

    public static void retryUntilTrue(Callable<Boolean> callable, String task) {
        ITRetryUtil.retryUntil(callable, true, DEFAULT_RETRY_SLEEP, 30, task);
    }

    public static void retryUntilFalse(Callable<Boolean> callable, String task) {
        ITRetryUtil.retryUntil(callable, false, DEFAULT_RETRY_SLEEP, 30, task);
    }

    public static void retryUntil(Callable<Boolean> callable, boolean expectedValue, long delayInMillis, int retryCount, String taskMessage) {
        try {
            int currentTry = 0;
            while (callable.call() != expectedValue) {
                if (currentTry > retryCount) {
                    throw new ISE("Max number of retries[%d] exceeded for Task[%s]. Failing.", new Object[]{retryCount, taskMessage});
                }
                LOG.info("Attempt[%d]: Task %s still not complete. Next retry in %d ms", new Object[]{currentTry, taskMessage, delayInMillis});
                Thread.sleep(delayInMillis);
                ++currentTry;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

