/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordination;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.client.cache.CachePopulator;
import org.apache.druid.guice.annotations.Processing;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.ReportTimelineMissingSegmentQueryRunner;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.segment.ReferenceCountingSegment;
import org.apache.druid.segment.SegmentReference;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.server.SegmentManager;
import org.apache.druid.server.coordination.ServerManager;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.timeline.VersionedIntervalTimeline;

public class ServerManagerForQueryRetryTest
extends ServerManager {
    public static final String QUERY_RETRY_TEST_CONTEXT_KEY = "query-retry-test";
    private static final Logger LOG = new Logger(ServerManagerForQueryRetryTest.class);
    private static final int MAX_NUM_FALSE_MISSING_SEGMENTS_REPORTS = 3;
    private final ConcurrentHashMap<String, Set<SegmentDescriptor>> queryToIgnoredSegments = new ConcurrentHashMap();

    @Inject
    public ServerManagerForQueryRetryTest(QueryRunnerFactoryConglomerate conglomerate, ServiceEmitter emitter, @Processing ExecutorService exec, CachePopulator cachePopulator, @Smile ObjectMapper objectMapper, Cache cache, CacheConfig cacheConfig, SegmentManager segmentManager, JoinableFactory joinableFactory, ServerConfig serverConfig) {
        super(conglomerate, emitter, exec, cachePopulator, objectMapper, cache, cacheConfig, segmentManager, joinableFactory, serverConfig);
    }

    <T> QueryRunner<T> buildQueryRunnerForSegment(Query<T> query, SegmentDescriptor descriptor, QueryRunnerFactory<T, Query<T>> factory, QueryToolChest<T, Query<T>> toolChest, VersionedIntervalTimeline<String, ReferenceCountingSegment> timeline, Function<SegmentReference, SegmentReference> segmentMapFn, AtomicLong cpuTimeAccumulator) {
        if (query.getContextBoolean(QUERY_RETRY_TEST_CONTEXT_KEY, false)) {
            MutableBoolean isIgnoreSegment = new MutableBoolean(false);
            this.queryToIgnoredSegments.compute(query.getMostSpecificId(), (queryId, ignoredSegments) -> {
                if (ignoredSegments == null) {
                    ignoredSegments = new HashSet<SegmentDescriptor>();
                }
                if (ignoredSegments.size() < 3) {
                    ignoredSegments.add(descriptor);
                    isIgnoreSegment.setTrue();
                }
                return ignoredSegments;
            });
            if (isIgnoreSegment.isTrue()) {
                LOG.info("Pretending I don't have segment[%s]", new Object[]{descriptor});
                return new ReportTimelineMissingSegmentQueryRunner(descriptor);
            }
        }
        return super.buildQueryRunnerForSegment(query, descriptor, factory, toolChest, timeline, segmentMapFn, cpuTimeAccumulator);
    }
}

