/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.clients;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import java.net.URL;
import java.util.Map;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.java.util.http.client.response.StatusResponseHandler;
import org.apache.druid.java.util.http.client.response.StatusResponseHolder;
import org.apache.druid.server.coordinator.CoordinatorCompactionConfig;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.testing.IntegrationTestingConfig;
import org.apache.druid.testing.guice.TestClient;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public class CompactionResourceTestClient {
    private final ObjectMapper jsonMapper;
    private final HttpClient httpClient;
    private final String coordinator;
    private final StatusResponseHandler responseHandler;

    @Inject
    CompactionResourceTestClient(ObjectMapper jsonMapper, @TestClient HttpClient httpClient, IntegrationTestingConfig config) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.coordinator = config.getCoordinatorUrl();
        this.responseHandler = StatusResponseHandler.getInstance();
    }

    private String getCoordinatorURL() {
        return StringUtils.format((String)"%s/druid/coordinator/v1/", (Object[])new Object[]{this.coordinator});
    }

    public void submitCompactionConfig(DataSourceCompactionConfig dataSourceCompactionConfig) throws Exception {
        String url = StringUtils.format((String)"%sconfig/compaction", (Object[])new Object[]{this.getCoordinatorURL()});
        StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.POST, new URL(url)).setContent("application/json", this.jsonMapper.writeValueAsBytes((Object)dataSourceCompactionConfig)), (HttpResponseHandler)this.responseHandler).get();
        if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
            throw new ISE("Error while submiting compaction config status[%s] content[%s]", new Object[]{response.getStatus(), response.getContent()});
        }
    }

    public void deleteCompactionConfig(String dataSource) throws Exception {
        String url = StringUtils.format((String)"%sconfig/compaction/%s", (Object[])new Object[]{this.getCoordinatorURL(), StringUtils.urlEncode((String)dataSource)});
        StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.DELETE, new URL(url)), (HttpResponseHandler)this.responseHandler).get();
        if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
            throw new ISE("Error while deleting compaction config status[%s] content[%s]", new Object[]{response.getStatus(), response.getContent()});
        }
    }

    public CoordinatorCompactionConfig getCoordinatorCompactionConfigs() throws Exception {
        String url = StringUtils.format((String)"%sconfig/compaction", (Object[])new Object[]{this.getCoordinatorURL()});
        StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.GET, new URL(url)), (HttpResponseHandler)this.responseHandler).get();
        if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
            throw new ISE("Error while getting compaction config status[%s] content[%s]", new Object[]{response.getStatus(), response.getContent()});
        }
        return (CoordinatorCompactionConfig)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<CoordinatorCompactionConfig>(){});
    }

    public DataSourceCompactionConfig getDataSourceCompactionConfig(String dataSource) throws Exception {
        String url = StringUtils.format((String)"%sconfig/compaction/%s", (Object[])new Object[]{this.getCoordinatorURL(), StringUtils.urlEncode((String)dataSource)});
        StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.GET, new URL(url)), (HttpResponseHandler)this.responseHandler).get();
        if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
            throw new ISE("Error while getting compaction config status[%s] content[%s]", new Object[]{response.getStatus(), response.getContent()});
        }
        return (DataSourceCompactionConfig)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<DataSourceCompactionConfig>(){});
    }

    public void forceTriggerAutoCompaction() throws Exception {
        String url = StringUtils.format((String)"%scompaction/compact", (Object[])new Object[]{this.getCoordinatorURL()});
        StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.POST, new URL(url)), (HttpResponseHandler)this.responseHandler).get();
        if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
            throw new ISE("Error while force trigger auto compaction status[%s] content[%s]", new Object[]{response.getStatus(), response.getContent()});
        }
    }

    public void updateCompactionTaskSlot(Double compactionTaskSlotRatio, Integer maxCompactionTaskSlots) throws Exception {
        String url = StringUtils.format((String)"%sconfig/compaction/taskslots?ratio=%s&max=%s", (Object[])new Object[]{this.getCoordinatorURL(), StringUtils.urlEncode((String)compactionTaskSlotRatio.toString()), StringUtils.urlEncode((String)maxCompactionTaskSlots.toString())});
        StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.POST, new URL(url)), (HttpResponseHandler)this.responseHandler).get();
        if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
            throw new ISE("Error while updating compaction task slot status[%s] content[%s]", new Object[]{response.getStatus(), response.getContent()});
        }
    }

    public Map<String, String> getCompactionProgress(String dataSource) throws Exception {
        String url = StringUtils.format((String)"%scompaction/progress?dataSource=%s", (Object[])new Object[]{this.getCoordinatorURL(), StringUtils.urlEncode((String)dataSource)});
        StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.GET, new URL(url)), (HttpResponseHandler)this.responseHandler).get();
        if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
            throw new ISE("Error while getting compaction progress status[%s] content[%s]", new Object[]{response.getStatus(), response.getContent()});
        }
        return (Map)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<Map<String, String>>(){});
    }
}

