/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.utils;

import com.google.inject.Injector;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.testing.IntegrationTestingConfig;
import org.apache.druid.testing.guice.DruidTestModuleFactory;
import org.apache.druid.testing.utils.DruidClusterAdminClient;
import org.testng.ISuite;
import org.testng.ISuiteListener;

public class SuiteListener
implements ISuiteListener {
    private static final Logger LOG = new Logger(SuiteListener.class);

    public void onStart(ISuite suite) {
        Injector injector = DruidTestModuleFactory.getInjector();
        IntegrationTestingConfig config = (IntegrationTestingConfig)injector.getInstance(IntegrationTestingConfig.class);
        DruidClusterAdminClient druidClusterAdminClient = (DruidClusterAdminClient)injector.getInstance(DruidClusterAdminClient.class);
        druidClusterAdminClient.waitUntilCoordinatorReady();
        druidClusterAdminClient.waitUntilIndexerReady();
        druidClusterAdminClient.waitUntilBrokerReady();
        String routerHost = config.getRouterUrl();
        if (null != routerHost) {
            druidClusterAdminClient.waitUntilRouterReady();
        }
        Lifecycle lifecycle = (Lifecycle)injector.getInstance(Lifecycle.class);
        try {
            lifecycle.start();
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "", new Object[0]);
            throw new RuntimeException(e);
        }
    }

    public void onFinish(ISuite suite) {
        Injector injector = DruidTestModuleFactory.getInjector();
        Lifecycle lifecycle = (Lifecycle)injector.getInstance(Lifecycle.class);
        lifecycle.stop();
    }
}

