/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.testing.IntegrationTestingConfig;
import org.apache.druid.testing.IntegrationTestingConfigProvider;

public class ConfigFileConfigProvider
implements IntegrationTestingConfigProvider {
    private static final Logger LOG = new Logger(ConfigFileConfigProvider.class);
    private String routerHost;
    private String brokerHost;
    private String historicalHost;
    private String coordinatorHost;
    private String coordinatorTwoHost;
    private String overlordHost;
    private String overlordTwoHost;
    private String routerUrl;
    private String brokerUrl;
    private String historicalUrl;
    private String coordinatorUrl;
    private String coordinatorTwoUrl;
    private String overlordUrl;
    private String overlordTwoUrl;
    private String permissiveRouterUrl;
    private String noClientAuthRouterUrl;
    private String customCertCheckRouterUrl;
    private String routerTLSUrl;
    private String brokerTLSUrl;
    private String historicalTLSUrl;
    private String coordinatorTLSUrl;
    private String coordinatorTwoTLSUrl;
    private String overlordTLSUrl;
    private String overlordTwoTLSUrl;
    private String permissiveRouterTLSUrl;
    private String noClientAuthRouterTLSUrl;
    private String customCertCheckRouterTLSUrl;
    private String middleManagerHost;
    private String zookeeperHosts;
    private String kafkaHost;
    private Map<String, String> props = null;
    private String username;
    private String password;
    private String cloudBucket;
    private String cloudPath;
    private String cloudRegion;
    private String hadoopGcsCredentialsPath;
    private String azureKey;
    private String streamEndpoint;

    @JsonCreator
    ConfigFileConfigProvider(@JsonProperty(value="configFile") String configFile) {
        this.loadProperties(configFile);
    }

    private void loadProperties(String configFile) {
        String customCertCheckRouterHost;
        String noClientAuthRouterHost;
        String permissiveRouterHost;
        ObjectMapper jsonMapper = new ObjectMapper();
        try {
            this.props = (Map)jsonMapper.readValue(new File(configFile), JacksonUtils.TYPE_REFERENCE_MAP_STRING_STRING);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.routerHost = this.props.get("router_host");
        this.routerUrl = this.props.get("router_url");
        if (this.routerUrl == null && null != this.routerHost) {
            this.routerUrl = StringUtils.format((String)"http://%s:%s", (Object[])new Object[]{this.routerHost, this.props.get("router_port")});
        }
        this.routerTLSUrl = this.props.get("router_tls_url");
        if (this.routerTLSUrl == null && null != this.routerHost) {
            this.routerTLSUrl = StringUtils.format((String)"https://%s:%s", (Object[])new Object[]{this.routerHost, this.props.get("router_tls_port")});
        }
        this.permissiveRouterUrl = this.props.get("router_permissive_url");
        if (this.permissiveRouterUrl == null && null != (permissiveRouterHost = this.props.get("router_permissive_host"))) {
            this.permissiveRouterUrl = StringUtils.format((String)"http://%s:%s", (Object[])new Object[]{permissiveRouterHost, this.props.get("router_permissive_port")});
        }
        this.permissiveRouterTLSUrl = this.props.get("router_permissive_tls_url");
        if (this.permissiveRouterTLSUrl == null && null != (permissiveRouterHost = this.props.get("router_permissive_host"))) {
            this.permissiveRouterTLSUrl = StringUtils.format((String)"https://%s:%s", (Object[])new Object[]{permissiveRouterHost, this.props.get("router_permissive_tls_port")});
        }
        this.noClientAuthRouterUrl = this.props.get("router_no_client_auth_url");
        if (this.noClientAuthRouterUrl == null && null != (noClientAuthRouterHost = this.props.get("router_no_client_auth_host"))) {
            this.noClientAuthRouterUrl = StringUtils.format((String)"http://%s:%s", (Object[])new Object[]{noClientAuthRouterHost, this.props.get("router_no_client_auth_port")});
        }
        this.noClientAuthRouterTLSUrl = this.props.get("router_no_client_auth_tls_url");
        if (this.noClientAuthRouterTLSUrl == null && null != (noClientAuthRouterHost = this.props.get("router_no_client_auth_host"))) {
            this.noClientAuthRouterTLSUrl = StringUtils.format((String)"https://%s:%s", (Object[])new Object[]{noClientAuthRouterHost, this.props.get("router_no_client_auth_tls_port")});
        }
        this.customCertCheckRouterUrl = this.props.get("router_no_client_auth_url");
        if (this.customCertCheckRouterUrl == null && null != (customCertCheckRouterHost = this.props.get("router_no_client_auth_host"))) {
            this.customCertCheckRouterUrl = StringUtils.format((String)"http://%s:%s", (Object[])new Object[]{customCertCheckRouterHost, this.props.get("router_no_client_auth_port")});
        }
        this.customCertCheckRouterTLSUrl = this.props.get("router_no_client_auth_tls_url");
        if (this.customCertCheckRouterTLSUrl == null && null != (customCertCheckRouterHost = this.props.get("router_no_client_auth_host"))) {
            this.customCertCheckRouterTLSUrl = StringUtils.format((String)"https://%s:%s", (Object[])new Object[]{customCertCheckRouterHost, this.props.get("router_no_client_auth_tls_port")});
        }
        this.brokerHost = this.props.get("broker_host");
        this.brokerUrl = this.props.get("broker_url");
        if (this.brokerUrl == null) {
            this.brokerUrl = StringUtils.format((String)"http://%s:%s", (Object[])new Object[]{this.props.get("broker_host"), this.props.get("broker_port")});
        }
        this.brokerTLSUrl = this.props.get("broker_tls_url");
        if (this.brokerTLSUrl == null && null != this.brokerHost) {
            this.brokerTLSUrl = StringUtils.format((String)"https://%s:%s", (Object[])new Object[]{this.brokerHost, this.props.get("broker_tls_port")});
        }
        this.historicalHost = this.props.get("historical_host");
        this.historicalUrl = this.props.get("historical_url");
        if (this.historicalUrl == null) {
            this.historicalUrl = StringUtils.format((String)"http://%s:%s", (Object[])new Object[]{this.props.get("historical_host"), this.props.get("historical_port")});
        }
        this.historicalTLSUrl = this.props.get("historical_tls_url");
        if (this.historicalTLSUrl == null && null != this.historicalHost) {
            this.historicalTLSUrl = StringUtils.format((String)"https://%s:%s", (Object[])new Object[]{this.historicalHost, this.props.get("historical_tls_port")});
        }
        this.coordinatorHost = this.props.get("coordinator_host");
        this.coordinatorUrl = this.props.get("coordinator_url");
        if (this.coordinatorUrl == null) {
            this.coordinatorUrl = StringUtils.format((String)"http://%s:%s", (Object[])new Object[]{this.coordinatorHost, this.props.get("coordinator_port")});
        }
        this.coordinatorTLSUrl = this.props.get("coordinator_tls_url");
        if (this.coordinatorTLSUrl == null && null != this.coordinatorHost) {
            this.coordinatorTLSUrl = StringUtils.format((String)"https://%s:%s", (Object[])new Object[]{this.coordinatorHost, this.props.get("coordinator_tls_port")});
        }
        this.overlordHost = this.props.get("indexer_host");
        this.overlordUrl = this.props.get("indexer_url");
        if (this.overlordUrl == null) {
            this.overlordUrl = StringUtils.format((String)"http://%s:%s", (Object[])new Object[]{this.overlordHost, this.props.get("indexer_port")});
        }
        this.overlordTLSUrl = this.props.get("indexer_tls_url");
        if (this.overlordTLSUrl == null && null != this.overlordHost) {
            this.overlordTLSUrl = StringUtils.format((String)"https://%s:%s", (Object[])new Object[]{this.overlordHost, this.props.get("indexer_tls_port")});
        }
        this.coordinatorTwoHost = this.props.get("coordinator_two_host");
        this.coordinatorTwoUrl = this.props.get("coordinator_two_url");
        if (this.coordinatorTwoUrl == null) {
            this.coordinatorTwoUrl = StringUtils.format((String)"http://%s:%s", (Object[])new Object[]{this.coordinatorTwoHost, this.props.get("coordinator_two_port")});
        }
        this.coordinatorTwoTLSUrl = this.props.get("coordinator_two_tls_url");
        if (this.coordinatorTwoTLSUrl == null && null != this.coordinatorTwoHost) {
            this.coordinatorTwoTLSUrl = StringUtils.format((String)"https://%s:%s", (Object[])new Object[]{this.coordinatorTwoHost, this.props.get("coordinator_two_tls_port")});
        }
        this.overlordTwoHost = this.props.get("overlord_two_host");
        this.overlordTwoUrl = this.props.get("overlord_two_url");
        if (this.overlordTwoUrl == null) {
            this.overlordTwoUrl = StringUtils.format((String)"http://%s:%s", (Object[])new Object[]{this.overlordTwoHost, this.props.get("overlord_two_port")});
        }
        this.overlordTwoTLSUrl = this.props.get("overlord_two_tls_url");
        if (this.overlordTwoTLSUrl == null && null != this.overlordTwoHost) {
            this.overlordTwoTLSUrl = StringUtils.format((String)"https://%s:%s", (Object[])new Object[]{this.overlordTwoHost, this.props.get("overlord_two_tls_port")});
        }
        this.middleManagerHost = this.props.get("middlemanager_host");
        this.zookeeperHosts = this.props.get("zookeeper_hosts");
        this.kafkaHost = this.props.get("kafka_host") + ":" + this.props.get("kafka_port");
        this.username = this.props.get("username");
        this.password = this.props.get("password");
        this.cloudBucket = this.props.get("cloud_bucket");
        this.cloudPath = this.props.get("cloud_path");
        this.cloudRegion = this.props.get("cloud_region");
        this.hadoopGcsCredentialsPath = this.props.get("hadoopGcsCredentialsPath");
        this.azureKey = this.props.get("azureKey");
        this.streamEndpoint = this.props.get("stream_endpoint");
        LOG.info("router: [%s], [%s]", new Object[]{this.routerUrl, this.routerTLSUrl});
        LOG.info("broker: [%s], [%s]", new Object[]{this.brokerUrl, this.brokerTLSUrl});
        LOG.info("historical: [%s], [%s]", new Object[]{this.historicalUrl, this.historicalTLSUrl});
        LOG.info("coordinator: [%s], [%s]", new Object[]{this.coordinatorUrl, this.coordinatorTLSUrl});
        LOG.info("overlord: [%s], [%s]", new Object[]{this.overlordUrl, this.overlordTLSUrl});
        LOG.info("middle manager: [%s]", new Object[]{this.middleManagerHost});
        LOG.info("zookeepers: [%s]", new Object[]{this.zookeeperHosts});
        LOG.info("kafka: [%s]", new Object[]{this.kafkaHost});
        LOG.info("Username: [%s]", new Object[]{this.username});
    }

    public IntegrationTestingConfig get() {
        return new IntegrationTestingConfig(){

            @Override
            public String getCoordinatorUrl() {
                return ConfigFileConfigProvider.this.coordinatorUrl;
            }

            @Override
            public String getCoordinatorTLSUrl() {
                return ConfigFileConfigProvider.this.coordinatorTLSUrl;
            }

            @Override
            public String getCoordinatorTwoUrl() {
                return ConfigFileConfigProvider.this.coordinatorTwoUrl;
            }

            @Override
            public String getCoordinatorTwoTLSUrl() {
                return ConfigFileConfigProvider.this.coordinatorTwoTLSUrl;
            }

            @Override
            public String getOverlordUrl() {
                return ConfigFileConfigProvider.this.overlordUrl;
            }

            @Override
            public String getOverlordTLSUrl() {
                return ConfigFileConfigProvider.this.overlordTLSUrl;
            }

            @Override
            public String getOverlordTwoUrl() {
                return ConfigFileConfigProvider.this.overlordTwoUrl;
            }

            @Override
            public String getOverlordTwoTLSUrl() {
                return ConfigFileConfigProvider.this.overlordTwoTLSUrl;
            }

            @Override
            public String getIndexerUrl() {
                return null;
            }

            @Override
            public String getIndexerTLSUrl() {
                return null;
            }

            @Override
            public String getRouterUrl() {
                return ConfigFileConfigProvider.this.routerUrl;
            }

            @Override
            public String getRouterTLSUrl() {
                return ConfigFileConfigProvider.this.routerTLSUrl;
            }

            @Override
            public String getPermissiveRouterUrl() {
                return ConfigFileConfigProvider.this.permissiveRouterUrl;
            }

            @Override
            public String getPermissiveRouterTLSUrl() {
                return ConfigFileConfigProvider.this.permissiveRouterTLSUrl;
            }

            @Override
            public String getNoClientAuthRouterUrl() {
                return ConfigFileConfigProvider.this.noClientAuthRouterUrl;
            }

            @Override
            public String getNoClientAuthRouterTLSUrl() {
                return ConfigFileConfigProvider.this.noClientAuthRouterTLSUrl;
            }

            @Override
            public String getCustomCertCheckRouterUrl() {
                return ConfigFileConfigProvider.this.customCertCheckRouterUrl;
            }

            @Override
            public String getCustomCertCheckRouterTLSUrl() {
                return ConfigFileConfigProvider.this.customCertCheckRouterTLSUrl;
            }

            @Override
            public String getBrokerUrl() {
                return ConfigFileConfigProvider.this.brokerUrl;
            }

            @Override
            public String getBrokerTLSUrl() {
                return ConfigFileConfigProvider.this.brokerTLSUrl;
            }

            @Override
            public String getHistoricalUrl() {
                return ConfigFileConfigProvider.this.historicalUrl;
            }

            @Override
            public String getHistoricalTLSUrl() {
                return ConfigFileConfigProvider.this.historicalTLSUrl;
            }

            @Override
            public String getMiddleManagerHost() {
                return ConfigFileConfigProvider.this.middleManagerHost;
            }

            @Override
            public String getHistoricalHost() {
                return ConfigFileConfigProvider.this.historicalHost;
            }

            @Override
            public String getZookeeperHosts() {
                return ConfigFileConfigProvider.this.zookeeperHosts;
            }

            @Override
            public String getKafkaHost() {
                return ConfigFileConfigProvider.this.kafkaHost;
            }

            @Override
            public String getBrokerHost() {
                return ConfigFileConfigProvider.this.brokerHost;
            }

            @Override
            public String getRouterHost() {
                return ConfigFileConfigProvider.this.routerHost;
            }

            @Override
            public String getCoordinatorHost() {
                return ConfigFileConfigProvider.this.coordinatorHost;
            }

            @Override
            public String getCoordinatorTwoHost() {
                return ConfigFileConfigProvider.this.coordinatorTwoHost;
            }

            @Override
            public String getOverlordHost() {
                return ConfigFileConfigProvider.this.overlordHost;
            }

            @Override
            public String getOverlordTwoHost() {
                return ConfigFileConfigProvider.this.overlordTwoHost;
            }

            @Override
            public String getProperty(String keyword) {
                return (String)ConfigFileConfigProvider.this.props.get(keyword);
            }

            @Override
            public String getUsername() {
                return ConfigFileConfigProvider.this.username;
            }

            @Override
            public String getPassword() {
                return ConfigFileConfigProvider.this.password;
            }

            @Override
            public String getCloudBucket() {
                return ConfigFileConfigProvider.this.cloudBucket;
            }

            @Override
            public String getCloudPath() {
                return ConfigFileConfigProvider.this.cloudPath;
            }

            @Override
            public String getCloudRegion() {
                return ConfigFileConfigProvider.this.cloudRegion;
            }

            @Override
            public String getAzureKey() {
                return ConfigFileConfigProvider.this.azureKey;
            }

            @Override
            public String getHadoopGcsCredentialsPath() {
                return ConfigFileConfigProvider.this.hadoopGcsCredentialsPath;
            }

            @Override
            public String getStreamEndpoint() {
                return ConfigFileConfigProvider.this.streamEndpoint;
            }

            @Override
            public Map<String, String> getProperties() {
                return ConfigFileConfigProvider.this.props;
            }

            @Override
            public boolean manageKafkaTopic() {
                return Boolean.valueOf(ConfigFileConfigProvider.this.props.getOrDefault("manageKafkaTopic", "true"));
            }

            @Override
            public String getExtraDatasourceNameSuffix() {
                return "";
            }

            @Override
            public boolean isDocker() {
                return false;
            }
        };
    }
}

