/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.utils;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.AmazonKinesisClientBuilder;
import com.amazonaws.services.kinesis.model.AddTagsToStreamRequest;
import com.amazonaws.services.kinesis.model.AddTagsToStreamResult;
import com.amazonaws.services.kinesis.model.CreateStreamResult;
import com.amazonaws.services.kinesis.model.DeleteStreamResult;
import com.amazonaws.services.kinesis.model.DescribeStreamResult;
import com.amazonaws.services.kinesis.model.ScalingType;
import com.amazonaws.services.kinesis.model.StreamDescription;
import com.amazonaws.services.kinesis.model.StreamStatus;
import com.amazonaws.services.kinesis.model.UpdateShardCountRequest;
import com.amazonaws.services.kinesis.model.UpdateShardCountResult;
import com.amazonaws.util.AwsHostNameUtils;
import java.io.FileInputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.testing.utils.ITRetryUtil;
import org.apache.druid.testing.utils.StreamAdminClient;

public class KinesisAdminClient
implements StreamAdminClient {
    private AmazonKinesis amazonKinesis;

    public KinesisAdminClient(String endpoint) throws Exception {
        String pathToConfigFile = System.getProperty("override.config.path");
        Properties prop = new Properties();
        prop.load(new FileInputStream(pathToConfigFile));
        AWSStaticCredentialsProvider credentials = new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(prop.getProperty("druid_kinesis_accessKey"), prop.getProperty("druid_kinesis_secretKey")));
        this.amazonKinesis = (AmazonKinesis)((AmazonKinesisClientBuilder)((AmazonKinesisClientBuilder)((AmazonKinesisClientBuilder)AmazonKinesisClientBuilder.standard().withCredentials((AWSCredentialsProvider)credentials)).withClientConfiguration(new ClientConfiguration())).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(endpoint, AwsHostNameUtils.parseRegion((String)endpoint, null)))).build();
    }

    @Override
    public void createStream(String streamName, int shardCount, Map<String, String> tags) {
        CreateStreamResult createStreamResult = this.amazonKinesis.createStream(streamName, Integer.valueOf(shardCount));
        if (createStreamResult.getSdkHttpMetadata().getHttpStatusCode() != 200) {
            throw new ISE("Cannot create stream for integration test", new Object[0]);
        }
        if (tags != null && !tags.isEmpty()) {
            AddTagsToStreamRequest addTagsToStreamRequest = new AddTagsToStreamRequest();
            addTagsToStreamRequest.setStreamName(streamName);
            addTagsToStreamRequest.setTags(tags);
            AddTagsToStreamResult addTagsToStreamResult = this.amazonKinesis.addTagsToStream(addTagsToStreamRequest);
            if (addTagsToStreamResult.getSdkHttpMetadata().getHttpStatusCode() != 200) {
                throw new ISE("Cannot tag stream for integration test", new Object[0]);
            }
        }
    }

    @Override
    public void deleteStream(String streamName) {
        DeleteStreamResult deleteStreamResult = this.amazonKinesis.deleteStream(streamName);
        if (deleteStreamResult.getSdkHttpMetadata().getHttpStatusCode() != 200) {
            throw new ISE("Cannot delete stream for integration test", new Object[0]);
        }
    }

    @Override
    public void updatePartitionCount(String streamName, int newShardCount, boolean blocksUntilStarted) {
        int originalShardCount = this.getStreamPartitionCount(streamName);
        UpdateShardCountRequest updateShardCountRequest = new UpdateShardCountRequest();
        updateShardCountRequest.setStreamName(streamName);
        updateShardCountRequest.setTargetShardCount(Integer.valueOf(newShardCount));
        updateShardCountRequest.setScalingType(ScalingType.UNIFORM_SCALING);
        UpdateShardCountResult updateShardCountResult = this.amazonKinesis.updateShardCount(updateShardCountRequest);
        if (updateShardCountResult.getSdkHttpMetadata().getHttpStatusCode() != 200) {
            throw new ISE("Cannot update stream's shard count for integration test", new Object[0]);
        }
        if (blocksUntilStarted) {
            ITRetryUtil.retryUntil(() -> {
                StreamDescription streamDescription = this.getStreamDescription(streamName);
                int updatedShardCount = this.getStreamShardCount(streamDescription);
                return this.verifyStreamStatus(streamDescription, StreamStatus.UPDATING) || this.verifyStreamStatus(streamDescription, StreamStatus.ACTIVE) && updatedShardCount > originalShardCount;
            }, true, 30L, 30, "Kinesis stream resharding to start (or finished)");
        }
    }

    @Override
    public boolean isStreamActive(String streamName) {
        StreamDescription streamDescription = this.getStreamDescription(streamName);
        return this.verifyStreamStatus(streamDescription, StreamStatus.ACTIVE);
    }

    @Override
    public int getStreamPartitionCount(String streamName) {
        StreamDescription streamDescription = this.getStreamDescription(streamName);
        return this.getStreamShardCount(streamDescription);
    }

    @Override
    public boolean verfiyPartitionCountUpdated(String streamName, int oldShardCount, int newShardCount) {
        int actualShardCount = this.getStreamPartitionCount(streamName);
        return actualShardCount == oldShardCount + newShardCount;
    }

    private boolean verifyStreamStatus(StreamDescription streamDescription, StreamStatus streamStatusToCheck) {
        return streamStatusToCheck.toString().equals(streamDescription.getStreamStatus());
    }

    private int getStreamShardCount(StreamDescription streamDescription) {
        return streamDescription.getShards().size();
    }

    private StreamDescription getStreamDescription(String streamName) {
        DescribeStreamResult describeStreamResult = this.amazonKinesis.describeStream(streamName);
        if (describeStreamResult.getSdkHttpMetadata().getHttpStatusCode() != 200) {
            throw new ISE("Cannot get stream description for integration test", new Object[0]);
        }
        return describeStreamResult.getStreamDescription();
    }
}

