/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.tests.coordinator.duty;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.druid.data.input.MaxSizeSplitHintSpec;
import org.apache.druid.data.input.SplitHintSpec;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.indexer.partitions.HashedPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexer.partitions.SingleDimensionPartitionsSpec;
import org.apache.druid.indexing.common.task.CompactionIntervalSpec;
import org.apache.druid.indexing.common.task.CompactionTask;
import org.apache.druid.indexing.overlord.http.TaskPayloadResponse;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.druid.query.aggregation.FloatSumAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchBuildAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.theta.SketchMergeAggregatorFactory;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.segment.indexing.granularity.UniformGranularitySpec;
import org.apache.druid.server.coordinator.AutoCompactionSnapshot;
import org.apache.druid.server.coordinator.CoordinatorCompactionConfig;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskDimensionsConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskGranularityConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskIOConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskQueryTuningConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskTransformConfig;
import org.apache.druid.testing.IntegrationTestingConfig;
import org.apache.druid.testing.clients.CompactionResourceTestClient;
import org.apache.druid.testing.clients.TaskResponseObject;
import org.apache.druid.testing.guice.DruidTestModuleFactory;
import org.apache.druid.testing.utils.ITRetryUtil;
import org.apache.druid.tests.indexer.AbstractITBatchIndexTest;
import org.apache.druid.tests.indexer.AbstractIndexerTest;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Chronology;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.chrono.ISOChronology;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Test(groups={"compaction"})
@Guice(moduleFactory=DruidTestModuleFactory.class)
public class ITAutoCompactionTest
extends AbstractIndexerTest {
    private static final Logger LOG = new Logger(ITAutoCompactionTest.class);
    private static final String INDEX_TASK = "/indexer/wikipedia_index_task.json";
    private static final String INDEX_TASK_WITH_GRANULARITY_SPEC = "/indexer/wikipedia_index_task_with_granularity_spec.json";
    private static final String INDEX_TASK_WITH_DIMENSION_SPEC = "/indexer/wikipedia_index_task_with_dimension_spec.json";
    private static final String INDEX_ROLLUP_QUERIES_RESOURCE = "/indexer/wikipedia_index_rollup_queries.json";
    private static final String INDEX_ROLLUP_SKETCH_QUERIES_RESOURCE = "/indexer/wikipedia_index_sketch_queries.json";
    private static final String INDEX_QUERIES_RESOURCE = "/indexer/wikipedia_index_queries.json";
    private static final String INDEX_TASK_WITH_ROLLUP_FOR_PRESERVE_METRICS = "/indexer/wikipedia_index_rollup_preserve_metric.json";
    private static final String INDEX_TASK_WITHOUT_ROLLUP_FOR_PRESERVE_METRICS = "/indexer/wikipedia_index_no_rollup_preserve_metric.json";
    private static final int MAX_ROWS_PER_SEGMENT_COMPACTED = 10000;
    private static final Period NO_SKIP_OFFSET = Period.seconds((int)0);
    @Inject
    protected CompactionResourceTestClient compactionResource;
    @Inject
    private IntegrationTestingConfig config;
    private String fullDatasourceName;

    @BeforeMethod
    public void setup() throws Exception {
        this.updateCompactionTaskSlot(0.5, 10, null);
        this.fullDatasourceName = "wikipedia_index_test_" + UUID.randomUUID() + this.config.getExtraDatasourceNameSuffix();
    }

    @Test
    public void testAutoCompactionRowWithMetricAndRowWithoutMetricShouldPreserveExistingMetricsUsingAggregatorWithDifferentReturnType() throws Exception {
        this.loadData(INDEX_TASK_WITH_ROLLUP_FOR_PRESERVE_METRICS);
        this.loadData(INDEX_TASK_WITHOUT_ROLLUP_FOR_PRESERVE_METRICS);
        try (Closeable ignored = this.unloader(this.fullDatasourceName);){
            List intervalsBeforeCompaction = this.coordinator.getSegmentIntervals(this.fullDatasourceName);
            intervalsBeforeCompaction.sort(null);
            this.verifySegmentsCount(2);
            ArrayList<Object> nullList = new ArrayList<Object>();
            nullList.add(null);
            ImmutableMap queryAndResultFields = ImmutableMap.of((Object)"%%FIELD_TO_QUERY%%", (Object)"added", (Object)"%%EXPECTED_COUNT_RESULT%%", (Object)2, (Object)"%%EXPECTED_SCAN_RESULT%%", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"events", (Object)ImmutableList.of(nullList)), (Object)ImmutableMap.of((Object)"events", (Object)ImmutableList.of((Object)ImmutableList.of((Object)31)))));
            this.verifyQuery(INDEX_ROLLUP_QUERIES_RESOURCE, (Map<String, Object>)queryAndResultFields);
            queryAndResultFields = ImmutableMap.of((Object)"%%FIELD_TO_QUERY%%", (Object)"count", (Object)"%%EXPECTED_COUNT_RESULT%%", (Object)2, (Object)"%%EXPECTED_SCAN_RESULT%%", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"events", (Object)ImmutableList.of((Object)ImmutableList.of((Object)2))), (Object)ImmutableMap.of((Object)"events", (Object)ImmutableList.of(nullList))));
            this.verifyQuery(INDEX_ROLLUP_QUERIES_RESOURCE, (Map<String, Object>)queryAndResultFields);
            queryAndResultFields = ImmutableMap.of((Object)"%%FIELD_TO_QUERY%%", (Object)"sum_added", (Object)"%%EXPECTED_COUNT_RESULT%%", (Object)2, (Object)"%%EXPECTED_SCAN_RESULT%%", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"events", (Object)ImmutableList.of((Object)ImmutableList.of((Object)62))), (Object)ImmutableMap.of((Object)"events", (Object)ImmutableList.of(nullList))));
            this.verifyQuery(INDEX_ROLLUP_QUERIES_RESOURCE, (Map<String, Object>)queryAndResultFields);
            queryAndResultFields = ImmutableMap.of((Object)"%%QUANTILESRESULT%%", (Object)2, (Object)"%%THETARESULT%%", (Object)2.0, (Object)"%%HLLRESULT%%", (Object)2);
            this.verifyQuery(INDEX_ROLLUP_SKETCH_QUERIES_RESOURCE, (Map<String, Object>)queryAndResultFields);
            this.submitCompactionConfig(10000, NO_SKIP_OFFSET, new UserCompactionTaskGranularityConfig(null, null, Boolean.valueOf(true)), new UserCompactionTaskDimensionsConfig(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"language"))), null, new AggregatorFactory[]{new CountAggregatorFactory("count"), new FloatSumAggregatorFactory("sum_added", "added"), new SketchMergeAggregatorFactory("thetaSketch", "user", Integer.valueOf(16384), Boolean.valueOf(true), Boolean.valueOf(false), null), new HllSketchBuildAggregatorFactory("HLLSketchBuild", "user", Integer.valueOf(12), TgtHllType.HLL_4.name(), false), new DoublesSketchAggregatorFactory("quantilesDoublesSketch", "delta", Integer.valueOf(128), Long.valueOf(1000000000L))}, false);
            this.forceTriggerAutoCompaction(1);
            queryAndResultFields = ImmutableMap.of((Object)"%%FIELD_TO_QUERY%%", (Object)"added", (Object)"%%EXPECTED_COUNT_RESULT%%", (Object)1, (Object)"%%EXPECTED_SCAN_RESULT%%", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"events", (Object)ImmutableList.of(nullList))));
            this.verifyQuery(INDEX_ROLLUP_QUERIES_RESOURCE, (Map<String, Object>)queryAndResultFields);
            queryAndResultFields = ImmutableMap.of((Object)"%%FIELD_TO_QUERY%%", (Object)"count", (Object)"%%EXPECTED_COUNT_RESULT%%", (Object)1, (Object)"%%EXPECTED_SCAN_RESULT%%", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"events", (Object)ImmutableList.of((Object)ImmutableList.of((Object)3)))));
            this.verifyQuery(INDEX_ROLLUP_QUERIES_RESOURCE, (Map<String, Object>)queryAndResultFields);
            queryAndResultFields = ImmutableMap.of((Object)"%%FIELD_TO_QUERY%%", (Object)"sum_added", (Object)"%%EXPECTED_COUNT_RESULT%%", (Object)1, (Object)"%%EXPECTED_SCAN_RESULT%%", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"events", (Object)ImmutableList.of((Object)ImmutableList.of((Object)Float.valueOf(93.0f))))));
            this.verifyQuery(INDEX_ROLLUP_QUERIES_RESOURCE, (Map<String, Object>)queryAndResultFields);
            queryAndResultFields = ImmutableMap.of((Object)"%%QUANTILESRESULT%%", (Object)3, (Object)"%%THETARESULT%%", (Object)3.0, (Object)"%%HLLRESULT%%", (Object)3);
            this.verifyQuery(INDEX_ROLLUP_SKETCH_QUERIES_RESOURCE, (Map<String, Object>)queryAndResultFields);
            this.verifySegmentsCompacted(1, (Integer)10000);
            this.checkCompactionIntervals(intervalsBeforeCompaction);
            List compactTasksBefore = this.indexer.getCompleteTasksForDataSource(this.fullDatasourceName);
            this.forceTriggerAutoCompaction(1);
            List compactTasksAfter = this.indexer.getCompleteTasksForDataSource(this.fullDatasourceName);
            Assert.assertEquals((int)compactTasksAfter.size(), (int)compactTasksBefore.size());
        }
    }

    @Test
    public void testAutoCompactionRowWithMetricAndRowWithoutMetricShouldPreserveExistingMetrics() throws Exception {
        this.loadData(INDEX_TASK_WITH_ROLLUP_FOR_PRESERVE_METRICS);
        this.loadData(INDEX_TASK_WITHOUT_ROLLUP_FOR_PRESERVE_METRICS);
        try (Closeable ignored = this.unloader(this.fullDatasourceName);){
            List intervalsBeforeCompaction = this.coordinator.getSegmentIntervals(this.fullDatasourceName);
            intervalsBeforeCompaction.sort(null);
            this.verifySegmentsCount(2);
            ArrayList<Object> nullList = new ArrayList<Object>();
            nullList.add(null);
            ImmutableMap queryAndResultFields = ImmutableMap.of((Object)"%%FIELD_TO_QUERY%%", (Object)"added", (Object)"%%EXPECTED_COUNT_RESULT%%", (Object)2, (Object)"%%EXPECTED_SCAN_RESULT%%", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"events", (Object)ImmutableList.of(nullList)), (Object)ImmutableMap.of((Object)"events", (Object)ImmutableList.of((Object)ImmutableList.of((Object)31)))));
            this.verifyQuery(INDEX_ROLLUP_QUERIES_RESOURCE, (Map<String, Object>)queryAndResultFields);
            queryAndResultFields = ImmutableMap.of((Object)"%%FIELD_TO_QUERY%%", (Object)"count", (Object)"%%EXPECTED_COUNT_RESULT%%", (Object)2, (Object)"%%EXPECTED_SCAN_RESULT%%", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"events", (Object)ImmutableList.of((Object)ImmutableList.of((Object)2))), (Object)ImmutableMap.of((Object)"events", (Object)ImmutableList.of(nullList))));
            this.verifyQuery(INDEX_ROLLUP_QUERIES_RESOURCE, (Map<String, Object>)queryAndResultFields);
            queryAndResultFields = ImmutableMap.of((Object)"%%FIELD_TO_QUERY%%", (Object)"sum_added", (Object)"%%EXPECTED_COUNT_RESULT%%", (Object)2, (Object)"%%EXPECTED_SCAN_RESULT%%", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"events", (Object)ImmutableList.of((Object)ImmutableList.of((Object)62))), (Object)ImmutableMap.of((Object)"events", (Object)ImmutableList.of(nullList))));
            this.verifyQuery(INDEX_ROLLUP_QUERIES_RESOURCE, (Map<String, Object>)queryAndResultFields);
            queryAndResultFields = ImmutableMap.of((Object)"%%QUANTILESRESULT%%", (Object)2, (Object)"%%THETARESULT%%", (Object)2.0, (Object)"%%HLLRESULT%%", (Object)2);
            this.verifyQuery(INDEX_ROLLUP_SKETCH_QUERIES_RESOURCE, (Map<String, Object>)queryAndResultFields);
            this.submitCompactionConfig(10000, NO_SKIP_OFFSET, new UserCompactionTaskGranularityConfig(null, null, Boolean.valueOf(true)), new UserCompactionTaskDimensionsConfig(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"language"))), null, new AggregatorFactory[]{new CountAggregatorFactory("count"), new LongSumAggregatorFactory("sum_added", "added"), new SketchMergeAggregatorFactory("thetaSketch", "user", Integer.valueOf(16384), Boolean.valueOf(true), Boolean.valueOf(false), null), new HllSketchBuildAggregatorFactory("HLLSketchBuild", "user", Integer.valueOf(12), TgtHllType.HLL_4.name(), false), new DoublesSketchAggregatorFactory("quantilesDoublesSketch", "delta", Integer.valueOf(128), Long.valueOf(1000000000L))}, false);
            this.forceTriggerAutoCompaction(1);
            queryAndResultFields = ImmutableMap.of((Object)"%%FIELD_TO_QUERY%%", (Object)"added", (Object)"%%EXPECTED_COUNT_RESULT%%", (Object)1, (Object)"%%EXPECTED_SCAN_RESULT%%", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"events", (Object)ImmutableList.of(nullList))));
            this.verifyQuery(INDEX_ROLLUP_QUERIES_RESOURCE, (Map<String, Object>)queryAndResultFields);
            queryAndResultFields = ImmutableMap.of((Object)"%%FIELD_TO_QUERY%%", (Object)"count", (Object)"%%EXPECTED_COUNT_RESULT%%", (Object)1, (Object)"%%EXPECTED_SCAN_RESULT%%", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"events", (Object)ImmutableList.of((Object)ImmutableList.of((Object)3)))));
            this.verifyQuery(INDEX_ROLLUP_QUERIES_RESOURCE, (Map<String, Object>)queryAndResultFields);
            queryAndResultFields = ImmutableMap.of((Object)"%%FIELD_TO_QUERY%%", (Object)"sum_added", (Object)"%%EXPECTED_COUNT_RESULT%%", (Object)1, (Object)"%%EXPECTED_SCAN_RESULT%%", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"events", (Object)ImmutableList.of((Object)ImmutableList.of((Object)93)))));
            this.verifyQuery(INDEX_ROLLUP_QUERIES_RESOURCE, (Map<String, Object>)queryAndResultFields);
            queryAndResultFields = ImmutableMap.of((Object)"%%QUANTILESRESULT%%", (Object)3, (Object)"%%THETARESULT%%", (Object)3.0, (Object)"%%HLLRESULT%%", (Object)3);
            this.verifyQuery(INDEX_ROLLUP_SKETCH_QUERIES_RESOURCE, (Map<String, Object>)queryAndResultFields);
            this.verifySegmentsCompacted(1, (Integer)10000);
            this.checkCompactionIntervals(intervalsBeforeCompaction);
            List compactTasksBefore = this.indexer.getCompleteTasksForDataSource(this.fullDatasourceName);
            this.forceTriggerAutoCompaction(1);
            List compactTasksAfter = this.indexer.getCompleteTasksForDataSource(this.fullDatasourceName);
            Assert.assertEquals((int)compactTasksAfter.size(), (int)compactTasksBefore.size());
        }
    }

    @Test
    public void testAutoCompactionOnlyRowsWithoutMetricShouldAddNewMetrics() throws Exception {
        this.loadData(INDEX_TASK_WITHOUT_ROLLUP_FOR_PRESERVE_METRICS);
        this.loadData(INDEX_TASK_WITHOUT_ROLLUP_FOR_PRESERVE_METRICS);
        try (Closeable ignored = this.unloader(this.fullDatasourceName);){
            List intervalsBeforeCompaction = this.coordinator.getSegmentIntervals(this.fullDatasourceName);
            intervalsBeforeCompaction.sort(null);
            this.verifySegmentsCount(2);
            ArrayList<Object> nullList = new ArrayList<Object>();
            nullList.add(null);
            ImmutableMap queryAndResultFields = ImmutableMap.of((Object)"%%FIELD_TO_QUERY%%", (Object)"added", (Object)"%%EXPECTED_COUNT_RESULT%%", (Object)2, (Object)"%%EXPECTED_SCAN_RESULT%%", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"events", (Object)ImmutableList.of((Object)ImmutableList.of((Object)31))), (Object)ImmutableMap.of((Object)"events", (Object)ImmutableList.of((Object)ImmutableList.of((Object)31)))));
            this.verifyQuery(INDEX_ROLLUP_QUERIES_RESOURCE, (Map<String, Object>)queryAndResultFields);
            this.submitCompactionConfig(10000, NO_SKIP_OFFSET, new UserCompactionTaskGranularityConfig(null, null, Boolean.valueOf(true)), new UserCompactionTaskDimensionsConfig(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"language"))), null, new AggregatorFactory[]{new CountAggregatorFactory("count"), new LongSumAggregatorFactory("sum_added", "added")}, false);
            this.forceTriggerAutoCompaction(1);
            queryAndResultFields = ImmutableMap.of((Object)"%%FIELD_TO_QUERY%%", (Object)"added", (Object)"%%EXPECTED_COUNT_RESULT%%", (Object)1, (Object)"%%EXPECTED_SCAN_RESULT%%", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"events", (Object)ImmutableList.of(nullList))));
            this.verifyQuery(INDEX_ROLLUP_QUERIES_RESOURCE, (Map<String, Object>)queryAndResultFields);
            queryAndResultFields = ImmutableMap.of((Object)"%%FIELD_TO_QUERY%%", (Object)"count", (Object)"%%EXPECTED_COUNT_RESULT%%", (Object)1, (Object)"%%EXPECTED_SCAN_RESULT%%", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"events", (Object)ImmutableList.of((Object)ImmutableList.of((Object)2)))));
            this.verifyQuery(INDEX_ROLLUP_QUERIES_RESOURCE, (Map<String, Object>)queryAndResultFields);
            queryAndResultFields = ImmutableMap.of((Object)"%%FIELD_TO_QUERY%%", (Object)"sum_added", (Object)"%%EXPECTED_COUNT_RESULT%%", (Object)1, (Object)"%%EXPECTED_SCAN_RESULT%%", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"events", (Object)ImmutableList.of((Object)ImmutableList.of((Object)62)))));
            this.verifyQuery(INDEX_ROLLUP_QUERIES_RESOURCE, (Map<String, Object>)queryAndResultFields);
            this.verifySegmentsCompacted(1, (Integer)10000);
            this.checkCompactionIntervals(intervalsBeforeCompaction);
            List compactTasksBefore = this.indexer.getCompleteTasksForDataSource(this.fullDatasourceName);
            this.forceTriggerAutoCompaction(1);
            List compactTasksAfter = this.indexer.getCompleteTasksForDataSource(this.fullDatasourceName);
            Assert.assertEquals((int)compactTasksAfter.size(), (int)compactTasksBefore.size());
        }
    }

    @Test
    public void testAutoCompactionOnlyRowsWithMetricShouldPreserveExistingMetrics() throws Exception {
        this.loadData(INDEX_TASK_WITH_ROLLUP_FOR_PRESERVE_METRICS);
        this.loadData(INDEX_TASK_WITH_ROLLUP_FOR_PRESERVE_METRICS);
        try (Closeable ignored = this.unloader(this.fullDatasourceName);){
            List intervalsBeforeCompaction = this.coordinator.getSegmentIntervals(this.fullDatasourceName);
            intervalsBeforeCompaction.sort(null);
            this.verifySegmentsCount(2);
            ImmutableMap queryAndResultFields = ImmutableMap.of((Object)"%%FIELD_TO_QUERY%%", (Object)"count", (Object)"%%EXPECTED_COUNT_RESULT%%", (Object)2, (Object)"%%EXPECTED_SCAN_RESULT%%", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"events", (Object)ImmutableList.of((Object)ImmutableList.of((Object)2))), (Object)ImmutableMap.of((Object)"events", (Object)ImmutableList.of((Object)ImmutableList.of((Object)2)))));
            this.verifyQuery(INDEX_ROLLUP_QUERIES_RESOURCE, (Map<String, Object>)queryAndResultFields);
            queryAndResultFields = ImmutableMap.of((Object)"%%FIELD_TO_QUERY%%", (Object)"sum_added", (Object)"%%EXPECTED_COUNT_RESULT%%", (Object)2, (Object)"%%EXPECTED_SCAN_RESULT%%", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"events", (Object)ImmutableList.of((Object)ImmutableList.of((Object)62))), (Object)ImmutableMap.of((Object)"events", (Object)ImmutableList.of((Object)ImmutableList.of((Object)62)))));
            this.verifyQuery(INDEX_ROLLUP_QUERIES_RESOURCE, (Map<String, Object>)queryAndResultFields);
            this.submitCompactionConfig(10000, NO_SKIP_OFFSET, new UserCompactionTaskGranularityConfig(null, null, Boolean.valueOf(true)), new UserCompactionTaskDimensionsConfig(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"language"))), null, new AggregatorFactory[]{new CountAggregatorFactory("count"), new LongSumAggregatorFactory("sum_added", "added")}, false);
            this.forceTriggerAutoCompaction(1);
            queryAndResultFields = ImmutableMap.of((Object)"%%FIELD_TO_QUERY%%", (Object)"count", (Object)"%%EXPECTED_COUNT_RESULT%%", (Object)1, (Object)"%%EXPECTED_SCAN_RESULT%%", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"events", (Object)ImmutableList.of((Object)ImmutableList.of((Object)4)))));
            this.verifyQuery(INDEX_ROLLUP_QUERIES_RESOURCE, (Map<String, Object>)queryAndResultFields);
            queryAndResultFields = ImmutableMap.of((Object)"%%FIELD_TO_QUERY%%", (Object)"sum_added", (Object)"%%EXPECTED_COUNT_RESULT%%", (Object)1, (Object)"%%EXPECTED_SCAN_RESULT%%", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"events", (Object)ImmutableList.of((Object)ImmutableList.of((Object)124)))));
            this.verifyQuery(INDEX_ROLLUP_QUERIES_RESOURCE, (Map<String, Object>)queryAndResultFields);
            this.verifySegmentsCompacted(1, (Integer)10000);
            this.checkCompactionIntervals(intervalsBeforeCompaction);
            List compactTasksBefore = this.indexer.getCompleteTasksForDataSource(this.fullDatasourceName);
            this.forceTriggerAutoCompaction(1);
            List compactTasksAfter = this.indexer.getCompleteTasksForDataSource(this.fullDatasourceName);
            Assert.assertEquals((int)compactTasksAfter.size(), (int)compactTasksBefore.size());
        }
    }

    @Test
    public void testAutoCompactionDutySubmitAndVerifyCompaction() throws Exception {
        this.loadData(INDEX_TASK);
        try (Closeable ignored = this.unloader(this.fullDatasourceName);){
            List intervalsBeforeCompaction = this.coordinator.getSegmentIntervals(this.fullDatasourceName);
            intervalsBeforeCompaction.sort(null);
            this.verifySegmentsCount(4);
            this.verifyQuery(INDEX_QUERIES_RESOURCE);
            this.submitCompactionConfig(10000, Period.days((int)1));
            this.forceTriggerAutoCompaction(3);
            this.verifyQuery(INDEX_QUERIES_RESOURCE);
            this.verifySegmentsCompacted(1, (Integer)10000);
            this.checkCompactionIntervals(intervalsBeforeCompaction);
            this.getAndAssertCompactionStatus(this.fullDatasourceName, AutoCompactionSnapshot.AutoCompactionScheduleStatus.RUNNING, 0L, 14762L, 14761L, 0L, 2L, 2L, 0L, 1L, 1L);
            this.submitCompactionConfig(10000, NO_SKIP_OFFSET);
            this.forceTriggerAutoCompaction(2);
            this.verifyQuery(INDEX_QUERIES_RESOURCE);
            this.verifySegmentsCompacted(2, (Integer)10000);
            this.checkCompactionIntervals(intervalsBeforeCompaction);
            this.getAndAssertCompactionStatus(this.fullDatasourceName, AutoCompactionSnapshot.AutoCompactionScheduleStatus.RUNNING, 0L, 23156L, 0L, 0L, 3L, 0L, 0L, 2L, 0L);
        }
    }

    @Test
    public void testAutoCompactionDutyCanUpdateCompactionConfig() throws Exception {
        this.loadData(INDEX_TASK);
        try (Closeable ignored = this.unloader(this.fullDatasourceName);){
            List intervalsBeforeCompaction = this.coordinator.getSegmentIntervals(this.fullDatasourceName);
            intervalsBeforeCompaction.sort(null);
            this.verifySegmentsCount(4);
            this.verifyQuery(INDEX_QUERIES_RESOURCE);
            this.submitCompactionConfig(10000, NO_SKIP_OFFSET);
            this.submitCompactionConfig(1, NO_SKIP_OFFSET);
            LOG.info("Auto compaction test with dynamic partitioning", new Object[0]);
            this.forceTriggerAutoCompaction(10);
            this.verifyQuery(INDEX_QUERIES_RESOURCE);
            this.verifySegmentsCompacted(10, (Integer)1);
            this.checkCompactionIntervals(intervalsBeforeCompaction);
            LOG.info("Auto compaction test with hash partitioning", new Object[0]);
            HashedPartitionsSpec hashedPartitionsSpec = new HashedPartitionsSpec(null, Integer.valueOf(3), null);
            this.submitCompactionConfig((PartitionsSpec)hashedPartitionsSpec, NO_SKIP_OFFSET, 1, null, null, null, null, false);
            this.forceTriggerAutoCompaction(4);
            this.verifyQuery(INDEX_QUERIES_RESOURCE);
            this.verifySegmentsCompacted((PartitionsSpec)hashedPartitionsSpec, 4);
            this.checkCompactionIntervals(intervalsBeforeCompaction);
            LOG.info("Auto compaction test with range partitioning", new Object[0]);
            SingleDimensionPartitionsSpec rangePartitionsSpec = new SingleDimensionPartitionsSpec(Integer.valueOf(5), null, "city", false);
            this.submitCompactionConfig((PartitionsSpec)rangePartitionsSpec, NO_SKIP_OFFSET, 1, null, null, null, null, false);
            this.forceTriggerAutoCompaction(2);
            this.verifyQuery(INDEX_QUERIES_RESOURCE);
            this.verifySegmentsCompacted((PartitionsSpec)rangePartitionsSpec, 2);
            this.checkCompactionIntervals(intervalsBeforeCompaction);
        }
    }

    @Test
    public void testAutoCompactionDutyCanDeleteCompactionConfig() throws Exception {
        this.loadData(INDEX_TASK);
        try (Closeable ignored = this.unloader(this.fullDatasourceName);){
            List intervalsBeforeCompaction = this.coordinator.getSegmentIntervals(this.fullDatasourceName);
            intervalsBeforeCompaction.sort(null);
            this.verifySegmentsCount(4);
            this.verifyQuery(INDEX_QUERIES_RESOURCE);
            this.submitCompactionConfig(10000, NO_SKIP_OFFSET);
            this.deleteCompactionConfig();
            this.forceTriggerAutoCompaction(4);
            this.verifyQuery(INDEX_QUERIES_RESOURCE);
            this.verifySegmentsCompacted(0, null);
            Assert.assertNull((Object)this.compactionResource.getCompactionStatus(this.fullDatasourceName));
            this.checkCompactionIntervals(intervalsBeforeCompaction);
        }
    }

    @Test
    public void testAutoCompactionDutyCanUpdateTaskSlots() throws Exception {
        this.updateCompactionTaskSlot(0.0, 0, null);
        this.loadData(INDEX_TASK);
        try (Closeable ignored = this.unloader(this.fullDatasourceName);){
            List intervalsBeforeCompaction = this.coordinator.getSegmentIntervals(this.fullDatasourceName);
            intervalsBeforeCompaction.sort(null);
            this.verifySegmentsCount(4);
            this.verifyQuery(INDEX_QUERIES_RESOURCE);
            this.submitCompactionConfig(10000, NO_SKIP_OFFSET);
            this.forceTriggerAutoCompaction(4);
            this.verifyQuery(INDEX_QUERIES_RESOURCE);
            this.verifySegmentsCompacted(0, null);
            this.checkCompactionIntervals(intervalsBeforeCompaction);
            Assert.assertNull((Object)this.compactionResource.getCompactionStatus(this.fullDatasourceName));
            this.updateCompactionTaskSlot(1.0, 1, null);
            this.forceTriggerAutoCompaction(3);
            this.verifyQuery(INDEX_QUERIES_RESOURCE);
            this.verifySegmentsCompacted(1, (Integer)10000);
            this.checkCompactionIntervals(intervalsBeforeCompaction);
            this.getAndAssertCompactionStatus(this.fullDatasourceName, AutoCompactionSnapshot.AutoCompactionScheduleStatus.RUNNING, 14762L, 14761L, 0L, 2L, 2L, 0L, 1L, 1L, 0L);
            Assert.assertEquals((String)((String)this.compactionResource.getCompactionProgress(this.fullDatasourceName).get("remainingSegmentSize")), (String)"14762");
            this.forceTriggerAutoCompaction(2);
            this.verifyQuery(INDEX_QUERIES_RESOURCE);
            this.verifySegmentsCompacted(2, (Integer)10000);
            this.checkCompactionIntervals(intervalsBeforeCompaction);
            this.getAndAssertCompactionStatus(this.fullDatasourceName, AutoCompactionSnapshot.AutoCompactionScheduleStatus.RUNNING, 0L, 23156L, 0L, 0L, 3L, 0L, 0L, 2L, 0L);
        }
    }

    @Test
    public void testAutoCompactionDutyWithSegmentGranularityAndWithDropExistingTrue() throws Exception {
        this.loadData(INDEX_TASK);
        try (Closeable ignored = this.unloader(this.fullDatasourceName);){
            List intervalsBeforeCompaction = this.coordinator.getSegmentIntervals(this.fullDatasourceName);
            intervalsBeforeCompaction.sort(null);
            this.verifySegmentsCount(4);
            this.verifyQuery(INDEX_QUERIES_RESOURCE);
            LOG.info("Auto compaction test with YEAR segment granularity, dropExisting is true", new Object[0]);
            Granularity newGranularity = Granularities.YEAR;
            this.submitCompactionConfig(1000, NO_SKIP_OFFSET, new UserCompactionTaskGranularityConfig(newGranularity, null, null), true);
            List<String> expectedIntervalAfterCompaction = new ArrayList<String>();
            for (Object interval : intervalsBeforeCompaction) {
                for (Interval newinterval : newGranularity.getIterable(new Interval(interval, (Chronology)ISOChronology.getInstanceUTC()))) {
                    expectedIntervalAfterCompaction.add(newinterval.toString());
                }
            }
            this.forceTriggerAutoCompaction(1);
            this.verifyQuery(INDEX_QUERIES_RESOURCE);
            this.verifySegmentsCompacted(1, (Integer)1000);
            this.checkCompactionIntervals(expectedIntervalAfterCompaction);
            LOG.info("Auto compaction test with MONTH segment granularity, dropExisting is true", new Object[0]);
            newGranularity = Granularities.MONTH;
            this.submitCompactionConfig(1000, NO_SKIP_OFFSET, new UserCompactionTaskGranularityConfig(newGranularity, null, null), true);
            List intervalsAfterYEARCompactionButBeforeMONTHCompaction = this.coordinator.getSegmentIntervals(this.fullDatasourceName);
            expectedIntervalAfterCompaction = new ArrayList();
            for (String interval : intervalsAfterYEARCompactionButBeforeMONTHCompaction) {
                for (Interval newinterval : newGranularity.getIterable(new Interval((Object)interval, (Chronology)ISOChronology.getInstanceUTC()))) {
                    expectedIntervalAfterCompaction.add(newinterval.toString());
                }
            }
            this.forceTriggerAutoCompaction(12);
            this.verifyQuery(INDEX_QUERIES_RESOURCE);
            this.verifyTombstones(10);
            this.verifySegmentsCompacted(12, (Integer)1000);
            this.checkCompactionIntervals(expectedIntervalAfterCompaction);
            LOG.info("Auto compaction test with SEMESTER segment granularity, dropExisting is true, over tombstones", new Object[0]);
            newGranularity = new PeriodGranularity(new Period((Object)"P6M"), null, DateTimeZone.UTC);
            this.submitCompactionConfig(1000, NO_SKIP_OFFSET, new UserCompactionTaskGranularityConfig(newGranularity, null, null), true);
            this.forceTriggerAutoCompaction(2);
            this.verifyQuery(INDEX_QUERIES_RESOURCE);
            this.verifyTombstones(1);
            this.verifySegmentsCompacted(2, (Integer)1000);
            expectedIntervalAfterCompaction = Arrays.asList("2013-01-01T00:00:00.000Z/2013-07-01T00:00:00.000Z", "2013-07-01T00:00:00.000Z/2014-01-01T00:00:00.000Z");
            this.checkCompactionIntervals(expectedIntervalAfterCompaction);
            List compactTasksBefore = this.indexer.getCompleteTasksForDataSource(this.fullDatasourceName);
            this.forceTriggerAutoCompaction(2);
            List compactTasksAfter = this.indexer.getCompleteTasksForDataSource(this.fullDatasourceName);
            Assert.assertEquals((int)compactTasksAfter.size(), (int)compactTasksBefore.size());
        }
    }

    @Test
    public void testAutoCompactionDutyWithSegmentGranularityAndWithDropExistingTrueThenFalse() throws Exception {
        this.loadData(INDEX_TASK);
        try (Closeable ignored = this.unloader(this.fullDatasourceName);){
            List intervalsBeforeCompaction = this.coordinator.getSegmentIntervals(this.fullDatasourceName);
            intervalsBeforeCompaction.sort(null);
            this.verifySegmentsCount(4);
            this.verifyQuery(INDEX_QUERIES_RESOURCE);
            LOG.info("Auto compaction test with YEAR segment granularity, dropExisting is true", new Object[0]);
            Granularity newGranularity = Granularities.YEAR;
            this.submitCompactionConfig(1000, NO_SKIP_OFFSET, new UserCompactionTaskGranularityConfig(newGranularity, null, null), true);
            List<String> expectedIntervalAfterCompaction = new ArrayList<String>();
            for (Object interval : intervalsBeforeCompaction) {
                for (Interval newinterval : newGranularity.getIterable(new Interval(interval, (Chronology)ISOChronology.getInstanceUTC()))) {
                    expectedIntervalAfterCompaction.add(newinterval.toString());
                }
            }
            this.forceTriggerAutoCompaction(1);
            this.verifyQuery(INDEX_QUERIES_RESOURCE);
            this.verifySegmentsCompacted(1, (Integer)1000);
            this.checkCompactionIntervals(expectedIntervalAfterCompaction);
            LOG.info("Auto compaction test with MONTH segment granularity, dropExisting is true", new Object[0]);
            newGranularity = Granularities.MONTH;
            this.submitCompactionConfig(1000, NO_SKIP_OFFSET, new UserCompactionTaskGranularityConfig(newGranularity, null, null), true);
            List intervalsAfterYEARCompactionButBeforeMONTHCompaction = this.coordinator.getSegmentIntervals(this.fullDatasourceName);
            expectedIntervalAfterCompaction = new ArrayList();
            for (String interval : intervalsAfterYEARCompactionButBeforeMONTHCompaction) {
                for (Interval newinterval : newGranularity.getIterable(new Interval((Object)interval, (Chronology)ISOChronology.getInstanceUTC()))) {
                    expectedIntervalAfterCompaction.add(newinterval.toString());
                }
            }
            this.forceTriggerAutoCompaction(12);
            this.verifyQuery(INDEX_QUERIES_RESOURCE);
            this.verifyTombstones(10);
            this.verifySegmentsCompacted(12, (Integer)1000);
            this.checkCompactionIntervals(expectedIntervalAfterCompaction);
            LOG.info("Auto compaction test with SEMESTER segment granularity, dropExisting is false, over tombstones", new Object[0]);
            newGranularity = new PeriodGranularity(new Period((Object)"P6M"), null, DateTimeZone.UTC);
            this.submitCompactionConfig(1000, NO_SKIP_OFFSET, new UserCompactionTaskGranularityConfig(newGranularity, null, null), false);
            this.forceTriggerAutoCompaction(2);
            this.verifyQuery(INDEX_QUERIES_RESOURCE);
            this.verifyTombstones(1);
            this.verifySegmentsCompacted(2, (Integer)1000);
            expectedIntervalAfterCompaction = Arrays.asList("2013-01-01T00:00:00.000Z/2013-07-01T00:00:00.000Z", "2013-07-01T00:00:00.000Z/2014-01-01T00:00:00.000Z");
            this.checkCompactionIntervals(expectedIntervalAfterCompaction);
            List compactTasksBefore = this.indexer.getCompleteTasksForDataSource(this.fullDatasourceName);
            this.forceTriggerAutoCompaction(2);
            List compactTasksAfter = this.indexer.getCompleteTasksForDataSource(this.fullDatasourceName);
            Assert.assertEquals((int)compactTasksAfter.size(), (int)compactTasksBefore.size());
        }
    }

    @Test
    public void testAutoCompactionDutyWithSegmentGranularityAndWithDropExistingFalse() throws Exception {
        this.loadData(INDEX_TASK);
        try (Closeable ignored = this.unloader(this.fullDatasourceName);){
            List intervalsBeforeCompaction = this.coordinator.getSegmentIntervals(this.fullDatasourceName);
            intervalsBeforeCompaction.sort(null);
            this.verifySegmentsCount(4);
            this.verifyQuery(INDEX_QUERIES_RESOURCE);
            Granularity newGranularity = Granularities.YEAR;
            this.submitCompactionConfig(1000, NO_SKIP_OFFSET, new UserCompactionTaskGranularityConfig(newGranularity, null, null), false);
            LOG.info("Auto compaction test with YEAR segment granularity", new Object[0]);
            ArrayList<String> expectedIntervalAfterCompaction = new ArrayList<String>();
            for (String interval : intervalsBeforeCompaction) {
                for (Interval newinterval : newGranularity.getIterable(new Interval((Object)interval, (Chronology)ISOChronology.getInstanceUTC()))) {
                    expectedIntervalAfterCompaction.add(newinterval.toString());
                }
            }
            this.forceTriggerAutoCompaction(1);
            this.verifyQuery(INDEX_QUERIES_RESOURCE);
            this.verifySegmentsCompacted(1, (Integer)1000);
            this.checkCompactionIntervals(expectedIntervalAfterCompaction);
            newGranularity = Granularities.DAY;
            this.submitCompactionConfig(1000, NO_SKIP_OFFSET, new UserCompactionTaskGranularityConfig(newGranularity, null, null), false);
            LOG.info("Auto compaction test with DAY segment granularity", new Object[0]);
            for (String interval : intervalsBeforeCompaction) {
                for (Interval newinterval : newGranularity.getIterable(new Interval((Object)interval, (Chronology)ISOChronology.getInstanceUTC()))) {
                    expectedIntervalAfterCompaction.add(newinterval.toString());
                }
            }
            this.forceTriggerAutoCompaction(3);
            this.verifyQuery(INDEX_QUERIES_RESOURCE);
            this.verifySegmentsCompacted(3, (Integer)1000);
            this.checkCompactionIntervals(expectedIntervalAfterCompaction);
        }
    }

    @Test
    public void testAutoCompactionDutyWithSegmentGranularityAndMixedVersion() throws Exception {
        this.loadData(INDEX_TASK);
        try (Closeable ignored = this.unloader(this.fullDatasourceName);){
            List intervalsBeforeCompaction = this.coordinator.getSegmentIntervals(this.fullDatasourceName);
            intervalsBeforeCompaction.sort(null);
            this.verifySegmentsCount(4);
            this.verifyQuery(INDEX_QUERIES_RESOURCE);
            this.submitCompactionConfig(10000, Period.days((int)1));
            this.forceTriggerAutoCompaction(3);
            this.verifyQuery(INDEX_QUERIES_RESOURCE);
            this.verifySegmentsCompacted(1, (Integer)10000);
            Granularity newGranularity = Granularities.YEAR;
            this.submitCompactionConfig(1000, NO_SKIP_OFFSET, new UserCompactionTaskGranularityConfig(newGranularity, null, null));
            LOG.info("Auto compaction test with YEAR segment granularity", new Object[0]);
            ArrayList<String> expectedIntervalAfterCompaction = new ArrayList<String>();
            for (String interval : intervalsBeforeCompaction) {
                for (Interval newinterval : newGranularity.getIterable(new Interval((Object)interval, (Chronology)ISOChronology.getInstanceUTC()))) {
                    expectedIntervalAfterCompaction.add(newinterval.toString());
                }
            }
            this.forceTriggerAutoCompaction(1);
            this.verifyQuery(INDEX_QUERIES_RESOURCE);
            this.verifySegmentsCompacted(1, (Integer)1000);
            this.checkCompactionIntervals(expectedIntervalAfterCompaction);
        }
    }

    @Test
    public void testAutoCompactionDutyWithSegmentGranularityAndExistingCompactedSegmentsHaveSameSegmentGranularity() throws Exception {
        this.loadData(INDEX_TASK);
        try (Closeable ignored = this.unloader(this.fullDatasourceName);){
            List intervalsBeforeCompaction = this.coordinator.getSegmentIntervals(this.fullDatasourceName);
            intervalsBeforeCompaction.sort(null);
            this.verifySegmentsCount(4);
            this.verifyQuery(INDEX_QUERIES_RESOURCE);
            this.submitCompactionConfig(10000, NO_SKIP_OFFSET);
            this.forceTriggerAutoCompaction(2);
            this.verifyQuery(INDEX_QUERIES_RESOURCE);
            this.verifySegmentsCompacted(2, (Integer)10000);
            List compactTasksBefore = this.indexer.getCompleteTasksForDataSource(this.fullDatasourceName);
            Granularity newGranularity = Granularities.DAY;
            this.submitCompactionConfig(10000, NO_SKIP_OFFSET, new UserCompactionTaskGranularityConfig(newGranularity, null, null));
            this.forceTriggerAutoCompaction(2);
            this.verifyQuery(INDEX_QUERIES_RESOURCE);
            this.verifySegmentsCompacted(2, (Integer)10000);
            List compactTasksAfter = this.indexer.getCompleteTasksForDataSource(this.fullDatasourceName);
            Assert.assertEquals((int)compactTasksAfter.size(), (int)compactTasksBefore.size());
        }
    }

    @Test
    public void testAutoCompactionDutyWithSegmentGranularityAndExistingCompactedSegmentsHaveDifferentSegmentGranularity() throws Exception {
        this.loadData(INDEX_TASK);
        try (Closeable ignored = this.unloader(this.fullDatasourceName);){
            List intervalsBeforeCompaction = this.coordinator.getSegmentIntervals(this.fullDatasourceName);
            intervalsBeforeCompaction.sort(null);
            this.verifySegmentsCount(4);
            this.verifyQuery(INDEX_QUERIES_RESOURCE);
            this.submitCompactionConfig(10000, NO_SKIP_OFFSET);
            this.forceTriggerAutoCompaction(2);
            this.verifyQuery(INDEX_QUERIES_RESOURCE);
            this.verifySegmentsCompacted(2, (Integer)10000);
            List compactTasksBefore = this.indexer.getCompleteTasksForDataSource(this.fullDatasourceName);
            Granularity newGranularity = Granularities.YEAR;
            this.submitCompactionConfig(10000, NO_SKIP_OFFSET, new UserCompactionTaskGranularityConfig(newGranularity, null, null));
            this.forceTriggerAutoCompaction(1);
            this.verifyQuery(INDEX_QUERIES_RESOURCE);
            this.verifySegmentsCompacted(1, (Integer)10000);
            List compactTasksAfter = this.indexer.getCompleteTasksForDataSource(this.fullDatasourceName);
            Assert.assertTrue((compactTasksAfter.size() > compactTasksBefore.size() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testAutoCompactionDutyWithSegmentGranularityAndSmallerSegmentGranularityCoveringMultipleSegmentsInTimelineAndDropExistingTrue() throws Exception {
        this.loadData(INDEX_TASK);
        try (Closeable ignored = this.unloader(this.fullDatasourceName);){
            List intervalsBeforeCompaction = this.coordinator.getSegmentIntervals(this.fullDatasourceName);
            intervalsBeforeCompaction.sort(null);
            this.verifySegmentsCount(4);
            this.verifyQuery(INDEX_QUERIES_RESOURCE);
            Granularity newGranularity = Granularities.YEAR;
            this.submitCompactionConfig(10000, NO_SKIP_OFFSET, new UserCompactionTaskGranularityConfig(newGranularity, null, null), true);
            ArrayList<String> expectedIntervalAfterCompaction = new ArrayList<String>();
            for (String interval : intervalsBeforeCompaction) {
                for (Interval newinterval : newGranularity.getIterable(new Interval((Object)interval, (Chronology)ISOChronology.getInstanceUTC()))) {
                    expectedIntervalAfterCompaction.add(newinterval.toString());
                }
            }
            this.forceTriggerAutoCompaction(1);
            this.verifyQuery(INDEX_QUERIES_RESOURCE);
            this.verifySegmentsCompacted(1, (Integer)10000);
            this.checkCompactionIntervals(expectedIntervalAfterCompaction);
            this.loadData(INDEX_TASK);
            this.verifySegmentsCount(5);
            this.verifyQuery(INDEX_QUERIES_RESOURCE);
            expectedIntervalAfterCompaction.addAll(intervalsBeforeCompaction);
            this.checkCompactionIntervals(expectedIntervalAfterCompaction);
            newGranularity = Granularities.MONTH;
            List intervalsAfterYEARButBeforeMONTHCompaction = this.coordinator.getSegmentIntervals(this.fullDatasourceName);
            this.submitCompactionConfig(10000, NO_SKIP_OFFSET, new UserCompactionTaskGranularityConfig(newGranularity, null, null), true);
            expectedIntervalAfterCompaction = new ArrayList();
            for (String interval : intervalsAfterYEARButBeforeMONTHCompaction) {
                for (Interval newinterval : Granularities.MONTH.getIterable(new Interval((Object)interval, (Chronology)ISOChronology.getInstanceUTC()))) {
                    expectedIntervalAfterCompaction.add(newinterval.toString());
                }
            }
            this.forceTriggerAutoCompaction(12);
            this.verifyQuery(INDEX_QUERIES_RESOURCE);
            this.verifyTombstones(10);
            this.verifySegmentsCompacted(12, (Integer)10000);
            this.checkCompactionIntervals(expectedIntervalAfterCompaction);
        }
    }

    @Test
    public void testAutoCompactionDutyWithSegmentGranularityAndSmallerSegmentGranularityCoveringMultipleSegmentsInTimelineAndDropExistingFalse() throws Exception {
        this.loadData(INDEX_TASK);
        try (Closeable ignored = this.unloader(this.fullDatasourceName);){
            List intervalsBeforeCompaction = this.coordinator.getSegmentIntervals(this.fullDatasourceName);
            intervalsBeforeCompaction.sort(null);
            this.verifySegmentsCount(4);
            this.verifyQuery(INDEX_QUERIES_RESOURCE);
            Granularity newGranularity = Granularities.YEAR;
            this.submitCompactionConfig(10000, NO_SKIP_OFFSET, new UserCompactionTaskGranularityConfig(newGranularity, null, null), false);
            ArrayList<String> expectedIntervalAfterCompaction = new ArrayList<String>();
            for (String interval : intervalsBeforeCompaction) {
                for (Interval newinterval : newGranularity.getIterable(new Interval((Object)interval, (Chronology)ISOChronology.getInstanceUTC()))) {
                    expectedIntervalAfterCompaction.add(newinterval.toString());
                }
            }
            this.forceTriggerAutoCompaction(1);
            this.verifyQuery(INDEX_QUERIES_RESOURCE);
            this.verifySegmentsCompacted(1, (Integer)10000);
            this.checkCompactionIntervals(expectedIntervalAfterCompaction);
            this.loadData(INDEX_TASK);
            this.verifySegmentsCount(5);
            this.verifyQuery(INDEX_QUERIES_RESOURCE);
            expectedIntervalAfterCompaction.addAll(intervalsBeforeCompaction);
            this.checkCompactionIntervals(expectedIntervalAfterCompaction);
            newGranularity = Granularities.MONTH;
            this.submitCompactionConfig(10000, NO_SKIP_OFFSET, new UserCompactionTaskGranularityConfig(newGranularity, null, null), false);
            expectedIntervalAfterCompaction = new ArrayList();
            for (String interval : intervalsBeforeCompaction) {
                for (Interval newinterval : Granularities.YEAR.getIterable(new Interval((Object)interval, (Chronology)ISOChronology.getInstanceUTC()))) {
                    expectedIntervalAfterCompaction.add(newinterval.toString());
                }
            }
            for (String interval : intervalsBeforeCompaction) {
                for (Interval newinterval : Granularities.MONTH.getIterable(new Interval((Object)interval, (Chronology)ISOChronology.getInstanceUTC()))) {
                    expectedIntervalAfterCompaction.add(newinterval.toString());
                }
            }
            this.forceTriggerAutoCompaction(3);
            this.verifyQuery(INDEX_QUERIES_RESOURCE);
            this.verifySegmentsCompacted(3, (Integer)10000);
            this.checkCompactionIntervals(expectedIntervalAfterCompaction);
        }
    }

    @Test
    public void testAutoCompactionDutyWithSegmentGranularityFinerAndNotAlignWithSegment() throws Exception {
        this.updateCompactionTaskSlot(1.0, 1, null);
        ISOChronology chrono = ISOChronology.getInstance((DateTimeZone)DateTimes.inferTzFromString((String)"America/Los_Angeles"));
        ImmutableMap specs = ImmutableMap.of((Object)"%%GRANULARITYSPEC%%", (Object)new UniformGranularitySpec(Granularities.MONTH, Granularities.DAY, Boolean.valueOf(false), (List)ImmutableList.of((Object)new Interval((Object)"2013-08-31/2013-09-02", (Chronology)chrono))));
        this.loadData(INDEX_TASK_WITH_GRANULARITY_SPEC, (Map<String, Object>)specs);
        try (Closeable ignored = this.unloader(this.fullDatasourceName);){
            ImmutableMap queryAndResultFields = ImmutableMap.of((Object)"%%FIELD_TO_QUERY%%", (Object)"added", (Object)"%%EXPECTED_COUNT_RESULT%%", (Object)2, (Object)"%%EXPECTED_SCAN_RESULT%%", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"events", (Object)ImmutableList.of((Object)ImmutableList.of((Object)57.0), (Object)ImmutableList.of((Object)459.0)))));
            this.verifyQuery(INDEX_ROLLUP_QUERIES_RESOURCE, (Map<String, Object>)queryAndResultFields);
            this.submitCompactionConfig(10000, NO_SKIP_OFFSET, new UserCompactionTaskGranularityConfig(Granularities.WEEK, null, null), false);
            this.forceTriggerAutoCompaction(3);
            queryAndResultFields = ImmutableMap.of((Object)"%%FIELD_TO_QUERY%%", (Object)"added", (Object)"%%EXPECTED_COUNT_RESULT%%", (Object)2, (Object)"%%EXPECTED_SCAN_RESULT%%", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"events", (Object)ImmutableList.of((Object)ImmutableList.of((Object)57.0), (Object)ImmutableList.of((Object)459.0)))));
            this.verifyQuery(INDEX_ROLLUP_QUERIES_RESOURCE, (Map<String, Object>)queryAndResultFields);
            this.verifySegmentsCompacted(1, (Integer)10000);
            List tasks = this.indexer.getCompleteTasksForDataSource(this.fullDatasourceName);
            TaskResponseObject compactTask = null;
            for (TaskResponseObject task : tasks) {
                if (!task.getType().equals("compact")) continue;
                compactTask = task;
            }
            Assert.assertNotNull(compactTask);
            TaskPayloadResponse task = this.indexer.getTaskPayload(compactTask.getId());
            Assert.assertEquals((Object)Intervals.of((String)"2013-08-26T00:00:00.000Z/2013-10-07T00:00:00.000Z"), (Object)((CompactionIntervalSpec)((CompactionTask)task.getPayload()).getIoConfig().getInputSpec()).getInterval());
        }
    }

    @Test
    public void testAutoCompactionDutyWithSegmentGranularityCoarserAndNotAlignWithSegment() throws Exception {
        this.updateCompactionTaskSlot(1.0, 1, null);
        ISOChronology chrono = ISOChronology.getInstance((DateTimeZone)DateTimes.inferTzFromString((String)"America/Los_Angeles"));
        ImmutableMap specs = ImmutableMap.of((Object)"%%GRANULARITYSPEC%%", (Object)new UniformGranularitySpec(Granularities.WEEK, Granularities.DAY, Boolean.valueOf(false), (List)ImmutableList.of((Object)new Interval((Object)"2013-08-31/2013-09-02", (Chronology)chrono))));
        this.loadData(INDEX_TASK_WITH_GRANULARITY_SPEC, (Map<String, Object>)specs);
        try (Closeable ignored = this.unloader(this.fullDatasourceName);){
            ImmutableMap queryAndResultFields = ImmutableMap.of((Object)"%%FIELD_TO_QUERY%%", (Object)"added", (Object)"%%EXPECTED_COUNT_RESULT%%", (Object)2, (Object)"%%EXPECTED_SCAN_RESULT%%", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"events", (Object)ImmutableList.of((Object)ImmutableList.of((Object)57.0), (Object)ImmutableList.of((Object)459.0)))));
            this.verifyQuery(INDEX_ROLLUP_QUERIES_RESOURCE, (Map<String, Object>)queryAndResultFields);
            this.submitCompactionConfig(10000, NO_SKIP_OFFSET, new UserCompactionTaskGranularityConfig(Granularities.MONTH, null, null), false);
            this.forceTriggerAutoCompaction(2);
            queryAndResultFields = ImmutableMap.of((Object)"%%FIELD_TO_QUERY%%", (Object)"added", (Object)"%%EXPECTED_COUNT_RESULT%%", (Object)2, (Object)"%%EXPECTED_SCAN_RESULT%%", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"events", (Object)ImmutableList.of((Object)ImmutableList.of((Object)57.0), (Object)ImmutableList.of((Object)459.0)))));
            this.verifyQuery(INDEX_ROLLUP_QUERIES_RESOURCE, (Map<String, Object>)queryAndResultFields);
            this.verifySegmentsCompacted(2, (Integer)10000);
            List tasks = this.indexer.getCompleteTasksForDataSource(this.fullDatasourceName);
            TaskResponseObject compactTask = null;
            for (TaskResponseObject task : tasks) {
                if (!task.getType().equals("compact")) continue;
                compactTask = task;
            }
            Assert.assertNotNull(compactTask);
            TaskPayloadResponse task = this.indexer.getTaskPayload(compactTask.getId());
            Assert.assertEquals((Object)Intervals.of((String)"2013-08-01T00:00:00.000Z/2013-10-01T00:00:00.000Z"), (Object)((CompactionIntervalSpec)((CompactionTask)task.getPayload()).getIoConfig().getInputSpec()).getInterval());
        }
    }

    @Test
    public void testAutoCompactionDutyWithRollup() throws Exception {
        ISOChronology chrono = ISOChronology.getInstance((DateTimeZone)DateTimes.inferTzFromString((String)"America/Los_Angeles"));
        ImmutableMap specs = ImmutableMap.of((Object)"%%GRANULARITYSPEC%%", (Object)new UniformGranularitySpec(Granularities.DAY, Granularities.DAY, Boolean.valueOf(false), (List)ImmutableList.of((Object)new Interval((Object)"2013-08-31/2013-09-02", (Chronology)chrono))));
        this.loadData(INDEX_TASK_WITH_GRANULARITY_SPEC, (Map<String, Object>)specs);
        try (Closeable ignored = this.unloader(this.fullDatasourceName);){
            ImmutableMap queryAndResultFields = ImmutableMap.of((Object)"%%FIELD_TO_QUERY%%", (Object)"added", (Object)"%%EXPECTED_COUNT_RESULT%%", (Object)2, (Object)"%%EXPECTED_SCAN_RESULT%%", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"events", (Object)ImmutableList.of((Object)ImmutableList.of((Object)57.0), (Object)ImmutableList.of((Object)459.0)))));
            this.verifyQuery(INDEX_ROLLUP_QUERIES_RESOURCE, (Map<String, Object>)queryAndResultFields);
            this.submitCompactionConfig(10000, NO_SKIP_OFFSET, new UserCompactionTaskGranularityConfig(null, null, Boolean.valueOf(true)), false);
            this.forceTriggerAutoCompaction(2);
            queryAndResultFields = ImmutableMap.of((Object)"%%FIELD_TO_QUERY%%", (Object)"added", (Object)"%%EXPECTED_COUNT_RESULT%%", (Object)1, (Object)"%%EXPECTED_SCAN_RESULT%%", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"events", (Object)ImmutableList.of((Object)ImmutableList.of((Object)516.0)))));
            this.verifyQuery(INDEX_ROLLUP_QUERIES_RESOURCE, (Map<String, Object>)queryAndResultFields);
            this.verifySegmentsCompacted(2, (Integer)10000);
            List compactTasksBefore = this.indexer.getCompleteTasksForDataSource(this.fullDatasourceName);
            this.forceTriggerAutoCompaction(2);
            List compactTasksAfter = this.indexer.getCompleteTasksForDataSource(this.fullDatasourceName);
            Assert.assertEquals((int)compactTasksAfter.size(), (int)compactTasksBefore.size());
        }
    }

    @Test
    public void testAutoCompactionDutyWithQueryGranularity() throws Exception {
        ISOChronology chrono = ISOChronology.getInstance((DateTimeZone)DateTimes.inferTzFromString((String)"America/Los_Angeles"));
        ImmutableMap specs = ImmutableMap.of((Object)"%%GRANULARITYSPEC%%", (Object)new UniformGranularitySpec(Granularities.DAY, Granularities.NONE, Boolean.valueOf(true), (List)ImmutableList.of((Object)new Interval((Object)"2013-08-31/2013-09-02", (Chronology)chrono))));
        this.loadData(INDEX_TASK_WITH_GRANULARITY_SPEC, (Map<String, Object>)specs);
        try (Closeable ignored = this.unloader(this.fullDatasourceName);){
            ImmutableMap queryAndResultFields = ImmutableMap.of((Object)"%%FIELD_TO_QUERY%%", (Object)"added", (Object)"%%EXPECTED_COUNT_RESULT%%", (Object)2, (Object)"%%EXPECTED_SCAN_RESULT%%", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"events", (Object)ImmutableList.of((Object)ImmutableList.of((Object)57.0), (Object)ImmutableList.of((Object)459.0)))));
            this.verifyQuery(INDEX_ROLLUP_QUERIES_RESOURCE, (Map<String, Object>)queryAndResultFields);
            this.submitCompactionConfig(10000, NO_SKIP_OFFSET, new UserCompactionTaskGranularityConfig(null, Granularities.DAY, null), false);
            this.forceTriggerAutoCompaction(2);
            queryAndResultFields = ImmutableMap.of((Object)"%%FIELD_TO_QUERY%%", (Object)"added", (Object)"%%EXPECTED_COUNT_RESULT%%", (Object)1, (Object)"%%EXPECTED_SCAN_RESULT%%", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"events", (Object)ImmutableList.of((Object)ImmutableList.of((Object)516.0)))));
            this.verifyQuery(INDEX_ROLLUP_QUERIES_RESOURCE, (Map<String, Object>)queryAndResultFields);
            this.verifySegmentsCompacted(2, (Integer)10000);
            List compactTasksBefore = this.indexer.getCompleteTasksForDataSource(this.fullDatasourceName);
            this.forceTriggerAutoCompaction(2);
            List compactTasksAfter = this.indexer.getCompleteTasksForDataSource(this.fullDatasourceName);
            Assert.assertEquals((int)compactTasksAfter.size(), (int)compactTasksBefore.size());
        }
    }

    @Test
    public void testAutoCompactionDutyWithDimensionsSpec() throws Exception {
        this.loadData(INDEX_TASK_WITH_DIMENSION_SPEC);
        try (Closeable ignored = this.unloader(this.fullDatasourceName);){
            List intervalsBeforeCompaction = this.coordinator.getSegmentIntervals(this.fullDatasourceName);
            intervalsBeforeCompaction.sort(null);
            this.verifySegmentsCount(4);
            ImmutableMap queryAndResultFields = ImmutableMap.of((Object)"%%FIELD_TO_QUERY%%", (Object)"added", (Object)"%%EXPECTED_COUNT_RESULT%%", (Object)2, (Object)"%%EXPECTED_SCAN_RESULT%%", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"events", (Object)ImmutableList.of((Object)ImmutableList.of((Object)57.0), (Object)ImmutableList.of((Object)459.0)))));
            this.verifyQuery(INDEX_ROLLUP_QUERIES_RESOURCE, (Map<String, Object>)queryAndResultFields);
            this.submitCompactionConfig(10000, NO_SKIP_OFFSET, null, new UserCompactionTaskDimensionsConfig(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"language"))), null, null, false);
            this.forceTriggerAutoCompaction(2);
            queryAndResultFields = ImmutableMap.of((Object)"%%FIELD_TO_QUERY%%", (Object)"added", (Object)"%%EXPECTED_COUNT_RESULT%%", (Object)1, (Object)"%%EXPECTED_SCAN_RESULT%%", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"events", (Object)ImmutableList.of((Object)ImmutableList.of((Object)516.0)))));
            this.verifyQuery(INDEX_ROLLUP_QUERIES_RESOURCE, (Map<String, Object>)queryAndResultFields);
            this.verifySegmentsCompacted(2, (Integer)10000);
            List compactTasksBefore = this.indexer.getCompleteTasksForDataSource(this.fullDatasourceName);
            this.forceTriggerAutoCompaction(2);
            List compactTasksAfter = this.indexer.getCompleteTasksForDataSource(this.fullDatasourceName);
            Assert.assertEquals((int)compactTasksAfter.size(), (int)compactTasksBefore.size());
        }
    }

    @Test
    public void testAutoCompactionDutyWithFilter() throws Exception {
        this.loadData(INDEX_TASK_WITH_DIMENSION_SPEC);
        try (Closeable ignored = this.unloader(this.fullDatasourceName);){
            List intervalsBeforeCompaction = this.coordinator.getSegmentIntervals(this.fullDatasourceName);
            intervalsBeforeCompaction.sort(null);
            this.verifySegmentsCount(4);
            ImmutableMap queryAndResultFields = ImmutableMap.of((Object)"%%FIELD_TO_QUERY%%", (Object)"added", (Object)"%%EXPECTED_COUNT_RESULT%%", (Object)2, (Object)"%%EXPECTED_SCAN_RESULT%%", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"events", (Object)ImmutableList.of((Object)ImmutableList.of((Object)57.0), (Object)ImmutableList.of((Object)459.0)))));
            this.verifyQuery(INDEX_ROLLUP_QUERIES_RESOURCE, (Map<String, Object>)queryAndResultFields);
            this.submitCompactionConfig(10000, NO_SKIP_OFFSET, null, null, new UserCompactionTaskTransformConfig((DimFilter)new SelectorDimFilter("page", "Striker Eureka", null)), null, false);
            this.forceTriggerAutoCompaction(2);
            queryAndResultFields = ImmutableMap.of((Object)"%%FIELD_TO_QUERY%%", (Object)"added", (Object)"%%EXPECTED_COUNT_RESULT%%", (Object)1, (Object)"%%EXPECTED_SCAN_RESULT%%", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"events", (Object)ImmutableList.of((Object)ImmutableList.of((Object)459.0)))));
            this.verifyQuery(INDEX_ROLLUP_QUERIES_RESOURCE, (Map<String, Object>)queryAndResultFields);
            this.verifySegmentsCompacted(2, (Integer)10000);
            List compactTasksBefore = this.indexer.getCompleteTasksForDataSource(this.fullDatasourceName);
            this.forceTriggerAutoCompaction(2);
            List compactTasksAfter = this.indexer.getCompleteTasksForDataSource(this.fullDatasourceName);
            Assert.assertEquals((int)compactTasksAfter.size(), (int)compactTasksBefore.size());
        }
    }

    @Test
    public void testAutoCompactionDutyWithMetricsSpec() throws Exception {
        this.loadData(INDEX_TASK_WITH_DIMENSION_SPEC);
        try (Closeable ignored = this.unloader(this.fullDatasourceName);){
            List intervalsBeforeCompaction = this.coordinator.getSegmentIntervals(this.fullDatasourceName);
            intervalsBeforeCompaction.sort(null);
            this.verifySegmentsCount(4);
            ImmutableMap queryAndResultFields = ImmutableMap.of((Object)"%%FIELD_TO_QUERY%%", (Object)"added", (Object)"%%EXPECTED_COUNT_RESULT%%", (Object)2, (Object)"%%EXPECTED_SCAN_RESULT%%", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"events", (Object)ImmutableList.of((Object)ImmutableList.of((Object)57.0), (Object)ImmutableList.of((Object)459.0)))));
            this.verifyQuery(INDEX_ROLLUP_QUERIES_RESOURCE, (Map<String, Object>)queryAndResultFields);
            this.submitCompactionConfig(10000, NO_SKIP_OFFSET, null, null, null, new AggregatorFactory[]{new DoubleSumAggregatorFactory("double_sum_added", "added"), new LongSumAggregatorFactory("long_sum_added", "added")}, false);
            this.forceTriggerAutoCompaction(2);
            queryAndResultFields = ImmutableMap.of((Object)"%%FIELD_TO_QUERY%%", (Object)"double_sum_added", (Object)"%%EXPECTED_COUNT_RESULT%%", (Object)2, (Object)"%%EXPECTED_SCAN_RESULT%%", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"events", (Object)ImmutableList.of((Object)ImmutableList.of((Object)57.0), (Object)ImmutableList.of((Object)459.0)))));
            this.verifyQuery(INDEX_ROLLUP_QUERIES_RESOURCE, (Map<String, Object>)queryAndResultFields);
            queryAndResultFields = ImmutableMap.of((Object)"%%FIELD_TO_QUERY%%", (Object)"long_sum_added", (Object)"%%EXPECTED_COUNT_RESULT%%", (Object)2, (Object)"%%EXPECTED_SCAN_RESULT%%", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"events", (Object)ImmutableList.of((Object)ImmutableList.of((Object)57), (Object)ImmutableList.of((Object)459)))));
            this.verifyQuery(INDEX_ROLLUP_QUERIES_RESOURCE, (Map<String, Object>)queryAndResultFields);
            this.verifySegmentsCompacted(2, (Integer)10000);
            List compactTasksBefore = this.indexer.getCompleteTasksForDataSource(this.fullDatasourceName);
            this.forceTriggerAutoCompaction(2);
            List compactTasksAfter = this.indexer.getCompleteTasksForDataSource(this.fullDatasourceName);
            Assert.assertEquals((int)compactTasksAfter.size(), (int)compactTasksBefore.size());
        }
    }

    @Test
    public void testAutoCompactionDutyWithOverlappingInterval() throws Exception {
        ISOChronology chrono = ISOChronology.getInstance((DateTimeZone)DateTimes.inferTzFromString((String)"America/Los_Angeles"));
        ImmutableMap specs = ImmutableMap.of((Object)"%%GRANULARITYSPEC%%", (Object)new UniformGranularitySpec(Granularities.WEEK, Granularities.NONE, Boolean.valueOf(false), (List)ImmutableList.of((Object)new Interval((Object)"2013-08-31/2013-09-02", (Chronology)chrono))));
        this.loadData(INDEX_TASK_WITH_GRANULARITY_SPEC, (Map<String, Object>)specs);
        specs = ImmutableMap.of((Object)"%%GRANULARITYSPEC%%", (Object)new UniformGranularitySpec(Granularities.MONTH, Granularities.NONE, Boolean.valueOf(false), (List)ImmutableList.of((Object)new Interval((Object)"2013-09-01/2013-09-02", (Chronology)chrono))));
        this.loadData(INDEX_TASK_WITH_GRANULARITY_SPEC, (Map<String, Object>)specs);
        try (Closeable ignored = this.unloader(this.fullDatasourceName);){
            this.verifySegmentsCount(2);
            ImmutableMap queryAndResultFields = ImmutableMap.of((Object)"%%FIELD_TO_QUERY%%", (Object)"added", (Object)"%%EXPECTED_COUNT_RESULT%%", (Object)2, (Object)"%%EXPECTED_SCAN_RESULT%%", (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"events", (Object)ImmutableList.of((Object)ImmutableList.of((Object)57.0), (Object)ImmutableList.of((Object)459.0)))));
            this.verifyQuery(INDEX_ROLLUP_QUERIES_RESOURCE, (Map<String, Object>)queryAndResultFields);
            this.submitCompactionConfig(10000, NO_SKIP_OFFSET, null, null, null, null, false);
            this.forceTriggerAutoCompaction(2);
            this.verifyQuery(INDEX_ROLLUP_QUERIES_RESOURCE, (Map<String, Object>)queryAndResultFields);
            this.forceTriggerAutoCompaction(2);
            this.verifyQuery(INDEX_ROLLUP_QUERIES_RESOURCE, (Map<String, Object>)queryAndResultFields);
            List compactTasksBefore = this.indexer.getCompleteTasksForDataSource(this.fullDatasourceName);
            for (TaskResponseObject taskResponseObject : compactTasksBefore) {
                Assert.assertEquals((Object)TaskState.SUCCESS, (Object)taskResponseObject.getStatus());
            }
            this.forceTriggerAutoCompaction(2);
            List compactTasksAfter = this.indexer.getCompleteTasksForDataSource(this.fullDatasourceName);
            Assert.assertEquals((int)compactTasksAfter.size(), (int)compactTasksBefore.size());
        }
    }

    @Test
    public void testUpdateCompactionTaskSlotWithUseAutoScaleSlots() throws Exception {
        this.updateCompactionTaskSlot(3.0, 5, null);
        CoordinatorCompactionConfig coordinatorCompactionConfig = this.compactionResource.getCoordinatorCompactionConfigs();
        Assert.assertFalse((boolean)coordinatorCompactionConfig.isUseAutoScaleSlots());
        this.updateCompactionTaskSlot(3.0, 5, true);
        coordinatorCompactionConfig = this.compactionResource.getCoordinatorCompactionConfigs();
        Assert.assertTrue((boolean)coordinatorCompactionConfig.isUseAutoScaleSlots());
        this.updateCompactionTaskSlot(3.0, 5, false);
        coordinatorCompactionConfig = this.compactionResource.getCoordinatorCompactionConfigs();
        Assert.assertFalse((boolean)coordinatorCompactionConfig.isUseAutoScaleSlots());
    }

    private void loadData(String indexTask) throws Exception {
        this.loadData(indexTask, (Map<String, Object>)ImmutableMap.of());
    }

    private void loadData(String indexTask, Map<String, Object> specs) throws Exception {
        String taskSpec = ITAutoCompactionTest.getResourceAsString(indexTask);
        taskSpec = StringUtils.replace((String)taskSpec, (String)"%%DATASOURCE%%", (String)this.fullDatasourceName);
        taskSpec = StringUtils.replace((String)taskSpec, (String)"%%SEGMENT_AVAIL_TIMEOUT_MILLIS%%", (String)this.jsonMapper.writeValueAsString((Object)"0"));
        for (Map.Entry<String, Object> entry : specs.entrySet()) {
            taskSpec = StringUtils.replace((String)taskSpec, (String)entry.getKey(), (String)this.jsonMapper.writeValueAsString(entry.getValue()));
        }
        String taskID = this.indexer.submitTask(taskSpec);
        LOG.info("TaskID for loading index task %s", new Object[]{taskID});
        this.indexer.waitUntilTaskCompletes(taskID);
        ITRetryUtil.retryUntilTrue(() -> this.coordinator.areSegmentsLoaded(this.fullDatasourceName), (String)"Segment Load");
    }

    private void verifyQuery(String queryResource) throws Exception {
        this.verifyQuery(queryResource, (Map<String, Object>)ImmutableMap.of());
    }

    private void verifyQuery(String queryResource, Map<String, Object> keyValueToReplace) throws Exception {
        String queryResponseTemplate;
        try {
            InputStream is = AbstractITBatchIndexTest.class.getResourceAsStream(queryResource);
            queryResponseTemplate = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new ISE((Throwable)e, "could not read query file: %s", new Object[]{queryResource});
        }
        queryResponseTemplate = StringUtils.replace((String)queryResponseTemplate, (String)"%%DATASOURCE%%", (String)this.fullDatasourceName);
        for (Map.Entry<String, Object> entry : keyValueToReplace.entrySet()) {
            queryResponseTemplate = StringUtils.replace((String)queryResponseTemplate, (String)entry.getKey(), (String)this.jsonMapper.writeValueAsString(entry.getValue()));
        }
        this.queryHelper.testQueriesFromString(queryResponseTemplate);
    }

    private void submitCompactionConfig(Integer maxRowsPerSegment, Period skipOffsetFromLatest) throws Exception {
        this.submitCompactionConfig(maxRowsPerSegment, skipOffsetFromLatest, null);
    }

    private void submitCompactionConfig(Integer maxRowsPerSegment, Period skipOffsetFromLatest, UserCompactionTaskGranularityConfig granularitySpec) throws Exception {
        this.submitCompactionConfig(maxRowsPerSegment, skipOffsetFromLatest, granularitySpec, false);
    }

    private void submitCompactionConfig(Integer maxRowsPerSegment, Period skipOffsetFromLatest, UserCompactionTaskGranularityConfig granularitySpec, boolean dropExisting) throws Exception {
        this.submitCompactionConfig(maxRowsPerSegment, skipOffsetFromLatest, granularitySpec, null, null, null, dropExisting);
    }

    private void submitCompactionConfig(Integer maxRowsPerSegment, Period skipOffsetFromLatest, UserCompactionTaskGranularityConfig granularitySpec, UserCompactionTaskDimensionsConfig dimensionsSpec, UserCompactionTaskTransformConfig transformSpec, AggregatorFactory[] metricsSpec, boolean dropExisting) throws Exception {
        this.submitCompactionConfig((PartitionsSpec)new DynamicPartitionsSpec(maxRowsPerSegment, null), skipOffsetFromLatest, 1, granularitySpec, dimensionsSpec, transformSpec, metricsSpec, dropExisting);
    }

    private void submitCompactionConfig(PartitionsSpec partitionsSpec, Period skipOffsetFromLatest, int maxNumConcurrentSubTasks, UserCompactionTaskGranularityConfig granularitySpec, UserCompactionTaskDimensionsConfig dimensionsSpec, UserCompactionTaskTransformConfig transformSpec, AggregatorFactory[] metricsSpec, boolean dropExisting) throws Exception {
        DataSourceCompactionConfig compactionConfig = new DataSourceCompactionConfig(this.fullDatasourceName, null, null, null, skipOffsetFromLatest, new UserCompactionTaskQueryTuningConfig(null, null, null, null, (SplitHintSpec)new MaxSizeSplitHintSpec(null, Integer.valueOf(1)), partitionsSpec, null, null, null, null, null, Integer.valueOf(maxNumConcurrentSubTasks), null, null, null, null, null, Integer.valueOf(1), null), granularitySpec, dimensionsSpec, metricsSpec, transformSpec, !dropExisting ? null : new UserCompactionTaskIOConfig(Boolean.valueOf(true)), null);
        this.compactionResource.submitCompactionConfig(compactionConfig);
        Thread.sleep(2000L);
        CoordinatorCompactionConfig coordinatorCompactionConfig = this.compactionResource.getCoordinatorCompactionConfigs();
        DataSourceCompactionConfig foundDataSourceCompactionConfig = null;
        for (DataSourceCompactionConfig dataSourceCompactionConfig : coordinatorCompactionConfig.getCompactionConfigs()) {
            if (!dataSourceCompactionConfig.getDataSource().equals(this.fullDatasourceName)) continue;
            foundDataSourceCompactionConfig = dataSourceCompactionConfig;
        }
        Assert.assertNotNull(foundDataSourceCompactionConfig);
        Assert.assertNotNull((Object)foundDataSourceCompactionConfig.getTuningConfig());
        Assert.assertEquals((Object)foundDataSourceCompactionConfig.getTuningConfig().getPartitionsSpec(), (Object)partitionsSpec);
        Assert.assertEquals((Object)foundDataSourceCompactionConfig.getSkipOffsetFromLatest(), (Object)skipOffsetFromLatest);
        foundDataSourceCompactionConfig = this.compactionResource.getDataSourceCompactionConfig(this.fullDatasourceName);
        Assert.assertNotNull((Object)foundDataSourceCompactionConfig);
        Assert.assertNotNull((Object)foundDataSourceCompactionConfig.getTuningConfig());
        Assert.assertEquals((Object)foundDataSourceCompactionConfig.getTuningConfig().getPartitionsSpec(), (Object)partitionsSpec);
        Assert.assertEquals((Object)foundDataSourceCompactionConfig.getSkipOffsetFromLatest(), (Object)skipOffsetFromLatest);
    }

    private void deleteCompactionConfig() throws Exception {
        this.compactionResource.deleteCompactionConfig(this.fullDatasourceName);
        CoordinatorCompactionConfig coordinatorCompactionConfig = this.compactionResource.getCoordinatorCompactionConfigs();
        DataSourceCompactionConfig foundDataSourceCompactionConfig = null;
        for (DataSourceCompactionConfig dataSourceCompactionConfig : coordinatorCompactionConfig.getCompactionConfigs()) {
            if (!dataSourceCompactionConfig.getDataSource().equals(this.fullDatasourceName)) continue;
            foundDataSourceCompactionConfig = dataSourceCompactionConfig;
        }
        Assert.assertNull(foundDataSourceCompactionConfig);
    }

    private void forceTriggerAutoCompaction(int numExpectedSegmentsAfterCompaction) throws Exception {
        this.compactionResource.forceTriggerAutoCompaction();
        this.waitForAllTasksToCompleteForDataSource(this.fullDatasourceName);
        ITRetryUtil.retryUntilTrue(() -> this.coordinator.areSegmentsLoaded(this.fullDatasourceName), (String)"Segment Compaction");
        this.verifySegmentsCount(numExpectedSegmentsAfterCompaction);
    }

    private void verifySegmentsCount(int numExpectedSegments) {
        ITRetryUtil.retryUntilTrue(() -> {
            int metadataSegmentCount = this.coordinator.getSegments(this.fullDatasourceName).size();
            LOG.info("Current metadata segment count: %d, expected: %d", new Object[]{metadataSegmentCount, numExpectedSegments});
            return metadataSegmentCount == numExpectedSegments;
        }, (String)"Compaction segment count check");
    }

    private void checkCompactionIntervals(List<String> expectedIntervals) {
        HashSet<String> expectedIntervalsSet = new HashSet<String>(expectedIntervals);
        ITRetryUtil.retryUntilTrue(() -> {
            HashSet actualIntervals = new HashSet(this.coordinator.getSegmentIntervals(this.fullDatasourceName));
            System.out.println("ACTUAL: " + actualIntervals);
            System.out.println("EXPECTED: " + expectedIntervalsSet);
            return actualIntervals.equals(expectedIntervalsSet);
        }, (String)"Compaction interval check");
    }

    private void verifySegmentsCompacted(int expectedCompactedSegmentCount, Integer expectedMaxRowsPerSegment) {
        this.verifySegmentsCompacted((PartitionsSpec)new DynamicPartitionsSpec(expectedMaxRowsPerSegment, Long.valueOf(Long.MAX_VALUE)), expectedCompactedSegmentCount);
    }

    private void verifyTombstones(int expectedCompactedTombstoneCount) {
        List segments = this.coordinator.getFullSegmentsMetadata(this.fullDatasourceName);
        int actualTombstoneCount = 0;
        for (DataSegment segment : segments) {
            if (!segment.isTombstone()) continue;
            ++actualTombstoneCount;
        }
        Assert.assertEquals((int)actualTombstoneCount, (int)expectedCompactedTombstoneCount);
    }

    private void verifySegmentsCompacted(PartitionsSpec partitionsSpec, int expectedCompactedSegmentCount) {
        List segments = this.coordinator.getFullSegmentsMetadata(this.fullDatasourceName);
        ArrayList<DataSegment> foundCompactedSegments = new ArrayList<DataSegment>();
        for (DataSegment segment : segments) {
            if (segment.getLastCompactionState() == null) continue;
            foundCompactedSegments.add(segment);
        }
        Assert.assertEquals((int)foundCompactedSegments.size(), (int)expectedCompactedSegmentCount);
        for (DataSegment compactedSegment : foundCompactedSegments) {
            Assert.assertNotNull((Object)compactedSegment.getLastCompactionState());
            Assert.assertNotNull((Object)compactedSegment.getLastCompactionState().getPartitionsSpec());
            Assert.assertEquals((Object)compactedSegment.getLastCompactionState().getPartitionsSpec(), (Object)partitionsSpec);
        }
    }

    private void updateCompactionTaskSlot(double compactionTaskSlotRatio, int maxCompactionTaskSlots, Boolean useAutoScaleSlots) throws Exception {
        this.compactionResource.updateCompactionTaskSlot(Double.valueOf(compactionTaskSlotRatio), Integer.valueOf(maxCompactionTaskSlots), useAutoScaleSlots);
        CoordinatorCompactionConfig coordinatorCompactionConfig = this.compactionResource.getCoordinatorCompactionConfigs();
        Assert.assertEquals((double)coordinatorCompactionConfig.getCompactionTaskSlotRatio(), (double)compactionTaskSlotRatio);
        Assert.assertEquals((int)coordinatorCompactionConfig.getMaxCompactionTaskSlots(), (int)maxCompactionTaskSlots);
        if (useAutoScaleSlots != null) {
            Assert.assertEquals((boolean)coordinatorCompactionConfig.isUseAutoScaleSlots(), (boolean)useAutoScaleSlots);
        }
    }

    private void getAndAssertCompactionStatus(String fullDatasourceName, AutoCompactionSnapshot.AutoCompactionScheduleStatus scheduleStatus, long bytesAwaitingCompaction, long bytesCompacted, long bytesSkipped, long segmentCountAwaitingCompaction, long segmentCountCompacted, long segmentCountSkipped, long intervalCountAwaitingCompaction, long intervalCountCompacted, long intervalCountSkipped) throws Exception {
        Map actualStatus = this.compactionResource.getCompactionStatus(fullDatasourceName);
        Assert.assertNotNull((Object)actualStatus);
        Assert.assertEquals((String)((String)actualStatus.get("scheduleStatus")), (String)scheduleStatus.toString());
        Assert.assertEquals((long)Long.parseLong((String)actualStatus.get("bytesAwaitingCompaction")), (long)bytesAwaitingCompaction);
        Assert.assertEquals((long)Long.parseLong((String)actualStatus.get("bytesCompacted")), (long)bytesCompacted);
        Assert.assertEquals((long)Long.parseLong((String)actualStatus.get("bytesSkipped")), (long)bytesSkipped);
        Assert.assertEquals((long)Long.parseLong((String)actualStatus.get("segmentCountAwaitingCompaction")), (long)segmentCountAwaitingCompaction);
        Assert.assertEquals((long)Long.parseLong((String)actualStatus.get("segmentCountCompacted")), (long)segmentCountCompacted);
        Assert.assertEquals((long)Long.parseLong((String)actualStatus.get("segmentCountSkipped")), (long)segmentCountSkipped);
        Assert.assertEquals((long)Long.parseLong((String)actualStatus.get("intervalCountAwaitingCompaction")), (long)intervalCountAwaitingCompaction);
        Assert.assertEquals((long)Long.parseLong((String)actualStatus.get("intervalCountCompacted")), (long)intervalCountCompacted);
        Assert.assertEquals((long)Long.parseLong((String)actualStatus.get("intervalCountSkipped")), (long)intervalCountSkipped);
    }
}

