/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.tests.indexer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.tests.indexer.AbstractITBatchIndexTest;
import org.testng.annotations.DataProvider;

public abstract class AbstractGcsInputSourceParallelIndexTest
extends AbstractITBatchIndexTest {
    private static final String INDEX_TASK = "/indexer/wikipedia_cloud_index_task.json";
    private static final String INDEX_QUERIES_RESOURCE = "/indexer/wikipedia_index_queries.json";
    private static final String INPUT_SOURCE_URIS_KEY = "uris";
    private static final String INPUT_SOURCE_PREFIXES_KEY = "prefixes";
    private static final String INPUT_SOURCE_OBJECTS_KEY = "objects";
    private static final String WIKIPEDIA_DATA_1 = "wikipedia_index_data1.json";
    private static final String WIKIPEDIA_DATA_2 = "wikipedia_index_data2.json";
    private static final String WIKIPEDIA_DATA_3 = "wikipedia_index_data3.json";

    @DataProvider
    public static Object[][] resources() {
        return new Object[][]{{new Pair((Object)INPUT_SOURCE_URIS_KEY, (Object)ImmutableList.of((Object)"gs://%%BUCKET%%/%%PATH%%wikipedia_index_data1.json", (Object)"gs://%%BUCKET%%/%%PATH%%wikipedia_index_data2.json", (Object)"gs://%%BUCKET%%/%%PATH%%wikipedia_index_data3.json"))}, {new Pair((Object)INPUT_SOURCE_PREFIXES_KEY, (Object)ImmutableList.of((Object)"gs://%%BUCKET%%/%%PATH%%"))}, {new Pair((Object)INPUT_SOURCE_OBJECTS_KEY, (Object)ImmutableList.of((Object)ImmutableMap.of((Object)"bucket", (Object)"%%BUCKET%%", (Object)"path", (Object)"%%PATH%%wikipedia_index_data1.json"), (Object)ImmutableMap.of((Object)"bucket", (Object)"%%BUCKET%%", (Object)"path", (Object)"%%PATH%%wikipedia_index_data2.json"), (Object)ImmutableMap.of((Object)"bucket", (Object)"%%BUCKET%%", (Object)"path", (Object)"%%PATH%%wikipedia_index_data3.json")))}};
    }

    void doTest(Pair<String, List> gcsInputSource, Pair<Boolean, Boolean> segmentAvailabilityConfirmationPair) throws Exception {
        String indexDatasource = "wikipedia_index_test_" + UUID.randomUUID();
        try (Closeable ignored1 = this.unloader(indexDatasource + this.config.getExtraDatasourceNameSuffix());){
            Function<String, String> gcsPropsTransform = spec -> {
                try {
                    String inputSourceValue = this.jsonMapper.writeValueAsString(gcsInputSource.rhs);
                    inputSourceValue = StringUtils.replace((String)inputSourceValue, (String)"%%BUCKET%%", (String)this.config.getCloudBucket());
                    inputSourceValue = StringUtils.replace((String)inputSourceValue, (String)"%%PATH%%", (String)this.config.getCloudPath());
                    spec = StringUtils.replace((String)spec, (String)"%%INPUT_FORMAT_TYPE%%", (String)AbstractITBatchIndexTest.InputFormatDetails.JSON.getInputFormatType());
                    spec = StringUtils.replace((String)spec, (String)"%%PARTITIONS_SPEC%%", (String)this.jsonMapper.writeValueAsString((Object)new DynamicPartitionsSpec(null, null)));
                    spec = StringUtils.replace((String)spec, (String)"%%INPUT_SOURCE_TYPE%%", (String)"google");
                    spec = StringUtils.replace((String)spec, (String)"%%INPUT_SOURCE_PROPERTY_KEY%%", (String)((String)gcsInputSource.lhs));
                    return StringUtils.replace((String)spec, (String)"%%INPUT_SOURCE_PROPERTY_VALUE%%", (String)inputSourceValue);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            };
            this.doIndexTest(indexDatasource, INDEX_TASK, gcsPropsTransform, INDEX_QUERIES_RESOURCE, false, true, true, segmentAvailabilityConfirmationPair);
        }
    }
}

