/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.tests.indexer;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.io.IOUtils;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.testing.IntegrationTestingConfig;
import org.apache.druid.testing.clients.CoordinatorResourceTestClient;
import org.apache.druid.testing.clients.OverlordResourceTestClient;
import org.apache.druid.testing.clients.TaskResponseObject;
import org.apache.druid.testing.utils.DataLoaderHelper;
import org.apache.druid.testing.utils.ITRetryUtil;
import org.apache.druid.testing.utils.SqlTestQueryHelper;
import org.apache.druid.testing.utils.TestQueryHelper;
import org.apache.druid.tests.indexer.ITRealtimeIndexTaskTest;
import org.joda.time.Interval;

public abstract class AbstractIndexerTest {
    private static final Logger LOG = new Logger(AbstractIndexerTest.class);
    @Inject
    protected CoordinatorResourceTestClient coordinator;
    @Inject
    protected OverlordResourceTestClient indexer;
    @Inject
    @Json
    protected ObjectMapper jsonMapper;
    @Inject
    @Smile
    protected ObjectMapper smileMapper;
    @Inject
    protected TestQueryHelper queryHelper;
    @Inject
    protected SqlTestQueryHelper sqlQueryHelper;
    @Inject
    protected DataLoaderHelper dataLoaderHelper;
    @Inject
    protected IntegrationTestingConfig config;

    protected Closeable unloader(String dataSource) {
        return () -> this.unloadAndKillData(dataSource);
    }

    protected void unloadAndKillData(String dataSource) {
        List allTasks = this.indexer.getCompleteTasksForDataSource(dataSource);
        for (TaskResponseObject task : allTasks) {
            if (!task.getStatus().isFailure()) continue;
            LOG.info("------- START Found failed task logging for taskId=" + task.getId() + " -------", new Object[0]);
            LOG.info("Start failed task log:", new Object[0]);
            LOG.info(this.indexer.getTaskLog(task.getId()), new Object[0]);
            LOG.info("End failed task log.", new Object[0]);
            LOG.info("Start failed task errorMsg:", new Object[0]);
            LOG.info(this.indexer.getTaskErrorMessage(task.getId()), new Object[0]);
            LOG.info("End failed task errorMsg.", new Object[0]);
            LOG.info("------- END Found failed task logging for taskId=" + task.getId() + " -------", new Object[0]);
        }
        List intervals = this.coordinator.getSegmentIntervals(dataSource);
        Collections.sort(intervals);
        String first = ((String)intervals.get(0)).split("/")[0];
        String last = ((String)intervals.get(intervals.size() - 1)).split("/")[1];
        this.unloadAndKillData(dataSource, first, last);
    }

    protected String submitIndexTask(String indexTask, String fullDatasourceName) throws Exception {
        String taskSpec = AbstractIndexerTest.getResourceAsString(indexTask);
        taskSpec = StringUtils.replace((String)taskSpec, (String)"%%DATASOURCE%%", (String)fullDatasourceName);
        taskSpec = StringUtils.replace((String)taskSpec, (String)"%%SEGMENT_AVAIL_TIMEOUT_MILLIS%%", (String)this.jsonMapper.writeValueAsString((Object)"0"));
        String taskID = this.indexer.submitTask(taskSpec);
        LOG.info("TaskID for loading index task %s", new Object[]{taskID});
        return taskID;
    }

    protected void loadData(String indexTask, String fullDatasourceName) throws Exception {
        String taskID = this.submitIndexTask(indexTask, fullDatasourceName);
        this.indexer.waitUntilTaskCompletes(taskID);
        ITRetryUtil.retryUntilTrue(() -> this.coordinator.areSegmentsLoaded(fullDatasourceName), (String)"Segment Load");
    }

    private void unloadAndKillData(final String dataSource, String start, String end) {
        this.waitForAllTasksToCompleteForDataSource(dataSource);
        Interval interval = Intervals.of((String)(start + "/" + end));
        this.coordinator.unloadSegmentsForDataSource(dataSource);
        ITRetryUtil.retryUntilFalse((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return AbstractIndexerTest.this.coordinator.areSegmentsLoaded(dataSource);
            }
        }, (String)"Segment Unloading");
        this.coordinator.deleteSegmentsDataSource(dataSource, interval);
        this.waitForAllTasksToCompleteForDataSource(dataSource);
    }

    protected void waitForAllTasksToCompleteForDataSource(String dataSource) {
        ITRetryUtil.retryUntilTrue(() -> this.indexer.getUncompletedTasksForDataSource(dataSource).size() == 0, (String)StringUtils.format((String)"Waiting for all tasks of [%s] to complete", (Object[])new Object[]{dataSource}));
    }

    public static String getResourceAsString(String file) throws IOException {
        try (InputStream inputStream = AbstractIndexerTest.getResourceAsStream(file);){
            if (inputStream == null) {
                throw new ISE("Failed to load resource: [%s]", new Object[]{file});
            }
            String string = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }

    public static InputStream getResourceAsStream(String resource) {
        return ITRealtimeIndexTaskTest.class.getResourceAsStream(resource);
    }

    public static List<String> listResources(String dir) throws IOException {
        ArrayList<String> resources = new ArrayList<String>();
        try (InputStream in = AbstractIndexerTest.getResourceAsStream(dir);
             BufferedReader br = new BufferedReader(new InputStreamReader(in, StringUtils.UTF8_STRING));){
            String resource;
            while ((resource = br.readLine()) != null) {
                resources.add(resource);
            }
        }
        return resources;
    }
}

