/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.tests.indexer;

import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.testing.guice.DruidTestModuleFactory;
import org.apache.druid.tests.indexer.AbstractITBatchIndexTest;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Test(groups={"batch-index"})
@Guice(moduleFactory=DruidTestModuleFactory.class)
public class ITOverwriteBatchIndexTest
extends AbstractITBatchIndexTest {
    private static final String INDEX_TASK = "/indexer/wikipedia_local_input_source_index_task.json";
    private static final String INDEX_QUERIES_ALL_INGESTION_RESOURCE = "/indexer/wikipedia_index_queries.json";
    private static final String INDEX_QUERIES_WITH_DROP_INGESTION_RESOURCE = "/indexer/wikipedia_index_queries_only_data3.json";
    private static final AbstractITBatchIndexTest.InputFormatDetails INPUT_FORMAT_DETAILS = AbstractITBatchIndexTest.InputFormatDetails.JSON;
    private static final String ALL_DATA = "*" + INPUT_FORMAT_DETAILS.getFileExtension();
    private static final String ONE_DAY_DATA = "wikipedia_index_data3" + INPUT_FORMAT_DETAILS.getFileExtension();

    @Test
    public void doIndexTestWithOverwriteAndDrop() throws Exception {
        String indexDatasource = "wikipedia_index_test_" + UUID.randomUUID();
        try (Closeable ignored1 = this.unloader(indexDatasource + this.config.getExtraDatasourceNameSuffix());){
            this.submitIngestionTaskAndVerify(indexDatasource, ALL_DATA, true);
            this.verifySegmentsCountAndLoaded(indexDatasource, 4, 0);
            this.doTestQuery(indexDatasource, INDEX_QUERIES_ALL_INGESTION_RESOURCE);
            this.submitIngestionTaskAndVerify(indexDatasource, ONE_DAY_DATA, true);
            this.verifySegmentsCountAndLoaded(indexDatasource, 2, 1);
            this.doTestQuery(indexDatasource, INDEX_QUERIES_WITH_DROP_INGESTION_RESOURCE);
        }
    }

    @Test
    public void doIndexTestWithOverwriteAndNoDrop() throws Exception {
        String indexDatasource = "wikipedia_index_test_" + UUID.randomUUID();
        try (Closeable ignored1 = this.unloader(indexDatasource + this.config.getExtraDatasourceNameSuffix());){
            this.submitIngestionTaskAndVerify(indexDatasource, ALL_DATA, false);
            this.verifySegmentsCountAndLoaded(indexDatasource, 4, 0);
            this.doTestQuery(indexDatasource, INDEX_QUERIES_ALL_INGESTION_RESOURCE);
            this.submitIngestionTaskAndVerify(indexDatasource, ONE_DAY_DATA, false);
            this.verifySegmentsCountAndLoaded(indexDatasource, 3, 0);
            this.doTestQuery(indexDatasource, INDEX_QUERIES_ALL_INGESTION_RESOURCE);
        }
    }

    private void submitIngestionTaskAndVerify(String indexDatasource, String fileFilter, boolean dropExisting) throws Exception {
        ImmutableMap inputFormatMap = new ImmutableMap.Builder().put((Object)"type", (Object)INPUT_FORMAT_DETAILS.getInputFormatType()).build();
        Function<String, String> sqlInputSourcePropsTransform = arg_0 -> this.lambda$submitIngestionTaskAndVerify$0(fileFilter, (Map)inputFormatMap, dropExisting, arg_0);
        this.doIndexTest(indexDatasource, INDEX_TASK, sqlInputSourcePropsTransform, null, false, false, true, (Pair<Boolean, Boolean>)new Pair((Object)false, (Object)false));
    }

    private /* synthetic */ String lambda$submitIngestionTaskAndVerify$0(String fileFilter, Map inputFormatMap, boolean dropExisting, String spec) {
        try {
            spec = StringUtils.replace((String)spec, (String)"%%PARTITIONS_SPEC%%", (String)this.jsonMapper.writeValueAsString((Object)new DynamicPartitionsSpec(null, null)));
            spec = StringUtils.replace((String)spec, (String)"%%INPUT_SOURCE_FILTER%%", (String)fileFilter);
            spec = StringUtils.replace((String)spec, (String)"%%INPUT_SOURCE_BASE_DIR%%", (String)("/resources/data/batch_index" + INPUT_FORMAT_DETAILS.getFolderSuffix()));
            spec = StringUtils.replace((String)spec, (String)"%%INPUT_FORMAT%%", (String)this.jsonMapper.writeValueAsString((Object)inputFormatMap));
            spec = StringUtils.replace((String)spec, (String)"%%APPEND_TO_EXISTING%%", (String)this.jsonMapper.writeValueAsString((Object)false));
            spec = StringUtils.replace((String)spec, (String)"%%DROP_EXISTING%%", (String)this.jsonMapper.writeValueAsString((Object)dropExisting));
            spec = StringUtils.replace((String)spec, (String)"%%FORCE_GUARANTEED_ROLLUP%%", (String)this.jsonMapper.writeValueAsString((Object)false));
            return spec;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

