/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.tests.indexer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.inject.Inject;
import java.io.Closeable;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.testing.clients.CoordinatorResourceTestClient;
import org.apache.druid.testing.guice.DruidTestModuleFactory;
import org.apache.druid.testing.utils.ITRetryUtil;
import org.apache.druid.tests.indexer.AbstractITBatchIndexTest;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(moduleFactory=DruidTestModuleFactory.class)
public class ITTestCoordinatorPausedTest
extends AbstractITBatchIndexTest {
    private static final Logger LOG = new Logger(ITTestCoordinatorPausedTest.class);
    private static final String INDEX_DATASOURCE = "wikipedia_index_test";
    private static final String INDEX_TASK = "/indexer/wikipedia_index_task.json";
    private static final String INDEX_QUERIES_RESOURCE = "/indexer/wikipedia_index_queries.json";
    private static final CoordinatorDynamicConfig DYNAMIC_CONFIG_PAUSED = CoordinatorDynamicConfig.builder().withPauseCoordination(true).build();
    private static final CoordinatorDynamicConfig DYNAMIC_CONFIG_DEFAULT = CoordinatorDynamicConfig.builder().build();
    @Inject
    CoordinatorResourceTestClient coordinatorClient;

    @Test
    public void testCoordinatorPause() throws Exception {
        try (Closeable ignored1 = this.unloader(INDEX_DATASOURCE + this.config.getExtraDatasourceNameSuffix());){
            this.coordinatorClient.postDynamicConfig(DYNAMIC_CONFIG_PAUSED);
            Function<String, String> transform = spec -> {
                try {
                    return StringUtils.replace((String)spec, (String)"%%SEGMENT_AVAIL_TIMEOUT_MILLIS%%", (String)this.jsonMapper.writeValueAsString((Object)"0"));
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            };
            this.doIndexTest(INDEX_DATASOURCE, INDEX_TASK, transform, INDEX_QUERIES_RESOURCE, false, false, false, (Pair<Boolean, Boolean>)new Pair((Object)false, (Object)false));
            TimeUnit.MINUTES.sleep(3L);
            if (this.coordinatorClient.areSegmentsLoaded(INDEX_DATASOURCE)) {
                throw new IllegalStateException("Segments Were Loaded Early!");
            }
            this.coordinatorClient.postDynamicConfig(DYNAMIC_CONFIG_DEFAULT);
            ITRetryUtil.retryUntilTrue(() -> this.coordinator.areSegmentsLoaded(INDEX_DATASOURCE + this.config.getExtraDatasourceNameSuffix()), (String)"Segment Load");
        }
    }
}

