/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.tests.query;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.List;
import org.apache.druid.curator.discovery.ServerDiscoveryFactory;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.server.coordinator.rules.ForeverBroadcastDistributionRule;
import org.apache.druid.testing.IntegrationTestingConfig;
import org.apache.druid.testing.clients.CoordinatorResourceTestClient;
import org.apache.druid.testing.guice.DruidTestModuleFactory;
import org.apache.druid.testing.guice.TestClient;
import org.apache.druid.testing.utils.DataLoaderHelper;
import org.apache.druid.testing.utils.ITRetryUtil;
import org.apache.druid.testing.utils.SqlTestQueryHelper;
import org.apache.druid.tests.indexer.AbstractIndexerTest;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Test(groups={"query"})
@Guice(moduleFactory=DruidTestModuleFactory.class)
public class ITBroadcastJoinQueryTest
extends AbstractIndexerTest {
    private static final Logger LOG = new Logger(ITBroadcastJoinQueryTest.class);
    private static final String BROADCAST_JOIN_TASK = "/indexer/broadcast_join_index_task.json";
    private static final String BROADCAST_JOIN_METADATA_QUERIES_RESOURCE = "/queries/broadcast_join_metadata_queries.json";
    private static final String BROADCAST_JOIN_METADATA_QUERIES_AFTER_DROP_RESOURCE = "/queries/broadcast_join_after_drop_metadata_queries.json";
    private static final String BROADCAST_JOIN_QUERIES_RESOURCE = "/queries/broadcast_join_queries.json";
    private static final String BROADCAST_JOIN_DATASOURCE = "broadcast_join_wikipedia_test";
    @Inject
    ServerDiscoveryFactory factory;
    @Inject
    CoordinatorResourceTestClient coordinatorClient;
    @Inject
    SqlTestQueryHelper queryHelper;
    @Inject
    DataLoaderHelper dataLoaderHelper;
    @Inject
    @TestClient
    HttpClient httpClient;
    @Inject
    IntegrationTestingConfig config;

    @Test
    public void testBroadcastJoin() throws Exception {
        Closer closer = Closer.create();
        try {
            closer.register(this.unloader(BROADCAST_JOIN_DATASOURCE));
            closer.register(() -> {
                try {
                    this.coordinatorClient.postLoadRules(BROADCAST_JOIN_DATASOURCE, (List)ImmutableList.of());
                }
                catch (Exception e) {
                    LOG.error((Throwable)e, "Failed to post load rules", new Object[0]);
                }
            });
            this.coordinatorClient.postLoadRules(BROADCAST_JOIN_DATASOURCE, (List)ImmutableList.of((Object)new ForeverBroadcastDistributionRule()));
            String taskJson = ITBroadcastJoinQueryTest.replaceJoinTemplate(ITBroadcastJoinQueryTest.getResourceAsString(BROADCAST_JOIN_TASK), BROADCAST_JOIN_DATASOURCE);
            this.indexer.submitTask(taskJson);
            this.dataLoaderHelper.waitUntilDatasourceIsReady(BROADCAST_JOIN_DATASOURCE);
            ITRetryUtil.retryUntilTrue(() -> {
                try {
                    this.queryHelper.testQueriesFromString(this.queryHelper.getQueryURL(this.config.getRouterUrl()), ITBroadcastJoinQueryTest.replaceJoinTemplate(ITBroadcastJoinQueryTest.getResourceAsString(BROADCAST_JOIN_METADATA_QUERIES_RESOURCE), BROADCAST_JOIN_DATASOURCE));
                    return true;
                }
                catch (Exception ex) {
                    LOG.error((Throwable)ex, "SQL metadata not yet in expected state", new Object[0]);
                    return false;
                }
            }, (String)"waiting for SQL metadata refresh");
            this.queryHelper.testQueriesFromString(this.queryHelper.getQueryURL(this.config.getRouterUrl()), ITBroadcastJoinQueryTest.replaceJoinTemplate(ITBroadcastJoinQueryTest.getResourceAsString(BROADCAST_JOIN_QUERIES_RESOURCE), BROADCAST_JOIN_DATASOURCE));
        }
        finally {
            closer.close();
            ITRetryUtil.retryUntilTrue(() -> {
                try {
                    this.queryHelper.testQueriesFromString(this.queryHelper.getQueryURL(this.config.getRouterUrl()), ITBroadcastJoinQueryTest.replaceJoinTemplate(ITBroadcastJoinQueryTest.getResourceAsString(BROADCAST_JOIN_METADATA_QUERIES_AFTER_DROP_RESOURCE), BROADCAST_JOIN_DATASOURCE));
                    return true;
                }
                catch (Exception ex) {
                    LOG.error((Throwable)ex, "SQL metadata not yet in expected state", new Object[0]);
                    return false;
                }
            }, (String)"waiting for SQL metadata refresh");
        }
    }

    private static String replaceJoinTemplate(String template, String joinDataSource) {
        return StringUtils.replace((String)StringUtils.replace((String)template, (String)"%%JOIN_DATASOURCE%%", (String)joinDataSource), (String)"%%REGULAR_DATASOURCE%%", (String)"wikipedia_editstream");
    }
}

