/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.clients;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.java.util.http.client.response.StatusResponseHandler;
import org.apache.druid.java.util.http.client.response.StatusResponseHolder;
import org.apache.druid.testing.guice.TestClient;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public class EventReceiverFirehoseTestClient {
    private static final Logger LOG = new Logger(EventReceiverFirehoseTestClient.class);
    static final int NUM_RETRIES = 30;
    static final long DELAY_FOR_RETRIES_MS = 10000L;
    private final String host;
    private final ObjectMapper jsonMapper;
    private final HttpClient httpClient;
    private final String chatID;
    private final ObjectMapper smileMapper;

    public EventReceiverFirehoseTestClient(String host, String chatID, ObjectMapper jsonMapper, @TestClient HttpClient httpClient, ObjectMapper smileMapper) {
        this.host = host;
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.chatID = chatID;
        this.smileMapper = smileMapper;
    }

    private String getURL() {
        return StringUtils.format((String)"https://%s/druid/worker/v1/chat/%s/push-events/", (Object[])new Object[]{this.host, this.chatID});
    }

    /*
     * Loose catch block
     */
    public int postEvents(Collection<Map<String, Object>> events, ObjectMapper objectMapper, String mediaType) throws InterruptedException {
        int retryCount = 0;
        while (true) {
            try {
                StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.POST, new URL(this.getURL())).setContent(mediaType, objectMapper.writeValueAsBytes(events)), (HttpResponseHandler)StatusResponseHandler.getInstance()).get();
                if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
                    throw new ISE("Error while posting events to url[%s] status[%s] content[%s]", new Object[]{this.getURL(), response.getStatus(), response.getContent()});
                }
                Map responseData = (Map)objectMapper.readValue(response.getContent(), (TypeReference)new TypeReference<Map<String, Integer>>(){});
                return (Integer)responseData.get("eventCount");
            }
            catch (ExecutionException e) {
                if (retryCount > 30) {
                    throw new RuntimeException(e);
                }
                LOG.info((Throwable)e, "received exception, sleeping and retrying", new Object[0]);
                ++retryCount;
                Thread.sleep(10000L);
                continue;
            }
            break;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int postEventsFromFile(String file) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(EventReceiverFirehoseTestClient.class.getResourceAsStream(file), StandardCharsets.UTF_8));){
            String s;
            ArrayList<Map<String, Object>> events = new ArrayList<Map<String, Object>>();
            int totalEventsPosted = 0;
            int expectedEventsPosted = 0;
            while ((s = reader.readLine()) != null) {
                events.add((Map<String, Object>)this.jsonMapper.readValue(s, JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT));
                ObjectMapper mapper = totalEventsPosted % 2 == 0 ? this.jsonMapper : this.smileMapper;
                String mediaType = totalEventsPosted % 2 == 0 ? "application/json" : "application/x-jackson-smile";
                totalEventsPosted += this.postEvents(events, mapper, mediaType);
                expectedEventsPosted += events.size();
                events = new ArrayList();
            }
            if (totalEventsPosted != expectedEventsPosted) {
                throw new ISE("All events not posted, expected : %d actual : %d", new Object[]{events.size(), totalEventsPosted});
            }
            int n = totalEventsPosted;
            return n;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

