/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.utils;

import com.google.inject.Inject;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.testing.clients.CoordinatorResourceTestClient;
import org.apache.druid.testing.utils.ITRetryUtil;
import org.apache.druid.testing.utils.SqlTestQueryHelper;

public final class DataLoaderHelper {
    @Inject
    private SqlTestQueryHelper sqlTestQueryHelper;
    @Inject
    private CoordinatorResourceTestClient coordinator;

    public void waitUntilDatasourceIsReady(String datasource) {
        ITRetryUtil.retryUntilTrue(() -> this.coordinator.areSegmentsLoaded(datasource), StringUtils.format((String)"Segment Load for datasource [%s]", (Object[])new Object[]{datasource}));
        ITRetryUtil.retryUntilTrue(() -> this.sqlTestQueryHelper.isDatasourceLoadedInSQL(datasource), StringUtils.format((String)"Waiting for [%s] to be ready for SQL queries", (Object[])new Object[]{datasource}));
    }
}

