/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.sql.http.SqlQuery;
import org.apache.druid.testing.IntegrationTestingConfig;
import org.apache.druid.testing.clients.SqlResourceTestClient;
import org.apache.druid.testing.utils.AbstractTestQueryHelper;
import org.apache.druid.testing.utils.SqlQueryWithResults;

public class SqlTestQueryHelper
extends AbstractTestQueryHelper<SqlQueryWithResults> {
    private static final Logger LOG = new Logger(SqlTestQueryHelper.class);

    @Inject
    public SqlTestQueryHelper(ObjectMapper jsonMapper, SqlResourceTestClient sqlClient, IntegrationTestingConfig config) {
        super(jsonMapper, sqlClient, config);
    }

    @Override
    public String getQueryURL(String schemeAndHost) {
        return StringUtils.format((String)"%s/druid/v2/sql", (Object[])new Object[]{schemeAndHost});
    }

    public boolean isDatasourceLoadedInSQL(String datasource) {
        SqlQuery query = new SqlQuery("SELECT 1 FROM \"" + datasource + "\" LIMIT 1", null, false, false, false, null, null);
        try {
            this.queryClient.query(this.getQueryURL(this.broker), query);
            return true;
        }
        catch (Exception e) {
            LOG.debug((Throwable)e, "Check query failed", new Object[0]);
            return false;
        }
    }
}

