/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.tests.indexer;

import com.google.inject.Inject;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.druid.curator.discovery.ServerDiscoveryFactory;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.testing.IntegrationTestingConfig;
import org.apache.druid.testing.guice.TestClient;
import org.apache.druid.testing.utils.ITRetryUtil;
import org.apache.druid.tests.indexer.AbstractIndexerTest;
import org.apache.druid.tests.indexer.ITRealtimeIndexTaskTest;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public abstract class AbstractITRealtimeIndexTaskTest
extends AbstractIndexerTest {
    static final String EVENT_RECEIVER_SERVICE_NAME = "eventReceiverServiceName";
    static final String EVENT_DATA_FILE = "/indexer/wikipedia_realtime_index_data.json";
    private static final Logger LOG = new Logger(AbstractITRealtimeIndexTaskTest.class);
    private static final String INDEX_DATASOURCE = "wikipedia_index_test";
    static final int DELAY_BETWEEN_EVENTS_SECS = 4;
    final String TIME_PLACEHOLDER = "YYYY-MM-DDTHH:MM:SS";
    static final DateTimeFormatter EVENT_FMT = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss");
    private static final DateTimeFormatter INTERVAL_FMT = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:'00Z'");
    private static final DateTimeFormatter TIMESTAMP_FMT = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss'.000Z'");
    DateTime dtFirst;
    DateTime dtLast;
    DateTime dtGroupBy;
    static final int NUM_RETRIES = 60;
    static final long DELAY_FOR_RETRIES_MS = 10000L;
    @Inject
    ServerDiscoveryFactory factory;
    @Inject
    @TestClient
    HttpClient httpClient;
    @Inject
    IntegrationTestingConfig config;
    private String fullDatasourceName;

    void doTest() {
        this.fullDatasourceName = INDEX_DATASOURCE + this.config.getExtraDatasourceNameSuffix();
        LOG.info("Starting test: %s", new Object[]{this.getClass().getSimpleName()});
        try (Closeable ignored = this.unloader(this.fullDatasourceName);){
            String query_response_template;
            String task = this.setShutOffTime(AbstractITRealtimeIndexTaskTest.getResourceAsString(this.getTaskResource()), DateTimes.utc((long)(System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(5L))));
            task = StringUtils.replace((String)task, (String)"%%DATASOURCE%%", (String)this.fullDatasourceName);
            LOG.info("indexerSpec: [%s]\n", new Object[]{task});
            String taskID = this.indexer.submitTask(task);
            TimeUnit.SECONDS.sleep(60L);
            this.postEvents();
            ITRetryUtil.retryUntil(() -> {
                int countRows = this.queryHelper.countRows(this.fullDatasourceName, Intervals.ETERNITY, name -> new LongSumAggregatorFactory(name, "count"));
                return countRows == this.getNumExpectedRowsIngested();
            }, (boolean)true, (long)10000L, (int)60, (String)"Waiting all events are ingested");
            InputStream is = ITRealtimeIndexTaskTest.class.getResourceAsStream(this.getQueriesResource());
            if (null == is) {
                throw new ISE("could not open query file: %s", new Object[]{this.getQueriesResource()});
            }
            String queryStr = query_response_template = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            queryStr = StringUtils.replace((String)queryStr, (String)"%%TIMEBOUNDARY_RESPONSE_TIMESTAMP%%", (String)TIMESTAMP_FMT.print((ReadableInstant)this.dtFirst));
            queryStr = StringUtils.replace((String)queryStr, (String)"%%TIMEBOUNDARY_RESPONSE_MAXTIME%%", (String)TIMESTAMP_FMT.print((ReadableInstant)this.dtLast));
            queryStr = StringUtils.replace((String)queryStr, (String)"%%TIMEBOUNDARY_RESPONSE_MINTIME%%", (String)TIMESTAMP_FMT.print((ReadableInstant)this.dtFirst));
            queryStr = StringUtils.replace((String)queryStr, (String)"%%TIMESERIES_QUERY_START%%", (String)INTERVAL_FMT.print((ReadableInstant)this.dtFirst));
            queryStr = StringUtils.replace((String)queryStr, (String)"%%TIMESERIES_QUERY_END%%", (String)INTERVAL_FMT.print((ReadableInstant)this.dtLast.plusMinutes(2)));
            queryStr = StringUtils.replace((String)queryStr, (String)"%%TIMESERIES_RESPONSE_TIMESTAMP%%", (String)TIMESTAMP_FMT.print((ReadableInstant)this.dtFirst));
            queryStr = StringUtils.replace((String)queryStr, (String)"%%POST_AG_REQUEST_START%%", (String)INTERVAL_FMT.print((ReadableInstant)this.dtFirst));
            queryStr = StringUtils.replace((String)queryStr, (String)"%%POST_AG_REQUEST_END%%", (String)INTERVAL_FMT.print((ReadableInstant)this.dtLast.plusMinutes(2)));
            String postAgResponseTimestamp = TIMESTAMP_FMT.print((ReadableInstant)this.dtGroupBy.withSecondOfMinute(0));
            queryStr = StringUtils.replace((String)queryStr, (String)"%%POST_AG_RESPONSE_TIMESTAMP%%", (String)postAgResponseTimestamp);
            queryStr = StringUtils.replace((String)queryStr, (String)"%%DATASOURCE%%", (String)this.fullDatasourceName);
            try {
                this.queryHelper.testQueriesFromString(this.getRouterURL(), queryStr);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.indexer.waitUntilTaskCompletes(taskID);
            ITRetryUtil.retryUntil(() -> this.coordinator.areSegmentsLoaded(this.fullDatasourceName), (boolean)true, (long)10000L, (int)60, (String)"Real-time generated segments loaded");
            this.queryHelper.testQueriesFromString(this.getRouterURL(), queryStr);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String setShutOffTime(String taskAsString, DateTime time) {
        return StringUtils.replace((String)taskAsString, (String)"#SHUTOFFTIME", (String)time.toString());
    }

    private String getRouterURL() {
        return StringUtils.format((String)"%s/druid/v2?pretty", (Object[])new Object[]{this.config.getRouterUrl()});
    }

    abstract String getTaskResource();

    abstract String getQueriesResource();

    abstract void postEvents() throws Exception;

    abstract int getNumExpectedRowsIngested();
}

