/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.tests.indexer;

import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.testing.IntegrationTestingConfig;
import org.apache.druid.testing.utils.KinesisAdminClient;
import org.apache.druid.testing.utils.KinesisEventWriter;
import org.apache.druid.testing.utils.StreamAdminClient;
import org.apache.druid.testing.utils.StreamEventWriter;
import org.apache.druid.tests.indexer.AbstractStreamIndexingTest;
import org.joda.time.ReadableInstant;

public abstract class AbstractKinesisIndexingServiceTest
extends AbstractStreamIndexingTest {
    private static final Logger LOG = new Logger(AbstractKinesisIndexingServiceTest.class);

    @Override
    StreamAdminClient createStreamAdminClient(IntegrationTestingConfig config) throws Exception {
        return new KinesisAdminClient(config.getStreamEndpoint());
    }

    @Override
    StreamEventWriter createStreamEventWriter(IntegrationTestingConfig config, @Nullable Boolean transactionEnabled) throws Exception {
        if (transactionEnabled != null) {
            LOG.warn("Kinesis event writer doesn't support transaction. Ignoring the given parameter transactionEnabled[%s]", new Object[]{transactionEnabled});
        }
        return new KinesisEventWriter(config.getStreamEndpoint(), false);
    }

    @Override
    Function<String, String> generateStreamIngestionPropsTransform(String streamName, String fullDatasourceName, String parserType, String parserOrInputFormat, List<String> dimensions, IntegrationTestingConfig config) {
        return spec -> {
            try {
                spec = StringUtils.replace((String)spec, (String)"%%DATASOURCE%%", (String)fullDatasourceName);
                spec = StringUtils.replace((String)spec, (String)"%%STREAM_TYPE%%", (String)"kinesis");
                spec = StringUtils.replace((String)spec, (String)"%%TOPIC_KEY%%", (String)"stream");
                spec = StringUtils.replace((String)spec, (String)"%%TOPIC_VALUE%%", (String)streamName);
                if ("inputFormat".equals(parserType)) {
                    spec = StringUtils.replace((String)spec, (String)"%%INPUT_FORMAT%%", (String)parserOrInputFormat);
                    spec = StringUtils.replace((String)spec, (String)"%%PARSER%%", (String)"null");
                } else if ("parser".equals(parserType)) {
                    spec = StringUtils.replace((String)spec, (String)"%%PARSER%%", (String)parserOrInputFormat);
                    spec = StringUtils.replace((String)spec, (String)"%%INPUT_FORMAT%%", (String)"null");
                }
                spec = StringUtils.replace((String)spec, (String)"%%USE_EARLIEST_KEY%%", (String)"useEarliestSequenceNumber");
                spec = StringUtils.replace((String)spec, (String)"%%STREAM_PROPERTIES_KEY%%", (String)"endpoint");
                spec = StringUtils.replace((String)spec, (String)"%%SCHEMA_REGISTRY_HOST%%", (String)StringUtils.format((String)"http://%s", (Object[])new Object[]{config.getSchemaRegistryInternalHost()}));
                spec = StringUtils.replace((String)spec, (String)"%%DIMENSIONS%%", (String)this.jsonMapper.writeValueAsString((Object)dimensions));
                return StringUtils.replace((String)spec, (String)"%%STREAM_PROPERTIES_VALUE%%", (String)this.jsonMapper.writeValueAsString((Object)config.getStreamEndpoint()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    @Override
    Function<String, String> generateStreamQueryPropsTransform(String streamName, String fullDatasourceName) {
        return spec -> {
            try {
                spec = StringUtils.replace((String)spec, (String)"%%DATASOURCE%%", (String)fullDatasourceName);
                spec = StringUtils.replace((String)spec, (String)"%%TIMEBOUNDARY_RESPONSE_TIMESTAMP%%", (String)TIMESTAMP_FMT.print((ReadableInstant)FIRST_EVENT_TIME));
                spec = StringUtils.replace((String)spec, (String)"%%TIMEBOUNDARY_RESPONSE_MAXTIME%%", (String)TIMESTAMP_FMT.print((ReadableInstant)FIRST_EVENT_TIME.plusSeconds(9)));
                spec = StringUtils.replace((String)spec, (String)"%%TIMEBOUNDARY_RESPONSE_MINTIME%%", (String)TIMESTAMP_FMT.print((ReadableInstant)FIRST_EVENT_TIME));
                spec = StringUtils.replace((String)spec, (String)"%%TIMESERIES_QUERY_START%%", (String)INTERVAL_FMT.print((ReadableInstant)FIRST_EVENT_TIME));
                spec = StringUtils.replace((String)spec, (String)"%%TIMESERIES_QUERY_END%%", (String)INTERVAL_FMT.print((ReadableInstant)FIRST_EVENT_TIME.plusSeconds(9).plusMinutes(2)));
                spec = StringUtils.replace((String)spec, (String)"%%TIMESERIES_RESPONSE_TIMESTAMP%%", (String)TIMESTAMP_FMT.print((ReadableInstant)FIRST_EVENT_TIME));
                spec = StringUtils.replace((String)spec, (String)"%%TIMESERIES_ADDED%%", (String)Long.toString(this.getSumOfEventSequence(6) * 10L));
                return StringUtils.replace((String)spec, (String)"%%TIMESERIES_NUMEVENTS%%", (String)Integer.toString(60));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }
}

