/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.tests.indexer;

import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.testing.guice.DruidTestModuleFactory;
import org.apache.druid.tests.indexer.AbstractITBatchIndexTest;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Test(groups={"input-source"})
@Guice(moduleFactory=DruidTestModuleFactory.class)
public class ITSqlInputSourceTest
extends AbstractITBatchIndexTest {
    private static final String INDEX_TASK = "/indexer/wikipedia_parallel_index_using_sqlinputsource_task.json";
    private static final String INDEX_QUERIES_RESOURCE = "/indexer/wikipedia_index_queries.json";

    @DataProvider
    public static Object[][] resources() {
        return new Object[][]{{ImmutableList.of((Object)"SELECT * FROM wikipedia_index_data1", (Object)"SELECT * FROM wikipedia_index_data2", (Object)"SELECT * FROM wikipedia_index_data3")}, {ImmutableList.of((Object)"SELECT * FROM wikipedia_index_data1 WHERE timestamp BETWEEN '2013-08-31 00:00:00' AND '2013-09-02 00:00:00'", (Object)"SELECT * FROM wikipedia_index_data2 WHERE timestamp BETWEEN '2013-08-31 00:00:00' AND '2013-09-02 00:00:00'", (Object)"SELECT * FROM wikipedia_index_data3 WHERE timestamp BETWEEN '2013-09-01 00:00:00' AND '2013-09-02 00:00:00'")}, {ImmutableList.of((Object)"SELECT * FROM wikipedia_index_data1 WHERE added > 0", (Object)"SELECT * FROM wikipedia_index_data2 WHERE added > 0", (Object)"SELECT * FROM wikipedia_index_data3 WHERE added > 0")}, {ImmutableList.of((Object)"SELECT * FROM wikipedia_index_data_all")}, {ImmutableList.of((Object)"SELECT * FROM wikipedia_index_data_all WHERE timestamp BETWEEN '2013-08-31 00:00:00' AND '2013-09-02 00:00:00'")}, {ImmutableList.of((Object)"SELECT * FROM wikipedia_index_data_all WHERE added > 0")}};
    }

    @Test(dataProvider="resources")
    public void testIndexData(List<String> sqlQueries) throws Exception {
        String indexDatasource = "wikipedia_index_test_" + UUID.randomUUID();
        try (Closeable ignored1 = this.unloader(indexDatasource + this.config.getExtraDatasourceNameSuffix());){
            Function<String, String> sqlInputSourcePropsTransform = spec -> {
                try {
                    spec = StringUtils.replace((String)spec, (String)"%%PARTITIONS_SPEC%%", (String)this.jsonMapper.writeValueAsString((Object)new DynamicPartitionsSpec(null, null)));
                    return StringUtils.replace((String)spec, (String)"%%SQL_QUERY%%", (String)this.jsonMapper.writeValueAsString((Object)sqlQueries));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            };
            this.doIndexTest(indexDatasource, INDEX_TASK, sqlInputSourcePropsTransform, INDEX_QUERIES_RESOURCE, false, true, true, (Pair<Boolean, Boolean>)new Pair((Object)false, (Object)false));
        }
    }
}

