/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.tests.query;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.testing.guice.DruidTestModuleFactory;
import org.apache.druid.testing.utils.DataLoaderHelper;
import org.apache.druid.testing.utils.SqlTestQueryHelper;
import org.apache.druid.testing.utils.TestQueryHelper;
import org.apache.druid.tests.indexer.AbstractIndexerTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Test(groups={"query-error"})
@Guice(moduleFactory=DruidTestModuleFactory.class)
public class ITQueryErrorTest {
    private static final String WIKIPEDIA_DATA_SOURCE = "wikipedia_editstream";
    private static final String NATIVE_QUERY_RESOURCE = "/queries/native_query_error_from_historicals_test.json";
    private static final String SQL_QUERY_RESOURCE = "/queries/sql_error_from_historicals_test.json";
    private static final String SQL_PLAN_FAILURE_RESOURCE = "/queries/sql_plan_failure_query.json";
    @Inject
    private DataLoaderHelper dataLoaderHelper;
    @Inject
    private TestQueryHelper queryHelper;
    @Inject
    private SqlTestQueryHelper sqlHelper;
    @Inject
    private ObjectMapper jsonMapper;

    @BeforeMethod
    public void before() {
        this.dataLoaderHelper.waitUntilDatasourceIsReady(WIKIPEDIA_DATA_SOURCE);
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp="(?s).*400.*")
    public void testSqlParseException() throws Exception {
        this.sqlHelper.testQueriesFromString(this.buildSqlPlanFailureQuery("FROM t WHERE col = 'a'"));
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp="(?s).*400.*")
    public void testSqlValidationException() throws Exception {
        this.sqlHelper.testQueriesFromString(this.buildSqlPlanFailureQuery(StringUtils.format((String)"SELECT unknown_col FROM %s LIMIT 1", (Object[])new Object[]{WIKIPEDIA_DATA_SOURCE})));
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp="(?s).*504.*")
    public void testSqlTimeout() throws Exception {
        this.sqlHelper.testQueriesFromString(this.buildHistoricalErrorSqlQuery("query-timeout-test"));
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp="(?s).*429.*")
    public void testSqlCapacityExceeded() throws Exception {
        this.sqlHelper.testQueriesFromString(this.buildHistoricalErrorSqlQuery("query-capacity-exceeded-test"));
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp="(?s).*501.*")
    public void testSqlUnsupported() throws Exception {
        this.sqlHelper.testQueriesFromString(this.buildHistoricalErrorSqlQuery("query-unsupported-test"));
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp="(?s).*400.*")
    public void testSqlResourceLimitExceeded() throws Exception {
        this.sqlHelper.testQueriesFromString(this.buildHistoricalErrorSqlQuery("resource-limit-exceeded-test"));
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp="(?s).*500.*")
    public void testSqlFailure() throws Exception {
        this.sqlHelper.testQueriesFromString(this.buildHistoricalErrorSqlQuery("query-failure-test"));
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp="(?s).*504.*")
    public void testQueryTimeout() throws Exception {
        this.queryHelper.testQueriesFromString(this.buildHistoricalErrorTestQuery("query-timeout-test"));
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp="(?s).*429.*")
    public void testQueryCapacityExceeded() throws Exception {
        this.queryHelper.testQueriesFromString(this.buildHistoricalErrorTestQuery("query-capacity-exceeded-test"));
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp="(?s).*501.*")
    public void testQueryUnsupported() throws Exception {
        this.queryHelper.testQueriesFromString(this.buildHistoricalErrorTestQuery("query-unsupported-test"));
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp="(?s).*400.*")
    public void testResourceLimitExceeded() throws Exception {
        this.queryHelper.testQueriesFromString(this.buildHistoricalErrorTestQuery("resource-limit-exceeded-test"));
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp="(?s).*500.*")
    public void testQueryFailure() throws Exception {
        this.queryHelper.testQueriesFromString(this.buildHistoricalErrorTestQuery("query-failure-test"));
    }

    private String buildSqlPlanFailureQuery(String sql) throws IOException {
        return StringUtils.replace((String)AbstractIndexerTest.getResourceAsString(SQL_PLAN_FAILURE_RESOURCE), (String)"%%QUERY%%", (String)sql);
    }

    private String buildHistoricalErrorSqlQuery(String contextKey) throws IOException {
        return StringUtils.replace((String)AbstractIndexerTest.getResourceAsString(SQL_QUERY_RESOURCE), (String)"%%CONTEXT%%", (String)this.jsonMapper.writeValueAsString(ITQueryErrorTest.buildTestContext(contextKey)));
    }

    private String buildHistoricalErrorTestQuery(String contextKey) throws IOException {
        return StringUtils.replace((String)AbstractIndexerTest.getResourceAsString(NATIVE_QUERY_RESOURCE), (String)"%%CONTEXT%%", (String)this.jsonMapper.writeValueAsString(ITQueryErrorTest.buildTestContext(contextKey)));
    }

    private static Map<String, Object> buildTestContext(String key) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("useCache", false);
        context.put(key, true);
        return context;
    }
}

