/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.tests.indexer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.indexer.partitions.HashedPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexer.partitions.SingleDimensionPartitionsSpec;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.testing.guice.DruidTestModuleFactory;
import org.apache.druid.tests.indexer.AbstractITBatchIndexTest;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Test(groups={"append-ingestion"})
@Guice(moduleFactory=DruidTestModuleFactory.class)
public class ITAppendBatchIndexTest
extends AbstractITBatchIndexTest {
    private static final Logger LOG = new Logger(ITAppendBatchIndexTest.class);
    private static final String INDEX_TASK = "/indexer/wikipedia_local_input_source_index_task.json";
    private static final String INDEX_QUERIES_INITIAL_INGESTION_RESOURCE = "/indexer/wikipedia_index_queries.json";
    private static final String INDEX_QUERIES_POST_APPEND_PRE_COMPACT_RESOURCE = "/indexer/wikipedia_double_ingestion_non_perfect_rollup_index_queries.json";
    private static final String INDEX_QUERIES_POST_APPEND_POST_COMPACT_RESOURCE = "/indexer/wikipedia_double_ingestion_perfect_rollup_index_queries.json";
    private static final String COMPACTION_TASK = "/indexer/wikipedia_compaction_task.json";

    @DataProvider
    public static Object[][] resources() {
        return new Object[][]{{ImmutableList.of((Object)new DynamicPartitionsSpec(null, null), (Object)new DynamicPartitionsSpec(null, null)), ImmutableList.of((Object)4, (Object)8, (Object)2)}, {ImmutableList.of((Object)new HashedPartitionsSpec(null, Integer.valueOf(3), (List)ImmutableList.of((Object)"page", (Object)"user")), (Object)new DynamicPartitionsSpec(null, null)), ImmutableList.of((Object)6, (Object)10, (Object)2)}, {ImmutableList.of((Object)new SingleDimensionPartitionsSpec(Integer.valueOf(1000), null, "page", false), (Object)new DynamicPartitionsSpec(null, null)), ImmutableList.of((Object)2, (Object)6, (Object)2)}};
    }

    @Test(dataProvider="resources")
    public void doIndexTest(List<PartitionsSpec> partitionsSpecList, List<Integer> expectedSegmentCountList) throws Exception {
        String indexDatasource = "wikipedia_index_test_" + UUID.randomUUID();
        try (Closeable ignored1 = this.unloader(indexDatasource + this.config.getExtraDatasourceNameSuffix());){
            this.submitIngestionTaskAndVerify(indexDatasource, partitionsSpecList.get(0), false, (Pair<Boolean, Boolean>)new Pair((Object)false, (Object)false));
            this.verifySegmentsCountAndLoaded(indexDatasource, expectedSegmentCountList.get(0));
            this.doTestQuery(indexDatasource, INDEX_QUERIES_INITIAL_INGESTION_RESOURCE);
            this.submitIngestionTaskAndVerify(indexDatasource, partitionsSpecList.get(1), true, (Pair<Boolean, Boolean>)new Pair((Object)false, (Object)false));
            this.verifySegmentsCountAndLoaded(indexDatasource, expectedSegmentCountList.get(1));
            this.doTestQuery(indexDatasource, INDEX_QUERIES_POST_APPEND_PRE_COMPACT_RESOURCE);
            this.compactData(indexDatasource, COMPACTION_TASK);
            this.verifySegmentsCountAndLoaded(indexDatasource, expectedSegmentCountList.get(2));
            this.verifySegmentsCompacted(indexDatasource, expectedSegmentCountList.get(2));
            this.doTestQuery(indexDatasource, INDEX_QUERIES_POST_APPEND_POST_COMPACT_RESOURCE);
        }
    }

    private void submitIngestionTaskAndVerify(String indexDatasource, PartitionsSpec partitionsSpec, boolean appendToExisting, Pair<Boolean, Boolean> segmentAvailabilityConfirmationPair) throws Exception {
        AbstractITBatchIndexTest.InputFormatDetails inputFormatDetails = AbstractITBatchIndexTest.InputFormatDetails.JSON;
        ImmutableMap inputFormatMap = new ImmutableMap.Builder().put((Object)"type", (Object)inputFormatDetails.getInputFormatType()).build();
        Function<String, String> sqlInputSourcePropsTransform = arg_0 -> this.lambda$submitIngestionTaskAndVerify$0(partitionsSpec, inputFormatDetails, (Map)inputFormatMap, appendToExisting, arg_0);
        this.doIndexTest(indexDatasource, INDEX_TASK, sqlInputSourcePropsTransform, null, false, false, true, segmentAvailabilityConfirmationPair);
    }

    private /* synthetic */ String lambda$submitIngestionTaskAndVerify$0(PartitionsSpec partitionsSpec, AbstractITBatchIndexTest.InputFormatDetails inputFormatDetails, Map inputFormatMap, boolean appendToExisting, String spec) {
        try {
            spec = StringUtils.replace((String)spec, (String)"%%PARTITIONS_SPEC%%", (String)this.jsonMapper.writeValueAsString((Object)partitionsSpec));
            spec = StringUtils.replace((String)spec, (String)"%%INPUT_SOURCE_FILTER%%", (String)("*" + inputFormatDetails.getFileExtension()));
            spec = StringUtils.replace((String)spec, (String)"%%INPUT_SOURCE_BASE_DIR%%", (String)("/resources/data/batch_index" + inputFormatDetails.getFolderSuffix()));
            spec = StringUtils.replace((String)spec, (String)"%%INPUT_FORMAT%%", (String)this.jsonMapper.writeValueAsString((Object)inputFormatMap));
            spec = StringUtils.replace((String)spec, (String)"%%APPEND_TO_EXISTING%%", (String)this.jsonMapper.writeValueAsString((Object)appendToExisting));
            spec = StringUtils.replace((String)spec, (String)"%%DROP_EXISTING%%", (String)this.jsonMapper.writeValueAsString((Object)false));
            if (partitionsSpec instanceof DynamicPartitionsSpec) {
                spec = StringUtils.replace((String)spec, (String)"%%FORCE_GUARANTEED_ROLLUP%%", (String)this.jsonMapper.writeValueAsString((Object)false));
            } else if (partitionsSpec instanceof HashedPartitionsSpec || partitionsSpec instanceof SingleDimensionPartitionsSpec) {
                spec = StringUtils.replace((String)spec, (String)"%%FORCE_GUARANTEED_ROLLUP%%", (String)this.jsonMapper.writeValueAsString((Object)true));
            }
            return spec;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

