/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.tests.indexer;

import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.testing.IntegrationTestingConfig;
import org.apache.druid.testing.clients.ClientInfoResourceTestClient;
import org.apache.druid.testing.clients.CoordinatorResourceTestClient;
import org.apache.druid.testing.guice.DruidTestModuleFactory;
import org.apache.druid.testing.utils.ITRetryUtil;
import org.apache.druid.testing.utils.TestQueryHelper;
import org.apache.druid.tests.indexer.AbstractITBatchIndexTest;
import org.apache.druid.tests.indexer.AbstractIndexerTest;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Test(groups={"query"})
@Guice(moduleFactory=DruidTestModuleFactory.class)
public class ITNestedQueryPushDownTest
extends AbstractIndexerTest {
    private static final String WIKITICKER_DATA_SOURCE = "wikiticker";
    private static final String WIKITICKER_INDEX_TASK = "/indexer/wikiticker_index_task.json";
    private static final String WIKITICKER_QUERIES_RESOURCE = "/queries/nestedquerypushdown_queries.json";
    @Inject
    private CoordinatorResourceTestClient coordinatorClient;
    @Inject
    private TestQueryHelper queryHelper;
    private static final Logger LOG = new Logger(ITNestedQueryPushDownTest.class);
    @Inject
    private IntegrationTestingConfig config;
    @Inject
    ClientInfoResourceTestClient clientInfoResourceTestClient;
    private String fullDatasourceName;

    @BeforeSuite
    public void setFullDatasourceName() {
        this.fullDatasourceName = WIKITICKER_DATA_SOURCE + this.config.getExtraDatasourceNameSuffix();
    }

    @Test
    public void testIndexData() {
        try {
            String queryResponseTemplate;
            this.loadData();
            try {
                InputStream is = AbstractITBatchIndexTest.class.getResourceAsStream(WIKITICKER_QUERIES_RESOURCE);
                queryResponseTemplate = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new ISE((Throwable)e, "could not read query file: %s", new Object[]{WIKITICKER_QUERIES_RESOURCE});
            }
            queryResponseTemplate = StringUtils.replace((String)queryResponseTemplate, (String)"%%DATASOURCE%%", (String)this.fullDatasourceName);
            this.queryHelper.testQueriesFromString(queryResponseTemplate);
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "Error while testing", new Object[0]);
            throw new RuntimeException(e);
        }
    }

    private void loadData() throws Exception {
        String taskSpec = ITNestedQueryPushDownTest.getResourceAsString(WIKITICKER_INDEX_TASK);
        taskSpec = StringUtils.replace((String)taskSpec, (String)"%%DATASOURCE%%", (String)this.fullDatasourceName);
        String taskID = this.indexer.submitTask(taskSpec);
        LOG.info("TaskID for loading index task %s", new Object[]{taskID});
        this.indexer.waitUntilTaskCompletes(taskID);
        ITRetryUtil.retryUntilTrue(() -> this.coordinator.areSegmentsLoaded(this.fullDatasourceName), (String)"Segment Load");
    }
}

