/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.tests.security;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.ClosedChannelException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import org.apache.druid.guice.annotations.Client;
import org.apache.druid.guice.http.DruidHttpClientConfig;
import org.apache.druid.https.SSLClientConfig;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.http.client.CredentialedHttpClient;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.HttpClientConfig;
import org.apache.druid.java.util.http.client.HttpClientInit;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.auth.BasicCredentials;
import org.apache.druid.java.util.http.client.auth.Credentials;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.java.util.http.client.response.StatusResponseHandler;
import org.apache.druid.java.util.http.client.response.StatusResponseHolder;
import org.apache.druid.server.security.TLSCertificateChecker;
import org.apache.druid.server.security.TLSUtils;
import org.apache.druid.testing.IntegrationTestingConfig;
import org.apache.druid.testing.guice.DruidTestModuleFactory;
import org.apache.druid.testing.utils.ITTLSCertificateChecker;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.joda.time.Duration;
import org.testng.Assert;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Test(groups={"security"})
@Guice(moduleFactory=DruidTestModuleFactory.class)
public class ITTLSTest {
    private static final Logger LOG = new Logger(ITTLSTest.class);
    private static final Duration SSL_HANDSHAKE_TIMEOUT = new Duration(30000L);
    private static final int MAX_CONNECTION_EXCEPTION_RETRIES = 30;
    @Inject
    IntegrationTestingConfig config;
    @Inject
    ObjectMapper jsonMapper;
    @Inject
    SSLClientConfig sslClientConfig;
    @Inject
    @Client
    HttpClient httpClient;
    @Inject
    @Client
    DruidHttpClientConfig httpClientConfig;
    @Inject
    TLSCertificateChecker certificateChecker;

    @Test
    public void testPlaintextAccess() {
        LOG.info("---------Testing resource access without TLS---------", new Object[0]);
        CredentialedHttpClient adminClient = new CredentialedHttpClient((Credentials)new BasicCredentials("admin", "priest"), this.httpClient);
        this.makeRequest((HttpClient)adminClient, HttpMethod.GET, this.config.getCoordinatorUrl() + "/status", null);
        this.makeRequest((HttpClient)adminClient, HttpMethod.GET, this.config.getOverlordUrl() + "/status", null);
        this.makeRequest((HttpClient)adminClient, HttpMethod.GET, this.config.getBrokerUrl() + "/status", null);
        this.makeRequest((HttpClient)adminClient, HttpMethod.GET, this.config.getHistoricalUrl() + "/status", null);
        this.makeRequest((HttpClient)adminClient, HttpMethod.GET, this.config.getRouterUrl() + "/status", null);
        this.makeRequest((HttpClient)adminClient, HttpMethod.GET, this.config.getPermissiveRouterUrl() + "/status", null);
        this.makeRequest((HttpClient)adminClient, HttpMethod.GET, this.config.getNoClientAuthRouterUrl() + "/status", null);
    }

    @Test
    public void testTLSNodeAccess() {
        LOG.info("---------Testing resource access with TLS enabled---------", new Object[0]);
        CredentialedHttpClient adminClient = new CredentialedHttpClient((Credentials)new BasicCredentials("admin", "priest"), this.httpClient);
        this.makeRequest((HttpClient)adminClient, HttpMethod.GET, this.config.getCoordinatorTLSUrl() + "/status", null);
        this.makeRequest((HttpClient)adminClient, HttpMethod.GET, this.config.getOverlordTLSUrl() + "/status", null);
        this.makeRequest((HttpClient)adminClient, HttpMethod.GET, this.config.getBrokerTLSUrl() + "/status", null);
        this.makeRequest((HttpClient)adminClient, HttpMethod.GET, this.config.getHistoricalTLSUrl() + "/status", null);
        this.makeRequest((HttpClient)adminClient, HttpMethod.GET, this.config.getRouterTLSUrl() + "/status", null);
        this.makeRequest((HttpClient)adminClient, HttpMethod.GET, this.config.getPermissiveRouterTLSUrl() + "/status", null);
        this.makeRequest((HttpClient)adminClient, HttpMethod.GET, this.config.getNoClientAuthRouterTLSUrl() + "/status", null);
    }

    @Test
    public void testTLSNodeAccessWithIntermediate() {
        LOG.info("---------Testing TLS resource access with 3-part cert chain---------", new Object[0]);
        HttpClient intermediateCertClient = this.makeCustomHttpClient("client_tls/intermediate_ca_client.jks", "intermediate_ca_client");
        this.makeRequest(intermediateCertClient, HttpMethod.GET, this.config.getCoordinatorTLSUrl() + "/status", null);
        this.makeRequest(intermediateCertClient, HttpMethod.GET, this.config.getOverlordTLSUrl() + "/status", null);
        this.makeRequest(intermediateCertClient, HttpMethod.GET, this.config.getBrokerTLSUrl() + "/status", null);
        this.makeRequest(intermediateCertClient, HttpMethod.GET, this.config.getHistoricalTLSUrl() + "/status", null);
        this.makeRequest(intermediateCertClient, HttpMethod.GET, this.config.getRouterTLSUrl() + "/status", null);
        this.makeRequest(intermediateCertClient, HttpMethod.GET, this.config.getPermissiveRouterTLSUrl() + "/status", null);
        this.makeRequest(intermediateCertClient, HttpMethod.GET, this.config.getNoClientAuthRouterTLSUrl() + "/status", null);
    }

    @Test
    public void checkAccessWithNoCert() {
        LOG.info("---------Testing TLS resource access without a certificate---------", new Object[0]);
        HttpClient certlessClient = this.makeCertlessClient();
        this.checkFailedAccessNoCert(certlessClient, HttpMethod.GET, this.config.getCoordinatorTLSUrl());
        this.checkFailedAccessNoCert(certlessClient, HttpMethod.GET, this.config.getOverlordTLSUrl());
        this.checkFailedAccessNoCert(certlessClient, HttpMethod.GET, this.config.getBrokerTLSUrl());
        this.checkFailedAccessNoCert(certlessClient, HttpMethod.GET, this.config.getHistoricalTLSUrl());
        this.checkFailedAccessNoCert(certlessClient, HttpMethod.GET, this.config.getRouterTLSUrl());
        this.checkFailedAccessNoCert(certlessClient, HttpMethod.GET, this.config.getPermissiveRouterTLSUrl());
        this.makeRequest(certlessClient, HttpMethod.GET, this.config.getNoClientAuthRouterTLSUrl() + "/status", null);
    }

    @Test
    public void checkAccessWithWrongHostname() {
        LOG.info("---------Testing TLS resource access when client certificate has non-matching hostnames---------", new Object[0]);
        HttpClient wrongHostnameClient = this.makeCustomHttpClient("client_tls/invalid_hostname_client.jks", "invalid_hostname_client");
        this.checkFailedAccessWrongHostname(wrongHostnameClient, HttpMethod.GET, this.config.getCoordinatorTLSUrl());
        this.checkFailedAccessWrongHostname(wrongHostnameClient, HttpMethod.GET, this.config.getOverlordTLSUrl());
        this.checkFailedAccessWrongHostname(wrongHostnameClient, HttpMethod.GET, this.config.getBrokerTLSUrl());
        this.checkFailedAccessWrongHostname(wrongHostnameClient, HttpMethod.GET, this.config.getHistoricalTLSUrl());
        this.checkFailedAccessWrongHostname(wrongHostnameClient, HttpMethod.GET, this.config.getRouterTLSUrl());
        this.makeRequest(wrongHostnameClient, HttpMethod.GET, this.config.getPermissiveRouterTLSUrl() + "/status", null);
        this.makeRequest(wrongHostnameClient, HttpMethod.GET, this.config.getNoClientAuthRouterTLSUrl() + "/status", null);
    }

    @Test
    public void checkAccessWithWrongRoot() {
        LOG.info("---------Testing TLS resource access when client certificate is signed by a non-trusted root CA---------", new Object[0]);
        HttpClient wrongRootClient = this.makeCustomHttpClient("client_tls/client_another_root.jks", "druid_another_root");
        this.checkFailedAccessWrongRoot(wrongRootClient, HttpMethod.GET, this.config.getCoordinatorTLSUrl());
        this.checkFailedAccessWrongRoot(wrongRootClient, HttpMethod.GET, this.config.getOverlordTLSUrl());
        this.checkFailedAccessWrongRoot(wrongRootClient, HttpMethod.GET, this.config.getBrokerTLSUrl());
        this.checkFailedAccessWrongRoot(wrongRootClient, HttpMethod.GET, this.config.getHistoricalTLSUrl());
        this.checkFailedAccessWrongRoot(wrongRootClient, HttpMethod.GET, this.config.getRouterTLSUrl());
        this.checkFailedAccessWrongRoot(wrongRootClient, HttpMethod.GET, this.config.getPermissiveRouterTLSUrl());
        this.makeRequest(wrongRootClient, HttpMethod.GET, this.config.getNoClientAuthRouterTLSUrl() + "/status", null);
    }

    @Test
    public void checkAccessWithRevokedCert() {
        LOG.info("---------Testing TLS resource access when client certificate has been revoked---------", new Object[0]);
        HttpClient revokedClient = this.makeCustomHttpClient("client_tls/revoked_client.jks", "revoked_druid");
        this.checkFailedAccessRevoked(revokedClient, HttpMethod.GET, this.config.getCoordinatorTLSUrl());
        this.checkFailedAccessRevoked(revokedClient, HttpMethod.GET, this.config.getOverlordTLSUrl());
        this.checkFailedAccessRevoked(revokedClient, HttpMethod.GET, this.config.getBrokerTLSUrl());
        this.checkFailedAccessRevoked(revokedClient, HttpMethod.GET, this.config.getHistoricalTLSUrl());
        this.checkFailedAccessRevoked(revokedClient, HttpMethod.GET, this.config.getRouterTLSUrl());
        this.makeRequest(revokedClient, HttpMethod.GET, this.config.getPermissiveRouterTLSUrl() + "/status", null);
        this.makeRequest(revokedClient, HttpMethod.GET, this.config.getNoClientAuthRouterTLSUrl() + "/status", null);
    }

    @Test
    public void checkAccessWithExpiredCert() {
        LOG.info("---------Testing TLS resource access when client certificate has expired---------", new Object[0]);
        HttpClient expiredClient = this.makeCustomHttpClient("client_tls/expired_client.jks", "expired_client");
        this.checkFailedAccessExpired(expiredClient, HttpMethod.GET, this.config.getCoordinatorTLSUrl());
        this.checkFailedAccessExpired(expiredClient, HttpMethod.GET, this.config.getOverlordTLSUrl());
        this.checkFailedAccessExpired(expiredClient, HttpMethod.GET, this.config.getBrokerTLSUrl());
        this.checkFailedAccessExpired(expiredClient, HttpMethod.GET, this.config.getHistoricalTLSUrl());
        this.checkFailedAccessExpired(expiredClient, HttpMethod.GET, this.config.getRouterTLSUrl());
        this.checkFailedAccessExpired(expiredClient, HttpMethod.GET, this.config.getPermissiveRouterTLSUrl());
        this.makeRequest(expiredClient, HttpMethod.GET, this.config.getNoClientAuthRouterTLSUrl() + "/status", null);
    }

    @Test
    public void checkAccessWithNotCASignedCert() {
        LOG.info("---------Testing TLS resource access when client certificate is signed by a non-CA intermediate cert---------", new Object[0]);
        HttpClient notCAClient = this.makeCustomHttpClient("client_tls/invalid_ca_client.jks", "invalid_ca_client");
        this.checkFailedAccessNotCA(notCAClient, HttpMethod.GET, this.config.getCoordinatorTLSUrl());
        this.checkFailedAccessNotCA(notCAClient, HttpMethod.GET, this.config.getOverlordTLSUrl());
        this.checkFailedAccessNotCA(notCAClient, HttpMethod.GET, this.config.getBrokerTLSUrl());
        this.checkFailedAccessNotCA(notCAClient, HttpMethod.GET, this.config.getHistoricalTLSUrl());
        this.checkFailedAccessNotCA(notCAClient, HttpMethod.GET, this.config.getRouterTLSUrl());
        this.checkFailedAccessNotCA(notCAClient, HttpMethod.GET, this.config.getPermissiveRouterTLSUrl());
        this.makeRequest(notCAClient, HttpMethod.GET, this.config.getNoClientAuthRouterTLSUrl() + "/status", null);
    }

    @Test
    public void checkAccessWithCustomCertificateChecks() {
        LOG.info("---------Testing TLS resource access with custom certificate checks---------", new Object[0]);
        HttpClient wrongHostnameClient = this.makeCustomHttpClient("client_tls/invalid_hostname_client.jks", "invalid_hostname_client", (TLSCertificateChecker)new ITTLSCertificateChecker());
        this.checkFailedAccessWrongHostname(this.httpClient, HttpMethod.GET, this.config.getCustomCertCheckRouterTLSUrl());
        this.makeRequest(wrongHostnameClient, HttpMethod.GET, this.config.getCustomCertCheckRouterTLSUrl() + "/status", null);
        this.checkFailedAccess(wrongHostnameClient, HttpMethod.POST, this.config.getCustomCertCheckRouterTLSUrl() + "/druid/v2", "Custom cert check", ISE.class, "Error while making request to url[https://127.0.0.1:9091/druid/v2] status[400 Bad Request] content[{\"error\":\"Unknown exception\",\"errorMessage\":\"No content to map due to end-of-input", true);
        this.makeRequest(wrongHostnameClient, HttpMethod.GET, this.config.getCustomCertCheckRouterTLSUrl() + "/druid/coordinator/v1/leader", null);
    }

    private void checkFailedAccessNoCert(HttpClient httpClient, HttpMethod method, String url) {
        this.checkFailedAccess(httpClient, method, url + "/status", "Certless", SSLException.class, "Received fatal alert: bad_certificate", false);
    }

    private void checkFailedAccessWrongHostname(HttpClient httpClient, HttpMethod method, String url) {
        this.checkFailedAccess(httpClient, method, url + "/status", "Wrong hostname", SSLException.class, "Received fatal alert: certificate_unknown", false);
    }

    private void checkFailedAccessWrongRoot(HttpClient httpClient, HttpMethod method, String url) {
        this.checkFailedAccess(httpClient, method, url + "/status", "Wrong root cert", SSLException.class, "Received fatal alert: certificate_unknown", false);
    }

    private void checkFailedAccessRevoked(HttpClient httpClient, HttpMethod method, String url) {
        this.checkFailedAccess(httpClient, method, url + "/status", "Revoked cert", SSLException.class, "Received fatal alert: certificate_unknown", false);
    }

    private void checkFailedAccessExpired(HttpClient httpClient, HttpMethod method, String url) {
        this.checkFailedAccess(httpClient, method, url + "/status", "Expired cert", SSLException.class, "Received fatal alert: certificate_unknown", false);
    }

    private void checkFailedAccessNotCA(HttpClient httpClient, HttpMethod method, String url) {
        this.checkFailedAccess(httpClient, method, url + "/status", "Cert signed by non-CA", SSLException.class, "Received fatal alert: certificate_unknown", false);
    }

    private HttpClientConfig.Builder getHttpClientConfigBuilder(SSLContext sslContext) {
        return HttpClientConfig.builder().withNumConnections(this.httpClientConfig.getNumConnections()).withReadTimeout(this.httpClientConfig.getReadTimeout()).withWorkerCount(this.httpClientConfig.getNumMaxThreads()).withCompressionCodec(HttpClientConfig.CompressionCodec.valueOf((String)StringUtils.toUpperCase((String)this.httpClientConfig.getCompressionCodec()))).withUnusedConnectionTimeoutDuration(this.httpClientConfig.getUnusedConnectionTimeout()).withSslHandshakeTimeout(SSL_HANDSHAKE_TIMEOUT).withSslContext(sslContext);
    }

    private HttpClient makeCustomHttpClient(String keystorePath, String certAlias) {
        return this.makeCustomHttpClient(keystorePath, certAlias, this.certificateChecker);
    }

    private HttpClient makeCustomHttpClient(String keystorePath, String certAlias, TLSCertificateChecker certificateChecker) {
        SSLContext intermediateClientSSLContext = new TLSUtils.ClientSSLContextBuilder().setProtocol(this.sslClientConfig.getProtocol()).setTrustStoreType(this.sslClientConfig.getTrustStoreType()).setTrustStorePath(this.sslClientConfig.getTrustStorePath()).setTrustStoreAlgorithm(this.sslClientConfig.getTrustStoreAlgorithm()).setTrustStorePasswordProvider(this.sslClientConfig.getTrustStorePasswordProvider()).setKeyStoreType(this.sslClientConfig.getKeyStoreType()).setKeyStorePath(keystorePath).setKeyStoreAlgorithm(this.sslClientConfig.getKeyManagerFactoryAlgorithm()).setCertAlias(certAlias).setKeyStorePasswordProvider(this.sslClientConfig.getKeyStorePasswordProvider()).setKeyManagerFactoryPasswordProvider(this.sslClientConfig.getKeyManagerPasswordProvider()).setCertificateChecker(certificateChecker).build();
        HttpClientConfig.Builder builder = this.getHttpClientConfigBuilder(intermediateClientSSLContext);
        Lifecycle lifecycle = new Lifecycle();
        HttpClient client = HttpClientInit.createClient((HttpClientConfig)builder.build(), (Lifecycle)lifecycle);
        CredentialedHttpClient adminClient = new CredentialedHttpClient((Credentials)new BasicCredentials("admin", "priest"), client);
        return adminClient;
    }

    private HttpClient makeCertlessClient() {
        SSLContext certlessClientSSLContext = new TLSUtils.ClientSSLContextBuilder().setProtocol(this.sslClientConfig.getProtocol()).setTrustStoreType(this.sslClientConfig.getTrustStoreType()).setTrustStorePath(this.sslClientConfig.getTrustStorePath()).setTrustStoreAlgorithm(this.sslClientConfig.getTrustStoreAlgorithm()).setTrustStorePasswordProvider(this.sslClientConfig.getTrustStorePasswordProvider()).setCertificateChecker(this.certificateChecker).build();
        HttpClientConfig.Builder builder = this.getHttpClientConfigBuilder(certlessClientSSLContext);
        Lifecycle lifecycle = new Lifecycle();
        HttpClient client = HttpClientInit.createClient((HttpClientConfig)builder.build(), (Lifecycle)lifecycle);
        CredentialedHttpClient adminClient = new CredentialedHttpClient((Credentials)new BasicCredentials("admin", "priest"), client);
        return adminClient;
    }

    private void checkFailedAccess(HttpClient httpClient, HttpMethod method, String url, String clientDesc, Class expectedException, String expectedExceptionMsg, boolean useContainsMsgCheck) {
        int retries = 0;
        while (true) {
            try {
                this.makeRequest(httpClient, method, url, null, -1);
            }
            catch (RuntimeException re) {
                Throwable rootCause = Throwables.getRootCause((Throwable)re);
                if (this.isRetriable(rootCause)) {
                    if (retries > 30) {
                        Assert.fail((String)StringUtils.format((String)"Broken pipe / connection reset retries exhausted, test failed, did not get %s.", (Object[])new Object[]{expectedException}));
                    } else {
                        ++retries;
                        continue;
                    }
                }
                Assert.assertTrue((boolean)expectedException.isInstance(rootCause), (String)StringUtils.format((String)"Expected %s but found %s instead.", (Object[])new Object[]{expectedException, Throwables.getStackTraceAsString((Throwable)rootCause)}));
                if (useContainsMsgCheck) {
                    Assert.assertTrue((boolean)rootCause.getMessage().contains(expectedExceptionMsg));
                } else {
                    Assert.assertEquals((String)rootCause.getMessage(), (String)expectedExceptionMsg);
                }
                LOG.info("%s client [%s] request failed as expected when accessing [%s]", new Object[]{clientDesc, method, url});
                return;
            }
            Assert.fail((String)StringUtils.format((String)"Test failed, did not get %s.", (Object[])new Object[]{expectedException}));
        }
    }

    private StatusResponseHolder makeRequest(HttpClient httpClient, HttpMethod method, String url, byte[] content) {
        return this.makeRequest(httpClient, method, url, content, 4);
    }

    private StatusResponseHolder makeRequest(HttpClient httpClient, HttpMethod method, String url, byte[] content, int maxRetries) {
        try {
            StatusResponseHolder response;
            Request request = new Request(method, new URL(url));
            if (content != null) {
                request.setContent("application/json", content);
            }
            int retryCount = 0;
            while (!(response = (StatusResponseHolder)httpClient.go(request, (HttpResponseHandler)StatusResponseHandler.getInstance()).get()).getStatus().equals((Object)HttpResponseStatus.OK)) {
                String errMsg = StringUtils.format((String)"Error while making request to url[%s] status[%s] content[%s]", (Object[])new Object[]{url, response.getStatus(), response.getContent()});
                if (retryCount > maxRetries) {
                    throw new ISE(errMsg, new Object[0]);
                }
                LOG.error(errMsg, new Object[0]);
                LOG.error("retrying in 3000ms, retryCount: " + retryCount, new Object[0]);
                ++retryCount;
                Thread.sleep(3000L);
            }
            LOG.info("[%s] request to [%s] succeeded.", new Object[]{method, url});
            return response;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isRetriable(Throwable ex) {
        if (!(ex instanceof IOException)) {
            return false;
        }
        if (ex instanceof ClosedChannelException) {
            return true;
        }
        return null != ex.getMessage() && ("Broken pipe".equals(ex.getMessage()) || "Connection reset by peer".contains(ex.getMessage()));
    }
}

